/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.calculator;

import java.util.Vector;
import org.statcato.calculator.CompUnit;
import org.statcato.calculator.MathOperations;

public class MathFunction {
    private int type;
    private boolean isRadian = true;

    public MathFunction(int type, boolean isRadian) {
        this.type = type;
        this.isRadian = isRadian;
    }

    public CompUnit call(CompUnit c) {
        int ctype = c.getType();
        if (ctype == 8) {
            return new CompUnit(8, this.call1(c.getNumber()));
        }
        Vector<Double> v = c.getColumn();
        for (int i = 0; i < v.size(); ++i) {
            Double value = v.elementAt(i);
            if (value == null) continue;
            v.setElementAt(new Double(this.call1(value)), i);
        }
        return new CompUnit(10, v);
    }

    public double call1(double argument) {
        switch (this.type) {
            case 3: {
                return Math.abs(argument);
            }
            case 5: {
                if (this.isRadian) {
                    return Math.acos(argument);
                }
                return Math.toDegrees(Math.acos(argument));
            }
            case 6: {
                if (this.isRadian) {
                    return Math.asin(argument);
                }
                return Math.toDegrees(Math.asin(argument));
            }
            case 7: {
                if (this.isRadian) {
                    return Math.atan(argument);
                }
                return Math.toDegrees(Math.atan(argument));
            }
            case 8: {
                return Math.ceil(argument);
            }
            case 1: {
                if (!this.isRadian) {
                    argument = Math.toRadians(argument);
                }
                return Math.cos(argument);
            }
            case 2: {
                return Math.exp(argument);
            }
            case 9: {
                return Math.floor(argument);
            }
            case 13: {
                return Math.log(argument);
            }
            case 10: {
                return Math.log(argument) / Math.log(10.0);
            }
            case 11: {
                return Math.round(argument);
            }
            case 0: {
                if (!this.isRadian) {
                    argument = Math.toRadians(argument);
                }
                return Math.sin(argument);
            }
            case 12: {
                return Math.sqrt(argument);
            }
            case 4: {
                if (!this.isRadian) {
                    argument = Math.toRadians(argument);
                }
                return Math.tan(argument);
            }
            case 14: {
                int argInt = (int)argument;
                if (argument - (double)argInt != 0.0 || argument < 0.0) {
                    return Double.NaN;
                }
                return MathOperations.factorial(argument);
            }
        }
        return Double.NaN;
    }
}

