/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.examples.swing.editor;

import com.mxgraph.analysis.StructuralException;
import com.mxgraph.analysis.mxAnalysisGraph;
import com.mxgraph.analysis.mxGraphGenerator;
import com.mxgraph.analysis.mxGraphProperties;
import com.mxgraph.analysis.mxGraphStructure;
import com.mxgraph.analysis.mxTraversal;
import com.mxgraph.costfunction.mxCostFunction;
import com.mxgraph.costfunction.mxDoubleValCostFunction;
import com.mxgraph.layout.mxCircleLayout;
import com.mxgraph.layout.mxCompactTreeLayout;
import com.mxgraph.layout.mxOrganicLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class GraphConfigDialog
extends JDialog {
    protected int numNodes = 6;
    protected int numEdges = 6;
    protected int valence = 2;
    protected int numRows = 8;
    protected int numVertexesInBranch = 3;
    protected int numColumns = 8;
    protected int minWeight = 1;
    protected int maxWeight = 10;
    protected int numVertexesLeft = 5;
    protected int numVertexesRight = 5;
    protected int startVertexValue = 0;
    protected int endVertexValue = 0;
    protected int numBranches = 4;
    protected boolean arrows = false;
    protected boolean weighted = false;
    protected boolean allowSelfLoops = false;
    protected boolean allowMultipleEdges = false;
    protected boolean forceConnected = false;
    protected float groupSpacing = 200.0f;
    protected float gridSpacing = 80.0f;
    private static final long serialVersionUID = 1535851135077957959L;
    protected boolean insertGraph = false;
    protected mxGraph graph;
    protected mxAnalysisGraph aGraph;
    protected mxGraphProperties.GraphType graphType;
    protected JTextField maxTreeNodeChildren = new JTextField();
    protected JTextField numNodesField = new JTextField();
    protected JTextField numEdgesField = new JTextField();
    protected JTextField valenceField = new JTextField();
    protected JTextField numRowsField = new JTextField();
    protected JTextField numColumnsField = new JTextField();
    protected JTextField gridSpacingField = new JTextField();
    protected JTextField numVertexesLeftField = new JTextField();
    protected JTextField numVertexesRightField = new JTextField();
    protected JTextField groupSpacingField = new JTextField();
    protected JCheckBox arrowsBox = new JCheckBox();
    protected JTextField startVertexValueField = new JTextField();
    protected JTextField endVertexValueField = new JTextField();
    protected JCheckBox selfLoopBox = new JCheckBox();
    protected JCheckBox multipleEdgeBox = new JCheckBox();
    protected JCheckBox forceConnectedBox = new JCheckBox();
    protected JCheckBox weightedBox = new JCheckBox();
    protected JTextField maxWeightField = new JTextField();
    protected JTextField minWeightField = new JTextField();
    protected JTextField numBranchesField = new JTextField();
    protected JTextField numVertexesInBranchField = new JTextField();

    public int getNumVertexesInBranch() {
        return this.numVertexesInBranch;
    }

    public void setNumVertexesInBranch(int numVertexesInBranch) {
        this.numVertexesInBranch = numVertexesInBranch;
    }

    public int getMinWeight() {
        return this.minWeight;
    }

    public void setMinWeight(int minWeight) {
        this.minWeight = minWeight;
    }

    public int getMaxWeight() {
        return this.maxWeight;
    }

    public void setMaxWeight(int maxWeight) {
        this.maxWeight = maxWeight;
    }

    public int getNumBranches() {
        return this.numBranches;
    }

    public void setNumBranches(int numBranches) {
        this.numBranches = numBranches;
    }

    public GraphConfigDialog(final mxGraphProperties.GraphType graphType2, String dialogText) {
        super((Frame)null, dialogText, true);
        if (graphType2 == mxGraphProperties.GraphType.NULL || graphType2 == mxGraphProperties.GraphType.SIMPLE_RANDOM_TREE) {
            JPanel panel = new JPanel(new GridLayout(1, 2, 4, 4));
            panel.add(new JLabel("Number of nodes"));
            panel.add(this.numNodesField);
            JPanel panelBorder = new JPanel();
            panelBorder.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelBorder.add(panel);
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY), BorderFactory.createEmptyBorder(16, 8, 8, 8)));
            JButton applyButton = new JButton("Generate");
            JButton closeButton = new JButton("Cancel");
            buttonPanel.add(closeButton);
            buttonPanel.add(applyButton);
            this.getRootPane().setDefaultButton(applyButton);
            applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.applyValues();
                    int nodeCount = Integer.parseInt(GraphConfigDialog.this.numNodesField.getText());
                    GraphConfigDialog.this.graph.getModel().beginUpdate();
                    GraphConfigDialog.this.graph.selectAll();
                    GraphConfigDialog.this.graph.removeCells();
                    if (graphType2 == mxGraphProperties.GraphType.NULL) {
                        mxGraphGenerator generator = new mxGraphGenerator(null, new mxDoubleValCostFunction());
                        HashMap<String, Object> props = new HashMap<String, Object>();
                        mxGraphProperties.setDirected(props, false);
                        GraphConfigDialog.this.configAnalysisGraph(GraphConfigDialog.this.graph, generator, props);
                        generator.getNullGraph(GraphConfigDialog.this.aGraph, nodeCount);
                        mxGraphStructure.setDefaultGraphStyle(GraphConfigDialog.this.aGraph, false);
                        mxCircleLayout layout = new mxCircleLayout(GraphConfigDialog.this.graph);
                        layout.execute(GraphConfigDialog.this.graph.getDefaultParent());
                    } else if (graphType2 == mxGraphProperties.GraphType.SIMPLE_RANDOM_TREE) {
                        GraphConfigDialog.this.graph.getModel().beginUpdate();
                        mxGraphGenerator generator = new mxGraphGenerator(mxGraphGenerator.getGeneratorFunction(GraphConfigDialog.this.graph, false, 0.0, 10.0), new mxDoubleValCostFunction());
                        HashMap<String, Object> props = new HashMap<String, Object>();
                        mxGraphProperties.setDirected(props, false);
                        GraphConfigDialog.this.configAnalysisGraph(GraphConfigDialog.this.graph, generator, props);
                        generator.getSimpleRandomTree(GraphConfigDialog.this.aGraph, nodeCount);
                        mxGraphProperties.setDirected(props, true);
                        mxGraphStructure.setDefaultGraphStyle(GraphConfigDialog.this.aGraph, false);
                        GraphConfigDialog.this.setVisible(false);
                        mxCompactTreeLayout layout = new mxCompactTreeLayout(GraphConfigDialog.this.graph, false);
                        layout.execute(GraphConfigDialog.this.graph.getDefaultParent());
                        GraphConfigDialog.this.graph.getModel().endUpdate();
                    }
                    GraphConfigDialog.this.graph.getModel().endUpdate();
                    GraphConfigDialog.this.setVisible(false);
                }
            });
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.insertGraph = false;
                    GraphConfigDialog.this.setVisible(false);
                }
            });
            this.getContentPane().add((Component)panelBorder, "Center");
            this.getContentPane().add((Component)buttonPanel, "South");
            this.pack();
            this.setResizable(false);
        } else if (graphType2 == mxGraphProperties.GraphType.COMPLETE) {
            JPanel panel = new JPanel(new GridLayout(5, 1, 4, 4));
            panel.add(new JLabel("Number of nodes"));
            panel.add(this.numNodesField);
            this.arrowsBox = new JCheckBox("Directed", false);
            panel.add(this.arrowsBox);
            this.weightedBox = new JCheckBox("Weighted", false);
            panel.add(this.weightedBox);
            panel.add(new JLabel("Min. weight"));
            panel.add(this.minWeightField);
            panel.add(new JLabel("Max. weight"));
            panel.add(this.maxWeightField);
            JPanel panelBorder = new JPanel();
            panelBorder.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelBorder.add(panel);
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY), BorderFactory.createEmptyBorder(16, 8, 8, 8)));
            JButton applyButton = new JButton("Generate");
            JButton closeButton = new JButton("Cancel");
            buttonPanel.add(closeButton);
            buttonPanel.add(applyButton);
            this.getRootPane().setDefaultButton(applyButton);
            applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.applyValues();
                    int vertexNumParam = Integer.parseInt(GraphConfigDialog.this.numNodesField.getText());
                    int minWeightParam = Integer.parseInt(GraphConfigDialog.this.minWeightField.getText());
                    int maxWeightParam = Integer.parseInt(GraphConfigDialog.this.maxWeightField.getText());
                    GraphConfigDialog.this.graph.getModel().beginUpdate();
                    GraphConfigDialog.this.graph.selectAll();
                    GraphConfigDialog.this.graph.removeCells();
                    mxGraphGenerator generator = new mxGraphGenerator(mxGraphGenerator.getGeneratorFunction(GraphConfigDialog.this.graph, GraphConfigDialog.this.weighted, minWeightParam, maxWeightParam), new mxDoubleValCostFunction());
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    mxGraphProperties.setDirected(props, GraphConfigDialog.this.arrows);
                    GraphConfigDialog.this.configAnalysisGraph(GraphConfigDialog.this.graph, generator, props);
                    generator.getCompleteGraph(GraphConfigDialog.this.aGraph, vertexNumParam);
                    mxGraphStructure.setDefaultGraphStyle(GraphConfigDialog.this.aGraph, false);
                    GraphConfigDialog.this.setVisible(false);
                    mxCircleLayout layout = new mxCircleLayout(GraphConfigDialog.this.graph);
                    layout.execute(GraphConfigDialog.this.graph.getDefaultParent());
                    GraphConfigDialog.this.graph.getModel().endUpdate();
                }
            });
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.insertGraph = false;
                    GraphConfigDialog.this.setVisible(false);
                }
            });
            this.getContentPane().add((Component)panelBorder, "Center");
            this.getContentPane().add((Component)buttonPanel, "South");
            this.pack();
            this.setResizable(false);
        } else if (graphType2 == mxGraphProperties.GraphType.FULL_WINDMILL || graphType2 == mxGraphProperties.GraphType.FRIENDSHIP_WINDMILL) {
            JPanel panel = new JPanel(new GridLayout(6, 1, 4, 4));
            panel.add(new JLabel("Number of branches"));
            panel.add(this.numBranchesField);
            panel.add(new JLabel("Number of vertexes per branch"));
            panel.add(this.numVertexesInBranchField);
            this.arrowsBox = new JCheckBox("Directed", false);
            panel.add(this.arrowsBox);
            this.weightedBox = new JCheckBox("Weighted", false);
            panel.add(this.weightedBox);
            panel.add(new JLabel("Min. weight"));
            panel.add(this.minWeightField);
            panel.add(new JLabel("Max. weight"));
            panel.add(this.maxWeightField);
            JPanel panelBorder = new JPanel();
            panelBorder.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelBorder.add(panel);
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY), BorderFactory.createEmptyBorder(16, 8, 8, 8)));
            JButton applyButton = new JButton("Generate");
            JButton closeButton = new JButton("Cancel");
            buttonPanel.add(closeButton);
            buttonPanel.add(applyButton);
            this.getRootPane().setDefaultButton(applyButton);
            applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.applyValues();
                    GraphConfigDialog.this.graph.selectAll();
                    GraphConfigDialog.this.graph.removeCells();
                    int minWeightParam = Integer.parseInt(GraphConfigDialog.this.minWeightField.getText());
                    int maxWeightParam = Integer.parseInt(GraphConfigDialog.this.maxWeightField.getText());
                    int numBranchesParam = Integer.parseInt(GraphConfigDialog.this.numBranchesField.getText());
                    int numVertexesInBranchParam = Integer.parseInt(GraphConfigDialog.this.numVertexesInBranchField.getText());
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    mxGraphProperties.setDirected(props, GraphConfigDialog.this.arrows);
                    mxGraphGenerator generator = new mxGraphGenerator(mxGraphGenerator.getGeneratorFunction(GraphConfigDialog.this.graph, GraphConfigDialog.this.weighted, minWeightParam, maxWeightParam), new mxDoubleValCostFunction());
                    GraphConfigDialog.this.configAnalysisGraph(GraphConfigDialog.this.graph, generator, props);
                    if (graphType2 == mxGraphProperties.GraphType.FRIENDSHIP_WINDMILL) {
                        generator.getFriendshipWindmillGraph(GraphConfigDialog.this.aGraph, numBranchesParam, numVertexesInBranchParam);
                    } else if (graphType2 == mxGraphProperties.GraphType.FULL_WINDMILL) {
                        generator.getWindmillGraph(GraphConfigDialog.this.aGraph, numBranchesParam, numVertexesInBranchParam);
                    }
                    generator.setWindmillGraphLayout(GraphConfigDialog.this.aGraph, numBranchesParam, numVertexesInBranchParam, 1000.0);
                    mxGraphStructure.setDefaultGraphStyle(GraphConfigDialog.this.aGraph, false);
                    GraphConfigDialog.this.setVisible(false);
                }
            });
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.insertGraph = false;
                    GraphConfigDialog.this.setVisible(false);
                }
            });
            this.getContentPane().add((Component)panelBorder, "Center");
            this.getContentPane().add((Component)buttonPanel, "South");
            this.pack();
            this.setResizable(false);
        } else if (graphType2 == mxGraphProperties.GraphType.WHEEL || graphType2 == mxGraphProperties.GraphType.STAR || graphType2 == mxGraphProperties.GraphType.PATH) {
            JPanel panel = new JPanel(new GridLayout(5, 1, 4, 4));
            panel.add(new JLabel("Number of nodes"));
            panel.add(this.numNodesField);
            this.arrowsBox = new JCheckBox("Directed", false);
            panel.add(this.arrowsBox);
            this.weightedBox = new JCheckBox("Weighted", false);
            panel.add(this.weightedBox);
            panel.add(new JLabel("Min. weight"));
            panel.add(this.minWeightField);
            panel.add(new JLabel("Max. weight"));
            panel.add(this.maxWeightField);
            JPanel panelBorder = new JPanel();
            panelBorder.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelBorder.add(panel);
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY), BorderFactory.createEmptyBorder(16, 8, 8, 8)));
            JButton applyButton = new JButton("Generate");
            JButton closeButton = new JButton("Cancel");
            buttonPanel.add(closeButton);
            buttonPanel.add(applyButton);
            this.getRootPane().setDefaultButton(applyButton);
            applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.applyValues();
                    int numNodesParam = Integer.parseInt(GraphConfigDialog.this.numNodesField.getText());
                    int minWeightParam = Integer.parseInt(GraphConfigDialog.this.minWeightField.getText());
                    int maxWeightParam = Integer.parseInt(GraphConfigDialog.this.maxWeightField.getText());
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    mxGraphProperties.setDirected(props, GraphConfigDialog.this.arrows);
                    mxGraphGenerator generator = new mxGraphGenerator(mxGraphGenerator.getGeneratorFunction(GraphConfigDialog.this.graph, GraphConfigDialog.this.weighted, minWeightParam, maxWeightParam), new mxDoubleValCostFunction());
                    GraphConfigDialog.this.configAnalysisGraph(GraphConfigDialog.this.graph, generator, props);
                    GraphConfigDialog.this.graph.getModel().beginUpdate();
                    GraphConfigDialog.this.graph.selectAll();
                    GraphConfigDialog.this.graph.removeCells();
                    if (graphType2 == mxGraphProperties.GraphType.WHEEL) {
                        generator.getWheelGraph(GraphConfigDialog.this.aGraph, numNodesParam);
                        generator.setStarGraphLayout(GraphConfigDialog.this.aGraph, 400.0);
                    } else if (graphType2 == mxGraphProperties.GraphType.STAR) {
                        generator.getStarGraph(GraphConfigDialog.this.aGraph, numNodesParam);
                        generator.setStarGraphLayout(GraphConfigDialog.this.aGraph, 400.0);
                    } else if (graphType2 == mxGraphProperties.GraphType.PATH) {
                        generator.getPathGraph(GraphConfigDialog.this.aGraph, numNodesParam);
                        generator.setPathGraphSpacing(GraphConfigDialog.this.aGraph, 80.0);
                    }
                    mxGraphStructure.setDefaultGraphStyle(GraphConfigDialog.this.aGraph, false);
                    GraphConfigDialog.this.setVisible(false);
                    GraphConfigDialog.this.graph.getModel().endUpdate();
                }
            });
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.insertGraph = false;
                    GraphConfigDialog.this.setVisible(false);
                }
            });
            this.getContentPane().add((Component)panelBorder, "Center");
            this.getContentPane().add((Component)buttonPanel, "South");
            this.pack();
            this.setResizable(false);
        } else if (graphType2 == mxGraphProperties.GraphType.PETERSEN) {
            JPanel panel = new JPanel(new GridLayout(4, 1, 4, 4));
            this.arrowsBox = new JCheckBox("Directed", false);
            panel.add(this.arrowsBox);
            this.weightedBox = new JCheckBox("Weighted", false);
            panel.add(this.weightedBox);
            panel.add(new JLabel("Min. weight"));
            panel.add(this.minWeightField);
            panel.add(new JLabel("Max. weight"));
            panel.add(this.maxWeightField);
            JPanel panelBorder = new JPanel();
            panelBorder.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelBorder.add(panel);
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY), BorderFactory.createEmptyBorder(16, 8, 8, 8)));
            JButton applyButton = new JButton("Generate");
            JButton closeButton = new JButton("Cancel");
            buttonPanel.add(closeButton);
            buttonPanel.add(applyButton);
            this.getRootPane().setDefaultButton(applyButton);
            applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.applyValues();
                    int minWeightParam = Integer.parseInt(GraphConfigDialog.this.minWeightField.getText());
                    int maxWeightParam = Integer.parseInt(GraphConfigDialog.this.maxWeightField.getText());
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    mxGraphProperties.setDirected(props, GraphConfigDialog.this.arrows);
                    mxGraphGenerator generator = new mxGraphGenerator(mxGraphGenerator.getGeneratorFunction(GraphConfigDialog.this.graph, GraphConfigDialog.this.weighted, minWeightParam, maxWeightParam), new mxDoubleValCostFunction());
                    GraphConfigDialog.this.configAnalysisGraph(GraphConfigDialog.this.graph, generator, props);
                    GraphConfigDialog.this.graph.getModel().beginUpdate();
                    GraphConfigDialog.this.graph.selectAll();
                    GraphConfigDialog.this.graph.removeCells();
                    generator.getPetersenGraph(GraphConfigDialog.this.aGraph);
                    mxGraphStructure.setDefaultGraphStyle(GraphConfigDialog.this.aGraph, false);
                    GraphConfigDialog.this.setVisible(false);
                    mxCircleLayout layout = new mxCircleLayout(GraphConfigDialog.this.graph);
                    layout.execute(GraphConfigDialog.this.graph.getDefaultParent());
                    GraphConfigDialog.this.graph.getModel().endUpdate();
                }
            });
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.insertGraph = false;
                    GraphConfigDialog.this.setVisible(false);
                }
            });
            this.getContentPane().add((Component)panelBorder, "Center");
            this.getContentPane().add((Component)buttonPanel, "South");
            this.pack();
            this.setResizable(false);
        } else if (graphType2 == mxGraphProperties.GraphType.GRID) {
            JPanel panel = new JPanel(new GridLayout(3, 2, 4, 4));
            panel.add(new JLabel("Number of rows"));
            panel.add(this.numRowsField);
            panel.add(new JLabel("Number of columns"));
            panel.add(this.numColumnsField);
            panel.add(new JLabel("Grid spacing"));
            panel.add(this.gridSpacingField);
            this.arrowsBox = new JCheckBox("Directed", false);
            panel.add(this.arrowsBox);
            this.weightedBox = new JCheckBox("Weighted", false);
            panel.add(this.weightedBox);
            panel.add(new JLabel("Min. weight"));
            panel.add(this.minWeightField);
            panel.add(new JLabel("Max. weight"));
            panel.add(this.maxWeightField);
            JPanel panelBorder = new JPanel();
            panelBorder.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelBorder.add(panel);
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY), BorderFactory.createEmptyBorder(16, 8, 8, 8)));
            JButton applyButton = new JButton("Generate");
            JButton closeButton = new JButton("Cancel");
            buttonPanel.add(closeButton);
            buttonPanel.add(applyButton);
            this.getRootPane().setDefaultButton(applyButton);
            applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.applyValues();
                    int yDim = Integer.parseInt(GraphConfigDialog.this.numRowsField.getText());
                    int xDim = Integer.parseInt(GraphConfigDialog.this.numColumnsField.getText());
                    int minWeightParam = Integer.parseInt(GraphConfigDialog.this.minWeightField.getText());
                    int maxWeightParam = Integer.parseInt(GraphConfigDialog.this.maxWeightField.getText());
                    float spacing = Float.parseFloat(GraphConfigDialog.this.gridSpacingField.getText());
                    GraphConfigDialog.this.graph.getModel().beginUpdate();
                    GraphConfigDialog.this.graph.selectAll();
                    GraphConfigDialog.this.graph.removeCells();
                    mxGraphGenerator generator = new mxGraphGenerator(mxGraphGenerator.getGeneratorFunction(GraphConfigDialog.this.graph, GraphConfigDialog.this.weighted, minWeightParam, maxWeightParam), new mxDoubleValCostFunction());
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    mxGraphProperties.setDirected(props, GraphConfigDialog.this.arrows);
                    GraphConfigDialog.this.configAnalysisGraph(GraphConfigDialog.this.graph, generator, props);
                    generator.getGridGraph(GraphConfigDialog.this.aGraph, xDim, yDim);
                    generator.setGridGraphSpacing(GraphConfigDialog.this.aGraph, spacing, spacing, xDim, yDim);
                    mxGraphStructure.setDefaultGraphStyle(GraphConfigDialog.this.aGraph, false);
                    GraphConfigDialog.this.setVisible(false);
                    GraphConfigDialog.this.graph.getModel().endUpdate();
                }
            });
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.insertGraph = false;
                    GraphConfigDialog.this.setVisible(false);
                }
            });
            this.getContentPane().add((Component)panelBorder, "Center");
            this.getContentPane().add((Component)buttonPanel, "South");
            this.pack();
            this.setResizable(false);
        } else if (graphType2 == mxGraphProperties.GraphType.KNIGHT || graphType2 == mxGraphProperties.GraphType.KING) {
            JPanel panel = new JPanel(new GridLayout(5, 2, 4, 4));
            panel.add(new JLabel("Number of rows"));
            panel.add(this.numRowsField);
            panel.add(new JLabel("Number of columns"));
            panel.add(this.numColumnsField);
            panel.add(new JLabel("Grid spacing"));
            panel.add(this.gridSpacingField);
            JPanel panelBorder = new JPanel();
            panelBorder.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelBorder.add(panel);
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY), BorderFactory.createEmptyBorder(16, 8, 8, 8)));
            JButton applyButton = new JButton("Generate");
            JButton closeButton = new JButton("Cancel");
            buttonPanel.add(closeButton);
            buttonPanel.add(applyButton);
            this.getRootPane().setDefaultButton(applyButton);
            applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.applyValues();
                    int yDim = Integer.parseInt(GraphConfigDialog.this.numRowsField.getText());
                    int xDim = Integer.parseInt(GraphConfigDialog.this.numColumnsField.getText());
                    float spacing = Float.parseFloat(GraphConfigDialog.this.gridSpacingField.getText());
                    mxGraphGenerator generator = new mxGraphGenerator(null, new mxDoubleValCostFunction());
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    mxGraphProperties.setDirected(props, GraphConfigDialog.this.arrows);
                    GraphConfigDialog.this.configAnalysisGraph(GraphConfigDialog.this.graph, generator, props);
                    GraphConfigDialog.this.graph.getModel().beginUpdate();
                    GraphConfigDialog.this.graph.selectAll();
                    GraphConfigDialog.this.graph.removeCells();
                    if (graphType2 == mxGraphProperties.GraphType.KNIGHT) {
                        generator.getKnightGraph(GraphConfigDialog.this.aGraph, xDim, yDim);
                    } else if (graphType2 == mxGraphProperties.GraphType.KING) {
                        generator.getKingGraph(GraphConfigDialog.this.aGraph, xDim, yDim);
                    }
                    generator.setGridGraphSpacing(GraphConfigDialog.this.aGraph, spacing, spacing, xDim, yDim);
                    mxGraphStructure.setDefaultGraphStyle(GraphConfigDialog.this.aGraph, false);
                    GraphConfigDialog.this.setVisible(false);
                    GraphConfigDialog.this.graph.getModel().endUpdate();
                }
            });
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.insertGraph = false;
                    GraphConfigDialog.this.setVisible(false);
                }
            });
            this.getContentPane().add((Component)panelBorder, "Center");
            this.getContentPane().add((Component)buttonPanel, "South");
            this.pack();
            this.setResizable(false);
        } else if (graphType2 == mxGraphProperties.GraphType.KNIGHT_TOUR) {
            JPanel panel = new JPanel(new GridLayout(4, 2, 4, 4));
            panel.add(new JLabel("Starting node"));
            panel.add(this.startVertexValueField);
            panel.add(new JLabel("X dimension of chessboard"));
            panel.add(this.numColumnsField);
            panel.add(new JLabel("Y dimension of chessboard"));
            panel.add(this.numRowsField);
            panel.add(new JLabel("Grid spacing"));
            panel.add(this.gridSpacingField);
            JPanel panelBorder = new JPanel();
            panelBorder.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelBorder.add(panel);
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY), BorderFactory.createEmptyBorder(16, 8, 8, 8)));
            JButton applyButton = new JButton("Generate");
            JButton closeButton = new JButton("Cancel");
            buttonPanel.add(closeButton);
            buttonPanel.add(applyButton);
            this.getRootPane().setDefaultButton(applyButton);
            applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.applyValues();
                    int yDim = Integer.parseInt(GraphConfigDialog.this.numRowsField.getText());
                    int xDim = Integer.parseInt(GraphConfigDialog.this.numColumnsField.getText());
                    int value = Integer.parseInt(GraphConfigDialog.this.startVertexValueField.getText());
                    float spacing = Float.parseFloat(GraphConfigDialog.this.gridSpacingField.getText());
                    mxGraphGenerator generator = new mxGraphGenerator(null, new mxDoubleValCostFunction());
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    mxGraphProperties.setDirected(props, true);
                    GraphConfigDialog.this.configAnalysisGraph(GraphConfigDialog.this.graph, generator, props);
                    GraphConfigDialog.this.graph.getModel().beginUpdate();
                    GraphConfigDialog.this.graph.selectAll();
                    GraphConfigDialog.this.graph.removeCells();
                    try {
                        generator.getKnightTour(GraphConfigDialog.this.aGraph, xDim, yDim, value);
                    }
                    catch (StructuralException e1) {
                        System.out.println(e1);
                    }
                    generator.setGridGraphSpacing(GraphConfigDialog.this.aGraph, spacing, spacing, xDim, yDim);
                    mxGraphStructure.setDefaultGraphStyle(GraphConfigDialog.this.aGraph, false);
                    GraphConfigDialog.this.setVisible(false);
                    GraphConfigDialog.this.graph.getModel().endUpdate();
                }
            });
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.insertGraph = false;
                    GraphConfigDialog.this.setVisible(false);
                }
            });
            this.getContentPane().add((Component)panelBorder, "Center");
            this.getContentPane().add((Component)buttonPanel, "South");
            this.pack();
            this.setResizable(false);
        } else if (graphType2 == mxGraphProperties.GraphType.BIPARTITE || graphType2 == mxGraphProperties.GraphType.COMPLETE_BIPARTITE) {
            JPanel panel = new JPanel(new GridLayout(3, 2, 4, 4));
            panel.add(new JLabel("Number of vertexes in group 1"));
            panel.add(this.numVertexesLeftField);
            panel.add(new JLabel("Number of vertexes in group 2"));
            panel.add(this.numVertexesRightField);
            panel.add(new JLabel("Group spacing"));
            panel.add(this.groupSpacingField);
            this.arrowsBox = new JCheckBox("Directed", false);
            panel.add(this.arrowsBox);
            this.weightedBox = new JCheckBox("Weighted", false);
            panel.add(this.weightedBox);
            panel.add(new JLabel("Min. weight"));
            panel.add(this.minWeightField);
            panel.add(new JLabel("Max. weight"));
            panel.add(this.maxWeightField);
            JPanel panelBorder = new JPanel();
            panelBorder.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelBorder.add(panel);
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY), BorderFactory.createEmptyBorder(16, 8, 8, 8)));
            JButton applyButton = new JButton("Generate");
            JButton closeButton = new JButton("Cancel");
            buttonPanel.add(closeButton);
            buttonPanel.add(applyButton);
            this.getRootPane().setDefaultButton(applyButton);
            applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.applyValues();
                    int leftNodeCount = Integer.parseInt(GraphConfigDialog.this.numVertexesLeftField.getText());
                    int rightNodeCount = Integer.parseInt(GraphConfigDialog.this.numVertexesRightField.getText());
                    float spacing = Float.parseFloat(GraphConfigDialog.this.groupSpacingField.getText());
                    int minWeightParam = Integer.parseInt(GraphConfigDialog.this.minWeightField.getText());
                    int maxWeightParam = Integer.parseInt(GraphConfigDialog.this.maxWeightField.getText());
                    mxGraphGenerator generator = new mxGraphGenerator(mxGraphGenerator.getGeneratorFunction(GraphConfigDialog.this.graph, GraphConfigDialog.this.weighted, minWeightParam, maxWeightParam), new mxDoubleValCostFunction());
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    mxGraphProperties.setDirected(props, GraphConfigDialog.this.arrows);
                    GraphConfigDialog.this.configAnalysisGraph(GraphConfigDialog.this.graph, generator, props);
                    GraphConfigDialog.this.graph.getModel().beginUpdate();
                    GraphConfigDialog.this.graph.selectAll();
                    GraphConfigDialog.this.graph.removeCells();
                    if (graphType2 == mxGraphProperties.GraphType.BIPARTITE) {
                        generator.getBipartiteGraph(GraphConfigDialog.this.aGraph, leftNodeCount, rightNodeCount);
                    } else if (graphType2 == mxGraphProperties.GraphType.COMPLETE_BIPARTITE) {
                        generator.getCompleteBipartiteGraph(GraphConfigDialog.this.aGraph, leftNodeCount, rightNodeCount);
                    }
                    generator.setBipartiteGraphSpacing(GraphConfigDialog.this.aGraph, leftNodeCount, rightNodeCount, spacing, spacing * 2.0f);
                    mxGraphStructure.setDefaultGraphStyle(GraphConfigDialog.this.aGraph, false);
                    GraphConfigDialog.this.setVisible(false);
                    GraphConfigDialog.this.graph.getModel().endUpdate();
                }
            });
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.insertGraph = false;
                    GraphConfigDialog.this.setVisible(false);
                }
            });
            this.getContentPane().add((Component)panelBorder, "Center");
            this.getContentPane().add((Component)buttonPanel, "South");
            this.pack();
            this.setResizable(false);
        } else if (graphType2 == mxGraphProperties.GraphType.SIMPLE_RANDOM) {
            JPanel panel = new JPanel(new GridLayout(15, 2, 4, 4));
            panel.add(new JLabel("Number of nodes"));
            panel.add(this.numNodesField);
            panel.add(new JLabel("Number of edges"));
            panel.add(this.numEdgesField);
            this.arrowsBox = new JCheckBox("Directed", false);
            panel.add(this.arrowsBox);
            this.weightedBox = new JCheckBox("Weighted", false);
            panel.add(this.weightedBox);
            panel.add(new JLabel("Min. weight"));
            panel.add(this.minWeightField);
            panel.add(new JLabel("Max. weight"));
            panel.add(this.maxWeightField);
            this.selfLoopBox = new JCheckBox("Allow self-loops", false);
            panel.add(this.selfLoopBox);
            this.multipleEdgeBox = new JCheckBox("Allow multiple edges", false);
            panel.add(this.multipleEdgeBox);
            this.forceConnectedBox = new JCheckBox("Always connected (edge count may be inaccurate)", false);
            panel.add(this.forceConnectedBox);
            JPanel panelBorder = new JPanel();
            panelBorder.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelBorder.add(panel);
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY), BorderFactory.createEmptyBorder(16, 8, 8, 8)));
            JButton applyButton = new JButton("Generate");
            JButton closeButton = new JButton("Cancel");
            buttonPanel.add(closeButton);
            buttonPanel.add(applyButton);
            this.getRootPane().setDefaultButton(applyButton);
            applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.applyValues();
                    int nodeCount = Integer.parseInt(GraphConfigDialog.this.numNodesField.getText());
                    int edgeCount = Integer.parseInt(GraphConfigDialog.this.numEdgesField.getText());
                    int minWeightParam = Integer.parseInt(GraphConfigDialog.this.minWeightField.getText());
                    int maxWeightParam = Integer.parseInt(GraphConfigDialog.this.maxWeightField.getText());
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    mxGraphProperties.setDirected(props, GraphConfigDialog.this.arrows);
                    mxGraphGenerator generator = new mxGraphGenerator(mxGraphGenerator.getGeneratorFunction(GraphConfigDialog.this.graph, GraphConfigDialog.this.weighted, minWeightParam, maxWeightParam), new mxDoubleValCostFunction());
                    GraphConfigDialog.this.configAnalysisGraph(GraphConfigDialog.this.graph, generator, props);
                    GraphConfigDialog.this.graph.getModel().beginUpdate();
                    GraphConfigDialog.this.graph.selectAll();
                    GraphConfigDialog.this.graph.removeCells();
                    generator.getSimpleRandomGraph(GraphConfigDialog.this.aGraph, nodeCount, edgeCount, GraphConfigDialog.this.allowSelfLoops, GraphConfigDialog.this.allowMultipleEdges, GraphConfigDialog.this.forceConnected);
                    mxGraphStructure.setDefaultGraphStyle(GraphConfigDialog.this.aGraph, false);
                    mxOrganicLayout layout = new mxOrganicLayout(GraphConfigDialog.this.graph);
                    layout.execute(GraphConfigDialog.this.graph.getDefaultParent());
                    GraphConfigDialog.this.graph.getModel().endUpdate();
                    GraphConfigDialog.this.setVisible(false);
                }
            });
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.insertGraph = false;
                    GraphConfigDialog.this.setVisible(false);
                }
            });
            this.getContentPane().add((Component)panelBorder, "Center");
            this.getContentPane().add((Component)buttonPanel, "South");
            this.pack();
            this.setResizable(false);
        } else if (graphType2 == mxGraphProperties.GraphType.RESET_STYLE) {
            JPanel panel = new JPanel(new GridLayout(4, 2, 4, 4));
            this.arrowsBox = new JCheckBox("Directed", false);
            panel.add(this.arrowsBox);
            this.weightedBox = new JCheckBox("Weighted", false);
            panel.add(this.weightedBox);
            panel.add(new JLabel("Min. weight"));
            panel.add(this.minWeightField);
            panel.add(new JLabel("Max. weight"));
            panel.add(this.maxWeightField);
            JPanel panelBorder = new JPanel();
            panelBorder.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelBorder.add(panel);
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY), BorderFactory.createEmptyBorder(16, 8, 8, 8)));
            JButton applyButton = new JButton("Generate");
            JButton closeButton = new JButton("Cancel");
            buttonPanel.add(closeButton);
            buttonPanel.add(applyButton);
            this.getRootPane().setDefaultButton(applyButton);
            applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.applyValues();
                    int minWeightParam = Integer.parseInt(GraphConfigDialog.this.minWeightField.getText());
                    int maxWeightParam = Integer.parseInt(GraphConfigDialog.this.maxWeightField.getText());
                    Map<String, Object> props = GraphConfigDialog.this.aGraph.getProperties();
                    mxGraphProperties.setDirected(props, GraphConfigDialog.this.arrows);
                    mxGraphGenerator generator = new mxGraphGenerator(mxGraphGenerator.getGeneratorFunction(GraphConfigDialog.this.graph, GraphConfigDialog.this.weighted, minWeightParam, maxWeightParam), new mxDoubleValCostFunction());
                    GraphConfigDialog.this.configAnalysisGraph(GraphConfigDialog.this.graph, generator, props);
                    GraphConfigDialog.this.graph.getModel().beginUpdate();
                    mxGraphStructure.setDefaultGraphStyle(GraphConfigDialog.this.aGraph, true);
                    GraphConfigDialog.this.graph.getModel().endUpdate();
                    GraphConfigDialog.this.setVisible(false);
                }
            });
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.insertGraph = false;
                    GraphConfigDialog.this.setVisible(false);
                }
            });
            this.getContentPane().add((Component)panelBorder, "Center");
            this.getContentPane().add((Component)buttonPanel, "South");
            this.pack();
            this.setResizable(false);
        } else if (graphType2 == mxGraphProperties.GraphType.BFS_DIR || graphType2 == mxGraphProperties.GraphType.DFS_DIR || graphType2 == mxGraphProperties.GraphType.BFS_UNDIR || graphType2 == mxGraphProperties.GraphType.DFS_UNDIR || graphType2 == mxGraphProperties.GraphType.MAKE_TREE_DIRECTED || graphType2 == mxGraphProperties.GraphType.INDEGREE || graphType2 == mxGraphProperties.GraphType.OUTDEGREE || graphType2 == mxGraphProperties.GraphType.IS_CUT_VERTEX) {
            JPanel panel = new JPanel(new GridLayout(1, 2, 4, 4));
            panel.add(new JLabel("Starting vertex"));
            panel.add(this.startVertexValueField);
            JPanel panelBorder = new JPanel();
            panelBorder.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelBorder.add(panel);
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY), BorderFactory.createEmptyBorder(16, 8, 8, 8)));
            JButton applyButton = new JButton("Start");
            JButton closeButton = new JButton("Cancel");
            buttonPanel.add(closeButton);
            buttonPanel.add(applyButton);
            this.getRootPane().setDefaultButton(applyButton);
            applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.applyValues();
                    int value = Integer.parseInt(GraphConfigDialog.this.startVertexValueField.getText());
                    Object startVertex = mxGraphStructure.getVertexWithValue(GraphConfigDialog.this.aGraph, value);
                    if (startVertex == null) {
                        System.out.println("The specified vertex is not in the graph.");
                    } else if (graphType2 == mxGraphProperties.GraphType.BFS_DIR) {
                        boolean oldDir = mxGraphProperties.isDirected(GraphConfigDialog.this.aGraph.getProperties(), mxGraphProperties.DEFAULT_DIRECTED);
                        mxGraphProperties.setDirected(GraphConfigDialog.this.aGraph.getProperties(), true);
                        System.out.println("BFS test");
                        mxTraversal.bfs(GraphConfigDialog.this.aGraph, startVertex, new mxGraph.mxICellVisitor(){

                            @Override
                            public boolean visit(Object vertex, Object edge) {
                                mxCell v = (mxCell)vertex;
                                mxCell e = (mxCell)edge;
                                if (e != null) {
                                    System.out.println("Vertex: " + v.getValue() + " edge: " + e.getValue());
                                } else {
                                    System.out.println("Vertex: " + v.getValue() + " edge: N/A");
                                }
                                return false;
                            }
                        });
                        mxGraphProperties.setDirected(GraphConfigDialog.this.aGraph.getProperties(), oldDir);
                    } else if (graphType2 == mxGraphProperties.GraphType.DFS_DIR) {
                        boolean oldDir = mxGraphProperties.isDirected(GraphConfigDialog.this.aGraph.getProperties(), mxGraphProperties.DEFAULT_DIRECTED);
                        mxGraphProperties.setDirected(GraphConfigDialog.this.aGraph.getProperties(), true);
                        System.out.println("DFS test");
                        mxTraversal.dfs(GraphConfigDialog.this.aGraph, startVertex, new mxGraph.mxICellVisitor(){

                            @Override
                            public boolean visit(Object vertex, Object edge) {
                                mxCell v = (mxCell)vertex;
                                mxCell e = (mxCell)edge;
                                if (e != null) {
                                    System.out.println("Vertex: " + v.getValue() + " edge: " + e.getValue());
                                } else {
                                    System.out.println("Vertex: " + v.getValue() + " edge: N/A");
                                }
                                return false;
                            }
                        });
                        mxGraphProperties.setDirected(GraphConfigDialog.this.aGraph.getProperties(), oldDir);
                    } else if (graphType2 == mxGraphProperties.GraphType.BFS_UNDIR) {
                        boolean oldDir = mxGraphProperties.isDirected(GraphConfigDialog.this.aGraph.getProperties(), mxGraphProperties.DEFAULT_DIRECTED);
                        mxGraphProperties.setDirected(GraphConfigDialog.this.aGraph.getProperties(), false);
                        System.out.println("BFS test");
                        mxTraversal.bfs(GraphConfigDialog.this.aGraph, startVertex, new mxGraph.mxICellVisitor(){

                            @Override
                            public boolean visit(Object vertex, Object edge) {
                                mxCell v = (mxCell)vertex;
                                mxCell e = (mxCell)edge;
                                if (e != null) {
                                    System.out.println("Vertex: " + v.getValue() + " edge: " + e.getValue());
                                } else {
                                    System.out.println("Vertex: " + v.getValue() + " edge: N/A");
                                }
                                return false;
                            }
                        });
                        mxGraphProperties.setDirected(GraphConfigDialog.this.aGraph.getProperties(), oldDir);
                    } else if (graphType2 == mxGraphProperties.GraphType.DFS_UNDIR) {
                        boolean oldDir = mxGraphProperties.isDirected(GraphConfigDialog.this.aGraph.getProperties(), mxGraphProperties.DEFAULT_DIRECTED);
                        mxGraphProperties.setDirected(GraphConfigDialog.this.aGraph.getProperties(), false);
                        System.out.println("DFS test");
                        mxTraversal.dfs(GraphConfigDialog.this.aGraph, startVertex, new mxGraph.mxICellVisitor(){

                            @Override
                            public boolean visit(Object vertex, Object edge) {
                                mxCell v = (mxCell)vertex;
                                mxCell e = (mxCell)edge;
                                if (e != null) {
                                    System.out.println("Vertex: " + v.getValue() + " edge: " + e.getValue());
                                } else {
                                    System.out.println("Vertex: " + v.getValue() + " edge: N/A");
                                }
                                return false;
                            }
                        });
                        mxGraphProperties.setDirected(GraphConfigDialog.this.aGraph.getProperties(), oldDir);
                    } else if (graphType2 == mxGraphProperties.GraphType.MAKE_TREE_DIRECTED) {
                        try {
                            GraphConfigDialog.this.graph.getModel().beginUpdate();
                            mxGraphStructure.makeTreeDirected(GraphConfigDialog.this.aGraph, startVertex);
                            GraphConfigDialog.this.graph.getModel().endUpdate();
                            GraphConfigDialog.this.graph.getModel().beginUpdate();
                            mxCompactTreeLayout layout = new mxCompactTreeLayout(GraphConfigDialog.this.graph);
                            layout.setHorizontal(false);
                            layout.execute(GraphConfigDialog.this.graph.getDefaultParent());
                            GraphConfigDialog.this.graph.getModel().endUpdate();
                        }
                        catch (StructuralException e1) {
                            System.out.println(e1);
                        }
                    } else if (graphType2 == mxGraphProperties.GraphType.INDEGREE) {
                        int indegree = mxGraphStructure.indegree(GraphConfigDialog.this.aGraph, startVertex);
                        System.out.println("Indegree of " + GraphConfigDialog.this.aGraph.getGraph().getModel().getValue(startVertex) + " is " + indegree);
                    } else if (graphType2 == mxGraphProperties.GraphType.OUTDEGREE) {
                        int outdegree = mxGraphStructure.outdegree(GraphConfigDialog.this.aGraph, startVertex);
                        System.out.println("Outdegree of " + GraphConfigDialog.this.aGraph.getGraph().getModel().getValue(startVertex) + " is " + outdegree);
                    } else if (graphType2 == mxGraphProperties.GraphType.IS_CUT_VERTEX) {
                        boolean isCutVertex = mxGraphStructure.isCutVertex(GraphConfigDialog.this.aGraph, startVertex);
                        if (isCutVertex) {
                            System.out.println("Vertex " + GraphConfigDialog.this.aGraph.getGraph().getModel().getValue(startVertex) + " is a cut vertex.");
                        } else {
                            System.out.println("Vertex " + GraphConfigDialog.this.aGraph.getGraph().getModel().getValue(startVertex) + " is not a cut vertex.");
                        }
                    }
                    GraphConfigDialog.this.setVisible(false);
                }
            });
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.insertGraph = false;
                    GraphConfigDialog.this.setVisible(false);
                }
            });
            this.getContentPane().add((Component)panelBorder, "Center");
            this.getContentPane().add((Component)buttonPanel, "South");
            this.pack();
            this.setResizable(false);
        } else if (graphType2 == mxGraphProperties.GraphType.DIJKSTRA || graphType2 == mxGraphProperties.GraphType.BELLMAN_FORD) {
            JPanel panel = new JPanel(new GridLayout(2, 2, 4, 4));
            panel.add(new JLabel("Starting vertex"));
            panel.add(this.startVertexValueField);
            panel.add(new JLabel("End vertex"));
            panel.add(this.endVertexValueField);
            JPanel panelBorder = new JPanel();
            panelBorder.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelBorder.add(panel);
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY), BorderFactory.createEmptyBorder(16, 8, 8, 8)));
            JButton applyButton = new JButton("Start");
            JButton closeButton = new JButton("Cancel");
            buttonPanel.add(closeButton);
            buttonPanel.add(applyButton);
            this.getRootPane().setDefaultButton(applyButton);
            applyButton.addActionListener(new ActionListener(){
                double distance = 0.0;

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.applyValues();
                    int startValue = Integer.parseInt(GraphConfigDialog.this.startVertexValueField.getText());
                    int endValue = Integer.parseInt(GraphConfigDialog.this.endVertexValueField.getText());
                    Object startVertex = mxGraphStructure.getVertexWithValue(GraphConfigDialog.this.aGraph, startValue);
                    Object endVertex = mxGraphStructure.getVertexWithValue(GraphConfigDialog.this.aGraph, endValue);
                    if (graphType2 == mxGraphProperties.GraphType.DIJKSTRA) {
                        System.out.println("Dijkstra test");
                        try {
                            mxTraversal.dijkstra(GraphConfigDialog.this.aGraph, startVertex, endVertex, new mxGraph.mxICellVisitor(){

                                @Override
                                public boolean visit(Object vertex, Object edge) {
                                    mxCell v = (mxCell)vertex;
                                    mxCell e = (mxCell)edge;
                                    String eVal = "N/A";
                                    if (e != null) {
                                        eVal = e.getValue() == null ? "1.0" : e.getValue().toString();
                                    }
                                    if (!eVal.equals("N/A")) {
                                        distance += Double.parseDouble(eVal);
                                    }
                                    System.out.print("(v: " + v.getValue() + " e: " + eVal + ")");
                                    return false;
                                }
                            });
                            System.out.println(".");
                            System.out.println("Total minimal distance is: " + this.distance);
                        }
                        catch (StructuralException e1) {
                            System.out.println(e1);
                        }
                    }
                    if (graphType2 == mxGraphProperties.GraphType.BELLMAN_FORD) {
                        try {
                            int i;
                            List<Map<Object, Object>> bellmanFord = mxTraversal.bellmanFord(GraphConfigDialog.this.aGraph, startVertex);
                            Map<Object, Object> distanceMap = bellmanFord.get(0);
                            Map<Object, Object> parentMap = bellmanFord.get(1);
                            mxCostFunction costFunction = GraphConfigDialog.this.aGraph.getGenerator().getCostFunction();
                            mxGraphView view = GraphConfigDialog.this.aGraph.getGraph().getView();
                            System.out.println("Bellman-Ford traversal test");
                            Object[] vertices = GraphConfigDialog.this.aGraph.getChildVertices(GraphConfigDialog.this.aGraph.getGraph().getDefaultParent());
                            int vertexNum = vertices.length;
                            System.out.print("Distances from " + costFunction.getCost(view.getState(startVertex)) + " to [ ");
                            for (i = 0; i < vertexNum; ++i) {
                                System.out.print(i + ":" + (double)Math.round((Double)distanceMap.get(vertices[i]) * 100.0) / 100.0 + " ");
                            }
                            System.out.println("]");
                            System.out.print("Parents are [ ");
                            for (i = 0; i < vertexNum; ++i) {
                                System.out.print(i + ":" + costFunction.getCost(view.getState(parentMap.get(vertices[i]))) + " ");
                            }
                            System.out.println("]");
                            if ((Double)distanceMap.get(endVertex) != Double.MAX_VALUE) {
                                System.out.println("The shortest distance from vertex " + costFunction.getCost(view.getState(startVertex)) + " to vertex " + Double.valueOf(costFunction.getCost(view.getState(endVertex))) + " is: " + distanceMap.get(endVertex));
                            } else {
                                System.out.println("The selected vertices aren't connected.");
                            }
                        }
                        catch (StructuralException e1) {
                            System.out.println(e1);
                        }
                    }
                    GraphConfigDialog.this.setVisible(false);
                }
            });
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphConfigDialog.this.insertGraph = false;
                    GraphConfigDialog.this.setVisible(false);
                }
            });
            this.getContentPane().add((Component)panelBorder, "Center");
            this.getContentPane().add((Component)buttonPanel, "South");
            this.pack();
            this.setResizable(false);
        }
    }

    public void configAnalysisGraph(mxGraph graph, mxGraphGenerator generator, Map<String, Object> props) {
        this.aGraph.setGraph(graph);
        if (generator == null) {
            this.aGraph.setGenerator(new mxGraphGenerator(null, null));
        } else {
            this.aGraph.setGenerator(generator);
        }
        if (props == null) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            mxGraphProperties.setDirected(properties, false);
            this.aGraph.setProperties(properties);
        } else {
            this.aGraph.setProperties(props);
        }
    }

    protected void applyValues() {
        this.setNumNodes(Integer.parseInt(this.numNodesField.getText()));
        this.setNumEdges(Integer.parseInt(this.numEdgesField.getText()));
        this.setValence(Integer.parseInt(this.valenceField.getText()));
        this.setNumRows(Integer.parseInt(this.numRowsField.getText()));
        this.setNumColumns(Integer.parseInt(this.numColumnsField.getText()));
        this.setGridSpacing(Float.parseFloat(this.gridSpacingField.getText()));
        this.setNumVertexesLeft(Integer.parseInt(this.numVertexesLeftField.getText()));
        this.setNumVertexesRight(Integer.parseInt(this.numVertexesRightField.getText()));
        this.setGroupSpacing(Float.parseFloat(this.groupSpacingField.getText()));
        this.setArrows(this.arrowsBox.isSelected());
        this.setWeighted(this.weightedBox.isSelected());
        this.setStartVertexValue(Integer.parseInt(this.startVertexValueField.getText()));
        this.setEndVertexValue(Integer.parseInt(this.endVertexValueField.getText()));
        this.setAllowSelfLoops(this.selfLoopBox.isSelected());
        this.setAllowMultipleEdges(this.multipleEdgeBox.isSelected());
        this.setForceConnected(this.forceConnectedBox.isSelected());
        this.setMaxWeight(Integer.parseInt(this.maxWeightField.getText()));
        this.setMinWeight(Integer.parseInt(this.minWeightField.getText()));
        this.setNumBranches(Integer.parseInt(this.numBranchesField.getText()));
        this.setNumVertexesInBranch(Integer.parseInt(this.numVertexesInBranchField.getText()));
    }

    public void configureLayout(mxGraph graph, mxGraphProperties.GraphType graphType, mxAnalysisGraph aGraph) {
        this.graph = graph;
        this.graphType = graphType;
        this.aGraph = aGraph;
        this.numNodesField.setText(String.valueOf(this.getNumNodes()));
        this.numEdgesField.setText(String.valueOf(this.getNumEdges()));
        this.valenceField.setText(String.valueOf(this.getValence()));
        this.numRowsField.setText(String.valueOf(this.getNumRows()));
        this.numColumnsField.setText(String.valueOf(this.getNumColumns()));
        this.gridSpacingField.setText(String.valueOf(this.getGridSpacing()));
        this.numVertexesLeftField.setText(String.valueOf(this.getNumVertexesLeft()));
        this.numVertexesRightField.setText(String.valueOf(this.getNumVertexesRight()));
        this.groupSpacingField.setText(String.valueOf(this.getGroupSpacing()));
        this.arrowsBox.setSelected(this.arrows);
        this.startVertexValueField.setText(String.valueOf(this.getStartVertexValue()));
        this.endVertexValueField.setText(String.valueOf(this.getEndVertexValue()));
        this.selfLoopBox.setSelected(this.allowSelfLoops);
        this.multipleEdgeBox.setSelected(this.allowMultipleEdges);
        this.forceConnectedBox.setSelected(this.forceConnected);
        this.weightedBox.setSelected(this.weighted);
        this.maxWeightField.setText(String.valueOf(this.getMaxWeight()));
        this.minWeightField.setText(String.valueOf(this.getMinWeight()));
        this.numBranchesField.setText(String.valueOf(this.getNumBranches()));
        this.numVertexesInBranchField.setText(String.valueOf(this.getNumVertexesInBranch()));
    }

    public void setAllowMultipleEdges(boolean allowMultipleEdges) {
        this.allowMultipleEdges = allowMultipleEdges;
    }

    public void setAllowSelfLoops(boolean allowSelfLoops) {
        this.allowSelfLoops = allowSelfLoops;
    }

    public void setArrows(boolean arrows) {
        this.arrows = arrows;
    }

    public void setEndVertexValue(int endVertexValue) {
        this.endVertexValue = endVertexValue;
    }

    public void setForceConnected(boolean forceConnected) {
        this.forceConnected = forceConnected;
    }

    public void setGridSpacing(float gridSpacing) {
        if (gridSpacing < 1.0f) {
            gridSpacing = 1.0f;
        }
        this.gridSpacing = gridSpacing;
    }

    public void setGroupSpacing(float groupSpacing) {
        this.groupSpacing = groupSpacing;
    }

    public void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
    }

    public void setNumEdges(int numEdges) {
        if (numEdges < 1) {
            numEdges = 1;
        } else if (numEdges > 2000000) {
            numEdges = 2000000;
        }
        this.numEdges = numEdges;
    }

    public void setNumNodes(int numNodes) {
        if (numNodes < 1) {
            numNodes = 1;
        } else if (numNodes > 2000000) {
            numNodes = 2000000;
        }
        this.numNodes = numNodes;
    }

    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    public void setNumVertexesLeft(int numVertexesLeft) {
        if (numVertexesLeft < 1) {
            numVertexesLeft = 1;
        } else if (numVertexesLeft > 300) {
            numVertexesLeft = 300;
        }
        this.numVertexesLeft = numVertexesLeft;
    }

    public void setNumVertexesRight(int numVertexesRight) {
        if (numVertexesRight < 1) {
            numVertexesRight = 1;
        } else if (numVertexesRight > 300) {
            numVertexesRight = 300;
        }
        this.numVertexesRight = numVertexesRight;
    }

    public void setStartVertexValue(int startVertexValue) {
        this.startVertexValue = startVertexValue;
    }

    public void setValence(int valence) {
        if (valence < 0) {
            valence = 0;
        } else if (valence > 100) {
            valence = 100;
        }
        this.valence = valence;
    }

    public int getEndVertexValue() {
        return this.endVertexValue;
    }

    public float getGridSpacing() {
        return this.gridSpacing;
    }

    public float getGroupSpacing() {
        return this.groupSpacing;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public int getNumEdges() {
        return this.numEdges;
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumVertexesLeft() {
        return this.numVertexesLeft;
    }

    public int getNumVertexesRight() {
        return this.numVertexesRight;
    }

    public int getStartVertexValue() {
        return this.startVertexValue;
    }

    public int getValence() {
        return this.valence;
    }

    public boolean isAllowMultipleEdges() {
        return this.allowMultipleEdges;
    }

    public boolean isAllowSelfLoops() {
        return this.allowSelfLoops;
    }

    public boolean isArrows() {
        return this.arrows;
    }

    public boolean isForceConnected() {
        return this.forceConnected;
    }

    public boolean isWeighted() {
        return this.weighted;
    }

    public void setWeighted(boolean weighted) {
        this.weighted = weighted;
    }
}

