/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.examples.swing.editor;

import com.mxgraph.examples.swing.editor.BasicGraphEditor;
import com.mxgraph.examples.swing.editor.EditorActions;
import com.mxgraph.examples.swing.editor.EditorMenuBar;
import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.util.mxResources;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;

public class EditorPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = -3132749140550242191L;

    public EditorPopupMenu(BasicGraphEditor editor) {
        boolean selected = !editor.getGraphComponent().getGraph().isSelectionEmpty();
        this.add(editor.bind(mxResources.get("undo"), new EditorActions.HistoryAction(true), "/com/mxgraph/examples/swing/images/undo.gif"));
        this.addSeparator();
        this.add(editor.bind(mxResources.get("cut"), TransferHandler.getCutAction(), "/com/mxgraph/examples/swing/images/cut.gif")).setEnabled(selected);
        this.add(editor.bind(mxResources.get("copy"), TransferHandler.getCopyAction(), "/com/mxgraph/examples/swing/images/copy.gif")).setEnabled(selected);
        this.add(editor.bind(mxResources.get("paste"), TransferHandler.getPasteAction(), "/com/mxgraph/examples/swing/images/paste.gif"));
        this.addSeparator();
        this.add(editor.bind(mxResources.get("delete"), mxGraphActions.getDeleteAction(), "/com/mxgraph/examples/swing/images/delete.gif")).setEnabled(selected);
        this.addSeparator();
        JMenu menu = (JMenu)this.add(new JMenu(mxResources.get("format")));
        EditorMenuBar.populateFormatMenu(menu, editor);
        menu = (JMenu)this.add(new JMenu(mxResources.get("shape")));
        EditorMenuBar.populateShapeMenu(menu, editor);
        this.addSeparator();
        this.add(editor.bind(mxResources.get("edit"), mxGraphActions.getEditAction())).setEnabled(selected);
        this.addSeparator();
        this.add(editor.bind(mxResources.get("selectVertices"), mxGraphActions.getSelectVerticesAction()));
        this.add(editor.bind(mxResources.get("selectEdges"), mxGraphActions.getSelectEdgesAction()));
        this.addSeparator();
        this.add(editor.bind(mxResources.get("selectAll"), mxGraphActions.getSelectAllAction()));
    }
}

