/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.examples.swing.editor;

import com.mxgraph.examples.swing.editor.ShadowBorder;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.swing.util.mxGraphTransferable;
import com.mxgraph.swing.util.mxSwingConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.TransferHandler;

public class EditorPalette
extends JPanel {
    private static final long serialVersionUID = 7771113885935187066L;
    protected JLabel selectedEntry = null;
    protected mxEventSource eventSource = new mxEventSource(this);
    protected Color gradientColor = new Color(117, 195, 173);

    public EditorPalette() {
        this.setBackground(new Color(149, 230, 190));
        this.setLayout(new FlowLayout(3, 5, 5));
        this.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                EditorPalette.this.clearSelection();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] flavors) {
                return true;
            }
        });
    }

    public void setGradientColor(Color c) {
        this.gradientColor = c;
    }

    public Color getGradientColor() {
        return this.gradientColor;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.gradientColor == null) {
            super.paintComponent(g);
        } else {
            Rectangle rect = this.getVisibleRect();
            if (g.getClipBounds() != null) {
                rect = rect.intersection(g.getClipBounds());
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), 0.0f, this.gradientColor));
            g2.fill(rect);
        }
    }

    public void clearSelection() {
        this.setSelectionEntry(null, null);
    }

    public void setSelectionEntry(JLabel entry, mxGraphTransferable t) {
        JLabel previous = this.selectedEntry;
        this.selectedEntry = entry;
        if (previous != null) {
            previous.setBorder(null);
            previous.setOpaque(false);
        }
        if (this.selectedEntry != null) {
            this.selectedEntry.setBorder(ShadowBorder.getSharedInstance());
            this.selectedEntry.setOpaque(true);
        }
        this.eventSource.fireEvent(new mxEventObject("select", "entry", this.selectedEntry, "transferable", t, "previous", previous));
    }

    public void setPreferredWidth(int width) {
        int cols = Math.max(1, width / 55);
        this.setPreferredSize(new Dimension(width, this.getComponentCount() * 55 / cols + 30));
        this.revalidate();
    }

    public void addEdgeTemplate(String name, ImageIcon icon, String style, int width, int height, Object value) {
        mxGeometry geometry = new mxGeometry(0.0, 0.0, width, height);
        geometry.setTerminalPoint(new mxPoint(0.0, height), true);
        geometry.setTerminalPoint(new mxPoint(width, 0.0), false);
        geometry.setRelative(true);
        mxCell cell = new mxCell(value, geometry, style);
        cell.setEdge(true);
        this.addTemplate(name, icon, cell);
    }

    public void addTemplate(String name, ImageIcon icon, String style, int width, int height, Object value) {
        mxCell cell = new mxCell(value, new mxGeometry(0.0, 0.0, width, height), style);
        cell.setVertex(true);
        this.addTemplate(name, icon, cell);
    }

    public void addTemplate(String name, ImageIcon icon, mxCell cell) {
        mxGeometry bounds = (mxGeometry)cell.getGeometry().clone();
        final mxGraphTransferable t = new mxGraphTransferable(new Object[]{cell}, bounds);
        if (icon != null && (icon.getIconWidth() > 32 || icon.getIconHeight() > 32)) {
            icon = new ImageIcon(icon.getImage().getScaledInstance(32, 32, 0));
        }
        final JLabel entry = new JLabel(icon);
        entry.setPreferredSize(new Dimension(50, 50));
        entry.setBackground(this.getBackground().brighter());
        entry.setFont(new Font(entry.getFont().getFamily(), 0, 10));
        entry.setVerticalTextPosition(3);
        entry.setHorizontalTextPosition(0);
        entry.setIconTextGap(0);
        entry.setToolTipText(name);
        entry.setText(name);
        entry.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                EditorPalette.this.setSelectionEntry(entry, t);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        DragGestureListener dragGestureListener = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent e) {
                e.startDrag(null, mxSwingConstants.EMPTY_IMAGE, new Point(), t, null);
            }
        };
        DragSource dragSource = new DragSource();
        dragSource.createDefaultDragGestureRecognizer(entry, 1, dragGestureListener);
        this.add(entry);
    }

    public void addListener(String eventName, mxEventSource.mxIEventListener listener) {
        this.eventSource.addListener(eventName, listener);
    }

    public boolean isEventsEnabled() {
        return this.eventSource.isEventsEnabled();
    }

    public void removeListener(mxEventSource.mxIEventListener listener) {
        this.eventSource.removeListener(listener);
    }

    public void removeListener(mxEventSource.mxIEventListener listener, String eventName) {
        this.eventSource.removeListener(listener, eventName);
    }

    public void setEventsEnabled(boolean eventsEnabled) {
        this.eventSource.setEventsEnabled(eventsEnabled);
    }
}

