/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.examples.swing;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxEdgeStyle;
import com.mxgraph.view.mxGraph;
import java.util.Map;
import javax.swing.JFrame;

public class Port
extends JFrame {
    private static final long serialVersionUID = -464235672367772404L;
    final int PORT_DIAMETER = 20;
    final int PORT_RADIUS = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Port() {
        super("Hello, World!");
        mxGraph graph = new mxGraph(){

            @Override
            public boolean isPort(Object cell) {
                mxGeometry geo = this.getCellGeometry(cell);
                return geo != null ? geo.isRelative() : false;
            }

            @Override
            public String getToolTipForCell(Object cell) {
                if (this.model.isEdge(cell)) {
                    return this.convertValueToString(this.model.getTerminal(cell, true)) + " -> " + this.convertValueToString(this.model.getTerminal(cell, false));
                }
                return super.getToolTipForCell(cell);
            }

            @Override
            public boolean isCellFoldable(Object cell, boolean collapse) {
                return false;
            }
        };
        Map<String, Object> style = graph.getStylesheet().getDefaultEdgeStyle();
        style.put(mxConstants.STYLE_EDGE, mxEdgeStyle.ElbowConnector);
        Object parent = graph.getDefaultParent();
        graph.getModel().beginUpdate();
        try {
            mxCell v1 = (mxCell)graph.insertVertex(parent, null, "Hello", 20.0, 20.0, 100.0, 100.0, "");
            v1.setConnectable(false);
            mxGeometry geo = graph.getModel().getGeometry(v1);
            geo.setAlternateBounds(new mxRectangle(20.0, 20.0, 100.0, 50.0));
            mxGeometry geo1 = new mxGeometry(0.0, 0.5, 20.0, 20.0);
            geo1.setOffset(new mxPoint(-10.0, -10.0));
            geo1.setRelative(true);
            mxCell port1 = new mxCell(null, geo1, "shape=ellipse;perimter=ellipsePerimeter");
            port1.setVertex(true);
            mxGeometry geo2 = new mxGeometry(1.0, 0.5, 20.0, 20.0);
            geo2.setOffset(new mxPoint(-10.0, -10.0));
            geo2.setRelative(true);
            mxCell port2 = new mxCell(null, geo2, "shape=ellipse;perimter=ellipsePerimeter");
            port2.setVertex(true);
            graph.addCell(port1, v1);
            graph.addCell(port2, v1);
            Object v2 = graph.insertVertex(parent, null, "World!", 240.0, 150.0, 80.0, 30.0);
            graph.insertEdge(parent, null, "Edge", port2, v2);
        }
        finally {
            graph.getModel().endUpdate();
        }
        mxGraphComponent graphComponent = new mxGraphComponent(graph);
        this.getContentPane().add(graphComponent);
        graphComponent.setToolTips(true);
    }

    public static void main(String[] args) {
        Port frame = new Port();
        frame.setDefaultCloseOperation(3);
        frame.setSize(400, 320);
        frame.setVisible(true);
    }
}

