/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.examples.swing;

import com.mxgraph.examples.swing.editor.BasicGraphEditor;
import com.mxgraph.examples.swing.editor.EditorMenuBar;
import com.mxgraph.examples.swing.editor.EditorPalette;
import com.mxgraph.io.mxCodec;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphTransferable;
import com.mxgraph.swing.util.mxSwingConstants;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxResources;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.Point;
import java.net.URL;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.w3c.dom.Document;

public class GraphEditor
extends BasicGraphEditor {
    private static final long serialVersionUID = -4601740824088314699L;
    public static final NumberFormat numberFormat = NumberFormat.getInstance();
    public static URL url = null;

    public GraphEditor() {
        this("mxGraph Editor", new CustomGraphComponent(new CustomGraph()));
    }

    public GraphEditor(String appTitle, mxGraphComponent component) {
        super(appTitle, component);
        final mxGraph graph = this.graphComponent.getGraph();
        EditorPalette shapesPalette = this.insertPalette(mxResources.get("shapes"));
        EditorPalette imagesPalette = this.insertPalette(mxResources.get("images"));
        EditorPalette symbolsPalette = this.insertPalette(mxResources.get("symbols"));
        shapesPalette.addListener("select", new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object sender, mxEventObject evt) {
                Object tmp = evt.getProperty("transferable");
                if (tmp instanceof mxGraphTransferable) {
                    mxGraphTransferable t = (mxGraphTransferable)tmp;
                    Object cell = t.getCells()[0];
                    if (graph.getModel().isEdge(cell)) {
                        ((CustomGraph)graph).setEdgeTemplate(cell);
                    }
                }
            }
        });
        shapesPalette.addTemplate("Container", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/swimlane.png")), "swimlane", 280, 280, "Container");
        shapesPalette.addTemplate("Icon", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/rounded.png")), "icon;image=/com/mxgraph/examples/swing/images/wrench.png", 70, 70, "Icon");
        shapesPalette.addTemplate("Label", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/rounded.png")), "label;image=/com/mxgraph/examples/swing/images/gear.png", 130, 50, "Label");
        shapesPalette.addTemplate("Rectangle", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/rectangle.png")), null, 160, 120, "");
        shapesPalette.addTemplate("Rounded Rectangle", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/rounded.png")), "rounded=1", 160, 120, "");
        shapesPalette.addTemplate("Double Rectangle", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/doublerectangle.png")), "rectangle;shape=doubleRectangle", 160, 120, "");
        shapesPalette.addTemplate("Ellipse", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/ellipse.png")), "ellipse", 160, 160, "");
        shapesPalette.addTemplate("Double Ellipse", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/doubleellipse.png")), "ellipse;shape=doubleEllipse", 160, 160, "");
        shapesPalette.addTemplate("Triangle", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/triangle.png")), "triangle", 120, 160, "");
        shapesPalette.addTemplate("Rhombus", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/rhombus.png")), "rhombus", 160, 160, "");
        shapesPalette.addTemplate("Horizontal Line", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/hline.png")), "line", 160, 10, "");
        shapesPalette.addTemplate("Hexagon", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/hexagon.png")), "shape=hexagon", 160, 120, "");
        shapesPalette.addTemplate("Cylinder", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/cylinder.png")), "shape=cylinder", 120, 160, "");
        shapesPalette.addTemplate("Actor", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/actor.png")), "shape=actor", 120, 160, "");
        shapesPalette.addTemplate("Cloud", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/cloud.png")), "ellipse;shape=cloud", 160, 120, "");
        shapesPalette.addEdgeTemplate("Straight", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/straight.png")), "straight", 120, 120, "");
        shapesPalette.addEdgeTemplate("Horizontal Connector", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/connect.png")), null, 100, 100, "");
        shapesPalette.addEdgeTemplate("Vertical Connector", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/vertical.png")), "vertical", 100, 100, "");
        shapesPalette.addEdgeTemplate("Entity Relation", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/entity.png")), "entity", 100, 100, "");
        shapesPalette.addEdgeTemplate("Arrow", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/arrow.png")), "arrow", 120, 120, "");
        imagesPalette.addTemplate("Bell", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/bell.png")), "image;image=/com/mxgraph/examples/swing/images/bell.png", 50, 50, "Bell");
        imagesPalette.addTemplate("Box", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/box.png")), "image;image=/com/mxgraph/examples/swing/images/box.png", 50, 50, "Box");
        imagesPalette.addTemplate("Cube", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/cube_green.png")), "image;image=/com/mxgraph/examples/swing/images/cube_green.png", 50, 50, "Cube");
        imagesPalette.addTemplate("User", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/dude3.png")), "roundImage;image=/com/mxgraph/examples/swing/images/dude3.png", 50, 50, "User");
        imagesPalette.addTemplate("Earth", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/earth.png")), "roundImage;image=/com/mxgraph/examples/swing/images/earth.png", 50, 50, "Earth");
        imagesPalette.addTemplate("Gear", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/gear.png")), "roundImage;image=/com/mxgraph/examples/swing/images/gear.png", 50, 50, "Gear");
        imagesPalette.addTemplate("Home", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/house.png")), "image;image=/com/mxgraph/examples/swing/images/house.png", 50, 50, "Home");
        imagesPalette.addTemplate("Package", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/package.png")), "image;image=/com/mxgraph/examples/swing/images/package.png", 50, 50, "Package");
        imagesPalette.addTemplate("Printer", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/printer.png")), "image;image=/com/mxgraph/examples/swing/images/printer.png", 50, 50, "Printer");
        imagesPalette.addTemplate("Server", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/server.png")), "image;image=/com/mxgraph/examples/swing/images/server.png", 50, 50, "Server");
        imagesPalette.addTemplate("Workplace", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/workplace.png")), "image;image=/com/mxgraph/examples/swing/images/workplace.png", 50, 50, "Workplace");
        imagesPalette.addTemplate("Wrench", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/wrench.png")), "roundImage;image=/com/mxgraph/examples/swing/images/wrench.png", 50, 50, "Wrench");
        symbolsPalette.addTemplate("Cancel", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/cancel_end.png")), "roundImage;image=/com/mxgraph/examples/swing/images/cancel_end.png", 80, 80, "Cancel");
        symbolsPalette.addTemplate("Error", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/error.png")), "roundImage;image=/com/mxgraph/examples/swing/images/error.png", 80, 80, "Error");
        symbolsPalette.addTemplate("Event", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/event.png")), "roundImage;image=/com/mxgraph/examples/swing/images/event.png", 80, 80, "Event");
        symbolsPalette.addTemplate("Fork", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/fork.png")), "rhombusImage;image=/com/mxgraph/examples/swing/images/fork.png", 80, 80, "Fork");
        symbolsPalette.addTemplate("Inclusive", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/inclusive.png")), "rhombusImage;image=/com/mxgraph/examples/swing/images/inclusive.png", 80, 80, "Inclusive");
        symbolsPalette.addTemplate("Link", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/link.png")), "roundImage;image=/com/mxgraph/examples/swing/images/link.png", 80, 80, "Link");
        symbolsPalette.addTemplate("Merge", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/merge.png")), "rhombusImage;image=/com/mxgraph/examples/swing/images/merge.png", 80, 80, "Merge");
        symbolsPalette.addTemplate("Message", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/message.png")), "roundImage;image=/com/mxgraph/examples/swing/images/message.png", 80, 80, "Message");
        symbolsPalette.addTemplate("Multiple", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/multiple.png")), "roundImage;image=/com/mxgraph/examples/swing/images/multiple.png", 80, 80, "Multiple");
        symbolsPalette.addTemplate("Rule", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/rule.png")), "roundImage;image=/com/mxgraph/examples/swing/images/rule.png", 80, 80, "Rule");
        symbolsPalette.addTemplate("Terminate", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/terminate.png")), "roundImage;image=/com/mxgraph/examples/swing/images/terminate.png", 80, 80, "Terminate");
        symbolsPalette.addTemplate("Timer", new ImageIcon(GraphEditor.class.getResource("/com/mxgraph/examples/swing/images/timer.png")), "roundImage;image=/com/mxgraph/examples/swing/images/timer.png", 80, 80, "Timer");
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        mxSwingConstants.SHADOW_COLOR = Color.LIGHT_GRAY;
        mxConstants.W3C_SHADOWCOLOR = "#D3D3D3";
        GraphEditor editor = new GraphEditor();
        editor.createFrame(new EditorMenuBar(editor)).setVisible(true);
    }

    public static class CustomGraph
    extends mxGraph {
        protected Object edgeTemplate;

        public CustomGraph() {
            this.setAlternateEdgeStyle("edgeStyle=mxEdgeStyle.ElbowConnector;elbow=vertical");
        }

        public void setEdgeTemplate(Object template) {
            this.edgeTemplate = template;
        }

        @Override
        public String getToolTipForCell(Object cell) {
            String tip = "<html>";
            mxGeometry geo = this.getModel().getGeometry(cell);
            mxCellState state = this.getView().getState(cell);
            if (this.getModel().isEdge(cell)) {
                List<mxPoint> points;
                tip = tip + "points={";
                if (geo != null && (points = geo.getPoints()) != null) {
                    for (mxPoint point : points) {
                        tip = tip + "[x=" + numberFormat.format(point.getX()) + ",y=" + numberFormat.format(point.getY()) + "],";
                    }
                    tip = tip.substring(0, tip.length() - 1);
                }
                tip = tip + "}<br>";
                tip = tip + "absPoints={";
                if (state != null) {
                    for (int i = 0; i < state.getAbsolutePointCount(); ++i) {
                        mxPoint point = state.getAbsolutePoint(i);
                        tip = tip + "[x=" + numberFormat.format(point.getX()) + ",y=" + numberFormat.format(point.getY()) + "],";
                    }
                    tip = tip.substring(0, tip.length() - 1);
                }
                tip = tip + "}";
            } else {
                tip = tip + "geo=[";
                if (geo != null) {
                    tip = tip + "x=" + numberFormat.format(geo.getX()) + ",y=" + numberFormat.format(geo.getY()) + ",width=" + numberFormat.format(geo.getWidth()) + ",height=" + numberFormat.format(geo.getHeight());
                }
                tip = tip + "]<br>";
                tip = tip + "state=[";
                if (state != null) {
                    tip = tip + "x=" + numberFormat.format(state.getX()) + ",y=" + numberFormat.format(state.getY()) + ",width=" + numberFormat.format(state.getWidth()) + ",height=" + numberFormat.format(state.getHeight());
                }
                tip = tip + "]";
            }
            mxPoint trans = this.getView().getTranslate();
            tip = tip + "<br>scale=" + numberFormat.format(this.getView().getScale()) + ", translate=[x=" + numberFormat.format(trans.getX()) + ",y=" + numberFormat.format(trans.getY()) + "]";
            tip = tip + "</html>";
            return tip;
        }

        @Override
        public Object createEdge(Object parent, String id, Object value, Object source, Object target, String style) {
            if (this.edgeTemplate != null) {
                mxCell edge = (mxCell)this.cloneCells(new Object[]{this.edgeTemplate})[0];
                edge.setId(id);
                return edge;
            }
            return super.createEdge(parent, id, value, source, target, style);
        }
    }

    public static class CustomGraphComponent
    extends mxGraphComponent {
        private static final long serialVersionUID = -6833603133512882012L;

        public CustomGraphComponent(mxGraph graph) {
            super(graph);
            this.setPageVisible(true);
            this.setGridVisible(true);
            this.setToolTips(true);
            this.getConnectionHandler().setCreateTarget(true);
            mxCodec codec = new mxCodec();
            Document doc = mxUtils.loadDocument(GraphEditor.class.getResource("/com/mxgraph/examples/swing/resources/default-style.xml").toString());
            codec.decode(doc.getDocumentElement(), graph.getStylesheet());
            this.getViewport().setOpaque(true);
            this.getViewport().setBackground(Color.WHITE);
        }

        @Override
        public Object[] importCells(Object[] cells, double dx, double dy, Object target, Point location) {
            if (target == null && cells.length == 1 && location != null && (target = this.getCellAt(location.x, location.y)) instanceof mxICell && cells[0] instanceof mxICell) {
                mxICell targetCell = (mxICell)target;
                mxICell dropCell = (mxICell)cells[0];
                if (targetCell.isVertex() == dropCell.isVertex() || targetCell.isEdge() == dropCell.isEdge()) {
                    mxIGraphModel model = this.graph.getModel();
                    model.setStyle(target, model.getStyle(cells[0]));
                    this.graph.setSelectionCell(target);
                    return null;
                }
            }
            return super.importCells(cells, dx, dy, target, location);
        }
    }
}

