/*
 * Decompiled with CFR 0.152.
 */
package com.aptech.gaussApi5_0;

public class GaussMatrixInfo {
    private int rows = 0;
    private int cols = 0;
    private boolean isComplexFlag = false;

    public GaussMatrixInfo(double[][] dArray) {
        this.rows = dArray.length;
        this.cols = dArray[0].length;
        for (int i = 0; i < this.rows; ++i) {
            if (dArray[i].length == this.cols) continue;
            throw new IllegalArgumentException("All rows must have the same length.");
        }
        if (this.cols == 0) {
            this.rows = 0;
        }
        this.isComplexFlag = false;
    }

    public GaussMatrixInfo(int n, int n2, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException("Number of Rows, " + n + " is negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Number of Columns, " + n2 + " is negative");
        }
        this.rows = n;
        this.cols = n2;
        if (bl ? (long)this.rows * (long)this.cols > 0x7FFFFFFL : (long)this.rows * (long)this.cols > 0xFFFFFFFL) {
            throw new IllegalArgumentException("Matrix size exceeds 2147483647 bytes");
        }
        this.isComplexFlag = bl;
    }

    GaussMatrixInfo() {
    }

    public boolean isComplex() {
        return this.isComplexFlag;
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public String toString() {
        return "GaussMatrixInfo Rows:" + this.getRows() + " Cols:" + this.getCols() + " isComplex:" + this.isComplex();
    }
}

