/*
 * Decompiled with CFR 0.152.
 */
package au.com.forward.utils;

import java.util.ArrayList;
import java.util.HashMap;

public class ReadWriteOrderedLock {
    private int activeReaders = 0;
    private int activeWriters = 0;
    private boolean showWaitingTime = false;
    private ArrayList<ReadWriteLocalLock> waitingThreads = new ArrayList();
    private HashMap<Thread, ReadWriteLocalLock> activeWriterThreads = new HashMap(5);
    private HashMap<Thread, ReadWriteLocalLock> activeReaderThreads = new HashMap(100);

    public ReadWriteOrderedLock() {
        this(false);
    }

    public ReadWriteOrderedLock(boolean bl) {
        this.showWaitingTime(bl);
    }

    public void showWaitingTime(boolean bl) {
        this.showWaitingTime = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestReadLock() throws InterruptedException {
        ReadLock readLock;
        if (this.activeWriterThreads.get(Thread.currentThread()) != null) {
            throw new IllegalStateException("Thread:'" + Thread.currentThread().getName() + "' called requestReadLock() when it already had a WriteLock.");
        }
        ReadLock readLock2 = readLock = new ReadLock();
        synchronized (readLock2) {
            ReadWriteOrderedLock readWriteOrderedLock = this;
            synchronized (readWriteOrderedLock) {
                if (this.showWaitingTime) {
                    System.out.println("RequestReadLock Current active readers:" + this.activeReaders + " writers:" + this.activeWriters);
                }
                if (this.activeWriters == 0) {
                    if (this.showWaitingTime) {
                        System.out.println(readLock.timeWaiting());
                    }
                    ++this.activeReaders;
                    this.activeReaderThreads.put(Thread.currentThread(), readLock);
                    return;
                }
                this.waitingThreads.add(readLock);
            }
            try {
                readLock.wait();
            }
            catch (InterruptedException interruptedException) {
                int n = this.waitingThreads.indexOf(readLock);
                if (n >= 0) {
                    this.waitingThreads.remove(n);
                }
                throw interruptedException;
            }
        }
    }

    public synchronized boolean requestReadTryLock() {
        if (this.activeWriterThreads.get(Thread.currentThread()) != null) {
            throw new IllegalStateException("Thread:'" + Thread.currentThread().getName() + "' called requestReadTryLock() when it already had a WriteLock.");
        }
        ReadLock readLock = new ReadLock();
        if (this.activeWriters == 0) {
            if (this.showWaitingTime) {
                System.out.println(readLock.timeWaiting());
            }
            ++this.activeReaders;
            this.activeReaderThreads.put(Thread.currentThread(), readLock);
            return true;
        }
        return false;
    }

    public synchronized void releaseLock() {
        ReadWriteLocalLock readWriteLocalLock;
        if (this.showWaitingTime) {
            System.out.println("ReleaseLock Current active readers:" + this.activeReaders + " writers:" + this.activeWriters);
        }
        if ((readWriteLocalLock = this.activeReaderThreads.remove(Thread.currentThread())) == null) {
            readWriteLocalLock = this.activeWriterThreads.get(Thread.currentThread());
        }
        if (readWriteLocalLock instanceof ReadLock) {
            if (--this.activeReaders == 0) {
                this.notify_next();
            }
            return;
        }
        if (readWriteLocalLock instanceof WriteLock) {
            --this.activeWriters;
            if (this.activeWriters == 0) {
                this.activeWriterThreads.remove(Thread.currentThread());
                this.notify_next();
            }
            return;
        }
        if (readWriteLocalLock == null) {
            throw new IllegalStateException("Thread:'" + Thread.currentThread().getName() + "' called releaseLock() when it did not have a Lock.");
        }
    }

    public synchronized boolean requestWriteTryLock() {
        if (this.activeReaderThreads.get(Thread.currentThread()) != null) {
            throw new IllegalStateException("Thread:'" + Thread.currentThread().getName() + "' called requestWriteTryLock() when it already had a ReadLock.");
        }
        if (this.activeReaders == 0 && (this.activeWriters == 0 || this.activeWriterThreads.get(Thread.currentThread()) instanceof WriteLock)) {
            if (this.showWaitingTime) {
                System.out.println(new WriteLock().timeWaiting());
            }
            ++this.activeWriters;
            if (this.activeWriters == 1) {
                this.activeWriterThreads.put(Thread.currentThread(), new WriteLock());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestWriteLock() throws InterruptedException {
        WriteLock writeLock;
        WriteLock writeLock2 = writeLock = new WriteLock();
        synchronized (writeLock2) {
            ReadWriteOrderedLock readWriteOrderedLock = this;
            synchronized (readWriteOrderedLock) {
                if (this.activeReaderThreads.get(Thread.currentThread()) != null) {
                    throw new IllegalStateException("Thread:'" + Thread.currentThread().getName() + "' called requestWriteLock() when it already had a ReadLock.");
                }
                if (this.showWaitingTime) {
                    System.out.println("RequestWriteLock Current active readers:" + this.activeReaders + " writers:" + this.activeWriters);
                }
                if (this.activeReaders == 0 && (this.activeWriters == 0 || this.activeWriterThreads.get(Thread.currentThread()) instanceof WriteLock)) {
                    if (this.showWaitingTime) {
                        System.out.println(writeLock.timeWaiting());
                    }
                    ++this.activeWriters;
                    if (this.activeWriters == 1) {
                        this.activeWriterThreads.put(Thread.currentThread(), writeLock);
                    }
                    return;
                }
                this.waitingThreads.add(writeLock);
            }
            try {
                writeLock.wait();
            }
            catch (InterruptedException interruptedException) {
                int n = this.waitingThreads.indexOf(writeLock);
                if (n >= 0) {
                    this.waitingThreads.remove(n);
                }
                throw interruptedException;
            }
        }
    }

    public synchronized void swapWriteToReadLock() {
        ReadWriteLocalLock readWriteLocalLock;
        if (this.showWaitingTime) {
            System.out.println("swapWriteToReadLock Currently active readers:" + this.activeReaders + " writers:" + this.activeWriters);
        }
        if ((readWriteLocalLock = this.activeWriterThreads.remove(Thread.currentThread())) == null) {
            throw new IllegalStateException("Thread:'" + Thread.currentThread().getName() + "' called swapWriteToReadLock() when it did not have a Write Lock.");
        }
        if (readWriteLocalLock instanceof ReadLock) {
            throw new IllegalStateException("Thread:'" + Thread.currentThread().getName() + "' called swapWriteToReadLock() when it did not have a Write Lock.");
        }
        if (readWriteLocalLock instanceof WriteLock) {
            --this.activeWriters;
            if (this.activeWriters != 0) {
                throw new IllegalStateException("Thread:'" + Thread.currentThread().getName() + "' called releaseLock() when there were more then one active Writer threads.");
            }
            ReadLock readLock = new ReadLock();
            ++this.activeReaders;
            this.activeReaderThreads.put(Thread.currentThread(), readLock);
            this.notify_next();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify_next() {
        while (this.waitingThreads.size() > 0) {
            ReadWriteLocalLock readWriteLocalLock;
            ReadWriteLocalLock readWriteLocalLock2 = this.waitingThreads.get(0);
            if (readWriteLocalLock2 instanceof WriteLock) {
                if (this.activeReaders != 0 || this.activeWriters != 0) break;
                ++this.activeWriters;
                this.activeWriterThreads.put(readWriteLocalLock2.getThread(), readWriteLocalLock2);
                this.waitingThreads.remove(0);
                readWriteLocalLock = readWriteLocalLock2;
                synchronized (readWriteLocalLock) {
                    if (this.showWaitingTime) {
                        System.out.println(readWriteLocalLock2.timeWaiting());
                    }
                    readWriteLocalLock2.notify();
                    continue;
                }
            }
            if (readWriteLocalLock2 instanceof ReadLock) {
                if (this.activeWriters != 0) break;
                ++this.activeReaders;
                this.activeReaderThreads.put(readWriteLocalLock2.getThread(), readWriteLocalLock2);
                this.waitingThreads.remove(0);
                readWriteLocalLock = readWriteLocalLock2;
                synchronized (readWriteLocalLock) {
                    if (this.showWaitingTime) {
                        System.out.println(readWriteLocalLock2.timeWaiting());
                    }
                    readWriteLocalLock2.notify();
                    continue;
                }
            }
            throw new IllegalStateException("Waiting lock not a ReaderLock or a WriterLock");
        }
    }

    class ReadLock
    extends ReadWriteLocalLock {
        ReadLock() {
        }
    }

    class WriteLock
    extends ReadWriteLocalLock {
        WriteLock() {
        }
    }

    class ReadWriteLocalLock {
        private long creationTimeInMilliSeconds = System.currentTimeMillis();
        private Thread owner = Thread.currentThread();

        ReadWriteLocalLock() {
        }

        Thread getThread() {
            return this.owner;
        }

        String timeWaiting() {
            long l = System.currentTimeMillis() - this.creationTimeInMilliSeconds;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            long l7 = 0L;
            String string = "Thread " + this.owner.getName() + " was " + (this instanceof WriteLock ? "write locked for " : "read locked for ");
            l6 = l / 10L;
            l5 = l - l6 * 10L;
            l7 = l6 / 10L;
            l6 -= l7 * 10L;
            l4 = l7 / 10L;
            l7 -= l4 * 10L;
            l3 = l4 / 60L;
            l4 -= l3 * 60L;
            l2 = l3 / 60L;
            l3 -= l2 * 60L;
            if (l2 != 0L) {
                if (l2 < 10L) {
                    string = string + "0";
                }
                string = string + l2 + ":";
            } else {
                string = string + "00:";
            }
            if (l3 != 0L) {
                if (l3 < 10L) {
                    string = string + "0";
                }
                string = string + l3 + ":";
            } else {
                string = string + "00:";
            }
            string = string + l4;
            if (l5 == 0L) {
                if (l6 == 0L) {
                    if (l7 != 0L) {
                        string = string + "." + l7;
                    }
                } else {
                    string = string + "." + l7 + l6;
                }
            } else {
                string = string + "." + l7 + l6 + l5;
            }
            string = string + " (hh:mm:ss)";
            return string;
        }
    }
}

