/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.InvalidUnitException;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.VerticalBox;

public class UnderOverAtom
extends Atom {
    private final Atom base;
    private final Atom under;
    private final Atom over;
    private final float underSpace;
    private final float overSpace;
    private final int underUnit;
    private final int overUnit;
    private final boolean underScriptSize;
    private final boolean overScriptSize;

    public UnderOverAtom(Atom base, Atom underOver, int underOverUnit, float underOverSpace, boolean underOverScriptSize, boolean over) {
        SpaceAtom.checkUnit(underOverUnit);
        this.base = base;
        this.type = this.type;
        if (over) {
            this.under = null;
            this.underSpace = 0.0f;
            this.underUnit = 0;
            this.underScriptSize = false;
            this.over = underOver;
            this.overUnit = underOverUnit;
            this.overSpace = underOverSpace;
            this.overScriptSize = underOverScriptSize;
        } else {
            this.under = underOver;
            this.underUnit = underOverUnit;
            this.underSpace = underOverSpace;
            this.underScriptSize = underOverScriptSize;
            this.overSpace = 0.0f;
            this.over = null;
            this.overUnit = 0;
            this.overScriptSize = false;
        }
    }

    public UnderOverAtom(Atom base, Atom under, int underUnit, float underSpace, boolean underScriptSize, Atom over, int overUnit, float overSpace, boolean overScriptSize) throws InvalidUnitException {
        SpaceAtom.checkUnit(underUnit);
        SpaceAtom.checkUnit(overUnit);
        this.base = base;
        this.under = under;
        this.underUnit = underUnit;
        this.underSpace = underSpace;
        this.underScriptSize = underScriptSize;
        this.over = over;
        this.overUnit = overUnit;
        this.overSpace = overSpace;
        this.overScriptSize = overScriptSize;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        Box b = this.base == null ? new StrutBox(0.0f, 0.0f, 0.0f, 0.0f) : this.base.createBox(env);
        Box o = null;
        Box u = null;
        float max = b.getWidth();
        if (this.over != null) {
            o = this.over.createBox(this.overScriptSize ? env.subStyle() : env);
            max = Math.max(max, o.getWidth());
        }
        if (this.under != null) {
            u = this.under.createBox(this.underScriptSize ? env.subStyle() : env);
            max = Math.max(max, u.getWidth());
        }
        VerticalBox vBox = new VerticalBox();
        env.setLastFontId(b.getLastFontId());
        if (this.over != null) {
            vBox.add(UnderOverAtom.changeWidth(o, max));
            vBox.add(new SpaceAtom(this.overUnit, 0.0f, this.overSpace, 0.0f).createBox(env));
        }
        Box c = UnderOverAtom.changeWidth(b, max);
        vBox.add(c);
        float h = vBox.getHeight() + vBox.getDepth() - c.getDepth();
        if (this.under != null) {
            vBox.add(new SpaceAtom(this.overUnit, 0.0f, this.underSpace, 0.0f).createBox(env));
            vBox.add(UnderOverAtom.changeWidth(u, max));
        }
        vBox.setDepth(vBox.getHeight() + vBox.getDepth() - h);
        vBox.setHeight(h);
        return vBox;
    }

    private static Box changeWidth(Box b, float maxWidth) {
        if (b != null && Math.abs(maxWidth - b.getWidth()) > 1.0E-7f) {
            return new HorizontalBox(b, maxWidth, 2);
        }
        return b;
    }

    @Override
    public int getLeftType() {
        return this.base.getLeftType();
    }

    @Override
    public int getRightType() {
        return this.base.getRightType();
    }
}

