/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.HashMap;
import java.util.Map;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Glue;
import org.scilab.forge.jlatexmath.InvalidUnitException;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.TeXFormula;

public class SpaceAtom
extends Atom {
    private static Map<String, Integer> units = new HashMap<String, Integer>();
    private static UnitConversion[] unitConversions;
    private boolean blankSpace;
    private int blankType;
    private float width;
    private float height;
    private float depth;
    private int wUnit;
    private int hUnit;
    private int dUnit;

    public SpaceAtom() {
        this.blankSpace = true;
    }

    public SpaceAtom(int type) {
        this.blankSpace = true;
        this.blankType = type;
    }

    public SpaceAtom(int unit, float width, float height, float depth) throws InvalidUnitException {
        SpaceAtom.checkUnit(unit);
        this.wUnit = unit;
        this.hUnit = unit;
        this.dUnit = unit;
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    public static void checkUnit(int unit) throws InvalidUnitException {
        if (unit < 0 || unit >= unitConversions.length) {
            throw new InvalidUnitException();
        }
    }

    public SpaceAtom(int widthUnit, float width, int heightUnit, float height, int depthUnit, float depth) throws InvalidUnitException {
        SpaceAtom.checkUnit(widthUnit);
        SpaceAtom.checkUnit(heightUnit);
        SpaceAtom.checkUnit(depthUnit);
        this.wUnit = widthUnit;
        this.hUnit = heightUnit;
        this.dUnit = depthUnit;
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    public static int getUnit(String unit) {
        Integer u = units.get(unit);
        return u == null ? 2 : u;
    }

    public static float[] getLength(String lgth) {
        int i;
        if (lgth == null) {
            return new float[]{2.0f, 0.0f};
        }
        for (i = 0; i < lgth.length() && !Character.isLetter(lgth.charAt(i)); ++i) {
        }
        float f = 0.0f;
        try {
            f = Float.parseFloat(lgth.substring(0, i));
        }
        catch (NumberFormatException e) {
            return new float[]{Float.NaN};
        }
        int unit = i != lgth.length() ? SpaceAtom.getUnit(lgth.substring(i).toLowerCase()) : 2;
        return new float[]{unit, f};
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        if (this.blankSpace) {
            int bl;
            if (this.blankType == 0) {
                return new StrutBox(env.getSpace(), 0.0f, 0.0f, 0.0f);
            }
            int n = bl = this.blankType < 0 ? -this.blankType : this.blankType;
            Box b = bl == 1 ? Glue.get(7, 1, env) : (bl == 2 ? Glue.get(2, 1, env) : Glue.get(3, 1, env));
            if (this.blankType < 0) {
                b.negWidth();
            }
            return b;
        }
        return new StrutBox(this.width * SpaceAtom.getFactor(this.wUnit, env), this.height * SpaceAtom.getFactor(this.hUnit, env), this.depth * SpaceAtom.getFactor(this.dUnit, env), 0.0f);
    }

    public static float getFactor(int unit, TeXEnvironment env) {
        return unitConversions[unit].getPixelConversion(env);
    }

    static {
        units.put("em", 0);
        units.put("ex", 1);
        units.put("px", 2);
        units.put("pix", 2);
        units.put("pixel", 2);
        units.put("pt", 10);
        units.put("bp", 3);
        units.put("pica", 4);
        units.put("pc", 4);
        units.put("mu", 5);
        units.put("cm", 6);
        units.put("mm", 7);
        units.put("in", 8);
        units.put("sp", 9);
        units.put("dd", 11);
        units.put("cc", 12);
        unitConversions = new UnitConversion[]{new UnitConversion(){

            @Override
            public float getPixelConversion(TeXEnvironment env) {
                return env.getTeXFont().getEM(env.getStyle());
            }
        }, new UnitConversion(){

            @Override
            public float getPixelConversion(TeXEnvironment env) {
                return env.getTeXFont().getXHeight(env.getStyle(), env.getLastFontId());
            }
        }, new UnitConversion(){

            @Override
            public float getPixelConversion(TeXEnvironment env) {
                return 1.0f / env.getSize();
            }
        }, new UnitConversion(){

            @Override
            public float getPixelConversion(TeXEnvironment env) {
                return TeXFormula.PIXELS_PER_POINT / env.getSize();
            }
        }, new UnitConversion(){

            @Override
            public float getPixelConversion(TeXEnvironment env) {
                return 12.0f * TeXFormula.PIXELS_PER_POINT / env.getSize();
            }
        }, new UnitConversion(){

            @Override
            public float getPixelConversion(TeXEnvironment env) {
                TeXFont tf = env.getTeXFont();
                return tf.getQuad(env.getStyle(), tf.getMuFontId()) / 18.0f;
            }
        }, new UnitConversion(){

            @Override
            public float getPixelConversion(TeXEnvironment env) {
                return 28.346457f * TeXFormula.PIXELS_PER_POINT / env.getSize();
            }
        }, new UnitConversion(){

            @Override
            public float getPixelConversion(TeXEnvironment env) {
                return 2.8346457f * TeXFormula.PIXELS_PER_POINT / env.getSize();
            }
        }, new UnitConversion(){

            @Override
            public float getPixelConversion(TeXEnvironment env) {
                return 72.0f * TeXFormula.PIXELS_PER_POINT / env.getSize();
            }
        }, new UnitConversion(){

            @Override
            public float getPixelConversion(TeXEnvironment env) {
                return 65536.0f * TeXFormula.PIXELS_PER_POINT / env.getSize();
            }
        }, new UnitConversion(){

            @Override
            public float getPixelConversion(TeXEnvironment env) {
                return 0.996264f * TeXFormula.PIXELS_PER_POINT / env.getSize();
            }
        }, new UnitConversion(){

            @Override
            public float getPixelConversion(TeXEnvironment env) {
                return 1.0660349f * TeXFormula.PIXELS_PER_POINT / env.getSize();
            }
        }, new UnitConversion(){

            @Override
            public float getPixelConversion(TeXEnvironment env) {
                return 12.792419f * TeXFormula.PIXELS_PER_POINT / env.getSize();
            }
        }};
    }

    private static interface UnitConversion {
        public float getPixelConversion(TeXEnvironment var1);
    }
}

