/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.RoundRectangle2D;
import org.scilab.forge.jlatexmath.FramedBox;

public class OvalBox
extends FramedBox {
    private float shadowRule;

    public OvalBox(FramedBox fbox) {
        super(fbox.box, fbox.thickness, fbox.space);
    }

    @Override
    public void draw(Graphics2D g2, float x, float y) {
        this.box.draw(g2, x + this.space + this.thickness, y);
        Stroke st = g2.getStroke();
        g2.setStroke(new BasicStroke(this.thickness, 0, 0));
        float th = this.thickness / 2.0f;
        float r = 0.5f * Math.min(this.width - this.thickness, this.height + this.depth - this.thickness);
        g2.draw(new RoundRectangle2D.Float(x + th, y - this.height + th, this.width - this.thickness, this.height + this.depth - this.thickness, r, r));
        g2.setStroke(st);
    }

    @Override
    public int getLastFontId() {
        return this.box.getLastFontId();
    }
}

