/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoVertexT5OptionsPanel;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import jhplot.jadraw.JaFillObject;
import jhplot.jadraw.JaObject;
import org.freehep.graphics2d.VectorGraphics;

public class JaVertexT5
extends JaFillObject {
    private static final long serialVersionUID = 1L;
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private double x3;
    private double y3;

    public JaVertexT5() {
        this.setRelw(5);
        this.setRelh(5);
    }

    public final void setX1(double newx1) {
        this.x1 = newx1;
    }

    public final double getX1() {
        return this.x1;
    }

    public final void setX2(double newx2) {
        this.x2 = newx2;
    }

    public final double getX2() {
        return this.x2;
    }

    public final void setX3(double newx3) {
        this.x3 = newx3;
    }

    public final double getX3() {
        return this.x3;
    }

    public final void setY1(double newy1) {
        this.y1 = newy1;
    }

    public final double getY1() {
        return this.y1;
    }

    public final void setY2(double newy2) {
        this.y2 = newy2;
    }

    public final double getY2() {
        return this.y2;
    }

    public final void setY3(double newy3) {
        this.y3 = newy3;
    }

    public final double getY3() {
        return this.y3;
    }

    public final void setVertexPts(double sx1, double sy1, double sx2, double sy2, double sx3, double sy3) {
        this.setX1(sx1);
        this.setY1(sy1);
        this.setX2(sx2);
        this.setY2(sy2);
        this.setX3(sx3);
        this.setY3(sy3);
    }

    @Override
    public final JaObject copy() {
        JaVertexT5 temp = new JaVertexT5();
        temp.setVertexPts(this.getX1(), this.getY1(), this.getX2(), this.getY2(), this.getX3(), this.getY3());
        temp.setX(this.getX());
        temp.setY(this.getY());
        temp.setColor(this.getColor());
        temp.setFillColor(this.getFillColor());
        temp.setStroke(this.getStroke());
        temp.setSize(this.getWidth(), this.getHeight(), this.getRelw(), this.getRelh());
        temp.setBoundingBox(this.getBoundingBox());
        return temp;
    }

    @Override
    public final boolean isCopy(JaObject comp) {
        JaVertexT5 vertex;
        boolean isCopy = false;
        if (comp instanceof JaVertexT5 && (vertex = (JaVertexT5)comp).getX() == this.getX() && vertex.getY() == this.getY() && vertex.getX1() == this.getX1() && vertex.getY1() == this.getY1() && vertex.getX2() == this.getX2() && vertex.getY2() == this.getY2() && vertex.getX3() == this.getX3() && vertex.getY3() == this.getY3() && vertex.getColor().equals(this.getColor()) && vertex.getFillColor().equals(this.getFillColor()) && vertex.getStroke() == this.getStroke() && vertex.getRelw() == this.getRelw() && vertex.getRelh() == this.getRelh()) {
            isCopy = true;
        }
        return isCopy;
    }

    @Override
    public final int getGrabbedHandle(int clickX, int clickY, int editmode) {
        int ax1 = (int)Math.round(this.getX1());
        int ay1 = (int)Math.round(this.getY1());
        int ax2 = (int)Math.round(this.getX2());
        int ay2 = (int)Math.round(this.getY2());
        int ax3 = (int)Math.round(this.getX3());
        int ay3 = (int)Math.round(this.getY3());
        if (editmode == 50 || editmode == 52) {
            if (clickX >= ax1 - 4 && clickX <= ax1 + 4 && clickY >= ay1 - 4 && clickY <= ay1 + 4) {
                return 11;
            }
            if (clickX >= ax2 - 4 && clickX <= ax2 + 4 && clickY >= ay2 - 4 && clickY <= ay2 + 4) {
                return 11;
            }
            if (clickX >= ax3 - 4 && clickX <= ax3 + 4 && clickY >= ay3 - 4 && clickY <= ay3 + 4) {
                return 11;
            }
        } else if (editmode == 51) {
            if (clickX >= ax1 - 4 && clickX <= ax1 + 4 && clickY >= ay1 - 4 && clickY <= ay1 + 4) {
                return 1;
            }
            if (clickX >= ax2 - 4 && clickX <= ax2 + 4 && clickY >= ay2 - 4 && clickY <= ay2 + 4) {
                return 2;
            }
            if (clickX >= ax3 - 4 && clickX <= ax3 + 4 && clickY >= ay3 - 4 && clickY <= ay3 + 4) {
                return 3;
            }
        }
        return 0;
    }

    @Override
    public final void drawHandles(VectorGraphics g2) {
        int ax1 = (int)Math.round(this.getX1());
        int ay1 = (int)Math.round(this.getY1());
        int ax2 = (int)Math.round(this.getX2());
        int ay2 = (int)Math.round(this.getY2());
        int ax3 = (int)Math.round(this.getX3());
        int ay3 = (int)Math.round(this.getY3());
        g2.setColor(JaxoColor.RED);
        g2.drawRect(ax1 - 4, ay1 - 4, 8, 8);
        g2.drawRect(ax2 - 4, ay2 - 4, 8, 8);
        g2.drawRect(ax3 - 4, ay3 - 4, 8, 8);
        if (this.isMarked()) {
            g2.setColor(JaxoColor.GRAYSCALE150);
            g2.fillRect(ax1 - 4 + 1, ay1 - 4 + 1, 7, 7);
            g2.fillRect(ax2 - 4 + 1, ay2 - 4 + 1, 7, 7);
            g2.fillRect(ax3 - 4 + 1, ay3 - 4 + 1, 7, 7);
        }
    }

    @Override
    public final void drawVisualAid(VectorGraphics g2) {
        g2.setColor(JaxoColor.RED);
        g2.setStroke((Stroke)new BasicStroke(1.0f));
        float ax1 = Math.round(this.getX1());
        float ay1 = Math.round(this.getY1());
        float ax2 = Math.round(this.getX2());
        float ay2 = Math.round(this.getY2());
        float ax3 = Math.round(this.getX3());
        float ay3 = Math.round(this.getY3());
        GeneralPath gpa = new GeneralPath();
        gpa.moveTo(ax1, ay1);
        gpa.lineTo(ax2, ay2);
        gpa.lineTo(ax3, ay3);
        gpa.closePath();
        g2.draw((Shape)gpa);
    }

    @Override
    public final void jaxoDraw(VectorGraphics g2, boolean drawToScreen) {
        g2.setColor(this.getColor());
        g2.setStroke((Stroke)new BasicStroke(this.getStroke()));
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        int ax1 = (int)Math.round(this.getX1());
        int ay1 = (int)Math.round(this.getY1());
        int ax2 = (int)Math.round(this.getX2());
        int ay2 = (int)Math.round(this.getY2());
        int ax3 = (int)Math.round(this.getX3());
        int ay3 = (int)Math.round(this.getY3());
        gp.moveTo(ax1, ay1);
        gp.lineTo(ax2, ay2);
        gp.lineTo(ax3, ay3);
        gp.closePath();
        g2.setStroke((Stroke)new BasicStroke(1.0f));
        g2.setColor(this.getFillColor());
        g2.fill((Shape)gp);
        g2.draw((Shape)gp);
        g2.setColor(this.getColor());
        g2.setStroke((Stroke)new BasicStroke(this.getStroke()));
        g2.draw((Shape)gp);
        Rectangle2D bb = gp.getBounds2D();
        double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
        this.setBoundingBox(bbox);
    }

    @Override
    public final void moveBy(int deltaX, int deltaY) {
        super.moveBy(deltaX, deltaY);
        this.setVertexPts(this.getX1() + (double)deltaX, this.getY1() + (double)deltaY, this.getX2() + (double)deltaX, this.getY2() + (double)deltaY, this.getX3() + (double)deltaX, this.getY3() + (double)deltaY);
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        double ax1 = this.getX1() / (double)scale;
        double ay1 = ((double)canvasDim.height - this.getY1()) / (double)scale;
        double ax2 = this.getX2() / (double)scale;
        double ay2 = ((double)canvasDim.height - this.getY2()) / (double)scale;
        double ax3 = this.getX3() / (double)scale;
        double ay3 = ((double)canvasDim.height - this.getY3()) / (double)scale;
        String command = "";
        if (JaxoColor.getIndex(this.getFillColor()) < JaxoColor.getIndex(JaxoColor.BLACK)) {
            String tlc = JaxoColor.getColorName(this.getColor());
            String tfc = JaxoColor.getColorName(this.getFillColor());
            command = "\\CTri(" + D_FORMAT.format(ax1) + "," + D_FORMAT.format(ay1) + ")(" + D_FORMAT.format(ax2) + "," + D_FORMAT.format(ay2) + ")(" + D_FORMAT.format(ax3) + "," + D_FORMAT.format(ay3) + "){" + tlc + "}{" + tfc + "}";
        } else {
            String grayScale = JaxoColor.getGreyScale(this.getFillColor());
            command = "\\GTri(" + D_FORMAT.format(ax1) + "," + D_FORMAT.format(ay1) + ")(" + D_FORMAT.format(ax2) + "," + D_FORMAT.format(ay2) + ")(" + D_FORMAT.format(ax3) + "," + D_FORMAT.format(ay3) + "){" + grayScale + "}";
        }
        return command;
    }

    @Override
    public final void rescaleObject(int orx, int ory, float scale) {
        this.setVertexPts(this.scalePoint(orx, ory, scale, this.getX1(), this.getY1()).getX(), this.scalePoint(orx, ory, scale, this.getX1(), this.getY1()).getY(), this.scalePoint(orx, ory, scale, this.getX2(), this.getY2()).getX(), this.scalePoint(orx, ory, scale, this.getX2(), this.getY2()).getY(), this.scalePoint(orx, ory, scale, this.getX3(), this.getY3()).getX(), this.scalePoint(orx, ory, scale, this.getX3(), this.getY3()).getY());
    }

    @Override
    public final boolean editPanel() {
        JaxoVertexT5OptionsPanel vert5op = new JaxoVertexT5OptionsPanel(this);
        return vert5op.hasChanged();
    }
}

