/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import japlot.jaxodraw.JaxoLineOptionsPanel;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jhplot.jadraw.JaLineObject;
import jhplot.jadraw.JaObject;
import org.freehep.graphics2d.VectorGraphics;

public class JaFLine
extends JaLineObject {
    private static final long serialVersionUID = 1L;

    public JaFLine() {
        this.setInflip(false);
    }

    @Override
    public final JaObject copy() {
        JaFLine temp = new JaFLine();
        temp.setX(this.getX());
        temp.setY(this.getY());
        temp.setColor(this.getColor());
        temp.setStroke(this.getStroke());
        temp.setArrow(this.isArrow());
        temp.setEnd(this.isEnd());
        temp.setFlip(this.isFlip());
        temp.setInflip(this.getInflip());
        temp.setDoubleLine(this.getDoubleLine());
        temp.setDLSeparation(this.getDLSeparation());
        temp.setSize(this.getWidth(), this.getHeight(), this.getRelw(), this.getRelh());
        temp.setBoundingBox(this.getBoundingBox());
        return temp;
    }

    @Override
    public final boolean isCopy(JaObject comp) {
        JaFLine line;
        boolean isCopy = false;
        if (comp instanceof JaFLine && (line = (JaFLine)comp).getX() == this.getX() && line.getY() == this.getY() && line.getColor().equals(this.getColor()) && line.getStroke() == this.getStroke() && line.isArrow() == this.isArrow() && line.isEnd() == this.isEnd() && line.isFlip() == this.isFlip() && line.getInflip() == this.getInflip() && line.getDoubleLine() == this.getDoubleLine() && line.getDLSeparation() == this.getDLSeparation() && line.getRelw() == this.getRelw() && line.getRelh() == this.getRelh()) {
            isCopy = true;
        }
        return isCopy;
    }

    @Override
    public final void jaxoDraw(VectorGraphics g2, boolean drawToScreen) {
        g2.setColor(this.getColor());
        GeneralPath gptmp = new GeneralPath();
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        double length = Math.sqrt((double)this.getWidth() * (double)this.getWidth() + (double)this.getHeight() * (double)this.getHeight());
        if (this.isArrow()) {
            if (this.getDoubleLine()) {
                gp = this.dLineArrow(g2, this.getColor(), length, 3.0f * this.getStroke(), this.getInflip(), this.getDLSeparation());
                gptmp.append(gp, false);
                gp.reset();
                gp = this.dLineArrow(g2, this.getColor(), length, 3.0f * this.getStroke(), this.getInflip(), -this.getDLSeparation());
                gptmp.append(gp, false);
            } else {
                gp = this.lineArrow(g2, this.getColor(), length, 4.0f * this.getStroke(), this.getInflip());
                gptmp.append(gp, false);
            }
        }
        g2.setStroke((Stroke)new BasicStroke(this.getStroke()));
        gp.reset();
        if (this.getDoubleLine()) {
            gp.moveTo(0.0f, this.getDLSeparation());
            gp.lineTo((float)length, this.getDLSeparation());
            gp = this.trans(gp, 1.0);
            gptmp.append(gp, false);
            gp.reset();
            gp.moveTo(0.0f, -this.getDLSeparation());
            gp.lineTo((float)length, -this.getDLSeparation());
            gp = this.trans(gp, 1.0);
            gptmp.append(gp, false);
        } else {
            gp.moveTo(0.0f, 0.0f);
            gp.lineTo((float)length, 0.0f);
            gp = this.trans(gp, 1.0);
            gptmp.append(gp, false);
        }
        g2.draw((Shape)gptmp);
        Rectangle2D bb = gptmp.getBounds2D();
        double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
        this.setBoundingBox(bbox);
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        Point2D startPoint = this.getLaTexStartPoint(scale, canvasHeight);
        Point2D endPoint = this.getLaTexEndPoint(scale, canvasHeight);
        String command = "";
        String base = "\\Line";
        if (this.isArrow()) {
            base = "\\ArrowLine";
            if (this.isEnd()) {
                base = "\\LongArrow";
            }
        }
        if ((int)endPoint.getX() == (int)startPoint.getX() && (int)endPoint.getY() == (int)startPoint.getY()) {
            command = "%";
        } else if (this.getDoubleLine()) {
            Point2D offSet = this.getOffSet(scale);
            if (this.isFlip()) {
                String command1 = base + "(" + D_FORMAT.format(endPoint.getX() + offSet.getX()) + "," + D_FORMAT.format(endPoint.getY() + offSet.getY()) + ")(" + D_FORMAT.format(startPoint.getX() + offSet.getX()) + "," + D_FORMAT.format(startPoint.getY() + offSet.getY()) + ")";
                String command2 = base + "(" + D_FORMAT.format(endPoint.getX() - offSet.getX()) + "," + D_FORMAT.format(endPoint.getY() - offSet.getY()) + ")(" + D_FORMAT.format(startPoint.getX() - offSet.getX()) + "," + D_FORMAT.format(startPoint.getY() - offSet.getY()) + ")";
                command = command1.concat(command2.concat("%%JaxoDrawID:DoubleLine(" + D_FORMAT.format(-this.getDLSeparation()) + ")"));
            } else {
                String command1 = base + "(" + D_FORMAT.format(startPoint.getX() + offSet.getX()) + "," + D_FORMAT.format(startPoint.getY() + offSet.getY()) + ")(" + D_FORMAT.format(endPoint.getX() + offSet.getX()) + "," + D_FORMAT.format(endPoint.getY() + offSet.getY()) + ")";
                String command2 = base + "(" + D_FORMAT.format(startPoint.getX() - offSet.getX()) + "," + D_FORMAT.format(startPoint.getY() - offSet.getY()) + ")(" + D_FORMAT.format(endPoint.getX() - offSet.getX()) + "," + D_FORMAT.format(endPoint.getY() - offSet.getY()) + ")";
                command = command1.concat(command2.concat("%%JaxoDrawID:DoubleLine(" + D_FORMAT.format(this.getDLSeparation()) + ")"));
            }
        } else {
            command = this.isFlip() ? base + "(" + D_FORMAT.format(endPoint.getX()) + "," + D_FORMAT.format(endPoint.getY()) + ")(" + D_FORMAT.format(startPoint.getX()) + "," + D_FORMAT.format(startPoint.getY()) + ")" : base + "(" + D_FORMAT.format(startPoint.getX()) + "," + D_FORMAT.format(startPoint.getY()) + ")(" + D_FORMAT.format(endPoint.getX()) + "," + D_FORMAT.format(endPoint.getY()) + ")";
        }
        return command;
    }

    private Point2D getLaTexStartPoint(float scaleFactor, int canvasHeight) {
        Point2D.Float startVec = new Point2D.Float();
        float x1 = this.getRelw() <= 0 ? (float)(this.getX() - this.getRelw()) : (float)this.getX();
        float y1 = this.getRelh() >= 0 ? (float)this.getY() : (float)(this.getY() - this.getRelh());
        ((Point2D)startVec).setLocation(x1 / scaleFactor, ((float)canvasHeight - y1) / scaleFactor);
        return startVec;
    }

    private Point2D getLaTexEndPoint(float scaleFactor, int canvasHeight) {
        Point2D.Float endVec = new Point2D.Float();
        float x2 = this.getRelw() >= 0 ? (float)(this.getX() + this.getRelw()) : (float)this.getX();
        float y2 = this.getRelh() <= 0 ? (float)this.getY() : (float)(this.getY() + this.getRelh());
        ((Point2D)endVec).setLocation(x2 / scaleFactor, ((float)canvasHeight - y2) / scaleFactor);
        return endVec;
    }

    private Point2D getOffSet(float scaleFactor) {
        Point2D.Float offSet = new Point2D.Float();
        float lSep = this.getDLSeparation() / scaleFactor;
        double theta = Math.atan2(this.getRelh(), this.getRelw());
        ((Point2D)offSet).setLocation((double)lSep * Math.sin(theta), (double)lSep * Math.cos(theta));
        return offSet;
    }

    @Override
    public final boolean editPanel() {
        JaxoLineOptionsPanel lineop = new JaxoLineOptionsPanel(3);
        lineop.initParams(this);
        lineop.setPanelIcon("japlot/jaxodraw/icons/fline.gif");
        lineop.setPanelTitle("Fermion_line_parameters");
        this.baseEditPanel(lineop);
        lineop.addLineArrowPanel(1, 0);
        lineop.addLineMiddlePanel(2, 0);
        lineop.addDlPanel(2, 1);
        boolean hasChanged = lineop.showPanel();
        return hasChanged;
    }
}

