/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoCanvas;
import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoColorChooser;
import japlot.jaxodraw.JaxoMainPanel;
import japlot.jaxodraw.JaxoOptionsMenu;
import japlot.jaxodraw.JaxoPrefs;
import japlot.jaxodraw.JaxoStaticCanvasMethods;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import jhplot.HPlotJa;

public class JaxoPrefsPanel
extends JFrame
implements ActionListener,
ItemListener {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private Color newColor = JaxoColor.getColor(JaxoPrefs.getPref(6));
    private Color newTColor;
    private ImageIcon colorPreviewIcon;
    private ImageIcon colorTPreviewIcon;
    private JButton colorbt;
    private JButton colorTbt;
    private Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private JSpinner sprot;
    private JSpinner sprot1;
    private SpinnerNumberModel modelgrid;
    private SpinnerNumberModel modelwidth;
    private SpinnerNumberModel modelamp;
    private SpinnerNumberModel modelXin;
    private SpinnerNumberModel modelYin;
    private SpinnerNumberModel modelsep;
    private SpinnerNumberModel modelrot;
    private SpinnerNumberModel modelrot1;
    private JaxoMainPanel thePanel;
    private JTextField psTextField;
    private JTextField editorTextField;
    private JTextField htmlTextField;
    private JTextField latexPathTextField;
    private JTextField dvipsPathTextField;
    private JCheckBox statusbarCheckBox;
    private JCheckBox toolbarCheckBox;
    private JCheckBox antialiasCheckBox;
    private JCheckBox arrowCheckBox;
    private JCheckBox gridCheckBox;
    private JRadioButton[] lookAndFeelRB;
    private JComboBox chooselanguage;
    private JComboBox chooseGridType;
    private String[] humanReadableName;
    private int num;
    private Vector knownLanguages;
    private Vector gridTypes;
    private JComboBox famcomb;
    private JComboBox sizecomb;
    private JComboBox stycomb;
    private JComboBox allicomb;
    private JComboBox defcomb;
    private JComboBox fscomb;
    private String fontChoice = JaxoPrefs.getPref(7);
    private int sizeChoiceInt = JaxoPrefs.getIntPref(106);
    private int styleChoice = JaxoPrefs.getIntPref(105);
    private int newAlli = JaxoPrefs.getIntPref(108);
    private int newDef = JaxoPrefs.getIntPref(114);
    private int newLatexFS = JaxoPrefs.getIntPref(107);
    private int newPSRot = -JaxoPrefs.getIntPref(109);
    private int newTeXRot = -JaxoPrefs.getIntPref(113);
    private Font dialogFont = new Font("Dialog", 1, 12);

    public JaxoPrefsPanel(JaxoMainPanel panel) {
        this.thePanel = panel;
        this.initComponents();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setKnownLanguages();
        this.setGridTypes();
        JPanel fPreviewCont = this.createOptionContainer();
        fPreviewCont.add((Component)this.getFPreviewPanel(), "Center");
        JPanel fAppearenceCont = this.createOptionContainer();
        fAppearenceCont.add((Component)this.getFAppearencePanel(), "Center");
        JTabbedPane fBehaviorPanel = new JTabbedPane(2);
        fBehaviorPanel.add(this.language.getString("Default"), this.getBDefCont());
        fBehaviorPanel.add(this.language.getString("Grid"), this.getBGridCont());
        fBehaviorPanel.add(this.language.getString("Objects"), this.getBObjectCont());
        fBehaviorPanel.add(this.language.getString("Text"), this.getBTextCont());
        JTabbedPane jtb = new JTabbedPane();
        jtb.add(this.language.getString("General"), fPreviewCont);
        jtb.add(this.language.getString("Appearence"), fAppearenceCont);
        jtb.add(this.language.getString("Behavior"), fBehaviorPanel);
        this.setTitle(this.language.getString("Preferences"));
        this.getContentPane().add((Component)jtb, "Center");
        this.pack();
        Dimension frameSize = this.getSize();
        if (frameSize.height > this.screenSize.height) {
            frameSize.height = this.screenSize.height;
        }
        if (frameSize.width > this.screenSize.width) {
            frameSize.width = this.screenSize.width;
        }
        this.setLocation((this.screenSize.width - frameSize.width) / 2, (this.screenSize.height - frameSize.height) / 2);
    }

    private void cancelButtonClicked() {
        this.dispose();
    }

    private void resetButtonClicked() {
        this.psTextField.setText(JaxoPrefs.getStringPref(2));
        this.htmlTextField.setText(JaxoPrefs.getStringPref(0));
        this.editorTextField.setText(JaxoPrefs.getStringPref(1));
        this.latexPathTextField.setText(JaxoPrefs.getStringPref(9));
        this.dvipsPathTextField.setText(JaxoPrefs.getStringPref(10));
        for (int i = 0; i < this.num; ++i) {
            this.lookAndFeelRB[i].setSelected(false);
            String prefLOOKNFEEL = JaxoPrefs.getStringPref(3);
            if (!prefLOOKNFEEL.equals(this.humanReadableName[i])) continue;
            this.lookAndFeelRB[i].setSelected(true);
        }
        int selected = 0;
        for (int i = 0; i < this.knownLanguages.size(); ++i) {
            if (!this.knownLanguages.elementAt(i).equals(JaxoPrefs.getPref(4))) continue;
            selected = i;
        }
        this.chooselanguage.setSelectedIndex(selected);
        int selectedg = 0;
        for (int i = 0; i < this.gridTypes.size(); ++i) {
            if (!this.gridTypes.elementAt(i).equals(JaxoPrefs.getPref(5))) continue;
            selectedg = i;
        }
        this.chooseGridType.setSelectedIndex(selectedg);
        this.colorbt.setIcon(new ImageIcon(this.getChooserImage(JaxoColor.getColor(JaxoPrefs.getPref(6)))));
        this.famcomb.setSelectedIndex(this.getFamilyIndex(JaxoPrefs.getPref(7)));
        this.stycomb.setSelectedIndex(JaxoPrefs.getIntPref(105));
        this.sizecomb.setSelectedIndex(this.getSizeIndex(new Integer(JaxoPrefs.getIntPref(106)).toString()));
        this.allicomb.setSelectedIndex(JaxoPrefs.getIntPref(108));
        this.fscomb.setSelectedIndex(JaxoPrefs.getIntPref(107));
        this.defcomb.setSelectedIndex(JaxoPrefs.getIntPref(114));
        int prefGRIDSIZE = JaxoPrefs.getIntPref(102);
        float prefLINEWIDTH = JaxoPrefs.getFloatPref(200);
        int prefAMPLITUDE = JaxoPrefs.getIntPref(104);
        float prefDLSEP = JaxoPrefs.getFloatPref(201);
        boolean prefSHOWTOOL = JaxoPrefs.getBooleanPref(300);
        boolean prefSHOWSTATUS = JaxoPrefs.getBooleanPref(301);
        boolean prefANTIALIASON = JaxoPrefs.getBooleanPref(302);
        boolean prefARROW = JaxoPrefs.getBooleanPref(303);
        this.modelgrid.setValue(new Integer(prefGRIDSIZE));
        this.modelwidth.setValue(new Float(prefLINEWIDTH));
        this.modelamp.setValue(new Integer(prefAMPLITUDE));
        this.modelXin.setValue(new Integer(JaxoPrefs.getIntPref(100)));
        this.modelYin.setValue(new Integer(JaxoPrefs.getIntPref(101)));
        this.modelsep.setValue(new Float(prefDLSEP));
        this.toolbarCheckBox.setSelected(prefSHOWTOOL);
        this.statusbarCheckBox.setSelected(prefSHOWSTATUS);
        this.antialiasCheckBox.setSelected(prefANTIALIASON);
        this.arrowCheckBox.setSelected(prefARROW);
    }

    private void clearButtonClicked() {
        this.psTextField.setText("");
        this.htmlTextField.setText("");
        this.editorTextField.setText("");
        this.latexPathTextField.setText("");
        this.dvipsPathTextField.setText("");
    }

    private void saveButtonClicked() {
        String prefFileName = HPlotJa.PREFS_FILENAME;
        String tmpEditor = JaxoPrefs.getPref(1);
        String tmpBrowser = JaxoPrefs.getPref(0);
        String tmpPSViewer = JaxoPrefs.getPref(2);
        String tmpLAF = JaxoPrefs.getPref(3);
        String tmpLang = JaxoPrefs.getPref(4);
        String tmpGridT = JaxoPrefs.getPref(5);
        String tmpColor = JaxoPrefs.getPref(6);
        String tmpPSFamily = JaxoPrefs.getPref(7);
        String tmpTColor = JaxoPrefs.getPref(8);
        String tmpLatexPath = JaxoPrefs.getPref(9);
        String tmpDvipsPath = JaxoPrefs.getPref(10);
        String tmpscreenX = JaxoPrefs.getPref(100);
        String tmpscreenY = JaxoPrefs.getPref(101);
        String tmpGrid = JaxoPrefs.getPref(102);
        String tmpPSStyle = JaxoPrefs.getPref(105);
        String tmpPSSize = JaxoPrefs.getPref(106);
        String tmpTeXSize = JaxoPrefs.getPref(107);
        String tmpTeXAlign = JaxoPrefs.getPref(108);
        String tmpLineWidth = JaxoPrefs.getPref(200);
        String tmpDLSep = JaxoPrefs.getPref(201);
        String tmpAmp = JaxoPrefs.getPref(104);
        String tmptool = JaxoPrefs.getPref(300);
        String tmpanti = JaxoPrefs.getPref(302);
        String tmparrow = JaxoPrefs.getPref(303);
        String tmpstatus = JaxoPrefs.getPref(301);
        String tmpGridOnOff = JaxoPrefs.getPref(304);
        String tmpPSRotAngle = JaxoPrefs.getPref(109);
        String tmpTeXRotAngle = JaxoPrefs.getPref(113);
        String tmpDef = JaxoPrefs.getPref(114);
        this.setPrefs();
        JaxoPrefs.exportPrefs(prefFileName);
        JaxoPrefs.setPref(1, tmpEditor);
        JaxoPrefs.setPref(0, tmpBrowser);
        JaxoPrefs.setPref(2, tmpPSViewer);
        JaxoPrefs.setPref(3, tmpLAF);
        JaxoPrefs.setPref(5, tmpGridT);
        JaxoPrefs.setPref(6, tmpColor);
        JaxoPrefs.setPref(7, tmpPSFamily);
        JaxoPrefs.setPref(8, tmpTColor);
        JaxoPrefs.setPref(9, tmpLatexPath);
        JaxoPrefs.setPref(10, tmpDvipsPath);
        JaxoPrefs.setPref(100, tmpscreenX);
        JaxoPrefs.setPref(101, tmpscreenY);
        JaxoPrefs.setPref(102, tmpGrid);
        JaxoPrefs.setPref(105, tmpPSStyle);
        JaxoPrefs.setPref(106, tmpPSSize);
        JaxoPrefs.setPref(107, tmpTeXSize);
        JaxoPrefs.setPref(108, tmpTeXAlign);
        JaxoPrefs.setPref(200, tmpLineWidth);
        JaxoPrefs.setPref(201, tmpDLSep);
        JaxoPrefs.setPref(300, tmptool);
        JaxoPrefs.setPref(301, tmpstatus);
        JaxoPrefs.setPref(302, tmpanti);
        JaxoPrefs.setPref(303, tmparrow);
        JaxoPrefs.setPref(104, tmpAmp);
        JaxoPrefs.setPref(4, tmpLang);
        JaxoPrefs.setPref(304, tmpGridOnOff);
        JaxoPrefs.setPref(109, tmpPSRotAngle);
        JaxoPrefs.setPref(113, tmpTeXRotAngle);
        JaxoPrefs.setPref(114, tmpDef);
    }

    private void okButtonClicked() {
        int gridSize = this.modelgrid.getNumber().intValue();
        if (gridSize != JaxoPrefs.getIntPref(102)) {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            double[] newbb = new double[]{5.0, 5.0, d.width, d.height};
            for (int i = 0; i < this.thePanel.getCanvasPanel().getTabCount(); ++i) {
                ((JaxoCanvas)this.thePanel.getCanvasPanel().getComponentAt(i)).setGridSize(gridSize);
                ((JaxoCanvas)this.thePanel.getCanvasPanel().getComponentAt(i)).setOldbb(newbb);
                ((JaxoCanvas)this.thePanel.getCanvasPanel().getComponentAt(i)).updateOffScreenImage();
            }
        }
        if (!((String)this.gridTypes.elementAt(this.chooseGridType.getSelectedIndex())).equals(JaxoPrefs.getPref(5))) {
            boolean type = false;
            if (((String)this.gridTypes.elementAt(this.chooseGridType.getSelectedIndex())).equals("hexagonal")) {
                type = true;
            }
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            double[] newbb = new double[]{5.0, 5.0, d.width, d.height};
            for (int i = 0; i < this.thePanel.getCanvasPanel().getTabCount(); ++i) {
                ((JaxoCanvas)this.thePanel.getCanvasPanel().getComponentAt(i)).setGridType(type);
                ((JaxoCanvas)this.thePanel.getCanvasPanel().getComponentAt(i)).setOldbb(newbb);
                ((JaxoCanvas)this.thePanel.getCanvasPanel().getComponentAt(i)).updateOffScreenImage();
            }
        }
        if (this.gridCheckBox.isSelected() != JaxoPrefs.getBooleanPref(304)) {
            JaxoOptionsMenu optionsmenu = this.thePanel.getOptMenu();
            optionsmenu.gridOn(this.gridCheckBox.isSelected());
        }
        this.setPrefs();
        this.applyPrefs();
        this.dispose();
    }

    private void setPrefs() {
        int screenSizeX = this.modelXin.getNumber().intValue();
        int screenSizeY = this.modelYin.getNumber().intValue();
        int gridSize = this.modelgrid.getNumber().intValue();
        float lineWidth = this.modelwidth.getNumber().floatValue();
        float dlSep = this.modelsep.getNumber().floatValue();
        int amp = this.modelamp.getNumber().intValue();
        String lang = (String)this.knownLanguages.elementAt(this.chooselanguage.getSelectedIndex());
        String gridType = (String)this.gridTypes.elementAt(this.chooseGridType.getSelectedIndex());
        String col = JaxoColor.getColorName(this.newColor);
        String colT = JaxoColor.getColorName(this.newTColor);
        this.newPSRot = this.modelrot.getNumber().intValue();
        this.newTeXRot = this.modelrot1.getNumber().intValue();
        JaxoPrefs.setPref(0, this.htmlTextField.getText());
        JaxoPrefs.setPref(1, this.editorTextField.getText());
        JaxoPrefs.setPref(2, this.psTextField.getText());
        for (int i = 0; i < this.num; ++i) {
            if (!this.lookAndFeelRB[i].isSelected()) continue;
            JaxoPrefs.setPref(3, this.humanReadableName[i]);
        }
        JaxoPrefs.setPref(4, lang);
        JaxoPrefs.setPref(5, gridType);
        JaxoPrefs.setPref(6, col);
        JaxoPrefs.setPref(7, this.fontChoice);
        JaxoPrefs.setPref(8, colT);
        JaxoPrefs.setPref(9, this.latexPathTextField.getText());
        JaxoPrefs.setPref(10, this.dvipsPathTextField.getText());
        JaxoPrefs.setIntPref(100, screenSizeX);
        JaxoPrefs.setIntPref(101, screenSizeY);
        JaxoPrefs.setIntPref(102, gridSize);
        JaxoPrefs.setIntPref(104, amp);
        JaxoPrefs.setIntPref(105, this.styleChoice);
        JaxoPrefs.setIntPref(106, this.sizeChoiceInt);
        JaxoPrefs.setIntPref(107, this.newLatexFS);
        JaxoPrefs.setIntPref(108, this.newAlli);
        JaxoPrefs.setFloatPref(200, lineWidth);
        JaxoPrefs.setFloatPref(201, dlSep);
        JaxoPrefs.setBooleanPref(300, this.toolbarCheckBox.isSelected());
        JaxoPrefs.setBooleanPref(301, this.statusbarCheckBox.isSelected());
        JaxoPrefs.setBooleanPref(302, this.antialiasCheckBox.isSelected());
        JaxoPrefs.setBooleanPref(303, this.arrowCheckBox.isSelected());
        JaxoPrefs.setBooleanPref(304, this.gridCheckBox.isSelected());
        JaxoPrefs.setIntPref(109, -this.newPSRot);
        JaxoPrefs.setIntPref(113, -this.newTeXRot);
        JaxoPrefs.setIntPref(114, this.newDef);
    }

    private void applyPrefs() {
        this.thePanel.applyPrefs();
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.colorbt) {
            JaxoColorChooser colorChooser = new JaxoColorChooser();
            this.newColor = colorChooser.color(this.newColor, false);
            if (this.newColor != null) {
                this.colorPreviewIcon = new ImageIcon(this.getChooserImage(this.newColor));
                this.colorbt.setIcon(this.colorPreviewIcon);
            }
        } else if (evt.getSource() == this.colorTbt) {
            JaxoColorChooser colorChooser = new JaxoColorChooser();
            this.newTColor = colorChooser.color(this.newTColor, false);
            if (this.newTColor != null) {
                this.colorTPreviewIcon = new ImageIcon(this.getChooserImage(this.newTColor));
                this.colorTbt.setIcon(this.colorTPreviewIcon);
            }
        } else if (evt.getSource() == this.allicomb) {
            this.newAlli = this.allicomb.getSelectedIndex();
        } else if (evt.getSource() == this.fscomb) {
            this.newLatexFS = this.fscomb.getSelectedIndex();
        } else if (evt.getSource() == this.defcomb) {
            this.newDef = this.defcomb.getSelectedIndex();
        }
    }

    private JPanel createOptionContainer() {
        JButton okBt = new JButton();
        okBt.setText(this.language.getString("OK"));
        okBt.setToolTipText(this.language.getString("Set_the_preferences_for_the_current_session"));
        okBt.addMouseListener(new MouseAdapter(){

            @Override
            public final void mouseClicked(MouseEvent evt) {
                JaxoPrefsPanel.this.okButtonClicked();
            }
        });
        JButton saveBt = new JButton();
        saveBt.setText(this.language.getString("Save"));
        saveBt.setToolTipText(this.language.getString("Save_the_current_settings_to_make_them_permanent"));
        saveBt.addMouseListener(new MouseAdapter(){

            @Override
            public final void mouseClicked(MouseEvent evt) {
                JaxoPrefsPanel.this.saveButtonClicked();
            }
        });
        JButton clearBt = new JButton();
        clearBt.setText(this.language.getString("Clear"));
        clearBt.setToolTipText(this.language.getString("Clear_all_the_text_fields"));
        clearBt.addMouseListener(new MouseAdapter(){

            @Override
            public final void mouseClicked(MouseEvent evt) {
                JaxoPrefsPanel.this.clearButtonClicked();
            }
        });
        JButton resetBt = new JButton();
        resetBt.setText(this.language.getString("Reset"));
        resetBt.setToolTipText(this.language.getString("Reset_the_initial_values"));
        resetBt.addMouseListener(new MouseAdapter(){

            @Override
            public final void mouseClicked(MouseEvent evt) {
                JaxoPrefsPanel.this.resetButtonClicked();
            }
        });
        JButton cancelBt = new JButton();
        cancelBt.setText(this.language.getString("Cancel"));
        cancelBt.setToolTipText(this.language.getString("Abondon_the_current_dialog"));
        cancelBt.addMouseListener(new MouseAdapter(){

            @Override
            public final void mouseClicked(MouseEvent evt) {
                JaxoPrefsPanel.this.cancelButtonClicked();
            }
        });
        JPanel btPanel = new JPanel();
        btPanel.add(okBt);
        btPanel.add(saveBt);
        btPanel.add(clearBt);
        btPanel.add(resetBt);
        btPanel.add(cancelBt);
        JPanel opCont = new JPanel();
        opCont.setLayout(new BorderLayout());
        opCont.add((Component)btPanel, "South");
        return opCont;
    }

    private Image getChooserImage(Color iconColor) {
        int width = 40;
        int height = 15;
        int size = width * height;
        int[] pixels = new int[size];
        for (int i = 0; i < size; ++i) {
            pixels[i] = iconColor.getRGB();
        }
        MemoryImageSource source = new MemoryImageSource(width, height, pixels, 0, width);
        Image jaxColorBox = this.createImage(source);
        return jaxColorBox;
    }

    @Override
    public final void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        Object list = e.getSource();
        if (list == this.famcomb) {
            this.fontChoice = (String)this.famcomb.getSelectedItem();
        } else if (list == this.stycomb) {
            this.styleChoice = this.stycomb.getSelectedIndex();
        } else {
            String sizeChoice = (String)this.sizecomb.getSelectedItem();
            Integer thisSize = new Integer(sizeChoice);
            this.sizeChoiceInt = thisSize;
        }
    }

    private int getSizeIndex(String s) {
        String[] sizes = new String[]{"4", "6", "8", "10", "12", "14", "16", "18", "20", "22", "24", "26", "28", "30", "32", "34", "36", "38", "40", "42", "44", "46", "48", "50", "52", "54", "56", "58", "60", "62", "64"};
        int i = 0;
        while (sizes[i].compareTo(s) != 0) {
            ++i;
        }
        if (sizes[i].compareTo(s) == 0) {
            return i;
        }
        return -1;
    }

    private int getFamilyIndex(String s) {
        String[] envFonts = JaxoStaticCanvasMethods.getSystemFonts();
        int i = envFonts.length;
        for (int j = 0; j < i; ++j) {
            if (envFonts[j].compareTo(s) != 0) continue;
            i = j;
            break;
        }
        if (i < envFonts.length) {
            return i;
        }
        return 0;
    }

    private JPanel getLanguagePanel() {
        Vector<String> i18nKnownLanguages = new Vector<String>();
        i18nKnownLanguages.addElement(this.language.getString("English"));
        i18nKnownLanguages.addElement(this.language.getString("German"));
        i18nKnownLanguages.addElement(this.language.getString("French"));
        i18nKnownLanguages.addElement(this.language.getString("Spanish"));
        i18nKnownLanguages.addElement(this.language.getString("Italian"));
        this.chooselanguage = new JComboBox(i18nKnownLanguages);
        int selected = 0;
        for (int i = 0; i < this.knownLanguages.size(); ++i) {
            if (!this.knownLanguages.elementAt(i).equals(JaxoPrefs.getPref(4))) continue;
            selected = i;
        }
        this.chooselanguage.setSelectedIndex(selected);
        JPanel languagePanel = new JPanel();
        languagePanel.setBorder(new TitledBorder(null, this.language.getString("Language"), 0, 0, this.dialogFont, JaxoColor.BLACK));
        JLabel languageLabel = new JLabel();
        languageLabel.setText(this.language.getString("Default_language"));
        languagePanel.add(languageLabel);
        languagePanel.add(this.chooselanguage);
        return languagePanel;
    }

    private void setKnownLanguages() {
        this.knownLanguages = new Vector(5);
        this.knownLanguages.addElement("english");
        this.knownLanguages.addElement("german");
        this.knownLanguages.addElement("french");
        this.knownLanguages.addElement("spanish");
        this.knownLanguages.addElement("italian");
    }

    private void setGridTypes() {
        this.gridTypes = new Vector();
        this.gridTypes.addElement("rectangular");
        this.gridTypes.addElement("hexagonal");
    }

    private JPanel getLookNFeelPanel() {
        JPanel lookNFeelPanel = new JPanel();
        lookNFeelPanel.setBorder(new TitledBorder(null, this.language.getString("Look_and_Feel"), 0, 0, this.dialogFont, JaxoColor.BLACK));
        String currentLookAndFeel = UIManager.getLookAndFeel().getName();
        ButtonGroup group = new ButtonGroup();
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        LookAndFeel thisLaF = UIManager.getLookAndFeel();
        this.num = info.length;
        this.humanReadableName = new String[this.num];
        String[] className = new String[this.num];
        this.lookAndFeelRB = new JRadioButton[this.num];
        for (int i = 0; i < this.num; ++i) {
            block5: {
                this.humanReadableName[i] = info[i].getName();
                className[i] = info[i].getClassName();
                this.lookAndFeelRB[i] = new JRadioButton(this.humanReadableName[i]);
                try {
                    UIManager.setLookAndFeel(className[i]);
                }
                catch (Exception exc) {
                    this.lookAndFeelRB[i].setEnabled(false);
                }
                try {
                    UIManager.setLookAndFeel(thisLaF);
                }
                catch (Exception exc) {
                    if (!JaxoPrefs.verbose()) break block5;
                    System.out.println(exc);
                }
            }
            lookNFeelPanel.add(this.lookAndFeelRB[i]);
            group.add(this.lookAndFeelRB[i]);
            this.lookAndFeelRB[i].setActionCommand(this.humanReadableName[i]);
            if (!this.humanReadableName[i].equals(currentLookAndFeel)) continue;
            this.lookAndFeelRB[i].setSelected(true);
        }
        return lookNFeelPanel;
    }

    private JPanel getLafPanel() {
        JPanel lafPanel = new JPanel();
        lafPanel.setLayout(new FlowLayout());
        lafPanel.add(this.getLookNFeelPanel());
        lafPanel.add(this.getLanguagePanel());
        return lafPanel;
    }

    private JPanel getFAppearencePanel() {
        JPanel fAppearencePanel = new JPanel();
        fAppearencePanel.setLayout(new BoxLayout(fAppearencePanel, 1));
        fAppearencePanel.add(this.getLafPanel());
        fAppearencePanel.add(this.getInitScreenPanel());
        fAppearencePanel.add(this.getCheckBoxPanel());
        return fAppearencePanel;
    }

    private JPanel getCheckBoxPanel() {
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setBorder(new TitledBorder(null, this.language.getString("Other_options"), 0, 0, this.dialogFont, JaxoColor.BLACK));
        checkBoxPanel.setLayout(new GridLayout(2, 2));
        this.toolbarCheckBox = new JCheckBox();
        this.toolbarCheckBox.setSelected(JaxoPrefs.getBooleanPref(300));
        this.toolbarCheckBox.setText(this.language.getString("Show_toolbar"));
        checkBoxPanel.add(this.toolbarCheckBox);
        this.statusbarCheckBox = new JCheckBox();
        this.statusbarCheckBox.setSelected(JaxoPrefs.getBooleanPref(301));
        this.statusbarCheckBox.setText(this.language.getString("Show_status_bar"));
        checkBoxPanel.add(this.statusbarCheckBox);
        this.antialiasCheckBox = new JCheckBox();
        this.antialiasCheckBox.setSelected(JaxoPrefs.getBooleanPref(302));
        this.antialiasCheckBox.setText(this.language.getString("Antialias_on"));
        checkBoxPanel.add(this.antialiasCheckBox);
        return checkBoxPanel;
    }

    private JPanel getInitScreenPanel() {
        JPanel pxin = new JPanel();
        pxin.setLayout(new GridLayout(0, 2));
        this.modelXin = new SpinnerNumberModel(JaxoPrefs.getIntPref(100), 0, this.screenSize.width, 1);
        JLabel xin = new JLabel(this.language.getString("Size_X:") + " ", 4);
        pxin.add(xin);
        JSpinner spxin = new JSpinner(this.modelXin);
        pxin.add(spxin);
        JPanel pyin = new JPanel();
        pyin.setLayout(new GridLayout(0, 2));
        this.modelYin = new SpinnerNumberModel(JaxoPrefs.getIntPref(101), 0, this.screenSize.height, 1);
        JLabel yin = new JLabel(this.language.getString("Size_Y:") + " ", 4);
        pyin.add(yin);
        JSpinner spyin = new JSpinner(this.modelYin);
        pyin.add(spyin);
        JPanel dimSPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints sc = new GridBagConstraints();
        dimSPanel.setLayout(gb);
        sc.gridx = 0;
        sc.gridy = 0;
        sc.insets = new Insets(0, 0, 5, 0);
        pxin.setPreferredSize(new Dimension(145, 20));
        gb.setConstraints(pxin, sc);
        dimSPanel.add((Component)pxin, sc);
        sc.gridx = 1;
        sc.gridy = 0;
        sc.insets = new Insets(0, 0, 5, 5);
        pyin.setPreferredSize(new Dimension(145, 20));
        gb.setConstraints(pyin, sc);
        dimSPanel.add((Component)pyin, sc);
        JPanel initScreenPanel = new JPanel();
        initScreenPanel.setBorder(new TitledBorder(null, this.language.getString("Initial_screen_size"), 0, 0, this.dialogFont, JaxoColor.BLACK));
        initScreenPanel.add(dimSPanel);
        return initScreenPanel;
    }

    private JPanel getPreviewPanel() {
        JPanel previewPanel = new JPanel();
        previewPanel.setBorder(new TitledBorder(null, this.language.getString("Preview_options"), 0, 0, this.dialogFont, JaxoColor.BLACK));
        JLabel htmlLabel = new JLabel();
        htmlLabel.setText(this.language.getString("Preferred_HTML_viewer"));
        this.htmlTextField = new JTextField(JaxoPrefs.getStringPref(0));
        this.htmlTextField.setPreferredSize(new Dimension(130, 20));
        JLabel editorLabel = new JLabel();
        editorLabel.setText(this.language.getString("Preferred_text_editor"));
        this.editorTextField = new JTextField(JaxoPrefs.getStringPref(1));
        this.editorTextField.setPreferredSize(new Dimension(130, 20));
        JLabel psLabel = new JLabel();
        psLabel.setText(this.language.getString("Preferred_postscript_viewer___"));
        this.psTextField = new JTextField(JaxoPrefs.getStringPref(2));
        this.psTextField.setPreferredSize(new Dimension(130, 20));
        GridBagLayout grba = new GridBagLayout();
        GridBagConstraints con = new GridBagConstraints();
        previewPanel.setLayout(grba);
        con.gridx = 0;
        con.gridy = 0;
        con.anchor = 21;
        grba.setConstraints(htmlLabel, con);
        previewPanel.add(htmlLabel);
        con.gridx = 0;
        con.gridy = 1;
        con.anchor = 21;
        grba.setConstraints(editorLabel, con);
        previewPanel.add(editorLabel);
        con.gridx = 0;
        con.gridy = 2;
        con.anchor = 21;
        grba.setConstraints(psLabel, con);
        previewPanel.add(psLabel);
        con.gridx = 1;
        con.gridy = 0;
        grba.setConstraints(this.htmlTextField, con);
        previewPanel.add(this.htmlTextField);
        con.gridx = 1;
        con.gridy = 1;
        grba.setConstraints(this.editorTextField, con);
        previewPanel.add(this.editorTextField);
        con.gridx = 1;
        con.gridy = 2;
        grba.setConstraints(this.psTextField, con);
        previewPanel.add(this.psTextField);
        return previewPanel;
    }

    private JPanel getPathPanel() {
        JPanel pathPanel = new JPanel();
        pathPanel.setBorder(new TitledBorder(null, this.language.getString("Paths"), 0, 0, this.dialogFont, JaxoColor.BLACK));
        JLabel latexPathLabel = new JLabel();
        latexPathLabel.setText(this.language.getString("LaTeX_path:"));
        this.latexPathTextField = new JTextField(JaxoPrefs.getStringPref(9));
        this.latexPathTextField.setPreferredSize(new Dimension(130, 20));
        JLabel dvipsPathLabel = new JLabel();
        dvipsPathLabel.setText(this.language.getString("dvips_path:"));
        this.dvipsPathTextField = new JTextField(JaxoPrefs.getStringPref(10));
        this.dvipsPathTextField.setPreferredSize(new Dimension(130, 20));
        GridBagLayout grba1 = new GridBagLayout();
        GridBagConstraints con1 = new GridBagConstraints();
        pathPanel.setLayout(grba1);
        con1.gridx = 0;
        con1.gridy = 0;
        con1.anchor = 21;
        grba1.setConstraints(latexPathLabel, con1);
        pathPanel.add(latexPathLabel);
        con1.gridx = 0;
        con1.gridy = 1;
        con1.anchor = 21;
        grba1.setConstraints(dvipsPathLabel, con1);
        pathPanel.add(dvipsPathLabel);
        con1.gridx = 1;
        con1.gridy = 0;
        grba1.setConstraints(this.latexPathTextField, con1);
        pathPanel.add(this.latexPathTextField);
        con1.gridx = 1;
        con1.gridy = 1;
        grba1.setConstraints(this.dvipsPathTextField, con1);
        pathPanel.add(this.dvipsPathTextField);
        return pathPanel;
    }

    private JPanel getFPreviewPanel() {
        JPanel fPreviewPanel = new JPanel();
        fPreviewPanel.setLayout(new BoxLayout(fPreviewPanel, 1));
        fPreviewPanel.add(this.getPreviewPanel());
        fPreviewPanel.add(this.getPathPanel());
        return fPreviewPanel;
    }

    private JPanel getGridOnOffPanel() {
        JPanel gridCheckBoxPanel = new JPanel();
        this.gridCheckBox = new JCheckBox();
        this.gridCheckBox.setSelected(JaxoPrefs.getBooleanPref(304));
        this.gridCheckBox.setText(this.language.getString("Grid_on"));
        gridCheckBoxPanel.add(this.gridCheckBox);
        gridCheckBoxPanel.setBorder(new TitledBorder(null, this.language.getString("Grid_on_off"), 0, 0, this.dialogFont, JaxoColor.BLACK));
        return gridCheckBoxPanel;
    }

    private JPanel getGridTypePanel() {
        Vector<String> gridCombTypes = new Vector<String>();
        gridCombTypes.addElement(this.language.getString("Rectangular"));
        gridCombTypes.addElement(this.language.getString("Hexagonal"));
        this.chooseGridType = new JComboBox(gridCombTypes);
        int selectedg = 0;
        for (int i = 0; i < this.gridTypes.size(); ++i) {
            if (!this.gridTypes.elementAt(i).equals(JaxoPrefs.getPref(5))) continue;
            selectedg = i;
        }
        this.chooseGridType.setSelectedIndex(selectedg);
        JPanel gridTypePanel = new JPanel();
        gridTypePanel.setBorder(new TitledBorder(null, this.language.getString("Grid_type"), 0, 0, this.dialogFont, JaxoColor.BLACK));
        JLabel gridTypeLabel = new JLabel();
        gridTypeLabel.setText(this.language.getString("Type"));
        gridTypePanel.add(gridTypeLabel);
        gridTypePanel.add(this.chooseGridType);
        return gridTypePanel;
    }

    private JPanel getGridSizePanel() {
        JPanel pgrid = new JPanel();
        pgrid.setLayout(new GridLayout(0, 2));
        int prefGRIDSIZE = JaxoPrefs.getIntPref(102);
        this.modelgrid = new SpinnerNumberModel(prefGRIDSIZE, 1, 75, 1);
        JLabel lgrid = new JLabel(this.language.getString("Size_:") + " ", 4);
        pgrid.add(lgrid);
        JSpinner spgrid = new JSpinner(this.modelgrid);
        pgrid.add(spgrid);
        JPanel gridSizePanel = new JPanel();
        gridSizePanel.setBorder(new TitledBorder(null, this.language.getString("Grid_size"), 0, 0, this.dialogFont, JaxoColor.BLACK));
        gridSizePanel.add(pgrid);
        return gridSizePanel;
    }

    private JPanel getColorPanel() {
        Image colorPreview = this.getChooserImage(this.newColor);
        this.colorPreviewIcon = new ImageIcon(colorPreview);
        this.colorbt = new JButton(this.colorPreviewIcon);
        this.colorbt.addActionListener(this);
        JPanel colorPanel = new JPanel();
        TitledBorder colorPanelTitle = BorderFactory.createTitledBorder(this.language.getString("Line_color"));
        colorPanel.setBorder(colorPanelTitle);
        colorPanel.add(this.colorbt);
        return colorPanel;
    }

    private JPanel getLineWidthPanel() {
        JPanel pwidth = new JPanel();
        pwidth.setLayout(new GridLayout(0, 2));
        this.modelwidth = new SpinnerNumberModel(JaxoPrefs.getFloatPref(200), 0.2, 100.0, 0.2);
        JLabel lwidth = new JLabel(this.language.getString("Width_:") + " ", 4);
        pwidth.add(lwidth);
        JSpinner spwidth = new JSpinner(this.modelwidth);
        pwidth.add(spwidth);
        JPanel lineWidthPanel = new JPanel();
        lineWidthPanel.setBorder(new TitledBorder(null, this.language.getString("Line_width"), 0, 0, this.dialogFont, JaxoColor.BLACK));
        lineWidthPanel.add(pwidth);
        return lineWidthPanel;
    }

    private JPanel getArrowPanel() {
        this.arrowCheckBox = new JCheckBox();
        this.arrowCheckBox.setSelected(JaxoPrefs.getBooleanPref(303));
        this.arrowCheckBox.setText(this.language.getString("Arrows"));
        JPanel arrowPanel = new JPanel();
        arrowPanel.setBorder(new TitledBorder(null, this.language.getString("Arrows"), 0, 0, this.dialogFont, JaxoColor.BLACK));
        arrowPanel.add(this.arrowCheckBox);
        return arrowPanel;
    }

    private JPanel getSepPanel() {
        JPanel psep = new JPanel();
        psep.setLayout(new GridLayout(0, 2));
        this.modelsep = new SpinnerNumberModel(JaxoPrefs.getFloatPref(201), 0.2, 100.0, 0.5);
        JLabel lsep = new JLabel(this.language.getString("Separation1"), 4);
        psep.add(lsep);
        JSpinner spsep = new JSpinner(this.modelsep);
        psep.add(spsep);
        JPanel sepPanel = new JPanel();
        sepPanel.setBorder(new TitledBorder(null, this.language.getString("Double_line_separation:"), 0, 0, this.dialogFont, JaxoColor.BLACK));
        sepPanel.add(psep);
        return sepPanel;
    }

    private JPanel getAmpPanel() {
        JPanel pamp = new JPanel();
        pamp.setLayout(new GridLayout(0, 2));
        this.modelamp = new SpinnerNumberModel((double)JaxoPrefs.getIntPref(104), -500.0, 500.0, 1.0);
        JLabel lamp = new JLabel(this.language.getString("Size_:") + " ", 4);
        pamp.add(lamp);
        JSpinner spamp = new JSpinner(this.modelamp);
        pamp.add(spamp);
        JPanel ampPanel = new JPanel();
        ampPanel.setBorder(new TitledBorder(null, this.language.getString("Amplitude1"), 0, 0, this.dialogFont, JaxoColor.BLACK));
        ampPanel.add(pamp);
        return ampPanel;
    }

    private JPanel getColorTPanel() {
        this.newTColor = JaxoColor.getColor(JaxoPrefs.getPref(8));
        Image colorTPreview = this.getChooserImage(this.newTColor);
        this.colorTPreviewIcon = new ImageIcon(colorTPreview);
        this.colorTbt = new JButton(this.colorTPreviewIcon);
        this.colorTbt.addActionListener(this);
        JPanel colorTPanel = new JPanel();
        TitledBorder colorTPanelTitle = BorderFactory.createTitledBorder(this.language.getString("Text_color"));
        colorTPanel.setBorder(colorTPanelTitle);
        colorTPanel.add(this.colorTbt);
        return colorTPanel;
    }

    private JPanel getTextFinalFontPanel() {
        JPanel textFamilyPanel = new JPanel();
        JLabel textFamilyLabel = new JLabel();
        textFamilyLabel.setText(this.language.getString("Font"));
        textFamilyLabel.setHorizontalAlignment(0);
        JPanel textSizePanel = new JPanel();
        JLabel textSizeLabel = new JLabel();
        textSizeLabel.setText(this.language.getString("Size"));
        textSizeLabel.setHorizontalAlignment(0);
        JPanel textStylePanel = new JPanel();
        JLabel textStyleLabel = new JLabel();
        textStyleLabel.setText(this.language.getString("Style"));
        textStyleLabel.setHorizontalAlignment(0);
        this.famcomb = new JComboBox<String>(JaxoStaticCanvasMethods.getSystemFonts());
        this.famcomb.addItemListener(this);
        this.famcomb.setSelectedIndex(this.getFamilyIndex(JaxoPrefs.getPref(7)));
        textFamilyPanel.add(this.famcomb);
        String[] sizes = new String[]{"4", "6", "8", "10", "12", "14", "16", "18", "20", "22", "24", "26", "28", "30", "32", "34", "36", "38", "40", "42", "44", "46", "48", "50", "52", "54", "56", "58", "60", "62", "64"};
        this.sizecomb = new JComboBox<String>(sizes);
        this.sizecomb.addItemListener(this);
        this.sizecomb.setSelectedIndex(this.getSizeIndex(new Integer(JaxoPrefs.getIntPref(106)).toString()));
        textSizePanel.add(this.sizecomb);
        String[] styles = new String[]{"Plain", "Bold", "Italic", "Bold & Italic"};
        this.stycomb = new JComboBox<String>(styles);
        this.stycomb.addItemListener(this);
        this.stycomb.setSelectedIndex(JaxoPrefs.getIntPref(105));
        textStylePanel.add(this.stycomb);
        JPanel textFinalFontPanel = new JPanel();
        textFinalFontPanel.setLayout(new BorderLayout());
        TitledBorder textFontTitle = BorderFactory.createTitledBorder(this.language.getString("Font_properties"));
        textFinalFontPanel.setBorder(textFontTitle);
        textFinalFontPanel.add("West", textFamilyPanel);
        textFinalFontPanel.add("Center", textSizePanel);
        textFinalFontPanel.add("East", textStylePanel);
        return textFinalFontPanel;
    }

    private JPanel getFinalRotSPanel() {
        JPanel prot = new JPanel();
        GridBagLayout rotgb = new GridBagLayout();
        GridBagConstraints rotc = new GridBagConstraints();
        prot.setLayout(rotgb);
        this.modelrot = new SpinnerNumberModel(this.newPSRot, -360, 360, 1);
        JLabel rot = new JLabel("PS " + this.language.getString("Rot._Angle") + ":  ", 4);
        this.sprot = new JSpinner(this.modelrot);
        rotc.gridx = 0;
        rotc.gridy = 0;
        rotc.insets = new Insets(0, 5, 0, 5);
        rotgb.setConstraints(rot, rotc);
        prot.add((Component)rot, rotc);
        rotc.gridx = 1;
        rotc.gridy = 0;
        this.sprot.setPreferredSize(new Dimension(55, 20));
        rotgb.setConstraints(this.sprot, rotc);
        prot.add((Component)this.sprot, rotc);
        JPanel prot1 = new JPanel();
        GridBagLayout rotgb1 = new GridBagLayout();
        GridBagConstraints rotc1 = new GridBagConstraints();
        prot1.setLayout(rotgb1);
        this.modelrot1 = new SpinnerNumberModel(this.newTeXRot, -360, 360, 1);
        JLabel rot1 = new JLabel("TeX " + this.language.getString("Rot._Angle") + ": ", 4);
        this.sprot1 = new JSpinner(this.modelrot1);
        rotc1.gridx = 0;
        rotc1.gridy = 0;
        rotc1.insets = new Insets(0, 5, 0, 5);
        rotgb1.setConstraints(rot1, rotc1);
        prot1.add((Component)rot1, rotc1);
        rotc1.gridx = 1;
        rotc1.gridy = 0;
        this.sprot1.setPreferredSize(new Dimension(55, 20));
        rotgb1.setConstraints(this.sprot1, rotc1);
        prot1.add((Component)this.sprot1, rotc1);
        JPanel rotSPanel = new JPanel();
        GridBagLayout gbrot = new GridBagLayout();
        GridBagConstraints scrot = new GridBagConstraints();
        rotSPanel.setLayout(gbrot);
        scrot.gridx = 0;
        scrot.gridy = 0;
        scrot.insets = new Insets(0, 0, 5, 0);
        gbrot.setConstraints(prot, scrot);
        rotSPanel.add((Component)prot, scrot);
        scrot.gridx = 0;
        scrot.gridy = 1;
        scrot.insets = new Insets(5, 0, 0, 5);
        gbrot.setConstraints(prot1, scrot);
        rotSPanel.add((Component)prot1, scrot);
        JPanel finalRotSPanel = new JPanel();
        finalRotSPanel.setLayout(new BoxLayout(finalRotSPanel, 0));
        TitledBorder rotSTitle = BorderFactory.createTitledBorder(this.language.getString("Rotation"));
        finalRotSPanel.setBorder(rotSTitle);
        finalRotSPanel.add(rotSPanel);
        return finalRotSPanel;
    }

    private JPanel getAlliPanel() {
        String[] possible = new String[]{this.language.getString("Left-Top"), this.language.getString("Left-Center"), this.language.getString("Left-Bottom"), this.language.getString("Center-Top"), this.language.getString("Center-Center"), this.language.getString("Center-Bottom"), this.language.getString("Right-Top"), this.language.getString("Right-Center"), this.language.getString("Right-Bottom")};
        this.allicomb = new JComboBox<String>(possible);
        this.allicomb.setSelectedIndex(JaxoPrefs.getIntPref(108));
        this.allicomb.addActionListener(this);
        JPanel alliPanel = new JPanel();
        TitledBorder alliPanelTitle = BorderFactory.createTitledBorder("TeX " + this.language.getString("Alignment"));
        alliPanel.setBorder(alliPanelTitle);
        alliPanel.add(this.allicomb);
        return alliPanel;
    }

    private JPanel getFsPanel() {
        String[] allowed = new String[]{"tiny", "scriptsize", "footnotesize", "small", "normalsize", "large", "Large", "LARGE", "huge", "Huge"};
        this.fscomb = new JComboBox<String>(allowed);
        this.fscomb.setSelectedIndex(JaxoPrefs.getIntPref(107));
        this.fscomb.addActionListener(this);
        JPanel fsPanel = new JPanel();
        TitledBorder fsPanelTitle = BorderFactory.createTitledBorder("TeX" + this.language.getString("Font_size"));
        fsPanel.setBorder(fsPanelTitle);
        fsPanel.add(this.fscomb);
        return fsPanel;
    }

    private JPanel getBGridCont() {
        JPanel gridPanel = new JPanel();
        gridPanel.add(this.getGridOnOffPanel());
        gridPanel.add(this.getGridTypePanel());
        gridPanel.add(this.getGridSizePanel());
        JPanel bGrid = new JPanel();
        bGrid.setLayout(new BoxLayout(bGrid, 1));
        bGrid.add(gridPanel);
        JPanel bGridCont = this.createOptionContainer();
        bGridCont.add((Component)bGrid, "Center");
        return bGridCont;
    }

    private JPanel getBDefCont() {
        JPanel bDef = new JPanel();
        bDef.setLayout(new BoxLayout(bDef, 1));
        bDef.add(this.getDefPanel());
        JPanel bDefCont = this.createOptionContainer();
        bDefCont.add((Component)bDef, "Center");
        return bDefCont;
    }

    private JPanel getBObjectCont() {
        JPanel objectPanel = new JPanel();
        objectPanel.add(this.getColorPanel());
        objectPanel.add(this.getLineWidthPanel());
        objectPanel.add(this.getArrowPanel());
        objectPanel.add(this.getSepPanel());
        JPanel objectPanel1 = new JPanel();
        objectPanel1.add(this.getAmpPanel());
        JPanel bObject = new JPanel();
        bObject.setLayout(new BoxLayout(bObject, 1));
        bObject.add(objectPanel);
        bObject.add(objectPanel1);
        JPanel bObjectCont = this.createOptionContainer();
        bObjectCont.add((Component)bObject, "Center");
        return bObjectCont;
    }

    private JPanel getBTextCont() {
        JPanel textPanel = new JPanel();
        textPanel.add(this.getColorTPanel());
        textPanel.add(this.getTextFinalFontPanel());
        JPanel textPanel1 = new JPanel();
        textPanel1.add(this.getFinalRotSPanel());
        textPanel1.add(this.getAlliPanel());
        textPanel1.add(this.getFsPanel());
        JPanel bText = new JPanel();
        bText.setLayout(new BoxLayout(bText, 1));
        bText.add(textPanel);
        bText.add(textPanel1);
        JPanel bTextCont = this.createOptionContainer();
        bTextCont.add((Component)bText, "Center");
        return bTextCont;
    }

    private JPanel getDefPanel() {
        String[] defaults = new String[]{this.language.getString("None"), this.language.getString("Fermion_Line"), this.language.getString("Fermion_Loop"), this.language.getString("Fermion_Arc"), this.language.getString("Scalar_Line"), this.language.getString("Scalar_Loop"), this.language.getString("Scalar_Arc"), this.language.getString("Ghost_Line"), this.language.getString("Ghost_Loop"), this.language.getString("Ghost_Arc"), this.language.getString("Photon_Line"), this.language.getString("Photon_Loop"), this.language.getString("Photon_Arc"), this.language.getString("Gluon_Line"), this.language.getString("Gluon_Loop"), this.language.getString("Gluon_Arc"), this.language.getString("Box"), this.language.getString("Blob"), this.language.getString("Vertex"), this.language.getString("Zigzag"), this.language.getString("Text"), this.language.getString("LaTex"), this.language.getString("Move"), this.language.getString("Resize"), this.language.getString("Copy"), this.language.getString("Color"), this.language.getString("Edit")};
        this.defcomb = new JComboBox<String>(defaults);
        this.defcomb.setSelectedIndex(JaxoPrefs.getIntPref(114));
        this.defcomb.addActionListener(this);
        JPanel defPanel = new JPanel();
        TitledBorder defPanelTitle = BorderFactory.createTitledBorder(this.language.getString("After_an_action_default_to"));
        defPanel.setBorder(defPanelTitle);
        defPanel.add(this.defcomb);
        return defPanel;
    }
}

