/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoMainPanel;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import jhplot.utils.AboutDialog;

public class JaxoHelpMenu
extends JMenu
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JaxoMainPanel thePanel;
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private JMenuItem aboutMI;
    private JMenuItem usrGuideMI;
    private JMenuItem aboutJaPlotMI;
    private JFrame frame;

    public JaxoHelpMenu(JaxoMainPanel mainPanel) {
        super(ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("Help"));
        this.thePanel = mainPanel;
        this.aboutMI = new JMenuItem(this.language.getString("About"));
        this.add(this.aboutMI);
        this.aboutMI.addActionListener(this);
        this.aboutMI.setAccelerator(KeyStroke.getKeyStroke('?'));
        this.aboutMI.setActionCommand("About");
        this.usrGuideMI = new JMenuItem(this.language.getString("User_guide"));
        this.add(this.usrGuideMI);
        this.usrGuideMI.addActionListener(this);
        this.usrGuideMI.setAccelerator(KeyStroke.getKeyStroke('G'));
        this.usrGuideMI.setActionCommand("User_guide");
        this.aboutJaPlotMI = new JMenuItem("About japlot");
        this.add(this.aboutJaPlotMI);
        this.aboutJaPlotMI.addActionListener(this);
        this.aboutJaPlotMI.setActionCommand("About japlot");
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        AbstractButton source = (AbstractButton)evt.getSource();
        if (source.getActionCommand().equals("About")) {
            new AboutDialog((Component)this.thePanel);
        }
        if (source.getActionCommand().equals("About japlot")) {
            this.about();
        } else if (source.getActionCommand().equals("User_guide")) {
            this.thePanel.helpEvent();
        }
    }

    public final void about() {
        String s0 = "japlot package. (C) S.Chekanov. Includes the JaxoDraw package \n";
        String s1 = "for drawing  Feynman diagrams";
        String s2 = "(by D.Binosi and L.Theuss)";
        JOptionPane.showMessageDialog(this.thePanel, s0 + s1 + s2);
    }

    public final void setLanguage(String languageString) {
        this.language = ResourceBundle.getBundle(languageString);
        super.setText(this.language.getString("Help"));
        this.aboutMI.setText(this.language.getString("About"));
        this.usrGuideMI.setText(this.language.getString("User_guide"));
    }

    private void displayHTML(String page, boolean listen) {
        JEditorPane editorPane;
        block3: {
            URL url = JaxoHelpMenu.class.getClassLoader().getResource(page);
            String newurl = url.toString();
            editorPane = new JEditorPane();
            editorPane.setEditable(false);
            if (listen) {
                editorPane.addHyperlinkListener(new Hyperlisten());
            }
            try {
                editorPane.setPage(newurl);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, this.language.getString("Cannot_not_open:") + newurl + "!");
                if (!JaxoPrefs.verbose()) break block3;
                System.err.println(e);
            }
        }
        JScrollPane scroller = new JScrollPane(editorPane);
        scroller.setVerticalScrollBarPolicy(22);
        scroller.setPreferredSize(new Dimension(250, 145));
        scroller.setMinimumSize(new Dimension(10, 10));
        JButton closeButton = new JButton(this.language.getString("Close"));
        closeButton.setBorder(BorderFactory.createRaisedBevelBorder());
        closeButton.addMouseListener(new MouseAdapter(){

            @Override
            public final void mouseClicked(MouseEvent evt) {
                JaxoHelpMenu.this.frame.dispose();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add((Component)closeButton, "Center");
        this.frame = new JFrame();
        this.frame.getContentPane().add((Component)scroller, "Center");
        this.frame.getContentPane().add((Component)buttonPanel, "South");
        this.frame.setDefaultCloseOperation(2);
        this.frame.setSize(1000, 800);
        this.frame.setTitle("japlot.jaxodraw-1.0 - " + this.language.getString("User_guide"));
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    static class Hyperlisten
    implements HyperlinkListener {
        Hyperlisten() {
        }

        @Override
        public final void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        pane.setPage(e.getURL());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }
}

