/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoCanvas;
import japlot.jaxodraw.JaxoMainPanel;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class JaxoGridPopupMenu
extends JPopupMenu
implements ActionListener,
MouseListener {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private JaxoMainPanel thePanel;
    private JMenuItem gridSizeMI;
    private JMenu gridM;
    private JRadioButtonMenuItem gridBType1;
    private JRadioButtonMenuItem gridBType2;
    private ButtonGroup gridGroup;
    private int xPos = 0;
    private int yPos = 0;

    public JaxoGridPopupMenu(JaxoMainPanel mainPanel) {
        this.thePanel = mainPanel;
        this.gridSizeMI = new JMenuItem(this.language.getString("Grid_size"));
        this.gridSizeMI.addActionListener(this);
        this.gridSizeMI.addMouseListener(this);
        this.gridSizeMI.setActionCommand("Grid size");
        this.gridM = new JMenu(this.language.getString("Grid_type"));
        this.gridGroup = new ButtonGroup();
        this.gridBType1 = new JRadioButtonMenuItem(this.language.getString("Rectangular"));
        this.gridBType1.addActionListener(this);
        this.gridBType1.setActionCommand("Rectangular");
        this.gridBType2 = new JRadioButtonMenuItem(this.language.getString("Hexagonal"));
        this.gridBType2.addActionListener(this);
        this.gridBType2.setActionCommand("Hexagonal");
        this.gridGroup.add(this.gridBType1);
        this.gridGroup.add(this.gridBType2);
        this.gridM.add(this.gridBType1);
        this.gridM.add(this.gridBType2);
        this.add(this.gridSizeMI);
        this.add(this.gridM);
    }

    public final void setGridType() {
        if (this.thePanel.getCanvas().getGridType()) {
            this.gridBType2.setSelected(true);
        } else {
            this.gridBType1.setSelected(true);
        }
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        AbstractButton source = (AbstractButton)evt.getSource();
        JaxoCanvas theCanvas = this.thePanel.getCanvas();
        if (source.getActionCommand().equals("Grid size")) {
            this.setGridSize(theCanvas);
        } else if (source.getActionCommand().equals("Rectangular")) {
            theCanvas.setGridType(false);
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            double[] newbb = new double[]{5.0, 5.0, d.width, d.height};
            theCanvas.setOldbb(newbb);
            theCanvas.updateOffScreenImage();
        } else if (source.getActionCommand().equals("Hexagonal")) {
            this.thePanel.getCanvas().setGridType(true);
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            double[] newbb = new double[]{5.0, 5.0, d.width, d.height};
            theCanvas.setOldbb(newbb);
            theCanvas.updateOffScreenImage();
        }
    }

    private void setGridSize(JaxoCanvas canvas) {
        int oldSize = canvas.getGridSize();
        int newSize = this.getNewGridSize(oldSize);
        if (newSize != oldSize) {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            double[] newbb = new double[]{5.0, 5.0, d.width, d.height};
            canvas.setGridSize(newSize);
            canvas.setOldbb(newbb);
            canvas.updateOffScreenImage();
        }
    }

    private int getNewGridSize(int os) {
        int newSize = os;
        JPanel pgrid = new JPanel();
        pgrid.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelgrid = new SpinnerNumberModel(os, 1, 75, 1);
        JLabel lgrid = new JLabel(this.language.getString("Size_:") + " ", 4);
        pgrid.add(lgrid);
        JSpinner spgrid = new JSpinner(modelgrid);
        pgrid.add(spgrid);
        JPanel gridSizePanel = new JPanel();
        gridSizePanel.add(pgrid);
        String btn1 = this.language.getString("OK");
        String btn2 = this.language.getString("Cancel");
        Object[] options = new Object[]{btn1, btn2};
        JOptionPane jPane = new JOptionPane(gridSizePanel, -1, 2, null, options, btn1);
        JDialog dialog = jPane.createDialog(this, this.language.getString("Grid_size"));
        dialog.setLocation(this.xPos, this.yPos);
        dialog.setVisible(true);
        Object selectedValue = jPane.getValue();
        int n = 0;
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            n = counter;
        }
        if (n == 0) {
            newSize = modelgrid.getNumber().intValue();
        }
        return newSize;
    }

    public final void setLanguage(String languageString) {
        this.language = ResourceBundle.getBundle(languageString);
        this.gridSizeMI.setText(this.language.getString("Grid_size"));
        this.gridM.setText(this.language.getString("Grid_type"));
        this.gridBType1.setText(this.language.getString("Rectangular"));
        this.gridBType2.setText(this.language.getString("Hexagonal"));
    }

    @Override
    public final void mouseClicked(MouseEvent e) {
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        Point tapLocation = this.getLocationOnScreen();
        this.xPos = tapLocation.x;
        this.yPos = tapLocation.y;
    }

    @Override
    public final void mouseExited(MouseEvent e) {
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
    }
}

