/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoMainPanel;
import japlot.jaxodraw.JaxoPopupListener;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class JaxoGridButtons
extends JPanel
implements ActionListener {
    private static final String[] GRID_BUTTON_ICONS = new String[]{"japlot/jaxodraw/icons/snap.png", "japlot/jaxodraw/icons/viewmag1.png", "japlot/jaxodraw/icons/exit.png"};
    private JaxoMainPanel thePanel;
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private boolean isSnapActive = false;
    private int gnbts = 3;
    private JButton[] gridButtons = new JButton[this.gnbts];
    private String[] gridTips = new String[]{this.language.getString("Snap_points_to_the_grid"), this.language.getString("Dynamical_zoom"), this.language.getString("Exits_JaxoDraw")};
    private JaxoPopupListener snapPopupListener;
    private JaxoPopupListener zoomPopupListener;
    private Border raisedetched = BorderFactory.createEtchedBorder(0);
    private Border raisedbevel = BorderFactory.createRaisedBevelBorder();
    private Border loweredbevel = BorderFactory.createLoweredBevelBorder();

    public JaxoGridButtons(JaxoMainPanel mainPanel) {
        this.thePanel = mainPanel;
        JPanel gridButtonPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        gridButtonPanel.setLayout(gridbag);
        for (int i = 0; i < this.gnbts; ++i) {
            this.gridButtons[i] = new JButton();
            this.gridButtons[i].setIcon(new ImageIcon(JaxoGridButtons.class.getClassLoader().getResource(GRID_BUTTON_ICONS[i])));
            this.gridButtons[i].setToolTipText(this.gridTips[i]);
            this.gridButtons[i].addActionListener(this);
            this.gridButtons[i].setMinimumSize(new Dimension(40, 40));
            this.gridButtons[i].setPreferredSize(new Dimension(40, 40));
            this.gridButtons[i].setBorder(this.raisedbevel);
            this.gridButtons[i].setFocusPainted(false);
        }
        for (int j = 0; j < 1; ++j) {
            for (int i = 0; i < 3; ++i) {
                c.gridx = i;
                c.gridy = j;
                gridbag.setConstraints(this.gridButtons[i + 3 * j], c);
                gridButtonPanel.add(this.gridButtons[i + 3 * j]);
            }
        }
        JPanel finalGridButtonPanel = new JPanel();
        finalGridButtonPanel.setLayout(new BorderLayout());
        finalGridButtonPanel.setBorder(this.raisedetched);
        finalGridButtonPanel.add((Component)gridButtonPanel, "Center");
        this.setLayout(new GridLayout(0, 1));
        this.add(finalGridButtonPanel);
        this.snapPopupListener = new JaxoPopupListener(this.thePanel, 3);
        this.gridButtons[0].addMouseListener(this.snapPopupListener);
        this.zoomPopupListener = new JaxoPopupListener(this.thePanel, 2);
        this.gridButtons[1].addMouseListener(this.zoomPopupListener);
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.gridButtons[0]) {
            this.isSnapActive = !this.isSnapActive;
            this.thePanel.setSnap(!this.thePanel.getSnap());
            if (this.isSnapActive) {
                this.setButtonBorder(0, this.loweredbevel);
                this.setButtonBackground(0, new Color(170, 170, 180));
            } else {
                this.setButtonBorder(0, this.raisedbevel);
                this.setButtonBackground(0, null);
            }
        } else if (evt.getSource() == this.gridButtons[1]) {
            this.thePanel.resetButtons();
            this.setButtonBorder(1, this.loweredbevel);
            this.setButtonBackground(1, new Color(170, 170, 180));
            this.thePanel.setMode(47);
            this.thePanel.updateZoom();
        } else if (evt.getSource() == this.gridButtons[2]) {
            this.thePanel.fileEvent(44);
        }
    }

    public final void reset() {
        this.setButtonBorder(1, this.raisedbevel);
        this.setButtonBackground(1, null);
    }

    public final int getgnbts() {
        return this.gnbts;
    }

    public final void setButtonBackground(int i, Color bgColor) {
        this.gridButtons[i].setBackground(bgColor);
    }

    public final void setButtonBorder(int i, Border border) {
        this.gridButtons[i].setBorder(border);
    }

    public final void pressButton(int j) {
        this.setButtonBackground(j, new Color(170, 170, 180));
        this.setButtonBorder(j, this.loweredbevel);
        this.gridButtons[j].setFocusPainted(false);
    }

    public final void setLanguage(String languageString) {
        this.language = ResourceBundle.getBundle(languageString);
        this.gridTips[0] = this.language.getString("Snap_points_to_the_grid");
        this.gridTips[1] = this.language.getString("Dynamical_zoom");
        this.gridTips[2] = this.language.getString("Exits_JaxoDraw");
        for (int i = 0; i < this.gnbts; ++i) {
            this.gridButtons[i].setToolTipText(this.gridTips[i]);
        }
        this.snapPopupListener.setLanguage(languageString);
        this.zoomPopupListener.setLanguage(languageString);
    }

    public final void enableGridBt(boolean enable) {
        this.gridButtons[0].setEnabled(enable);
    }

    public final void disableSnap() {
        this.gridButtons[0].doClick();
    }
}

