/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoDraw;
import japlot.jaxodraw.JaxoPrefs;
import java.io.File;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class JaxoChooseFile {
    public final String chooseFile(String[] fileFilter, String approveText, String description, String selectedFile) {
        String fileName = "";
        JFileChooser chooser = new JFileChooser(JaxoDraw.getCurDir());
        chooser.setDialogTitle(approveText);
        chooser.setFileFilter(new JaxoFileFilter(fileFilter, description));
        chooser.setSelectedFile(new File(selectedFile));
        chooser.setApproveButtonText(approveText);
        chooser.setApproveButtonToolTipText(approveText + ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("_chosen_file"));
        int returnVal = chooser.showDialog(null, null);
        if (returnVal == 0) {
            fileName = chooser.getSelectedFile().getAbsolutePath();
            JaxoDraw.setCurDir(chooser.getSelectedFile().getParent());
        }
        return fileName;
    }

    static class JaxoFileFilter
    extends FileFilter {
        private Hashtable filters = new Hashtable();
        private String description = null;

        public JaxoFileFilter(String[] filterStrings, String descriptionString) {
            for (int i = 0; i < filterStrings.length; ++i) {
                this.addExtension(filterStrings[i]);
            }
            if (descriptionString != null) {
                this.setDescription(descriptionString);
            }
        }

        @Override
        public final boolean accept(File f) {
            if (f != null) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = this.getExtension(f);
                if (extension != null && this.filters.get(this.getExtension(f)) != null) {
                    return true;
                }
            }
            return false;
        }

        public final String getExtension(File f) {
            String filename;
            int i;
            if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
                return filename.substring(i + 1).toLowerCase();
            }
            return null;
        }

        public final void addExtension(String extension) {
            if (this.filters == null) {
                this.filters = new Hashtable(5);
            }
            this.filters.put(extension.toLowerCase(), this);
        }

        @Override
        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String newDescription) {
            this.description = newDescription;
        }
    }
}

