/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoColorChooser;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import jhplot.jadraw.JaBox;

public class JaxoBoxOptionsPanel
extends JPanel
implements ActionListener {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    private JaBox theBox;
    private String sBox;
    private Icon theIcon;
    private ImageIcon colorPreviewIcon;
    private ImageIcon colorFillPreviewIcon;
    private JButton colorbt;
    private JButton colorFillbt;
    private JPanel colorPanel;
    private JPanel colorFillPanel;
    private TitledBorder colorPanelTitle;
    private TitledBorder colorFillPanelTitle;
    private Color newColor;
    private Color newFillColor;
    private Image colorPreview;
    private Image colorFillPreview;
    private int newXfin;
    private int newYfin;
    private int newWidth;
    private int newHeight;
    private int newRelWidth;
    private int newRelHeight;
    private int newXin;
    private int newYin;
    private float newStroke;
    private boolean changed = false;

    public JaxoBoxOptionsPanel(JaBox box) {
        this.theBox = box;
        this.sBox = this.language.getString("Box_parameters");
        this.theIcon = new ImageIcon(JaxoBoxOptionsPanel.class.getClassLoader().getResource("japlot/jaxodraw/icons/box.png"));
        this.newColor = this.theBox.getColor();
        this.newFillColor = this.theBox.getFillColor();
        this.colorPreview = this.getChooserImage(this.newColor);
        this.colorFillPreview = this.getChooserImage(this.newFillColor);
        this.colorPreviewIcon = new ImageIcon(this.colorPreview);
        this.colorFillPreviewIcon = new ImageIcon(this.colorFillPreview);
        this.newWidth = this.theBox.getSize().width;
        this.newHeight = this.theBox.getSize().height;
        this.newRelWidth = this.theBox.getRelSize().width;
        this.newRelHeight = this.theBox.getRelSize().height;
        this.getXYCoord(this.theBox.getX(), this.theBox.getY(), this.newRelWidth, this.newRelHeight);
        this.newStroke = this.theBox.getStroke();
        JPanel pxin = new JPanel();
        pxin.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelXin = new SpinnerNumberModel(this.newXin, 0, this.d.width, 1);
        JLabel xin = new JLabel("Xmin: ", 4);
        pxin.add(xin);
        JSpinner spxin = new JSpinner(modelXin);
        pxin.add(spxin);
        JPanel pyin = new JPanel();
        pyin.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelYin = new SpinnerNumberModel(this.newYin, 0, this.d.height, 1);
        JLabel yin = new JLabel("Ymin: ", 4);
        pyin.add(yin);
        JSpinner spyin = new JSpinner(modelYin);
        pyin.add(spyin);
        JPanel pxfin = new JPanel();
        pxfin.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelXfin = new SpinnerNumberModel(this.newXfin, 0, this.d.width, 1);
        JLabel xfin = new JLabel("Xmax: ", 4);
        pxfin.add(xfin);
        JSpinner spxfin = new JSpinner(modelXfin);
        pxfin.add(spxfin);
        JPanel pyfin = new JPanel();
        pyfin.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelYfin = new SpinnerNumberModel(this.newYfin, 0, this.d.height, 1);
        JLabel yfin = new JLabel("Ymax: ", 4);
        pyfin.add(yfin);
        JSpinner spyfin = new JSpinner(modelYfin);
        pyfin.add(spyfin);
        JPanel dimSPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints sc = new GridBagConstraints();
        dimSPanel.setLayout(gb);
        sc.gridx = 0;
        sc.gridy = 0;
        sc.insets = new Insets(0, 0, 0, 5);
        pxin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pxin, sc);
        dimSPanel.add((Component)pxin, sc);
        sc.gridx = 0;
        sc.gridy = 1;
        sc.insets = new Insets(5, 0, 5, 5);
        pyin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pyin, sc);
        dimSPanel.add((Component)pyin, sc);
        sc.gridx = 1;
        sc.gridy = 0;
        sc.insets = new Insets(0, 5, 0, 5);
        pxfin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pxfin, sc);
        dimSPanel.add((Component)pxfin, sc);
        sc.gridx = 1;
        sc.gridy = 1;
        sc.insets = new Insets(5, 5, 5, 5);
        pyfin.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(pyfin, sc);
        dimSPanel.add((Component)pyfin, sc);
        JPanel finalDimSPanel = new JPanel();
        finalDimSPanel.setLayout(new BoxLayout(finalDimSPanel, 0));
        TitledBorder dimSTitle = BorderFactory.createTitledBorder(this.language.getString("Position/Size"));
        finalDimSPanel.setBorder(dimSTitle);
        finalDimSPanel.add(dimSPanel);
        JPanel pstin = new JPanel();
        GridBagLayout subgb = new GridBagLayout();
        GridBagConstraints subc = new GridBagConstraints();
        pstin.setLayout(subgb);
        SpinnerNumberModel modelstin = new SpinnerNumberModel(this.newStroke, 0.0, 100.0, 0.2);
        JLabel stin = new JLabel(this.language.getString("Line_Width"), 4);
        JSpinner spstin = new JSpinner(modelstin);
        subc.gridx = 0;
        subc.gridy = 0;
        subc.insets = new Insets(0, 5, 5, 5);
        subgb.setConstraints(stin, subc);
        pstin.add((Component)stin, subc);
        subc.gridx = 1;
        subc.gridy = 0;
        spstin.setPreferredSize(new Dimension(50, 20));
        subgb.setConstraints(spstin, subc);
        pstin.add((Component)spstin, subc);
        JPanel strSPanel = new JPanel();
        GridBagLayout gb1 = new GridBagLayout();
        GridBagConstraints sc1 = new GridBagConstraints();
        strSPanel.setLayout(gb1);
        sc1.gridx = 0;
        sc1.gridy = 0;
        gb1.setConstraints(pstin, sc1);
        strSPanel.add((Component)pstin, sc1);
        JPanel finalStrSPanel = new JPanel();
        finalStrSPanel.setLayout(new BoxLayout(finalStrSPanel, 0));
        TitledBorder strSTitle = BorderFactory.createTitledBorder(this.language.getString("Width"));
        finalStrSPanel.setBorder(strSTitle);
        finalStrSPanel.add(strSPanel);
        this.colorbt = new JButton(this.colorPreviewIcon);
        this.colorbt.addActionListener(this);
        this.colorPanel = new JPanel();
        this.colorPanelTitle = BorderFactory.createTitledBorder(this.language.getString("Line_color"));
        this.colorPanel.add(this.colorbt);
        if (JaxoColor.isGrayScale(this.newFillColor)) {
            this.colorPanelTitle.setTitleColor(JaxoColor.GRAYSCALE165);
            this.colorbt.setEnabled(false);
        }
        this.colorPanel.setBorder(this.colorPanelTitle);
        this.colorFillbt = new JButton(this.colorFillPreviewIcon);
        this.colorFillbt.addActionListener(this);
        this.colorFillPanel = new JPanel();
        this.colorFillPanelTitle = BorderFactory.createTitledBorder(this.language.getString("Fill_color"));
        this.colorFillPanel.setBorder(this.colorFillPanelTitle);
        this.colorFillPanel.add(this.colorFillbt);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 5);
        gridbag.setConstraints(finalDimSPanel, c);
        this.add((Component)finalDimSPanel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(5, 0, 0, 5);
        gridbag.setConstraints(finalStrSPanel, c);
        this.add((Component)finalStrSPanel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(0, 5, 5, 0);
        this.colorPanel.setPreferredSize(new Dimension(100, 70));
        gridbag.setConstraints(this.colorPanel, c);
        this.add((Component)this.colorPanel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(5, 5, 0, 0);
        this.colorFillPanel.setPreferredSize(new Dimension(100, 70));
        gridbag.setConstraints(this.colorFillPanel, c);
        this.add((Component)this.colorFillPanel, c);
        Object[] optionButtonNames = new String[]{this.language.getString("Accept"), this.language.getString("Cancel")};
        int n = JOptionPane.showOptionDialog(this, this, this.sBox, 2, 1, this.theIcon, optionButtonNames, optionButtonNames[0]);
        if (n == 0) {
            if (this.newColor != null && this.newFillColor != null) {
                if (JaxoColor.isGrayScale(this.newFillColor)) {
                    this.newColor = JaxoColor.BLACK;
                }
                this.theBox.setColor(this.newColor);
                this.theBox.setFillColor(this.newFillColor);
            }
            this.newXin = modelXin.getNumber().intValue();
            this.newYin = modelYin.getNumber().intValue();
            this.newXfin = modelXfin.getNumber().intValue();
            this.newYfin = modelYfin.getNumber().intValue();
            this.newStroke = Math.abs(modelstin.getNumber().floatValue());
            this.theBox.setStroke(this.newStroke);
            this.setNewBox(this.newXin, this.newYin, this.newXfin, this.newYfin);
            this.theBox.setX(this.newXin);
            this.theBox.setY(this.newYin);
            if (this.newRelWidth >= 0 && this.newRelHeight >= 0 || this.newRelWidth < 0 && this.newRelHeight < 0) {
                this.theBox.setRelWAndH(this.newWidth, this.newHeight);
            } else if (this.newRelWidth >= 0 && this.newRelHeight < 0 || this.newRelWidth < 0 && this.newRelHeight >= 0) {
                this.theBox.setRelWAndH(this.newWidth, -this.newHeight);
            }
            this.changed = true;
        }
    }

    public final boolean hasChanged() {
        return this.changed;
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        JaxoColorChooser colorChooser;
        if (evt.getSource() == this.colorbt) {
            colorChooser = new JaxoColorChooser();
            this.newColor = colorChooser.color(this.newColor, false);
            if (this.newColor != null) {
                this.colorPreviewIcon = new ImageIcon(this.getChooserImage(this.newColor));
                this.colorbt.setIcon(this.colorPreviewIcon);
            }
        }
        if (evt.getSource() == this.colorFillbt) {
            colorChooser = new JaxoColorChooser();
            this.newFillColor = colorChooser.color(this.newFillColor, true);
            if (this.newFillColor != null) {
                this.colorFillPreviewIcon = new ImageIcon(this.getChooserImage(this.newFillColor));
                this.colorFillbt.setIcon(this.colorFillPreviewIcon);
                this.colorPanelTitle = BorderFactory.createTitledBorder(this.language.getString("Line_color"));
                this.colorbt.setEnabled(true);
                if (JaxoColor.isGrayScale(this.newFillColor)) {
                    this.colorPanelTitle.setTitleColor(JaxoColor.GRAYSCALE165);
                    this.colorbt.setEnabled(false);
                }
                this.colorPanel.setBorder(this.colorPanelTitle);
            }
        }
    }

    private void getXYCoord(int x, int y, int relw, int relh) {
        if (relw > 0 && relh >= 0 || relw < 0 && relh <= 0) {
            this.newXin = x;
            this.newYin = y;
            this.newXfin = x + Math.abs(relw);
            this.newYfin = y + Math.abs(relh);
        }
        if (relw >= 0 && relh < 0 || relw <= 0 && relh > 0) {
            this.newXin = x;
            this.newYin = y + Math.abs(relh);
            this.newXfin = x + Math.abs(relw);
            this.newYfin = y;
        }
    }

    private Image getChooserImage(Color iconColor) {
        int width = 40;
        int height = 15;
        int size = width * height;
        int[] pixels = new int[size];
        for (int i = 0; i < size; ++i) {
            pixels[i] = iconColor.getRGB();
        }
        MemoryImageSource source = new MemoryImageSource(width, height, pixels, 0, width);
        Image jaxColorBox = this.createImage(source);
        return jaxColorBox;
    }

    private void setNewBox(int xin, int yin, int xfin, int yfin) {
        this.newWidth = Math.abs(xfin - xin);
        this.newHeight = Math.abs(yfin - yin);
        this.newRelWidth = xfin - xin;
        this.newRelHeight = yfin - yin;
        if (this.newRelWidth > 0 && this.newRelHeight >= 0) {
            this.newXin = xin;
            this.newYin = yin;
        }
        if (this.newRelWidth < 0 && this.newRelHeight <= 0) {
            this.newXin = xfin;
            this.newYin = yfin;
        }
        if (this.newRelWidth >= 0 && this.newRelHeight < 0) {
            this.newXin = xin;
            this.newYin = yin + this.newRelHeight;
        }
        if (this.newRelWidth <= 0 && this.newRelHeight > 0) {
            this.newXin = xin + this.newRelWidth;
            this.newYin = yin;
        }
    }
}

