/*
 * Decompiled with CFR 0.152.
 */
package jyplot;

import cern.colt.list.BooleanArrayList;
import cern.colt.list.IntArrayList;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import jyplot.Jyplot;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;

public class BarClusterPlot
implements ChartMouseListener {
    boolean[][] booleanarrays;
    String[] columnnames;
    String[][] columnorders;
    String[][] domainlabels;
    String[] plottitles;
    Jyplot jplot;
    ArrayList charts;
    HashMap chartToRectGeneMap;
    ArrayList genelist;

    public BarClusterPlot(boolean[][] booleanarrays, String[] columnnames, String[][] columnorders, String[][] domainlabels, String[] plottitles) {
        try {
            this.booleanarrays = booleanarrays;
            this.columnnames = columnnames;
            this.columnorders = columnorders;
            this.domainlabels = domainlabels;
            this.plottitles = plottitles;
            this.jplot = new Jyplot();
            int plotCols = columnorders.length / 2;
            int plotRows = 2;
            int plotcount = 1;
            this.genelist = new ArrayList(booleanarrays.length);
            this.charts = new ArrayList();
            this.chartToRectGeneMap = new HashMap();
            for (int i = 0; i < columnorders.length; ++i) {
                int k;
                IntArrayList booleanArrayIndices = new IntArrayList(columnorders[i].length);
                block3: for (int j = 0; j < columnorders[i].length; ++j) {
                    for (k = 0; k < columnnames.length; ++k) {
                        if (!columnorders[i][j].equalsIgnoreCase(columnnames[k])) continue;
                        booleanArrayIndices.add(k);
                        continue block3;
                    }
                }
                boolean[][] tempBooleanArray = new boolean[booleanarrays.length][booleanArrayIndices.size()];
                for (k = 0; k < booleanarrays.length; ++k) {
                    for (int j = 0; j < booleanArrayIndices.size(); ++j) {
                        tempBooleanArray[k][j] = booleanarrays[k][booleanArrayIndices.get(j)];
                    }
                }
                HashMap rectToGeneListMap = this.computeRectCoords(tempBooleanArray);
                this.jplot.subplot(plotRows, plotCols, plotcount);
                ++plotcount;
                this.plotBarClusterData(rectToGeneListMap, this.jplot);
                if (domainlabels != null) {
                    this.jplot.xticks(new double[]{1.0, 2.0, 3.0}, domainlabels[i]);
                }
                if (plottitles != null) {
                    this.jplot.title(plottitles[i]);
                }
                this.charts.add(this.jplot.getChart());
                this.chartToRectGeneMap.put(this.jplot.getChart(), rectToGeneListMap);
            }
            HashMap chartPanelMap = this.jplot.getChartPanelMap();
            for (JFreeChart element : chartPanelMap.keySet()) {
                ChartPanel panel = new ChartPanel(element);
                panel.addChartMouseListener((ChartMouseListener)this);
                chartPanelMap.put(element, panel);
            }
            this.jplot.connect(this);
            this.jplot.show(500, 500);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BarClusterPlot() {
    }

    public HashMap computeRectCoords(boolean[][] data) {
        int i;
        int rows = data.length;
        int cols = data[0].length;
        ArrayList<IntArrayList> indicesLists = new ArrayList<IntArrayList>();
        int groups = cols;
        ArrayList binArrays = this.generateAllBinaryArrays((int)Math.pow(2.0, groups));
        binArrays.remove(0);
        HashMap rectangleToIndexArray = new HashMap();
        for (int i2 = 0; i2 < binArrays.size(); ++i2) {
            indicesLists.add(new IntArrayList());
        }
        int[] countMatches = new int[binArrays.size()];
        boolean matches = true;
        block1: for (int i3 = 0; i3 < rows; ++i3) {
            for (int binindex = 0; binindex < binArrays.size(); ++binindex) {
                boolean[] binarray = (boolean[])binArrays.get(binindex);
                matches = true;
                for (int j = 0; j < data[i3].length; ++j) {
                    if (data[i3][j] == binarray[j]) continue;
                    matches = false;
                    break;
                }
                if (!matches) continue;
                int n = binindex;
                countMatches[n] = countMatches[n] + 1;
                ((IntArrayList)indicesLists.get(binindex)).add(i3);
                continue block1;
            }
        }
        int total = countMatches.length;
        int[][] coords = new int[total][2];
        for (int i4 = 0; i4 < coords.length; ++i4) {
            coords[i4][0] = 1;
            coords[i4][1] = total;
        }
        int totalHeight = 0;
        for (i = 0; i < binArrays.size(); ++i) {
            if (!((boolean[])binArrays.get(i))[0]) continue;
            ++totalHeight;
        }
        for (i = 0; i < binArrays.size(); ++i) {
            if (!((boolean[])binArrays.get(i))[0]) continue;
            coords[i][1] = totalHeight;
        }
        IntArrayList binArrayOrder = new IntArrayList();
        int minPositionOfSelectedArrays = 1;
        for (int columnIndex = 0; columnIndex < cols; ++columnIndex) {
            IntArrayList localArrayIndices = new IntArrayList();
            for (int binArrayIndex = 0; binArrayIndex < binArrays.size(); ++binArrayIndex) {
                BooleanArrayList b = new BooleanArrayList((boolean[])binArrays.get(binArrayIndex));
                if (columnIndex != 0 && b.indexOfFromTo(true, 0, columnIndex - 1) != -1 || !b.get(columnIndex)) continue;
                binArrayOrder.add(binArrayIndex);
            }
            int selectedArrayCount = localArrayIndices.size();
            for (int i5 = 0; i5 < localArrayIndices.size(); ++i5) {
                coords[i5][0] = minPositionOfSelectedArrays;
                coords[i5][1] = minPositionOfSelectedArrays + selectedArrayCount - 1;
            }
            minPositionOfSelectedArrays += selectedArrayCount;
        }
        int currentHeight = 1;
        for (int i6 = 0; i6 < binArrayOrder.size(); ++i6) {
            int binarrayindex = binArrayOrder.get(i6);
            int height = countMatches[binarrayindex];
            for (int index = 0; index < ((boolean[])binArrays.get(binarrayindex)).length; ++index) {
                if (!((boolean[])binArrays.get(binarrayindex))[index]) continue;
                Rectangle rect = new Rectangle(index, currentHeight, 1, height);
                rectangleToIndexArray.put(rect, indicesLists.get(binarrayindex));
            }
            currentHeight += height;
        }
        return rectangleToIndexArray;
    }

    private ArrayList generateAllBinaryArrays(int size) {
        ArrayList<boolean[]> results = new ArrayList<boolean[]>(size);
        int maxarraylength = this.denary2Binary(size - 1, 0).length;
        for (int i = 0; i < size; ++i) {
            results.add(this.denary2Binary(i, maxarraylength));
        }
        return results;
    }

    private boolean[] denary2Binary(int decimalint, int maxarraylength) {
        BooleanArrayList result = new BooleanArrayList(maxarraylength);
        if (decimalint < 0) {
            System.err.println("denary2Binary(): must be a positive integer");
            return result.elements();
        }
        if (decimalint == 0) {
            for (int i = 0; i < maxarraylength; ++i) {
                result.add(false);
            }
            result.trimToSize();
            return result.elements();
        }
        while (decimalint > 0) {
            result.add(decimalint % 2 > 0);
            decimalint >>= 1;
        }
        if (result.size() < maxarraylength) {
            for (int i = result.size(); i < maxarraylength; ++i) {
                result.add(false);
            }
        }
        result.reverse();
        result.trimToSize();
        return result.elements();
    }

    private void plotBarClusterData(HashMap rectToGeneListMap, Jyplot plotter) {
        for (Rectangle rect : rectToGeneListMap.keySet()) {
            plotter.bar(rect.getX() - 0.5, rect.getHeight(), rect.getWidth(), rect.getY(), new Color(0.6f, 0.6f, 0.6f));
        }
    }

    public static void main(String[] args) {
    }

    public void chartMouseClicked(ChartMouseEvent event) {
        JFreeChart chart = event.getChart();
        int x = event.getTrigger().getX();
        int y = event.getTrigger().getY();
        ChartPanel panel = (ChartPanel)event.getTrigger().getComponent();
        XYPlot plot = chart.getXYPlot();
        ChartRenderingInfo info = panel.getChartRenderingInfo();
        Rectangle2D dataArea = info.getPlotInfo().getDataArea();
        double xdata = plot.getDomainAxis().java2DToValue((double)x, dataArea, plot.getDomainAxisEdge());
        double ydata = plot.getRangeAxis().java2DToValue((double)y, dataArea, plot.getRangeAxisEdge());
        System.out.println((xdata += 0.5) + " " + ydata);
        if (!this.charts.contains(chart)) {
            System.out.println("Chart not contained in charts");
            return;
        }
        for (Rectangle rect : ((HashMap)this.chartToRectGeneMap.get(chart)).keySet()) {
            if (!rect.contains(xdata, ydata)) continue;
            IntArrayList genelist = (IntArrayList)this.chartToRectGeneMap.get(rect);
            System.out.println("Clicked rect " + rect);
            break;
        }
    }

    public void chartMouseMoved(ChartMouseEvent event) {
    }
}

