/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import javax.swing.JPanel;
import jplot.GPoints;
import jplot.LinePars;

public class LineStyle
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Color backgroundColor;
    private Stroke stroke;
    private Stroke pointStroke;
    private Dimension panelSize;
    private double lineLength;
    private LinePars lp;
    private Rectangle rectangle;

    public LineStyle(LinePars l) {
        this.lp = l;
        this.backgroundColor = Color.white;
        this.panelSize = new Dimension(45, 16);
        this.rectangle = new Rectangle(0, 0, this.panelSize.width, this.panelSize.height);
    }

    private void initialize() {
        float[] dash = new float[]{this.lp.getDashLength()};
        this.pointStroke = new BasicStroke(this.lp.getPenWidth());
        this.stroke = dash[0] < 0.0f ? new BasicStroke(0.0f) : (dash[0] == 0.0f ? this.pointStroke : new BasicStroke(this.lp.getPenWidth(), 2, 0, 10.0f, dash, 0.0f));
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.backgroundColor);
        g2.fill(this.rectangle);
        this.panelSize = this.getSize(this.panelSize);
        this.lineLength = 8 * this.panelSize.width / 10;
        double x_inset = this.panelSize.width / 10;
        double y_inset = (double)this.panelSize.height / 2.0;
        this.initialize();
        g2.setColor(this.lp.getColor());
        if (this.lp.drawLine()) {
            g2.setStroke(this.stroke);
            g2.draw(new Line2D.Double(x_inset, y_inset, this.lineLength + x_inset, y_inset));
        }
        if (this.lp.getSymbol() < 13 && this.lp.getSymbolSize() > 0.0f) {
            g2.setStroke(this.pointStroke);
            if (this.lp.drawSymbol()) {
                GPoints.drawPointType(this.lp.getSymbol(), g2, x_inset + this.lineLength / 2.0, y_inset, this.lp.getSymbolSize());
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.panelSize;
    }

    public LinePars getLinePars() {
        return this.lp;
    }

    public void setLinePars(LinePars lp) {
        this.lp = lp;
    }

    public void setColor(Color c) {
        this.lp.setColor(c);
    }

    public void setPenWidth(float f) {
        this.lp.setPenWidth(f);
    }

    @Override
    public void setBackground(Color c) {
        this.backgroundColor = c;
    }
}

