/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import jhplot.shapes.HShape;
import jplot.DataChangeListener;
import jplot.GraphLabel;
import jplot.Utils;
import jplot.XMLRead;
import jplot.XMLWrite;

public class GraphSettings
extends DataChangeListener
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final int DISABLE = 0;
    static final int ENABLE = 1;
    static final int AUTO = 2;
    static final Color[] color = new Color[]{new Color(0, 0, 102), new Color(255, 0, 0), new Color(0, 114, 0), new Color(132, 0, 132), new Color(102, 0, 255), new Color(255, 0, 102), new Color(0, 145, 0), new Color(255, 0, 255), new Color(0, 153, 255), new Color(255, 153, 0), new Color(0, 195, 100), new Color(255, 188, 255), new Color(0, 255, 255), new Color(255, 255, 0), new Color(102, 255, 0), new Color(255, 220, 226), new Color(10, 10, 10), new Color(100, 100, 100), new Color(160, 160, 160), new Color(220, 220, 220)};
    public static final float[] dashLengths = new float[]{0.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, -1.0f};
    static final double INF = 1.0E300;
    public static final int N_AXES = 2;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int GRAPHTYPE_2D = 0;
    public static final int CONTOUR_2D = 4;
    public static final int GRAPHTYPE_PIPER = 1;
    public static final int GRAPHTYPE_MULTI = 2;
    public static final int NO_SYMBOL = 13;
    public static final int NO_LINE = 7;
    int colorIndex = 0;
    int pointIndex = 0;
    private Dimension panelSize;
    private double leftMargin;
    private double rightMargin;
    private double bottomMargin;
    private double topMargin;
    private int contour_binsX;
    private int contour_binsY;
    private int contour_levels;
    private boolean contour_bar;
    private boolean contour_gray;
    private int histo = 0;
    private double[] ticLength = new double[2];
    private double[] subticLength = new double[2];
    private int[] subticNumber = new int[2];
    private int maxNumberOfTics;
    private int[] numberOfTics = new int[2];
    private boolean[] useNumberOfTics = new boolean[2];
    private boolean[] useTics = new boolean[2];
    private boolean[] rotTics = new boolean[2];
    private boolean[] mirrorTics = new boolean[2];
    private boolean[] useTicLabels = new boolean[2];
    private boolean antiAlias;
    private Vector<GraphLabel> labels = new Vector();
    private Vector<HShape> primitives = new Vector();
    private Vector<String> ticklabelX = new Vector();
    private Vector<String> ticklabelY = new Vector();
    private boolean[] useAutoTics = new boolean[2];
    private double axesRatio;
    private boolean useRatio;
    private boolean[] useAxis = new boolean[2];
    private boolean[] mirrorAxis = new boolean[2];
    private double[] inv = new double[2];
    private float axesPenTicWidth;
    private int axesArrow;
    private Color backgroundColor;
    private Color axesColor;
    private Color[] labelColor = new Color[2];
    private Color titleColor;
    private Color graphBgColor;
    private Color[] ticColor = new Color[2];
    private Font legendFont;
    private boolean useLegend;
    private boolean useLegendPos;
    private double[] legendPos = new double[2];
    private double legendSpacing;
    private boolean NoData = false;
    private boolean[] isLog = new boolean[2];
    private boolean[] aRange = new boolean[2];
    private double[] minValue = new double[2];
    private double[] maxValue = new double[2];
    private Font[] ticFont = new Font[2];
    private boolean[] useGrid = new boolean[2];
    private Color gridColor;
    private boolean toFront;
    private boolean toFrontPrimitives;
    private boolean isAttResizable;
    private boolean shadow;
    private Color triangleFillColor;
    private boolean useInner;
    private boolean useBox;
    private float boxOffset;
    private Color boxFillColor;
    private Color boxColor;
    private boolean fntChanged;
    private int pointMode;
    private int colorMode;
    private int graphType;
    private int graphStyle;
    float tdsFac;
    private float penWidthForAxis = 2.0f;
    boolean useTds;
    private final String lf = System.getProperty("line.separator");

    public GraphSettings(JFrame frame) {
        if (frame != null) {
            this.setFrame(frame);
        }
        this.reset();
    }

    public GraphSettings() {
        this(null);
    }

    public void setLabel(GraphLabel gl) {
        boolean labelFound = false;
        Enumeration<GraphLabel> e = this.labels.elements();
        while (e.hasMoreElements()) {
            GraphLabel g = e.nextElement();
            if (!gl.equals(g.getText())) continue;
            g.copy(gl);
            labelFound = true;
            break;
        }
        if (!labelFound) {
            this.labels.add(gl);
        }
    }

    public void addLabel(GraphLabel gl) {
        this.labels.add(gl);
    }

    public void addPrimitive(HShape ob) {
        this.primitives.add(ob);
    }

    public void resetLabels() {
        Enumeration<GraphLabel> e = this.labels.elements();
        while (e.hasMoreElements()) {
            e.nextElement().setUsePosition(false);
        }
    }

    public Vector<GraphLabel> getLabels() {
        return this.labels;
    }

    public void setLabels(Vector<GraphLabel> labels) {
        this.labels = labels;
    }

    public Vector<HShape> getPrimitives() {
        return this.primitives;
    }

    public void setGraphType(int type) {
        this.graphType = type;
        if (type == 1) {
            this.gridColor = new Color(200, 200, 200);
            this.ticFont[0] = Utils.getDefaultFont().deriveFont(9.0f);
            this.ticFont[1] = Utils.getDefaultFont().deriveFont(9.0f);
        }
    }

    public int getGraphType() {
        return this.graphType;
    }

    public int get2DType() {
        return this.histo;
    }

    public void set2DType(int type) {
        this.histo = type;
    }

    public Vector<String> getLabelTicks(int axis) {
        if (axis == 0) {
            return this.ticklabelX;
        }
        if (axis == 1) {
            return this.ticklabelY;
        }
        return this.ticklabelX;
    }

    public void setLabelTicks(int axis, Vector<String> ticklabel) {
        if (axis == 0) {
            this.ticklabelX = ticklabel;
        }
        if (axis == 1) {
            this.ticklabelY = ticklabel;
        }
    }

    public void setAutomaticTicks(int axis, boolean auto) {
        this.useAutoTics[axis] = auto;
    }

    public boolean getAutomaticTicks(int axis) {
        return this.useAutoTics[axis];
    }

    public void reset() {
        for (int k = 0; k < 2; ++k) {
            this.useAutoTics[k] = true;
            this.minValue[k] = 1.0E300;
            this.maxValue[k] = -1.0E300;
            this.aRange[k] = true;
            this.isLog[k] = false;
            this.useTicLabels[k] = true;
            this.useTics[k] = true;
            this.useAxis[k] = true;
            this.mirrorAxis[k] = true;
            this.rotTics[k] = false;
            this.mirrorTics[k] = true;
            this.numberOfTics[k] = 5;
            this.useNumberOfTics[k] = false;
            this.ticColor[k] = Color.black;
            this.ticFont[k] = Utils.getDefaultFont();
            this.useGrid[k] = true;
            this.legendPos[k] = 5.0;
            this.ticLength[k] = 0.02;
            this.subticLength[k] = 0.01;
            this.subticNumber[k] = 2;
            this.contour_binsX = 40;
            this.contour_binsY = 40;
            this.contour_levels = 10;
            this.contour_bar = true;
            this.contour_gray = false;
        }
        this.antiAlias = false;
        this.isAttResizable = true;
        this.setDataChanged(false);
        this.axesRatio = 0.0;
        this.panelSize = new Dimension(470, 330);
        this.shadow = true;
        this.maxNumberOfTics = 10;
        this.axesColor = Color.black;
        this.axesArrow = 0;
        this.axesPenTicWidth = 2.0f;
        this.leftMargin = 20.0;
        this.rightMargin = 27.0;
        this.bottomMargin = 15.0;
        this.topMargin = 15.0;
        this.useRatio = false;
        this.histo = 0;
        this.legendFont = Utils.getDefaultFont();
        this.legendSpacing = 1.0;
        this.useLegendPos = false;
        this.useLegend = true;
        this.gridColor = new Color(227, 230, 230);
        this.toFront = false;
        this.toFrontPrimitives = false;
        this.fntChanged = true;
        this.pointMode = 0;
        this.colorMode = 2;
        this.graphStyle = 0;
        this.graphType = 0;
        this.triangleFillColor = new Color(224, 223, 221);
        this.useInner = true;
        this.useBox = false;
        this.boxFillColor = Color.white;
        this.boxColor = Color.black;
        this.backgroundColor = Color.white;
        this.graphBgColor = Color.white;
        this.boxOffset = 3.0f;
        this.tdsFac = 1000.0f;
        this.useTds = true;
        this.penWidthForAxis = 2.0f;
        this.labels.clear();
        this.primitives.clear();
    }

    public void removeLabels() {
        this.labels.clear();
    }

    public void removePrimitives() {
        this.primitives.clear();
    }

    public void removeLabel(int i) {
        if (i < this.labels.size()) {
            this.labels.remove(i);
        }
    }

    public void removePrimitive(int i) {
        if (i < this.primitives.size()) {
            this.primitives.remove(i);
        }
    }

    public int numberLabels() {
        return this.labels.size();
    }

    public int numberPrimitives() {
        return this.primitives.size();
    }

    public void print() {
        PrintStream out = System.out;
        this.print(out);
    }

    public void print(PrintStream out) {
        out.println(" ");
        out.println("Graph Settings ");
        out.println("=========== ");
        out.println("graph-type: " + String.valueOf(this.graphType));
        out.println("graph-style: " + String.valueOf(this.graphStyle));
        out.println("histo: " + String.valueOf(this.histo));
        out.println("\n ---- panel-size");
        out.println("width: " + String.valueOf(this.panelSize.width));
        out.println("height: " + String.valueOf(this.panelSize.height));
        out.println("\n ---- panel-margins");
        out.println("left: " + String.valueOf(this.leftMargin));
        out.println("right: " + String.valueOf(this.rightMargin));
        out.println("top: " + String.valueOf(this.topMargin));
        out.println("bottom: " + String.valueOf(this.bottomMargin));
        out.println("graph-bgcolor: " + this.graphBgColor.toString());
        out.println("panel-bgcolor: " + this.backgroundColor.toString());
        out.println("fix:" + String.valueOf(this.useRatio));
        out.println("axes-ratio :" + String.valueOf(this.axesRatio));
        out.println("axes-color: " + this.axesColor);
        out.println("axes-penwidth-tic: " + this.axesPenTicWidth);
        out.println("axes-arrow: " + this.axesArrow);
        for (int k = 0; k < 2; ++k) {
            String loc = k == 0 ? "x1" : (k == 1 ? "y1" : "??");
            out.println("show: " + String.valueOf(this.useAxis[k]));
            out.println("mirror: " + String.valueOf(this.mirrorAxis[k]));
            out.println(loc + "-axis");
            out.println("\n ---- range:");
            out.println("auto: " + String.valueOf(this.aRange[k]));
            out.println("min: " + String.valueOf(this.minValue[k]));
            out.println("max: " + String.valueOf(this.maxValue[k]));
            out.println("log: " + String.valueOf(this.isLog[k]));
            out.println("\n --- tics:");
            out.println("show : " + String.valueOf(this.useTics[k]));
            out.println("rotate: " + String.valueOf(this.rotTics[k]));
            out.println("fix: " + String.valueOf(this.useNumberOfTics[k]));
            out.println("number: " + String.valueOf(this.numberOfTics[k]));
            out.println("length: " + String.valueOf(this.ticLength[k]));
            out.println("color: " + this.ticColor[k].toString());
            out.println("show: " + String.valueOf(this.useTicLabels[k]));
            out.println("tic-labels");
            out.println("font: " + this.ticFont[k].toString());
        }
        out.println("v-show: " + String.valueOf(this.useGrid[0]));
        out.println("h-show: " + String.valueOf(this.useGrid[1]));
        out.println("\ngrid");
        out.println("color: " + this.gridColor);
        out.println("to-front: " + String.valueOf(this.toFront));
        out.println("to-front-primitives: " + String.valueOf(this.toFrontPrimitives));
        out.println("\n ---- legends:");
        out.println("show: " + String.valueOf(this.useLegend));
        out.println("fix: " + String.valueOf(this.useLegendPos));
        out.println("position");
        out.println("x: " + String.valueOf((int)this.legendPos[0]));
        out.println("y: " + String.valueOf((int)this.legendPos[1]));
        out.println("spacing: " + String.valueOf(this.legendSpacing));
        out.println("font: " + this.legendFont.toString());
        out.println("\nbounding-box");
        out.println("show: " + String.valueOf(this.useBox));
        out.println("type2D: " + String.valueOf(this.histo));
        out.println("offset: " + String.valueOf(this.boxOffset));
        out.println("box-color: " + this.boxColor.toString());
        out.println("fill-color: " + this.boxFillColor.toString());
    }

    public void getSettings(XMLWrite xw) {
        Vector v = new Vector();
        xw.open("graph-settings");
        xw.setData("graph-type", String.valueOf(this.graphType));
        xw.setData("graph-style", String.valueOf(this.graphStyle));
        xw.setData("graph-data", String.valueOf(this.NoData));
        xw.setData("graph-antialias", String.valueOf(this.antiAlias));
        xw.setData("graph-attresizable", String.valueOf(this.isAttResizable));
        xw.add("x", String.valueOf(this.contour_binsX));
        xw.add("y", String.valueOf(this.contour_binsY));
        xw.add("levels", String.valueOf(this.contour_levels));
        xw.add("bar", String.valueOf(this.contour_bar));
        xw.add("gray", String.valueOf(this.contour_gray));
        xw.set("contour");
        xw.add("width", String.valueOf(this.panelSize.width));
        xw.add("height", String.valueOf(this.panelSize.height));
        xw.set("panel-size");
        xw.add("left", String.valueOf(this.leftMargin));
        xw.add("right", String.valueOf(this.rightMargin));
        xw.add("top", String.valueOf(this.topMargin));
        xw.add("bottom", String.valueOf(this.bottomMargin));
        xw.set("panel-margins");
        xw.set("graph-bgcolor", this.graphBgColor);
        xw.set("panel-bgcolor", this.backgroundColor);
        xw.add("fix", String.valueOf(this.useRatio));
        xw.setData("axes-ratio", String.valueOf(this.axesRatio));
        xw.set("axes-color", this.axesColor);
        xw.setData("axes-penwidth-tic", String.valueOf(this.axesPenTicWidth));
        xw.setData("axes-arrow", String.valueOf(this.axesArrow));
        for (int k = 0; k < 2; ++k) {
            String loc = k == 0 ? "x1" : (k == 1 ? "y1" : "??");
            xw.add("show", String.valueOf(this.useAxis[k]));
            xw.add("mirror", String.valueOf(this.mirrorAxis[k]));
            xw.open(loc + "-axis");
            xw.add("auto", String.valueOf(this.aRange[k]));
            xw.add("min", String.valueOf(this.minValue[k]));
            xw.add("max", String.valueOf(this.maxValue[k]));
            xw.set("range");
            xw.add("log", String.valueOf(this.isLog[k]));
            xw.set("scaling");
            xw.add("show", String.valueOf(this.useTics[k]));
            xw.open("tics");
            xw.setData("rotate", String.valueOf(this.rotTics[k]));
            xw.add("fix", String.valueOf(this.useNumberOfTics[k]));
            xw.setData("number", String.valueOf(this.numberOfTics[k]));
            xw.setData("length", String.valueOf(this.ticLength[k]));
            xw.set("color", this.ticColor[k]);
            xw.add("show", String.valueOf(this.useTicLabels[k]));
            xw.open("tic-labels");
            xw.set("font", this.ticFont[k]);
            xw.close();
            xw.close();
            xw.close();
        }
        xw.add("v-show", String.valueOf(this.useGrid[0]));
        xw.add("h-show", String.valueOf(this.useGrid[1]));
        xw.open("grid");
        xw.set("color", this.gridColor);
        xw.setData("to-front", String.valueOf(this.toFront));
        xw.close();
        xw.add("show", String.valueOf(this.useLegend));
        xw.open("legend");
        xw.add("fix", String.valueOf(this.useLegendPos));
        xw.add("x", String.valueOf((int)this.legendPos[0]));
        xw.add("y", String.valueOf((int)this.legendPos[1]));
        xw.set("position");
        xw.setData("spacing", String.valueOf(this.legendSpacing));
        xw.set("font", this.legendFont);
        xw.close();
        xw.add("show", String.valueOf(this.useBox));
        xw.add("type2D", String.valueOf(this.histo));
        xw.open("boundingbox");
        xw.setData("offset", String.valueOf(this.boxOffset));
        xw.set("box-color", this.boxColor);
        xw.set("fill-color", this.boxFillColor);
        xw.close();
        if (this.graphType == 1) {
            xw.open("piper");
            xw.add("show", String.valueOf(this.useTds));
            xw.add("scaling", String.valueOf(this.tdsFac));
            xw.set("tds");
            xw.add("show", String.valueOf(this.useInner));
            xw.open("triangles");
            xw.set("color", this.triangleFillColor);
            xw.close();
            xw.close();
        }
        if (this.labels.size() > 0) {
            xw.open("labels");
            Enumeration<GraphLabel> e = this.labels.elements();
            while (e.hasMoreElements()) {
                GraphLabel gl = e.nextElement();
                if (gl.equals(9)) continue;
                gl.getSettings(xw);
            }
            xw.close();
        }
        if (this.primitives.size() > 0) {
            xw.setData("to-front-primitives", String.valueOf(this.toFrontPrimitives));
            xw.open("primitives");
            Enumeration<HShape> e = this.primitives.elements();
            while (e.hasMoreElements()) {
                HShape hs = e.nextElement();
                hs.getSettings(xw);
            }
            xw.close();
        }
        xw.close();
    }

    public void updateSettings(XMLRead xr) {
        if (xr.open("graph-settings")) {
            this.graphType = xr.getInt("graph-type", this.graphType);
            this.graphStyle = xr.getInt("graph-style", this.graphStyle);
            this.NoData = xr.getBoolean("graph-data", this.NoData);
            this.antiAlias = xr.getBoolean("graph-antialias", this.antiAlias);
            this.isAttResizable = xr.getBoolean("graph-attresizable", this.isAttResizable);
            this.contour_binsX = xr.getInt("contour/x", this.contour_binsX);
            this.contour_binsY = xr.getInt("contour/y", this.contour_binsY);
            this.contour_levels = xr.getInt("contour/levels", this.contour_levels);
            this.contour_bar = xr.getBoolean("contour/bar", this.contour_bar);
            this.contour_gray = xr.getBoolean("contour/gray", this.contour_gray);
            this.leftMargin = xr.getDouble("panel-margins/left", this.leftMargin);
            this.rightMargin = xr.getDouble("panel-margins/right", this.rightMargin);
            this.topMargin = xr.getDouble("panel-margins/top", this.topMargin);
            this.bottomMargin = xr.getDouble("panel-margins/bottom", this.bottomMargin);
            this.histo = xr.getInt("type2D", this.histo);
            this.panelSize = xr.getDimension("panel-size", this.panelSize);
            this.graphBgColor = xr.getColor("graph-bgcolor", this.graphBgColor);
            this.backgroundColor = xr.getColor("panel-bgcolor", this.backgroundColor);
            this.boxFillColor = xr.getColor("panel-bgcolor", this.boxFillColor);
            this.useRatio = xr.getBoolean("axes-ratio/fix", this.useRatio);
            this.axesRatio = xr.getDouble("axes-ratio/value", this.axesRatio);
            this.axesColor = xr.getColor("axes-color", this.axesColor);
            this.axesArrow = xr.getInt("axes-arrow/value", this.axesArrow);
            this.axesPenTicWidth = (float)xr.getDouble("axes-penwidth-tic/value", this.axesPenTicWidth);
            for (int i = 0; i < 2; ++i) {
                int axis;
                boolean b = false;
                if (i == 0) {
                    axis = 0;
                    b = xr.open("x1-axis");
                } else {
                    axis = 1;
                    b = xr.open("y1-axis");
                }
                if (!b) continue;
                this.useAxis[axis] = xr.getBoolean("show", this.useAxis[axis]);
                this.mirrorAxis[axis] = xr.getBoolean("mirror", this.mirrorAxis[axis]);
                this.aRange[axis] = xr.getBoolean("range/auto", this.aRange[axis]);
                this.minValue[axis] = xr.getDouble("range/min", this.minValue[axis]);
                this.maxValue[axis] = xr.getDouble("range/max", this.maxValue[axis]);
                this.isLog[axis] = xr.getBoolean("scaling/log", this.isLog[axis]);
                if (xr.open("tics")) {
                    this.useTics[axis] = xr.getBoolean("show", this.useTics[axis]);
                    this.useNumberOfTics[axis] = xr.getBoolean("number/fix", this.useNumberOfTics[axis]);
                    this.numberOfTics[axis] = xr.getInt("number/value", this.numberOfTics[axis]);
                    this.ticLength[axis] = xr.getDouble("length/value", this.ticLength[axis]);
                    this.labelColor[axis] = xr.getColor("color", this.labelColor[axis]);
                    if (xr.open("tic-labels")) {
                        this.useTicLabels[axis] = xr.getBoolean("show", this.useTicLabels[axis]);
                        this.ticFont[axis] = xr.getFont("font", this.ticFont[axis]);
                        xr.close();
                    }
                    xr.close();
                }
                xr.close();
            }
            if (xr.open("grid")) {
                this.useGrid[0] = xr.getBoolean("v-show", this.useGrid[0]);
                this.useGrid[1] = xr.getBoolean("h-show", this.useGrid[1]);
                this.gridColor = xr.getColor("color", this.gridColor);
                this.toFront = xr.getBoolean("to-front", this.toFront);
                xr.close();
            }
            if (xr.open("legend")) {
                this.useLegend = xr.getBoolean("show", this.useLegend);
                this.useLegendPos = xr.getBoolean("position/fix", this.useLegendPos);
                this.legendPos[0] = xr.getDouble("position/x", this.legendPos[0]);
                this.legendPos[1] = xr.getDouble("position/y", this.legendPos[1]);
                this.legendSpacing = xr.getDouble("spacing/value", this.legendSpacing);
                this.legendFont = xr.getFont("font", this.legendFont);
                xr.close();
            }
            if (xr.open("boundingbox")) {
                this.useBox = xr.getBoolean("show", this.useBox);
                this.boxOffset = xr.getFloat("offset/value", this.boxOffset);
                this.boxColor = xr.getColor("box-color", this.boxColor);
                this.boxFillColor = xr.getColor("fill-color", this.boxFillColor);
                xr.close();
            }
            if (xr.open("labels")) {
                while (xr.open("label")) {
                    GraphLabel gl = new GraphLabel();
                    gl.updateSettings(xr);
                    this.labels.add(gl);
                    xr.close();
                    xr.hide("label");
                }
                xr.unHide();
                xr.close();
            }
            if (xr.open("primitives")) {
                this.toFrontPrimitives = xr.getBoolean("to-front-primitives", this.toFrontPrimitives);
                while (xr.open("primitive")) {
                    HShape hs = new HShape();
                    hs.updateSettings(xr);
                    this.primitives.add(hs);
                    xr.close();
                    xr.hide("primitive");
                }
                xr.unHide();
                xr.close();
            }
            xr.close();
        }
        if (this.graphType == 1 && xr.open("piper")) {
            this.useTds = xr.getBoolean("tds/show", this.useTds);
            this.tdsFac = xr.getFloat("tds/scaling", this.tdsFac);
            this.useInner = xr.getBoolean("triangles/show", this.useInner);
            this.triangleFillColor = xr.getColor("triangles/triangleFillColor", this.triangleFillColor);
            xr.close();
        }
    }

    public Dimension getPanelSize() {
        return this.panelSize;
    }

    public void setPanelSize(Dimension d) {
        this.panelSize = d;
    }

    public double getLeftMargin() {
        return this.leftMargin;
    }

    public void setRightMargin(double rm) {
        this.rightMargin = rm;
    }

    public float getPenWidthAxis() {
        return this.penWidthForAxis;
    }

    public void setPenWidthAxis(float width) {
        this.penWidthForAxis = width;
    }

    public void setLeftMargin(double lm) {
        this.leftMargin = lm;
    }

    public double getRightMargin() {
        return this.rightMargin;
    }

    public static Color[] getColors() {
        return color;
    }

    public double getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(double bm) {
        this.bottomMargin = bm;
    }

    public double getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(double tm) {
        this.topMargin = tm;
    }

    public double getTicLength(int axis) {
        return this.ticLength[axis];
    }

    public double getSubTicLength(int axis) {
        return this.subticLength[axis];
    }

    public int getSubTicNumber(int axis) {
        return this.subticNumber[axis];
    }

    public void setTicLength(int axis, double length) {
        this.ticLength[axis] = length;
    }

    public void setSubTicLength(int axis, double length) {
        this.subticLength[axis] = length;
    }

    public void setSubTicNumber(int axis, int number) {
        this.subticNumber[axis] = number;
    }

    public boolean useAxesRatio() {
        return this.useRatio;
    }

    public void setUseAxesRatio(boolean b) {
        this.useRatio = b;
    }

    public double getAxesRatio() {
        return this.axesRatio;
    }

    public void setAxesRatio(double r) {
        if (r > 0.0) {
            this.axesRatio = r;
        } else {
            this.axesRatio = 0.0;
            this.useRatio = false;
        }
    }

    public void setUseNumberOfTics(int axis, boolean b) {
        this.useNumberOfTics[axis] = b;
    }

    public boolean useNumberOfTics(int axis) {
        return this.useNumberOfTics[axis];
    }

    public int getNumberOfTics(int axis) {
        return this.numberOfTics[axis];
    }

    public void setNumberOfTics(int axis, int n) {
        this.numberOfTics[axis] = n > 0 ? n : 0;
    }

    public int getMaxNumberOfTics() {
        return this.maxNumberOfTics;
    }

    public void setMaxNumberOfTics(int n) {
        this.maxNumberOfTics = n;
    }

    public double getMinValue(int axis) {
        return this.minValue[axis];
    }

    public void setMinValue(int axis, double min) {
        this.minValue[axis] = min;
    }

    public double getMaxValue(int axis) {
        return this.maxValue[axis];
    }

    public void setMaxValue(int axis, double max) {
        this.maxValue[axis] = max;
    }

    public void setRange(int axis, double min, double max) {
        this.minValue[axis] = min;
        this.maxValue[axis] = max;
    }

    public boolean drawAxis(int axis) {
        return this.useAxis[axis];
    }

    public void setDrawAxis(int axis, boolean b) {
        this.useAxis[axis] = b;
    }

    public boolean drawMirrorAxis(int axis) {
        return this.mirrorAxis[axis];
    }

    public void setDrawMirrorAxis(int axis, boolean b) {
        this.mirrorAxis[axis] = b;
    }

    public boolean drawTicLabels(int axis) {
        return this.useTicLabels[axis];
    }

    public void setDrawTicLabels(boolean b) {
        this.useTicLabels[0] = this.useTicLabels[1] = b;
    }

    public void setDrawTicLabels(int axis, boolean b) {
        this.useTicLabels[axis] = b;
    }

    public boolean drawTics(int axis) {
        return this.useTics[axis];
    }

    public void setDrawTics(int axis, boolean b) {
        this.useTics[axis] = b;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getAxesColor() {
        return this.axesColor;
    }

    public int getAxesArrow() {
        return this.axesArrow;
    }

    public float getAxesPenTicWidth() {
        return this.axesPenTicWidth;
    }

    public void setAxesColor(Color color) {
        this.axesColor = color;
    }

    public void setAxesArrow(int type) {
        this.axesArrow = type;
    }

    public void setAxesPenTicWidth(float pen) {
        this.axesPenTicWidth = pen;
    }

    public Font getTicFont(int axis) {
        return this.ticFont[axis];
    }

    public void setTicFont(int axis, Font font) {
        this.ticFont[axis] = font;
        this.fntChanged = true;
    }

    public Color getTicColor(int axis) {
        return this.ticColor[axis];
    }

    public void setTicColor(int axis, Color color) {
        this.ticColor[axis] = color;
    }

    public Font getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(Font font) {
        this.legendFont = font;
        this.fntChanged = true;
    }

    public boolean drawLegend() {
        return this.useLegend;
    }

    public void setDrawLegend(boolean b) {
        this.useLegend = b;
    }

    public double getLegendPosition(int axis) {
        return this.legendPos[axis];
    }

    public void setLegendPosition(int axis, double coordinate) {
        this.legendPos[axis] = coordinate;
    }

    public void setLegendPosition(double x, double y) {
        this.legendPos[0] = x;
        this.legendPos[1] = y;
    }

    public boolean useLegendPosition() {
        return this.useLegendPos;
    }

    public void setUseLegendPosition(boolean b) {
        this.useLegendPos = b;
    }

    public double getLegendSpacing() {
        return this.legendSpacing;
    }

    public void setLegendSpacing(double dy) {
        this.legendSpacing = dy;
    }

    public boolean useLogScale(int axis) {
        return this.isLog[axis];
    }

    public void setUseLogScale(int axis, boolean b) {
        this.isLog[axis] = b;
    }

    public boolean autoRange(int axis) {
        return this.aRange[axis];
    }

    public void setAutoRange(int axis, boolean b) {
        this.aRange[axis] = b;
    }

    public boolean drawMirrorTics(int axis) {
        return this.mirrorTics[axis];
    }

    public void setDrawMirrorTics(int axis, boolean b) {
        this.mirrorTics[axis] = b;
    }

    public void setRotateTics(int axis, boolean b) {
        this.rotTics[axis] = b;
    }

    public boolean rotateTics(int axis) {
        return this.rotTics[axis];
    }

    public boolean drawShadow() {
        return this.shadow;
    }

    public void setShadow(boolean b) {
        this.shadow = b;
    }

    public void setDrawGrid(int axis, boolean b) {
        this.useGrid[axis] = b;
    }

    public boolean drawGrid(int axis) {
        return this.useGrid[axis];
    }

    public void setGridColor(Color c) {
        this.gridColor = c;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public boolean gridToFront() {
        return this.toFront;
    }

    public boolean primitivesToFront() {
        return this.toFrontPrimitives;
    }

    public void setGridToFront(boolean b) {
        this.toFront = b;
    }

    public void setPrimitivesToFront(boolean b) {
        this.toFrontPrimitives = b;
    }

    public Color getInnerColor() {
        return this.triangleFillColor;
    }

    public void setInnerColor(Color c) {
        this.triangleFillColor = c;
    }

    public void setDrawInner(boolean b) {
        this.useInner = b;
    }

    public boolean drawInner() {
        return this.useInner;
    }

    public void setDrawBox(boolean b) {
        this.useBox = b;
    }

    public void setNoData(boolean b) {
        this.NoData = b;
    }

    public boolean getNoData() {
        return this.NoData;
    }

    public int getContour_binsX() {
        return this.contour_binsX;
    }

    public int getContour_binsY() {
        return this.contour_binsY;
    }

    public void setContour_binsX(int contour_bins) {
        this.contour_binsX = contour_bins;
    }

    public void setContour_binsY(int contour_bins) {
        this.contour_binsY = contour_bins;
    }

    public boolean getContour_gray() {
        return this.contour_gray;
    }

    public void setContour_gray(boolean gray) {
        this.contour_gray = gray;
    }

    public int getContour_levels() {
        return this.contour_levels;
    }

    public void setContour_levels(int contour_levels) {
        this.contour_levels = contour_levels;
    }

    public boolean getContour_bar() {
        return this.contour_bar;
    }

    public void setContour_bar(boolean contour_bar) {
        this.contour_bar = contour_bar;
    }

    public boolean drawBox() {
        return this.useBox;
    }

    public void setBoxOffset(float f) {
        this.boxOffset = f;
    }

    public float getBoxOffset() {
        return this.boxOffset;
    }

    public void setBoxFillColor(Color c) {
        this.boxFillColor = c;
    }

    public Color getBoxFillColor() {
        return this.boxFillColor;
    }

    public void setBoxColor(Color c) {
        this.boxColor = c;
    }

    public Color getBoxColor() {
        return this.boxColor;
    }

    public void setGraphBackgroundColor(Color c) {
        this.graphBgColor = c;
    }

    public Color getGraphBackgroundColor() {
        return this.graphBgColor;
    }

    public void setTdsFactor(float f) {
        this.tdsFac = f;
    }

    public float getTdsFactor() {
        return this.tdsFac;
    }

    public void setDrawTds(boolean b) {
        this.useTds = b;
    }

    public boolean drawTds() {
        return this.useTds;
    }

    public int getColorIndex() {
        if (this.colorIndex == color.length) {
            this.colorIndex = 0;
        }
        return this.colorIndex++;
    }

    public int getPointIndex() {
        if (this.pointIndex == 12) {
            this.pointIndex = 0;
        }
        return this.pointIndex++;
    }

    public void resetColorIndex() {
        this.colorIndex = 0;
    }

    public void resetPointIndex() {
        this.pointIndex = 0;
    }

    public void setAntiAlias(boolean setit) {
        this.antiAlias = setit;
    }

    public void setAttResizable(boolean setit) {
        this.isAttResizable = setit;
    }

    public boolean getAntiAlias() {
        return this.antiAlias;
    }

    public boolean getAttResizable() {
        return this.isAttResizable;
    }

    public boolean fontChanged() {
        return this.fntChanged;
    }

    public void setFontChanged(boolean b) {
        this.fntChanged = b;
    }
}

