/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io.images;

import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import jhplot.gui.CommonGUI;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.fop.render.ps.EPSTranscoder;
import org.apache.fop.render.ps.PSTranscoder;
import org.apache.fop.svg.PDFTranscoder;
import org.freehep.graphicsbase.util.export.ExportFileType;

public class ExportVGraphics {
    public static void export(Component CanvasPanel, String rootKey, String file) {
        ByteArrayOutputStream bytes2;
        String[] ext;
        String SAVE_AS_TYPE = rootKey + ".SaveAsType";
        String SAVE_AS_FILE = rootKey + ".SaveAsFile";
        File f = new File(file);
        ExportFileType t2 = null;
        int dot = file.lastIndexOf(46);
        String base = dot == -1 ? file : file.substring(0, dot);
        String fext = dot == -1 ? "" : file.substring(dot + 1);
        fext = fext.trim();
        boolean isSVGZ = false;
        if (fext.equalsIgnoreCase("svgz")) {
            isSVGZ = true;
        }
        boolean isEPS = false;
        if (fext.equalsIgnoreCase("eps")) {
            isEPS = true;
        }
        boolean isPS = false;
        if (fext.equalsIgnoreCase("ps")) {
            isPS = true;
        }
        boolean isPDF = false;
        if (fext.equalsIgnoreCase("pdf")) {
            isPDF = true;
        }
        boolean isJPG = false;
        if (fext.equalsIgnoreCase("jpg") || fext.equalsIgnoreCase("jpeg")) {
            isJPG = true;
        }
        List list = ExportFileType.getExportFileTypes();
        Iterator iterator = list.iterator();
        while (!(!iterator.hasNext() || fext.equalsIgnoreCase((ext = (t2 = (ExportFileType)iterator.next()).getExtensions())[0]) || isSVGZ && ext[0].equalsIgnoreCase("svg") || isEPS && ext[0].equalsIgnoreCase("svg") || isPDF && ext[0].equalsIgnoreCase("svg") || isPS && ext[0].equalsIgnoreCase("svg") || isJPG && ext[0].equalsIgnoreCase("svg") || !isSVGZ && !isEPS && !isPDF && !isPS && !isJPG && fext.equalsIgnoreCase(ext[0]))) {
            t2 = null;
        }
        if (t2 == null) {
            String tmp = "svgz; ";
            for (ExportFileType t2 : list) {
                String[] ext2 = t2.getExtensions();
                tmp = tmp + ext2[0] + "; ";
            }
            System.err.println("File format is not supported!\nTry: " + tmp);
            return;
        }
        Properties props = new Properties();
        String a = t2.getDescription();
        props.put(SAVE_AS_FILE, file);
        props.put(SAVE_AS_TYPE, a);
        String metadata = "(C) DataMelt (https://datamelt.org/). S.Chekanov";
        if (isSVGZ) {
            try {
                FileOutputStream fos = new FileOutputStream(file);
                GZIPOutputStream gzos = new GZIPOutputStream(fos);
                t2.exportToFile((OutputStream)gzos, CanvasPanel, CanvasPanel, props, "(C) DataMelt (https://datamelt.org/). S.Chekanov");
                gzos.close();
                fos.flush();
                fos.close();
                return;
            }
            catch (IOException e) {
                System.err.println(e.toString());
            }
        }
        if (isJPG) {
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                t2.exportToFile((OutputStream)bytes, CanvasPanel, CanvasPanel, props, "(C) DataMelt (https://datamelt.org/). S.Chekanov");
                bytes.close();
                TranscoderInput input = new TranscoderInput((InputStream)new ByteArrayInputStream(bytes.toByteArray()));
                FileOutputStream os = new FileOutputStream(file);
                JPEGTranscoder trans = new JPEGTranscoder();
                trans.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(1.0f));
                trans.addTranscodingHint(JPEGTranscoder.KEY_WIDTH, (Object)new Float(1000.0f));
                trans.addTranscodingHint(JPEGTranscoder.KEY_ALLOWED_SCRIPT_TYPES, (Object)"*");
                trans.addTranscodingHint(JPEGTranscoder.KEY_CONSTRAIN_SCRIPT_ORIGIN, (Object)new Boolean(true));
                trans.addTranscodingHint(JPEGTranscoder.KEY_EXECUTE_ONLOAD, (Object)new Boolean(true));
                TranscoderOutput output = new TranscoderOutput((OutputStream)os);
                trans.transcode(input, output);
                os.flush();
                os.close();
                return;
            }
            catch (IOException | TranscoderException e) {
                System.err.println("Error while converting  " + e.getLocalizedMessage());
            }
        }
        if (isEPS) {
            try {
                bytes2 = new ByteArrayOutputStream();
                t2.exportToFile((OutputStream)bytes2, CanvasPanel, CanvasPanel, props, "(C) DataMelt (https://datamelt.org/). S.Chekanov");
                bytes2.flush();
                byte[] bb = bytes2.toByteArray();
                bytes2.close();
                if (bb == null) {
                    return;
                }
                if (bb.length < 1) {
                    return;
                }
                TranscoderInput input = new TranscoderInput((InputStream)new ByteArrayInputStream(bb));
                FileOutputStream os = new FileOutputStream(file);
                EPSTranscoder trans = new EPSTranscoder();
                TranscoderOutput output = new TranscoderOutput((OutputStream)os);
                trans.transcode(input, output);
                os.flush();
                os.close();
                return;
            }
            catch (IOException e) {
                System.err.println("DataMelt ExportVGraphics: IOException: Error while converting  " + e.getLocalizedMessage());
            }
            catch (TranscoderException e) {
                // empty catch block
            }
        }
        if (isPS) {
            try {
                bytes2 = new ByteArrayOutputStream();
                t2.exportToFile((OutputStream)bytes2, CanvasPanel, CanvasPanel, props, "(C) DataMelt (https://datamelt.org/). S.Chekanov");
                bytes2.flush();
                byte[] bb = bytes2.toByteArray();
                bytes2.close();
                if (bb == null) {
                    return;
                }
                if (bb.length < 1) {
                    return;
                }
                FileOutputStream os = new FileOutputStream(file);
                TranscoderInput input = new TranscoderInput((InputStream)new ByteArrayInputStream(bb));
                PSTranscoder trans = new PSTranscoder();
                TranscoderOutput output = new TranscoderOutput((OutputStream)os);
                trans.transcode(input, output);
                os.flush();
                os.close();
                return;
            }
            catch (IOException e) {
                System.err.println("DataMelt ExportVGraphics: IOException: Error while converting  " + e.getLocalizedMessage());
            }
            catch (TranscoderException e) {
                // empty catch block
            }
        }
        if (isPDF) {
            try {
                bytes2 = new ByteArrayOutputStream();
                t2.exportToFile((OutputStream)bytes2, CanvasPanel, CanvasPanel, props, "(C) DataMelt (https://datamelt.org/). S.Chekanov");
                bytes2.flush();
                byte[] bb = bytes2.toByteArray();
                bytes2.close();
                if (bb == null) {
                    return;
                }
                if (bb.length < 1) {
                    return;
                }
                PDFTranscoder trans = new PDFTranscoder();
                TranscoderInput input = new TranscoderInput((InputStream)new ByteArrayInputStream(bb));
                FileOutputStream os = new FileOutputStream(file);
                TranscoderOutput output = new TranscoderOutput((OutputStream)os);
                trans.transcode(input, output);
                os.flush();
                os.close();
                return;
            }
            catch (IOException e) {
                System.err.println("DataMelt ExportVGraphics: IOException: Error while converting  " + e.getLocalizedMessage());
            }
            catch (TranscoderException e) {
                // empty catch block
            }
        }
        try {
            t2.exportToFile(f, CanvasPanel, CanvasPanel, props, "(C) DataMelt (https://datamelt.org/). S.Chekanov");
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
    }

    public static void exportDialog(final Component component, final String rootKey, JFrame frame) {
        JFileChooser fileChooser = CommonGUI.openImageFileChooser(frame);
        if (fileChooser.showDialog(frame, "Export to ") == 0) {
            int res;
            final File scriptFile = ExportVGraphics.getSelectedFileWithExtension(fileChooser);
            if (scriptFile == null) {
                return;
            }
            if (scriptFile.exists() && (res = JOptionPane.showConfirmDialog(frame, "The file exists. Do you want to overwrite the file?", "", 0)) == 1) {
                return;
            }
            String mess = "write image  file ..";
            Thread t = new Thread(mess){

                @Override
                public void run() {
                    ExportVGraphics.export(component, rootKey, scriptFile.getAbsolutePath());
                }
            };
            t.start();
        }
    }

    public static File getSelectedFileWithExtension(JFileChooser c) {
        File file = c.getSelectedFile();
        if (c.getFileFilter() instanceof FileNameExtensionFilter) {
            String[] exts = ((FileNameExtensionFilter)c.getFileFilter()).getExtensions();
            String nameLower = file.getName().toLowerCase();
            for (String ext : exts) {
                if (!nameLower.endsWith('.' + ext.toLowerCase())) continue;
                return file;
            }
            file = new File(file.toString() + '.' + exts[0]);
        }
        return file;
    }
}

