/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io;

import hep.aida.IAxis;
import hep.aida.ref.histogram.Histogram1D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import jhplot.H1D;
import jhplot.P0D;
import jhplot.P0I;
import jhplot.P1D;
import jhplot.PND;
import jhplot.PNI;
import jhplot.gui.HelpBrowser;
import jhplot.io.csv.CSVReader;
import jhplot.io.csv.CSVWriter;
import jhplot.utils.Util;

public class HFileCSV {
    private FileWriter outStream;
    private BufferedReader inStream;
    private final int version = 1;
    private int nev = 0;
    private String file;
    private char delim = (char)44;
    private char quotechar = '\u0000';

    public HFileCSV(String file, String option, char delim) {
        this.file = file.trim();
        this.nev = 0;
        this.delim = delim;
        if (option.equalsIgnoreCase("w")) {
            try {
                new File(file).delete();
                this.outStream = new FileWriter(file);
            }
            catch (IOException e) {
                System.err.println(e.toString());
            }
        } else if (option.equalsIgnoreCase("r")) {
            if (file.startsWith("http") || file.startsWith("ftp")) {
                URL url = null;
                try {
                    url = new URL(this.file);
                }
                catch (MalformedURLException e) {
                    System.err.println(e.toString());
                }
                try {
                    URLConnection urlConn = url.openConnection();
                    urlConn.setDoInput(true);
                    urlConn.setUseCaches(false);
                    this.inStream = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
                }
                catch (MalformedURLException e) {
                    System.err.println(e.toString());
                }
                catch (IOException e) {
                    System.err.println(e.toString());
                }
            } else {
                try {
                    this.inStream = new BufferedReader(new FileReader(this.file));
                }
                catch (IOException e) {
                    System.err.println(e.toString());
                }
            }
        } else {
            Util.ErrorMessage((String)"Wrong option!. Only \"r\" or \"w\"  is allowed");
        }
    }

    public HFileCSV(String file) {
        this(file, "r", ',');
    }

    public HFileCSV(String file, String option) {
        this(file, option, ',');
    }

    public void setQuotechar(char c) {
        this.quotechar = c;
    }

    public char getQuotechar() {
        return this.quotechar;
    }

    public boolean write(double[] p) {
        ++this.nev;
        boolean tmp = true;
        try {
            CSVWriter writer = new CSVWriter(new FileWriter(this.file), this.delim, this.quotechar);
            String[] nextLine = new String[p.length];
            for (int j = 0; j < p.length; ++j) {
                nextLine[j] = Double.toString(p[j]);
            }
            writer.writeNext(nextLine);
            writer.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            tmp = false;
        }
        return tmp;
    }

    public boolean write(int[] p) {
        ++this.nev;
        boolean tmp = true;
        try {
            CSVWriter writer = new CSVWriter(new FileWriter(this.file), this.delim, this.quotechar);
            String[] nextLine = new String[p.length];
            for (int j = 0; j < p.length; ++j) {
                nextLine[j] = Integer.toString(p[j]);
            }
            writer.writeNext(nextLine);
            writer.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            tmp = false;
        }
        return tmp;
    }

    public boolean write(String[] p) {
        ++this.nev;
        boolean tmp = true;
        try {
            CSVWriter writer = new CSVWriter(new FileWriter(this.file), this.quotechar);
            writer.writeNext(p);
            writer.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            tmp = false;
        }
        return tmp;
    }

    public boolean write(P0I p) {
        ++this.nev;
        boolean tmp = true;
        try {
            CSVWriter writer = new CSVWriter(new FileWriter(this.file), this.delim, this.quotechar);
            String[] nextLine = new String[p.size()];
            for (int j = 0; j < p.size(); ++j) {
                nextLine[j] = Integer.toString(p.get(j));
            }
            writer.writeNext(nextLine);
            writer.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            tmp = false;
        }
        return tmp;
    }

    public boolean write(P0D p) {
        ++this.nev;
        boolean tmp = true;
        try {
            CSVWriter writer = new CSVWriter(new FileWriter(this.file), this.delim, this.quotechar);
            String[] nextLine = new String[p.size()];
            for (int j = 0; j < p.size(); ++j) {
                nextLine[j] = Double.toString(p.get(j));
            }
            writer.writeNext(nextLine);
            writer.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            tmp = false;
        }
        return tmp;
    }

    public boolean write(PND p) {
        ++this.nev;
        boolean tmp = true;
        CSVWriter writer = new CSVWriter(this.outStream, this.delim, this.quotechar);
        try {
            for (int j = 0; j < p.size(); ++j) {
                double[] tt = p.get(j);
                int dimension = tt.length;
                String[] nextLine = new String[dimension];
                for (int i = 0; i < dimension; ++i) {
                    nextLine[j] = Double.toString(tt[i]);
                }
                writer.writeNext(nextLine);
            }
            writer.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            tmp = false;
        }
        return tmp;
    }

    public boolean write(PNI p) {
        ++this.nev;
        boolean tmp = true;
        CSVWriter writer = new CSVWriter(this.outStream, this.delim, this.quotechar);
        try {
            for (int j = 0; j < p.size(); ++j) {
                int[] tt = p.get(j);
                int dimension = tt.length;
                String[] nextLine = new String[dimension];
                for (int i = 0; i < dimension; ++i) {
                    nextLine[j] = Double.toString(tt[i]);
                }
                writer.writeNext(nextLine);
            }
            writer.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            tmp = false;
        }
        return tmp;
    }

    public boolean write(H1D p) {
        ++this.nev;
        boolean tmp = true;
        CSVWriter writer = new CSVWriter(this.outStream, this.delim, this.quotechar);
        Histogram1D h1 = p.get();
        IAxis axis = h1.axis();
        int bins = axis.bins();
        try {
            for (int j = 0; j < bins; ++j) {
                String[] nextLine = new String[]{Double.toString(axis.binLowerEdge(j)), Double.toString(axis.binUpperEdge(j)), Double.toString(h1.binHeight(j)), Double.toString(h1.binError(j))};
                writer.writeNext(nextLine);
            }
            writer.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            tmp = false;
        }
        return tmp;
    }

    public boolean write(P1D p) {
        ++this.nev;
        boolean tmp = true;
        int dimen = p.getDimension();
        CSVWriter writer = new CSVWriter(this.outStream, this.delim, this.quotechar);
        try {
            for (int i = 0; i < p.size(); ++i) {
                String[] nextLine;
                if (dimen == 2) {
                    nextLine = new String[]{Double.toString(p.getX(i)), Double.toString(p.getY(i))};
                    writer.writeNext(nextLine);
                    continue;
                }
                if (dimen == 3) {
                    nextLine = new String[]{Double.toString(p.getX(i)), Double.toString(p.getY(i)), Double.toString(p.getYupper(i))};
                    writer.writeNext(nextLine);
                    continue;
                }
                if (dimen == 4) {
                    nextLine = new String[]{Double.toString(p.getX(i)), Double.toString(p.getY(i)), Double.toString(p.getYupper(i)), Double.toString(p.getYlower(i))};
                    writer.writeNext(nextLine);
                    continue;
                }
                if (dimen == 6) {
                    nextLine = new String[]{Double.toString(p.getX(i)), Double.toString(p.getY(i)), Double.toString(p.getYupper(i)), Double.toString(p.getYlower(i)), Double.toString(p.getXleft(i)), Double.toString(p.getXright(i))};
                    writer.writeNext(nextLine);
                    continue;
                }
                if (dimen != 10) continue;
                nextLine = new String[]{Double.toString(p.getX(i)), Double.toString(p.getY(i)), Double.toString(p.getYupper(i)), Double.toString(p.getYlower(i)), Double.toString(p.getXleft(i)), Double.toString(p.getXright(i)), Double.toString(p.getYupperSys(i)), Double.toString(p.getYlowerSys(i)), Double.toString(p.getXleftSys(i)), Double.toString(p.getXrightSys(i))};
                writer.writeNext(nextLine);
            }
            writer.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            tmp = false;
        }
        return tmp;
    }

    public CSVReader read() {
        CSVReader reader = null;
        reader = new CSVReader(this.inStream, this.delim, this.quotechar);
        return reader;
    }

    public boolean close() {
        boolean success = true;
        try {
            if (this.inStream != null) {
                this.inStream.close();
                this.inStream = null;
            }
            if (this.outStream != null) {
                this.outStream.close();
                this.outStream = null;
            }
        }
        catch (IOException e) {
            success = false;
            System.err.println(e.toString());
        }
        System.gc();
        return success;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

