/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import com.mxgraph.layout.mxCircleLayout;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jhplot.gui.GHFrame;
import jhplot.gui.HelpBrowser;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgrapht.Graph;
import org.jgrapht.ListenableGraph;
import org.jgrapht.ext.JGraphModelAdapter;
import org.jgrapht.ext.JGraphXAdapter;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.graph.DirectedPseudograph;
import org.jgrapht.graph.DirectedWeightedMultigraph;
import org.jgrapht.graph.ListenableDirectedGraph;
import org.jgrapht.graph.Multigraph;
import org.jgrapht.graph.Pseudograph;
import org.jgrapht.graph.SimpleGraph;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.jgrapht.graph.WeightedPseudograph;

public class HGraph
extends GHFrame {
    private static final long serialVersionUID = 1L;
    private JGraphModelAdapter[][] sc;
    private JGraph[][] jp;
    private ListenableGraph[][] ls;
    public boolean set;
    private static final Color DEFAULT_BG_COLOR = Color.white;
    private static final Dimension DEFAULT_SIZE = new Dimension(530, 320);
    private Thread1 m_Close;

    public HGraph(String title, int xsize, int ysize, int n1, int n2, boolean set) {
        super(title, xsize, ysize, n1, n2, set, 1);
        if (set) {
            this.setGraph();
        }
    }

    @Override
    protected void clearFrame() {
    }

    public Pseudograph<Object, DefaultEdge> buildPseudograph() {
        return new Pseudograph(DefaultEdge.class);
    }

    public Pseudograph<Object, DefaultWeightedEdge> buildWeightedPseudograph() {
        return new WeightedPseudograph(DefaultWeightedEdge.class);
    }

    public DirectedPseudograph<Object, DefaultEdge> buildDirectedPseudograph() {
        return new DirectedPseudograph(DefaultEdge.class);
    }

    public SimpleGraph<Object, DefaultEdge> buildSimpleGraph() {
        return new SimpleGraph(DefaultEdge.class);
    }

    public SimpleWeightedGraph<Object, DefaultWeightedEdge> buildSimpleWeightedGraph() {
        return new SimpleWeightedGraph(DefaultWeightedEdge.class);
    }

    public DefaultDirectedGraph<Object, DefaultEdge> buildDirectedGraph() {
        return new DefaultDirectedGraph(DefaultEdge.class);
    }

    public Multigraph<Object, DefaultEdge> buildMultigraph() {
        return new Multigraph(DefaultEdge.class);
    }

    public DirectedMultigraph<Object, DefaultEdge> buildDirectedMultigraph() {
        return new DirectedMultigraph(DefaultEdge.class);
    }

    public DirectedWeightedMultigraph<Object, DefaultWeightedEdge> buildDirectedWeightedMultigraph() {
        return new DirectedWeightedMultigraph(DefaultWeightedEdge.class);
    }

    public mxGraphComponent showGraph(Graph g) {
        JGraphXAdapter jgxAdapter = new JGraphXAdapter(g);
        mxCircleLayout layout = new mxCircleLayout((mxGraph)jgxAdapter);
        layout.execute(jgxAdapter.getDefaultParent());
        JFrame frame = new JFrame();
        mxGraphComponent mgraph = new mxGraphComponent((mxGraph)jgxAdapter);
        mgraph.setAntiAlias(true);
        mgraph.setAutoExtend(true);
        mgraph.setAutoScroll(true);
        mgraph.setCenterPage(true);
        mgraph.setPageScale(2.0);
        mgraph.setDragEnabled(true);
        mgraph.setEventsEnabled(true);
        mgraph.setExportEnabled(true);
        mgraph.setSwimlaneSelectionEnabled(false);
        mgraph.setInvokesStopCellEditing(false);
        frame.getContentPane().add((Component)mgraph);
        frame.setTitle("HGraph");
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
        return mgraph;
    }

    @Override
    protected void refreshFrame() {
    }

    @Override
    protected void openWriteDialog() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for HGraph");
    }

    @Override
    protected void openReadDialog() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for HGraph");
    }

    public void visible(boolean vs) {
        this.mainFrame.setVisible(vs);
    }

    public void update() {
        this.mainFrame.validate();
        this.mainFrame.repaint();
    }

    public void visible() {
        this.mainFrame.setVisible(true);
    }

    public void destroy() {
        this.mainFrame.setVisible(false);
        this.close();
    }

    private void setGraph() {
        this.sc = new JGraphModelAdapter[this.N1final][this.N2final];
        this.jp = new JGraph[this.N1final][this.N2final];
        this.ls = new ListenableGraph[this.N1final][this.N2final];
        for (int i2 = 0; i2 < this.N2final; ++i2) {
            for (int i1 = 0; i1 < this.N1final; ++i1) {
                this.ls[i1][i2] = new ListenableDirectedGraph(DefaultEdge.class);
                this.sc[i1][i2] = new JGraphModelAdapter((Graph)this.ls[i1][i2]);
                this.jp[i1][i2] = new JGraph((GraphModel)this.sc[i1][i2]);
                this.adjustDisplaySettings(this.jp[i1][i2]);
                this.mainPanel.add((Component)this.jp[i1][i2]);
            }
        }
    }

    private void positionVertexAt(Object vertex, int x, int y) {
        DefaultGraphCell cell = this.sc[N1][N2].getVertexCell(vertex);
        AttributeMap attr = cell.getAttributes();
        Rectangle2D bounds = GraphConstants.getBounds((Map)attr);
        Rectangle2D.Double newBounds = new Rectangle2D.Double(x, y, bounds.getWidth(), bounds.getHeight());
        GraphConstants.setBounds((Map)attr, (Rectangle2D)newBounds);
        AttributeMap cellAttr = new AttributeMap();
        cellAttr.put((Object)cell, (Object)attr);
        this.sc[N1][N2].edit((Map)cellAttr, null, null, null);
    }

    public void setPos(String vertex, int n1, int n2) {
        this.positionVertexAt(vertex, n1, n2);
    }

    public HGraph(String title, int xs, int ys) {
        this(title, xs, ys, 1, 1, true);
    }

    public HGraph(String title, int xs, int ys, boolean set) {
        this(title, xs, ys, 1, 1, set);
    }

    public HGraph(String title, int xs, int ys, int n1, int n2) {
        this(title, xs, ys, n1, n2, true);
    }

    public HGraph(String title) {
        this(title, 600, 400, 1, 1, true);
    }

    public HGraph() {
    }

    public void clear() {
        this.clear(N1, N2);
    }

    public void clear(int i1, int i2) {
        this.setGTitle("");
        System.gc();
    }

    public void clearAll() {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.clear(i1, i2);
            }
        }
        System.gc();
    }

    private void adjustDisplaySettings(JGraph jg) {
        jg.setPreferredSize(DEFAULT_SIZE);
        Color c = DEFAULT_BG_COLOR;
        jg.setBackground(c);
    }

    public void close() {
        this.mainFrame.setVisible(false);
        this.m_Close = new Thread1("Closing softly");
        if (!this.m_Close.Alive()) {
            this.m_Close.Start();
        }
    }

    public void addVertex(String vertex) {
        this.ls[N1][N2].addVertex((Object)vertex);
    }

    public void addEdge(String vertex1, String vertex2) {
        this.ls[N1][N2].addEdge((Object)vertex1, (Object)vertex2);
    }

    public JGraph getGraph() {
        return this.jp[N1][N2];
    }

    public ListenableGraph getListenableGraph() {
        return this.ls[N1][N2];
    }

    public void quit() {
        this.doNotShowFrame();
        this.clearAll();
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.ls[i1][i2] = null;
                this.jp[i1][i2] = null;
                this.sc[i1][i2] = null;
            }
        }
        this.ls = null;
        this.jp = null;
        this.sc = null;
        this.removeFrame();
    }

    @Override
    protected void quitFrame() {
        this.close();
    }

    @Override
    protected void openReadDataDialog() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for this canvas");
    }

    @Override
    protected void showHelp() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for HGraph");
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    class Thread1
    implements Runnable {
        private Thread t = null;
        private String mess;

        Thread1(String s1) {
            this.mess = s1;
        }

        public boolean Alive() {
            boolean tt = false;
            if (this.t != null && this.t.isAlive()) {
                tt = true;
            }
            return tt;
        }

        public boolean Joint() {
            boolean tt = false;
            try {
                this.t.join();
                return true;
            }
            catch (InterruptedException interruptedException) {
                return tt;
            }
        }

        public void Start() {
            this.t = new Thread((Runnable)this, this.mess);
            this.t.start();
        }

        public void Stop() {
            this.t = null;
        }

        @Override
        public void run() {
            HGraph.this.quit();
        }
    }
}

