/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import hep.aida.IAnalysisFactory;
import hep.aida.IDataPointSet;
import hep.aida.IDataPointSetFactory;
import hep.aida.IFitData;
import hep.aida.IFitFactory;
import hep.aida.IFitResult;
import hep.aida.IFitter;
import hep.aida.IFunction;
import hep.aida.IFunctionCatalog;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.ITree;
import hep.aida.ref.fitter.Fitter;
import hep.aida.ref.function.AbstractIFunction;
import java.io.Serializable;
import jhplot.H1D;
import jhplot.H2D;
import jhplot.P1D;
import jhplot.PND;
import jhplot.fit.Landau;
import jhplot.fit.Pow;
import jhplot.gui.HelpBrowser;
import jhplot.utils.Util;

public class HFitter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IAnalysisFactory anFactory;
    private ITree tree;
    private IFunctionFactory funcFactory;
    private IFitFactory fitFactory;
    private IDataPointSetFactory dataPointSet;
    private IFitter fitter;
    private IFunctionCatalog funcCatalog;
    private IFitData data;
    private IFunction iFunc = null;
    private IFitResult result;
    private String[] items;
    private String[] engines;
    double rmin = -99.0;
    double rmax = -99.0;
    double[] param;
    private String range = null;
    private String method;

    public HFitter(String method) {
        this.method = method;
        this.anFactory = IAnalysisFactory.create();
        this.tree = this.anFactory.createTreeFactory().create();
        this.dataPointSet = this.anFactory.createDataPointSetFactory(this.tree);
        this.funcFactory = this.anFactory.createFunctionFactory(this.tree);
        this.fitFactory = this.anFactory.createFitFactory();
        this.fitter = this.fitFactory.createFitter(method, "jminuit", "noClone=\"false\"");
        this.fitter = new Fitter(method, "jminuit", "noClone=\"false\"");
        this.funcCatalog = this.funcFactory.catalog();
        this.items = this.fitFactory.availableFitMethods();
        this.engines = this.fitFactory.availableFitEngines();
        this.funcCatalog = this.funcFactory.catalog();
        String s = "pow";
        AbstractIFunction f = new Pow(s);
        this.funcCatalog.add(s, (IFunction)f);
        s = "landau";
        f = new Landau(s);
        this.funcCatalog.add(s, (IFunction)f);
    }

    public String[] getFitMethods() {
        return this.items;
    }

    public String getFitMethod() {
        return this.method;
    }

    public void setFitMethod(String method) {
        this.method = method;
        this.fitter = this.fitFactory.createFitter(method, "jminuit", "noClone=\"false\"");
        this.fitter = new Fitter(method, "jminuit", "noClone=\"false\"");
        this.funcCatalog = this.funcFactory.catalog();
    }

    public void addFunc(String name, IFunction f) {
        this.funcCatalog.add(name, f);
    }

    public String[] getFitEngines() {
        return this.engines;
    }

    public HFitter() {
        this("chi2");
    }

    public void setFunc(IFunction func) {
        this.iFunc = func;
    }

    public String[] getFuncCatalog() {
        return this.funcCatalog.list();
    }

    public void setFunc(String func) {
        this.iFunc = this.funcFactory.createFunctionByName(func, func);
    }

    public double getPar(String name) {
        return this.iFunc.parameter(name);
    }

    public void setPar(String name, double value) {
        this.iFunc.setParameter(name, value);
    }

    public void setParStep(String name, double step) {
        this.fitter.fitParameterSettings(name).setStepSize(step);
    }

    public void setParFixed(String name) {
        this.fitter.fitParameterSettings(name).setFixed(true);
    }

    public void setParFixed(String name, boolean fix) {
        this.fitter.fitParameterSettings(name).setFixed(fix);
    }

    public void setParRange(String name, double min, double max) {
        this.fitter.fitParameterSettings(name).setBounds(min, max);
    }

    public void setParConstraint(String constraint) {
        this.fitter.setConstraint(constraint);
    }

    public IFunction getFunc() {
        return this.iFunc;
    }

    public void setFunc(String name, int dimension, String function, String parameters) {
        this.iFunc = this.funcFactory.createFunctionFromScript(name, dimension, function, parameters, "", "");
    }

    public void fit(H1D h1d) {
        this.doFit(h1d);
    }

    public void fit(P1D p1d) {
        this.doFit(p1d);
    }

    public void fit(PND pnd) {
        this.doFit(pnd);
    }

    public void fit(H2D h2d) {
        this.doFit(h2d);
    }

    public void setRange(double rmin, double rmax) {
        this.rmin = rmin;
        this.rmax = rmax;
    }

    public IFitter getFitter() {
        return this.fitter;
    }

    private void doFit(P1D p1) {
        double min = 0.0;
        double max = 0.0;
        if (p1.getDimension() == 2 && this.method.equals("chi2")) {
            Util.ErrorMessage((String)"The dimension of input data is 2, but you require to use \"chi2\" method. For such containers, you can only use \"leastsquares\" method. For the \"chi2\" method, you should specify errors on Y-values");
        }
        IDataPointSet dps2D = this.dataPointSet.create(p1.getTitle(), p1.getTitle(), 2);
        p1.fillIDataPointSet(dps2D);
        this.data = this.fitFactory.createFitData();
        min = p1.getMin(0);
        max = p1.getMax(0);
        this.data.create1DConnection(dps2D, 0, 1);
        if (this.rmin == this.rmax) {
            this.rmin = min;
            this.rmax = max;
        }
        this.data.range(0).excludeAll();
        this.data.range(0).include(this.rmin, this.rmax);
        this.result = this.fitter.fit(this.data, this.iFunc);
    }

    private void doFit(H1D h1d) {
        this.data = this.fitFactory.createFitData();
        double min = 0.0;
        double max = 0.0;
        min = h1d.getMin();
        max = h1d.getMax();
        this.data.create1DConnection((IHistogram1D)h1d.get());
        if (this.rmin == this.rmax) {
            this.rmin = min;
            this.rmax = max;
        }
        this.data.range(0).excludeAll();
        this.data.range(0).include(this.rmin, this.rmax);
        this.result = this.fitter.fit(this.data, this.iFunc);
    }

    private void doFit(H2D h2d) {
        this.data = this.fitFactory.createFitData();
        double min = 0.0;
        double max = 0.0;
        double minX = h2d.getMinX();
        double maxX = h2d.getMaxX();
        double minY = h2d.getMinY();
        double maxY = h2d.getMaxY();
        this.data.create2DConnection((IHistogram2D)h2d.get());
        this.data.range(0).excludeAll();
        this.data.range(1).excludeAll();
        this.data.range(0).include(minX, maxX);
        this.data.range(1).include(minY, maxY);
        this.result = this.fitter.fit(this.data, this.iFunc);
    }

    private void doFit(PND pnd) {
        this.data = this.fitFactory.createFitData();
        double min = 0.0;
        double max = 0.0;
        int[] tt = new int[pnd.getDimension()];
        for (int m = 0; m < pnd.getDimension() - 1; ++m) {
            tt[m] = m;
        }
        this.data.createConnection(pnd.getIDataPointSet(), tt, pnd.getDimension() - 1);
        this.result = this.fitter.fit(this.data, this.iFunc);
    }

    public IFunction getFittedFunc() {
        return this.result.fittedFunction();
    }

    public IFitResult getResult() {
        return this.result;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

