/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.DataSet;
import graph.TextLine;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class VectorSet
extends DataSet {
    private static final int VECTOR_STRIDE = 4;
    private boolean drawlegend = false;
    public static final int MEAN = 1;
    public static final int MINIMUM = 2;
    public static final int MAXIMUM = 3;
    public double scale = 0.1;
    protected int stride = 4;
    protected int scalingType = 1;
    private double vmean;
    private double vmin;
    private double vmax;

    public VectorSet() throws Exception {
        super(4);
        this.stride = 4;
    }

    public VectorSet(double[] d, int n) throws Exception {
        super(d, n, 4);
        this.stride = 4;
    }

    public VectorSet(double scale) throws Exception {
        super(4);
        this.scale = scale;
    }

    public VectorSet(double[] d, int n, double scale) throws Exception {
        this(d, n);
        this.scale = scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setScalingType(int type) {
        if (type == 1 || type == 3 || type == 2) {
            this.scalingType = type;
        }
    }

    public double getScaleFactor() {
        double f = this.xrange > this.yrange ? this.scale * this.yrange : this.scale * this.xrange;
        if (this.vmean <= 0.0) {
            return 1.0;
        }
        if (this.scalingType == 1) {
            return f / this.vmean;
        }
        if (this.scalingType == 2) {
            return f / this.vmin;
        }
        if (this.scalingType == 3) {
            return f / this.vmax;
        }
        return 1.0;
    }

    public void legend() {
        super.legend(-1, -1, (String)null);
        this.drawlegend = true;
    }

    public void legend(String text) {
        super.legend(-1, -1, text);
        this.drawlegend = true;
    }

    @Override
    public void legend(int x, int y, String text) {
        super.legend(x, y, text);
        this.drawlegend = true;
    }

    @Override
    public void legend(double x, double y, String text) {
        super.legend(x, y, text);
        this.drawlegend = true;
    }

    @Override
    public void draw_data(Graphics g, Rectangle bounds) {
        if (this.xaxis != null) {
            this.xmax = this.xaxis.maximum;
            this.xmin = this.xaxis.minimum;
        }
        if (this.yaxis != null) {
            this.ymax = this.yaxis.maximum;
            this.ymin = this.yaxis.minimum;
        }
        this.xrange = this.xmax - this.xmin;
        this.yrange = this.ymax - this.ymin;
        this.draw_legend(g, bounds);
        if (this.clipping) {
            g.clipRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        Color c = g.getColor();
        if (this.linecolor != null) {
            g.setColor(this.linecolor);
        } else {
            g.setColor(c);
        }
        this.drawVectors(g, bounds);
        g.setColor(c);
    }

    @Override
    protected void draw_legend(Graphics g, Rectangle w) {
        Color c = g.getColor();
        TextLine value = new TextLine();
        if (!this.drawlegend) {
            return;
        }
        double dx = this.xrange * (double)this.legend_length / (double)w.width / this.getScaleFactor();
        value.parseDouble(dx, 3);
        int length = this.legend_length + value.getWidth(g) + value.charWidth(g, ' ');
        if (this.legend_ix == 0 && this.legend_iy == 0) {
            this.legend_ix = (int)((double)w.x + (this.legend_dx - this.xmin) / this.xrange * (double)w.width);
            this.legend_iy = (int)((double)w.y + (1.0 - (this.legend_dy - this.ymin) / this.yrange) * (double)w.height);
        } else if (this.legend_ix == -1 && this.legend_iy == -1) {
            this.legend_ix = w.x + w.width / 2 - length / 2;
            this.legend_iy = w.y - value.getAscent(g) / 2;
        }
        if (this.linecolor != null) {
            g.setColor(this.linecolor);
        }
        g.drawLine(this.legend_ix, this.legend_iy, this.legend_ix + this.legend_length, this.legend_iy);
        int ix = this.legend_ix + (int)(0.25 * (double)this.legend_length + 0.5);
        int iy = this.legend_iy - (int)(0.25 * (double)this.legend_length + 0.5);
        g.drawLine(this.legend_ix, this.legend_iy, ix, iy);
        ix = this.legend_ix + (int)(0.25 * (double)this.legend_length + 0.5);
        iy = this.legend_iy + (int)(0.25 * (double)this.legend_length + 0.5);
        g.drawLine(this.legend_ix, this.legend_iy, ix, iy);
        value.draw(g, this.legend_ix + this.legend_length + value.charWidth(g, ' '), iy, 1);
        g.setColor(c);
        if (this.legend_text != null && !this.legend_text.isNull()) {
            this.legend_text.draw(g, this.legend_ix + length / 2, iy - value.getAscent(g) - this.legend_text.getDescent(g) - this.legend_text.getLeading(g), 0);
        }
    }

    protected void drawVectors(Graphics g, Rectangle w) {
        if (this.data == null || this.data.length < this.stride) {
            return;
        }
        for (int i = 0; i < this.length; i += this.stride) {
            double x0 = this.data[i];
            double y0 = this.data[i + 1];
            double dx = this.data[i + 2] * this.getScaleFactor();
            double dy = this.data[i + 3] * this.getScaleFactor();
            double x1 = x0 + dx;
            double y1 = y0 + dy;
            if (!this.inside(x0, y0) && !this.inside(x1, y1)) continue;
            int ix0 = (int)((double)w.x + (x0 - this.xmin) / this.xrange * (double)w.width);
            int iy0 = (int)((double)w.y + (1.0 - (y0 - this.ymin) / this.yrange) * (double)w.height);
            int ix1 = (int)((double)w.x + (x1 - this.xmin) / this.xrange * (double)w.width);
            int iy1 = (int)((double)w.y + (1.0 - (y1 - this.ymin) / this.yrange) * (double)w.height);
            g.drawLine(ix0, iy0, ix1, iy1);
            dx = ix1 - ix0;
            dy = iy1 - iy0;
            ix0 = ix1 - (int)(0.25 * (dx - dy) + 0.5);
            iy0 = iy1 - (int)(0.25 * (dx + dy) + 0.5);
            g.drawLine(ix0, iy0, ix1, iy1);
            ix0 = ix1 - (int)(0.25 * (dx + dy) + 0.5);
            iy0 = iy1 - (int)(0.25 * (-dx + dy) + 0.5);
            g.drawLine(ix0, iy0, ix1, iy1);
        }
    }

    @Override
    protected void range(int stride) {
        double mag = 0.0;
        if (this.length > stride) {
            this.dxmax = this.data[0];
            this.dymax = this.data[1];
            this.dxmin = this.dxmax;
            this.dymin = this.dymax;
            mag = this.data[2] * this.data[2] + this.data[3] * this.data[3];
            this.vmean = Math.sqrt(mag);
            this.vmin = mag;
            this.vmax = mag;
        } else {
            this.dxmin = 0.0;
            this.dxmax = 0.0;
            this.dymin = 0.0;
            this.dymax = 0.0;
            this.vmean = 0.0;
            this.vmin = 0.0;
            this.vmax = 0.0;
        }
        for (int i = stride; i < this.length; i += stride) {
            if (this.dxmax < this.data[i]) {
                this.dxmax = this.data[i];
            } else if (this.dxmin > this.data[i]) {
                this.dxmin = this.data[i];
            }
            if (this.dymax < this.data[i + 1]) {
                this.dymax = this.data[i + 1];
            } else if (this.dymin > this.data[i + 1]) {
                this.dymin = this.data[i + 1];
            }
            mag = this.data[i + 2] * this.data[i + 2] + this.data[i + 3] * this.data[i + 3];
            this.vmean += Math.sqrt(mag);
            if (this.vmin > mag) {
                this.vmin = mag;
            }
            if (!(this.vmax < mag)) continue;
            this.vmax = mag;
        }
        if (this.length > stride) {
            this.vmin = Math.sqrt(this.vmin);
            this.vmax = Math.sqrt(this.vmax);
            this.vmean /= (double)this.dataPoints();
        }
        if (this.xaxis == null) {
            this.xmin = this.dxmin;
            this.xmax = this.dxmax;
        }
        if (this.yaxis == null) {
            this.ymin = this.dymin;
            this.ymax = this.dymax;
        }
    }
}

