/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.Graph2D;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

class LoadMessage
extends Thread {
    Graph2D g2d;
    String message = "Loading Data ... Please Wait!";
    String newmessage = null;
    long visible = 500L;
    long invisible = 200L;
    Color foreground = Color.red;
    Graphics lg = null;
    Font f = null;

    public LoadMessage(Graph2D g2d) {
        this.g2d = g2d;
    }

    public LoadMessage(Graph2D g2d, String s) {
        this(g2d);
        this.message = s;
    }

    public LoadMessage(Graph2D g, String s, long visible, long invisible) {
        this(g, s);
        this.visible = visible;
        this.invisible = invisible;
    }

    public void begin() {
        this.g2d.clearAll = false;
        this.g2d.paintAll = false;
        super.start();
    }

    public void end() {
        super.stop();
        this.g2d.clearAll = true;
        this.g2d.paintAll = true;
        if (this.lg != null) {
            this.lg.dispose();
        }
        this.g2d.repaint();
    }

    @Override
    public void run() {
        boolean draw = true;
        int sw = 0;
        int sa = 0;
        int x = 0;
        int y = 0;
        this.setPriority(1);
        while (true) {
            if (this.newmessage != null && draw) {
                this.message = this.newmessage;
                this.newmessage = null;
            }
            if (this.lg == null) {
                this.lg = this.g2d.getGraphics();
                if (this.lg != null) {
                    this.lg = this.lg.create();
                }
            }
            if (this.lg != null) {
                if (this.f != null) {
                    this.lg.setFont(this.f);
                }
                FontMetrics fm = this.lg.getFontMetrics(this.lg.getFont());
                sw = fm.stringWidth(this.message);
                sa = fm.getAscent();
            } else {
                draw = false;
            }
            if (draw) {
                this.lg.setColor(this.foreground);
                Rectangle r = this.g2d.bounds();
                x = r.x + (r.width - sw) / 2;
                y = r.y + (r.height + sa) / 2;
                this.lg.drawString(this.message, x, y);
                this.g2d.repaint();
                try {
                    LoadMessage.sleep(this.visible);
                }
                catch (Exception exception) {}
            } else {
                if (this.lg != null) {
                    this.lg.setColor(this.g2d.getBackground());
                    this.lg.drawString(this.message, x, y);
                    this.g2d.repaint();
                }
                try {
                    LoadMessage.sleep(this.invisible);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            draw = !draw;
        }
    }

    public void setFont(Font f) {
        this.f = f;
    }

    public void setForeground(Color c) {
        if (c == null) {
            return;
        }
        this.foreground = c;
    }

    public void setMessage(String s) {
        if (s == null) {
            return;
        }
        this.newmessage = s;
    }
}

