/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.BaseColorControl;
import visad.Control;
import visad.ControlEvent;
import visad.ControlListener;
import visad.Display;
import visad.DisplayException;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;
import visad.util.BaseRGBMap;
import visad.util.SimpleColorMapWidget;

public class ColorMapWidget
extends SimpleColorMapWidget
implements ActionListener,
ControlListener,
ScalarMapListener {
    private JPanel buttonPanel = null;
    private float[][] undoTable = null;
    BaseColorControl control;
    BaseColorControl realControl;

    public ColorMapWidget(ScalarMap smap) throws VisADException, RemoteException {
        this(smap, (float[][])null, true, true);
    }

    public ColorMapWidget(ScalarMap smap, boolean immediate) throws VisADException, RemoteException {
        this(smap, (float[][])null, true, immediate);
    }

    public ColorMapWidget(ScalarMap smap, float[][] table) throws VisADException, RemoteException {
        this(smap, table, true, true);
    }

    public ColorMapWidget(ScalarMap smap, float[][] table, boolean update) throws VisADException, RemoteException {
        this(smap, table, update, true);
    }

    public ColorMapWidget(ScalarMap smap, float[][] table, boolean update, boolean immediate) throws VisADException, RemoteException {
        super(smap.getScalarName(), smap.getControl(), (float)smap.getRange()[0], (float)smap.getRange()[1] + 1.0f);
        Control ctl = smap.getControl();
        if (!(ctl instanceof BaseColorControl)) {
            throw new DisplayException(this.getClass().getName() + ": ScalarMap must be Display.RGB or Display.RGBA");
        }
        if (immediate) {
            this.control = (BaseColorControl)ctl;
            this.realControl = null;
        } else {
            this.realControl = (BaseColorControl)ctl;
            this.control = new BaseColorControl(this.realControl.getDisplay(), this.realControl.getNumberOfComponents());
            this.control.syncControl(this.realControl);
            this.baseMap = new BaseRGBMap(this.control);
            this.preview.setMap(this.baseMap);
            this.rebuildGUI();
        }
        if (table != null) {
            this.control.setTable(table);
        }
        if (!immediate) {
            this.buttonPanel = this.buildButtons();
            this.add(this.buttonPanel);
        }
        if (this.realControl != null) {
            this.realControl.addControlListener(this);
        } else {
            this.control.addControlListener(this);
        }
        if (update) {
            smap.addScalarMapListener(this);
        }
    }

    public void setTableView(float[][] table) {
        try {
            this.control.setTable(table);
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
    }

    public float[][] getTableView() {
        return this.control.getTable();
    }

    private JPanel buildButtons() {
        JButton apply = new JButton("Apply");
        apply.setActionCommand("apply");
        apply.addActionListener(this);
        JButton undo = new JButton("Undo");
        undo.setActionCommand("undo");
        undo.addActionListener(this);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(1, 5, 5));
        panel.add(apply);
        panel.add(undo);
        this.undoTable = this.control.getTable();
        return panel;
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("apply")) {
            this.undoTable = this.realControl.getTable();
            try {
                this.realControl.syncControl(this.control);
            }
            catch (VisADException visADException) {}
        } else if (evt.getActionCommand().equals("undo")) {
            try {
                this.realControl.setTable(this.undoTable);
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void controlChanged(ControlEvent evt) throws RemoteException, VisADException {
        if (this.realControl == evt.getControl()) {
            this.control.syncControl(this.realControl);
        }
    }

    @Override
    public void mapChanged(ScalarMapEvent evt) {
        double[] range = evt.getScalarMap().getRange();
        this.updateSlider((float)range[0], (float)range[1]);
    }

    @Override
    public void controlChanged(ScalarMapControlEvent evt) throws RemoteException, VisADException {
        int id = evt.getId();
        if ((id == 4 || id == 5) && this.realControl != null) {
            evt.getControl().removeControlListener(this);
        }
        if (id == 5 || id == 3) {
            BaseColorControl ctl = (BaseColorControl)evt.getScalarMap().getControl();
            if (this.realControl != null) {
                this.realControl = ctl;
                this.realControl.addControlListener(this);
            }
        }
    }

    public static void main(String[] args) {
        try {
            RealType vis = RealType.getRealType("vis");
            ScalarMap visMap = new ScalarMap(vis, Display.RGBA);
            visMap.setRange(0.0, 1.0);
            RealType ir = RealType.getRealType("ir");
            ScalarMap irMap = new ScalarMap(vis, Display.RGB);
            irMap.setRange(0.0, 1.0);
            DisplayImplJ2D dpy = new DisplayImplJ2D("2d");
            dpy.addMap(visMap);
            dpy.addMap(irMap);
            JFrame f = new JFrame("0");
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    System.exit(0);
                }
            });
            f.getContentPane().add(new ColorMapWidget(visMap));
            f.pack();
            f.setVisible(true);
            f = new JFrame("1");
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    System.exit(0);
                }
            });
            f.getContentPane().add(new ColorMapWidget(visMap, false));
            f.pack();
            f.setVisible(true);
            f = new JFrame("!Updated");
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    System.exit(0);
                }
            });
            f.getContentPane().add(new ColorMapWidget(visMap, (float[][])null, false, true));
            f.pack();
            f.setVisible(true);
            int num = 3;
            int len = 256;
            float[][] table = new float[3][256];
            float step = 0.003921569f;
            float total = 1.0f;
            for (int j = 0; j < 256; ++j) {
                float f2 = total;
                table[2][j] = f2;
                table[1][j] = f2;
                table[0][j] = f2;
                total -= 0.003921569f;
            }
            f = new JFrame("Table");
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    System.exit(0);
                }
            });
            f.getContentPane().add(new ColorMapWidget(irMap, table));
            f.pack();
            f.setVisible(true);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            visMap.setRange(-10.0, 10.0);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        catch (VisADException ve) {
            ve.printStackTrace();
        }
    }
}

