/*
 * Decompiled with CFR 0.152.
 */
package visad.rabin;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.DataReferenceImpl;
import visad.RealType;
import visad.VisADException;
import visad.ss.BasicSSCell;
import visad.ss.FancySSCell;
import visad.util.VisADSlider;

public class RainSheet
extends JFrame
implements ActionListener {
    static final int N_COLUMNS = 3;
    static final int N_ROWS = 4;
    static final JPanel[] row_panels = new JPanel[4];
    static final FancySSCell[] cells = new FancySSCell[12];
    static final JTextField[] formulas = new JTextField[12];
    static final JButton[] maps = new JButton[12];
    static final int WIDTH = 1100;
    static final int HEIGHT = 900;
    static final int CELL_WIDTH = 200;
    static final int CELL_HEIGHT = 200;
    static String[] formula_name = new String[]{"A1", "B1", "C1", "A2", "B2", "C2", "A3", "B3", "C3", "A4", "B4", "C4"};
    static String[] formula_array = new String[]{"file:dallas_2.5km_v5d.v5d", "A1(0)", "((10^((extract(B1,0))/10))/SLIDER300)^(1/SLIDER1_4)", "((10^((extract(B1,1))/10))/SLIDER300)^(1/SLIDER1_4)", "((10^((extract(B1,2))/10))/SLIDER300)^(1/SLIDER1_4)", "((10^((extract(B1,3))/10))/SLIDER300)^(1/SLIDER1_4)", "((10^((extract(B1,4))/10))/SLIDER300)^(1/SLIDER1_4)", "((10^((extract(B1,5))/10))/SLIDER300)^(1/SLIDER1_4)", "(10*C1+10*A2+10*B2+10*C2+10*A3+3*B3)/53", "extract(B1,6)", "extract(B1,7)", "extract(B1,8)"};
    private JTextField Formula1;
    private JTextField Formula2;

    public static void main(String[] argv) throws VisADException, RemoteException {
        RainSheet ms = new RainSheet();
        ms.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ms.setSize(1100, 900);
        Dimension appSize = ms.getSize();
        ms.setLocation(screenSize.width / 2 - appSize.width / 2, screenSize.height / 2 - appSize.height / 2);
        ms.setVisible(true);
    }

    private static void createLabel(JPanel p, String s) {
        JLabel l = new JLabel(s);
        l.setForeground(Color.black);
        p.add(l);
    }

    public RainSheet() throws VisADException, RemoteException {
        super("RainSheet");
        this.setBackground(Color.white);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RainSheet.this.quitProgram();
            }
        });
        JPanel main = new JPanel();
        this.setContentPane(main);
        main.setLayout(new BoxLayout(main, 0));
        JPanel left = new JPanel();
        left.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 10, 5, 10)));
        left.setLayout(new BoxLayout(left, 1));
        main.add(left);
        JPanel display_panel = new JPanel();
        display_panel.setLayout(new BoxLayout(display_panel, 1));
        display_panel.setAlignmentY(0.0f);
        display_panel.setAlignmentX(0.0f);
        main.add(display_panel);
        RainSheet.createLabel(left, "RainSheet -- a custom spreadsheet");
        RainSheet.createLabel(left, "for rain estimation");
        DataReferenceImpl ref300 = new DataReferenceImpl("num300");
        DataReferenceImpl ref1_4 = new DataReferenceImpl("num1_4");
        VisADSlider slider300 = new VisADSlider("num300", 0, 600, 300, 1.0, ref300, RealType.Generic);
        VisADSlider slider1_4 = new VisADSlider("num1_4", 0, 280, 140, 0.01, ref1_4, RealType.Generic);
        left.add(slider300);
        left.add(slider1_4);
        BasicSSCell.createVar("SLIDER300", ref300);
        BasicSSCell.createVar("SLIDER1_4", ref1_4);
        JPanel qpanel = new JPanel();
        qpanel.setAlignmentX(0.0f);
        qpanel.setLayout(new BoxLayout(qpanel, 0));
        left.add(Box.createRigidArea(new Dimension(0, 15)));
        left.add(qpanel);
        JButton quit = new JButton("Quit");
        quit.addActionListener(this);
        quit.setActionCommand("quit");
        qpanel.add(Box.createHorizontalGlue());
        qpanel.add(quit);
        qpanel.add(Box.createHorizontalGlue());
        Dimension lps = left.getPreferredSize();
        left.setMinimumSize(lps);
        left.setMaximumSize(lps);
        int i = 0;
        for (int k = 0; k < 4; ++k) {
            RainSheet.row_panels[k] = new JPanel();
            row_panels[k].setLayout(new BoxLayout(row_panels[k], 0));
            row_panels[k].setAlignmentY(0.0f);
            row_panels[k].setAlignmentX(0.0f);
            display_panel.add(row_panels[k]);
            for (int j = 0; j < 3; ++j) {
                JPanel cellPanel = new JPanel();
                cellPanel.setLayout(new BoxLayout(cellPanel, 1));
                row_panels[k].add(cellPanel);
                FancySSCell fCell = null;
                try {
                    fCell = new FancySSCell(formula_name[i], this);
                    fCell.setDimension(true, false);
                }
                catch (Exception exc) {
                    System.out.println("Could not create the first spreadsheet cell!");
                    System.out.println("Received the following exception:");
                    System.out.println(exc.toString());
                    System.exit(i);
                }
                fCell.setPreferredSize(new Dimension(200, 200));
                fCell.setMaximumSize(new Dimension(200, 200));
                JPanel bPanel = new JPanel();
                bPanel.setLayout(new BoxLayout(bPanel, 0));
                JButton load = new JButton("Load");
                load.addActionListener(this);
                load.setActionCommand("load" + i);
                bPanel.add(load);
                JButton save = new JButton("Save");
                save.addActionListener(this);
                save.setActionCommand("save" + i);
                bPanel.add(save);
                JButton map = new JButton("Maps");
                map.addActionListener(this);
                map.setActionCommand("map" + i);
                bPanel.add(map);
                JButton show = new JButton("Show");
                show.addActionListener(this);
                show.setActionCommand("show" + i);
                bPanel.add(show);
                JTextField tf = new JTextField();
                Dimension msize = tf.getMaximumSize();
                Dimension psize = tf.getPreferredSize();
                msize.height = psize.height;
                tf.setMaximumSize(msize);
                JPanel lPanel = new JPanel();
                lPanel.setLayout(new BoxLayout(lPanel, 0));
                lPanel.add(Box.createHorizontalGlue());
                JLabel l = new JLabel(formula_name[i]);
                l.setForeground(Color.blue);
                lPanel.add(l);
                lPanel.add(Box.createHorizontalGlue());
                JPanel fPanel = new JPanel();
                fPanel.setLayout(new BoxLayout(fPanel, 0));
                RainSheet.createLabel(fPanel, "Formula:  ");
                JTextField textf = new JTextField(formula_array[i]);
                msize = textf.getMaximumSize();
                psize = textf.getPreferredSize();
                msize.height = psize.height;
                textf.setMaximumSize(msize);
                textf.addActionListener(this);
                textf.setActionCommand("formula" + i);
                fPanel.add(textf);
                cellPanel.add(lPanel);
                cellPanel.add(fPanel);
                cellPanel.add(fCell);
                cellPanel.add(bPanel);
                RainSheet.cells[i] = fCell;
                RainSheet.maps[i] = map;
                RainSheet.formulas[i] = textf;
                ++i;
            }
        }
        for (i = 0; i < 12; ++i) {
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("quit")) {
            this.quitProgram();
            return;
        }
        for (int i = 0; i < 12; ++i) {
            if (cmd.equals("load" + i)) {
                cells[i].loadDataDialog();
                continue;
            }
            if (cmd.equals("save" + i)) {
                cells[i].saveDataDialog(true);
                continue;
            }
            if (cmd.equals("map" + i)) {
                cells[i].addMapDialog();
                continue;
            }
            if (cmd.equals("show" + i)) {
                cells[i].showWidgetFrame();
                continue;
            }
            if (!cmd.equals("formula" + i)) continue;
            maps[i].requestFocus();
            try {
                cells[i].setFormula(formulas[i].getText());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void quitProgram() {
        Thread t = new Thread(){

            @Override
            public void run() {
                if (BasicSSCell.isSaving()) {
                    System.out.println("Please wait for RainSheet to finish saving files...");
                }
                while (BasicSSCell.isSaving()) {
                    try {
                        2.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                System.exit(0);
            }
        };
        t.start();
    }
}

