/*
 * Decompiled with CFR 0.152.
 */
package visad.jmet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visad.AnimationControl;
import visad.ColorControl;
import visad.ConstantMap;
import visad.ContourControl;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.FieldImpl;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Integer1DSet;
import visad.LocalDisplay;
import visad.MathType;
import visad.ProjectionControl;
import visad.RealType;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.ScalarMap;
import visad.UnionSet;
import visad.ValueControl;
import visad.VisADException;
import visad.data.mcidas.BaseMapAdapter;
import visad.java3d.DisplayImplJ3D;
import visad.jmet.NCEPPanel;
import visad.jmet.NetcdfGrids;
import visad.util.ClientServer;

public class ShowNCEPModel
extends JFrame
implements ActionListener,
ChangeListener,
DisplayListener {
    private BaseMapAdapter baseMap;
    private ColorControl ccmap;
    private float[][] colorTable;
    private Container cf;
    private JSlider speedSlider;
    private JLabel speedSliderLabel;
    private int speedValue;
    private int frameValue;
    private int maxFrames;
    private JButton start_stop;
    private JButton snapButton;
    private JButton forward;
    private JButton backward;
    private JButton mapColor;
    private boolean isLooping;
    private ContourControl ci;
    private ProjectionControl pc;
    private AnimationControl ca;
    private double[] pcMatrix;
    private GraphicsModeControl gmc;
    private LocalDisplay display;
    private NetcdfGrids ng;
    private JPanel vdisplay;
    private RealType x;
    private RealType y;
    private RealType level;
    private RealType time_type;
    private RealType pres;
    private RealType Values;
    private RealType SfcValues;
    private boolean firstFile;
    private boolean gotSfcGrids;
    private boolean gotAloftGrids;
    private JLabel statLabel;
    private String cmd;
    private NCEPPanel[] ncp;
    private JTabbedPane tabby;
    private FieldImpl mapField;
    private ValueControl mapControl;
    private DataReference mapRef;
    private RealType enableMap;
    private ScalarMap mapMap;
    private ScalarMap xAxis;
    private ScalarMap yAxis;
    private JCheckBox showMap;
    private String directory;
    private String MapFile;
    private boolean isServer = false;
    private boolean isClient = false;
    private String clientHost = null;

    public static void main(String[] args) {
        int num = 1;
        boolean srvr = false;
        boolean clnt = false;
        String fileName = null;
        String host = null;
        if (args != null && args.length > 0) {
            boolean killMe = false;
            boolean gotNum = false;
            block8: for (int i = 0; i < args.length; ++i) {
                if (args[i].charAt(0) == '-' && args[i].length() > 1) {
                    switch (args[i].charAt(1)) {
                        case 'c': {
                            if (srvr) {
                                System.out.println("Cannot specify both '-c' and '-s'");
                                killMe = true;
                            }
                            clnt = true;
                            if (args[i].length() <= 2) continue block8;
                            host = args[i].substring(2).trim();
                            break;
                        }
                        case 's': {
                            if (clnt) {
                                System.out.println("Cannot specify both '-c' and '-s'");
                                killMe = true;
                            }
                            srvr = true;
                            break;
                        }
                        default: {
                            System.out.println("Unknown argument \"" + args[i] + "\"");
                            killMe = true;
                            break;
                        }
                    }
                    continue;
                }
                boolean triedNum = false;
                if (!gotNum) {
                    try {
                        num = Integer.parseInt(args[i]);
                        triedNum = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (triedNum) {
                        if (num >= 1 && num <= 9) {
                            gotNum = true;
                            continue;
                        }
                        System.out.println("invalid number of tabs (1-9) = " + num);
                        killMe = true;
                        continue;
                    }
                }
                if (fileName == null) {
                    fileName = args[i];
                    continue;
                }
                System.out.println("Ignoring extra argument \"" + args[i] + "\"");
            }
            if (killMe) {
                System.out.println("Usage: ShowNCEPModel [-c|-s] # [fileName]");
                System.out.println("Usage: ShowNCEPModel [-chostname|-s] # [fileName]");
                System.exit(1);
            }
        }
        try {
            new ShowNCEPModel(num, srvr, clnt, host, fileName);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.exit(1);
        }
    }

    public ShowNCEPModel(int numPanels) throws RemoteException, VisADException {
        this(numPanels, false, false, null, null);
    }

    public ShowNCEPModel(int numPanels, boolean srvr, boolean clnt) throws RemoteException, VisADException {
        this(numPanels, srvr, clnt, null, null);
    }

    public ShowNCEPModel(int numPanels, String fileName) throws RemoteException, VisADException {
        this(numPanels, false, false, null, fileName);
    }

    public ShowNCEPModel(int numPanels, boolean srvr, boolean clnt, String host, String fileName) throws RemoteException, VisADException {
        super("Show NCEP Model Data");
        this.isServer = srvr;
        this.isClient = clnt;
        this.clientHost = host;
        if (this.clientHost == null) {
            this.clientHost = "localhost";
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.frameValue = 0;
        this.maxFrames = -1;
        this.firstFile = true;
        this.gotSfcGrids = false;
        this.gotAloftGrids = false;
        this.directory = ".";
        this.ng = null;
        this.MapFile = "../data/mcidas/OUTLUSAM";
        String serviceName = this.getClass().getName();
        if (!this.isClient) {
            DisplayImpl di = this.buildData(numPanels);
            if (this.isServer) {
                RemoteServerImpl server = ClientServer.startServer(serviceName);
                server.addDisplay(new RemoteDisplayImpl(di));
            }
            this.display = di;
        } else {
            RemoteServer client = ClientServer.connectToServer(this.clientHost, serviceName);
            LocalDisplay[] lh = ClientServer.getClientDisplays(client);
            this.display = lh[0];
        }
        this.buildUI();
        if (fileName != null) {
            try {
                this.setLooping(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.getNewFile(".", fileName);
        }
    }

    private DisplayImpl buildData(int numPanels) throws RemoteException, VisADException {
        DisplayImplJ3D di = new DisplayImplJ3D("display1");
        di.addDisplayListener(this);
        this.pc = ((DisplayImpl)di).getProjectionControl();
        this.pcMatrix = this.pc.getMatrix();
        this.pcMatrix[0] = 0.95;
        this.pcMatrix[5] = 0.95;
        this.pcMatrix[10] = 0.95;
        this.pc.setMatrix(this.pcMatrix);
        this.x = RealType.getRealType("x");
        this.y = RealType.getRealType("y");
        this.level = RealType.getRealType("level");
        this.time_type = RealType.Time;
        this.pres = RealType.getRealType("pres");
        this.gmc = ((DisplayImpl)di).getGraphicsModeControl();
        this.gmc.setProjectionPolicy(0);
        this.xAxis = new ScalarMap(this.x, Display.XAxis);
        this.yAxis = new ScalarMap(this.y, Display.YAxis);
        di.addMap(this.xAxis);
        di.addMap(this.yAxis);
        ScalarMap lvl = new ScalarMap(this.pres, Display.ZAxis);
        lvl.setRange(1020.0, 10.0);
        di.addMap(lvl);
        ScalarMap ani = new ScalarMap(this.time_type, Display.Animation);
        di.addMap(ani);
        this.ca = (AnimationControl)((Object)ani.getControl());
        this.ca.setOn(false);
        this.statLabel = new JLabel("Please choose a data file...");
        this.statLabel.setForeground(Color.black);
        this.tabby = new JTabbedPane();
        this.ncp = new NCEPPanel[numPanels + 1];
        this.ncp[0] = new NCEPPanel(false, di, this.statLabel, this.tabby, "Single-level Data");
        for (int i = 1; i < this.ncp.length; ++i) {
            this.ncp[i] = new NCEPPanel(true, di, this.statLabel, this.tabby, "Data Aloft");
        }
        this.enableMap = RealType.getRealType("enableMap");
        this.mapMap = new ScalarMap(this.enableMap, Display.SelectValue);
        di.addMap(this.mapMap);
        ScalarMap scalarMapColor = new ScalarMap(this.enableMap, Display.RGB);
        di.addMap(scalarMapColor);
        this.ccmap = (ColorControl)scalarMapColor.getControl();
        this.colorTable = new float[3][256];
        for (int i = 0; i < 256; ++i) {
            this.colorTable[0][i] = 0.6f;
            this.colorTable[1][i] = 0.0f;
            this.colorTable[2][i] = 0.6f;
        }
        this.ccmap.setTable(this.colorTable);
        return di;
    }

    private void buildMenuBar() {
        JMenuBar mb = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem menuFile = new JMenuItem("Open File");
        menuFile.addActionListener(this);
        menuFile.setActionCommand("menuFile");
        fileMenu.add(menuFile);
        JMenuItem menuQuit = new JMenuItem("Exit");
        menuQuit.addActionListener(this);
        menuQuit.setActionCommand("menuQuit");
        fileMenu.add(menuQuit);
        ButtonGroup menuSelectors = new ButtonGroup();
        JMenu mapMenu = new JMenu("Map");
        JRadioButtonMenuItem menuNA = new JRadioButtonMenuItem("North America", true);
        menuNA.addActionListener(this);
        menuNA.setActionCommand("menuNA");
        mapMenu.add(menuNA);
        menuSelectors.add(menuNA);
        JRadioButtonMenuItem menuWorld = new JRadioButtonMenuItem("World", false);
        menuWorld.addActionListener(this);
        menuWorld.setActionCommand("menuWorld");
        mapMenu.add(menuWorld);
        menuSelectors.add(menuWorld);
        mb.add(fileMenu);
        mb.add(mapMenu);
        this.setJMenuBar(mb);
    }

    private Component buildMapControls() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentX(0.5f);
        panel.add(this.mapColor);
        panel.add(Box.createRigidArea(new Dimension(10, 10)));
        panel.add(this.showMap);
        return panel;
    }

    private Component buildSpeedControl() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentX(0.5f);
        panel.setAlignmentY(0.5f);
        this.speedSlider = new JSlider(0, 1, 20, 10);
        this.speedSlider.setMaximumSize(this.speedSlider.getPreferredSize());
        this.speedSlider.setAlignmentX(0.5f);
        this.speedSlider.addChangeListener(this);
        this.speedValue = 3;
        panel.add(new JLabel("Speed"));
        panel.add(this.speedSlider);
        return panel;
    }

    private Component buildAnimationControls() {
        this.backward = new JButton(" < ");
        this.backward.setAlignmentX(0.5f);
        this.backward.setMaximumSize(this.backward.getMaximumSize());
        this.backward.setMinimumSize(this.backward.getMaximumSize());
        this.backward.setPreferredSize(this.backward.getMaximumSize());
        this.backward.addActionListener(this);
        this.backward.setActionCommand("backward");
        this.start_stop = new JButton("Animate");
        this.start_stop.setAlignmentX(0.5f);
        this.start_stop.setMaximumSize(this.start_stop.getMaximumSize());
        this.start_stop.setMinimumSize(this.start_stop.getMaximumSize());
        this.start_stop.setPreferredSize(this.start_stop.getMaximumSize());
        this.start_stop.addActionListener(this);
        this.start_stop.setActionCommand("start_stop");
        this.isLooping = false;
        this.forward = new JButton(" > ");
        this.forward.setAlignmentX(0.5f);
        this.forward.setMaximumSize(this.forward.getMaximumSize());
        this.forward.setMinimumSize(this.forward.getMaximumSize());
        this.forward.setPreferredSize(this.forward.getMaximumSize());
        this.forward.addActionListener(this);
        this.forward.setActionCommand("forward");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentX(0.5f);
        panel.add(this.backward);
        panel.add(this.start_stop);
        panel.add(this.forward);
        panel.add(this.buildSpeedControl());
        return panel;
    }

    private Component buildControlPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentX(0.5f);
        panel.setAlignmentY(0.0f);
        panel.setMaximumSize(new Dimension(300, Short.MAX_VALUE));
        panel.setMinimumSize(new Dimension(300, 400));
        panel.setPreferredSize(new Dimension(300, 400));
        this.mapColor = new JButton("Map Color");
        this.mapColor.addActionListener(this);
        this.mapColor.setActionCommand("mapColor");
        this.mapColor.setBackground(new Color(154, 0, 154));
        this.showMap = new JCheckBox("Make map visible");
        this.showMap.setAlignmentX(0.5f);
        this.showMap.addActionListener(this);
        this.showMap.setActionCommand("showmap");
        this.showMap.setSelected(true);
        this.snapButton = new JButton("Snap!");
        this.snapButton.setAlignmentX(0.5f);
        this.snapButton.setMaximumSize(this.snapButton.getMaximumSize());
        this.snapButton.setMinimumSize(this.snapButton.getMaximumSize());
        this.snapButton.setPreferredSize(this.snapButton.getMaximumSize());
        this.snapButton.addActionListener(this);
        this.snapButton.setActionCommand("snapButton");
        panel.add(Box.createRigidArea(new Dimension(10, 10)));
        panel.add(this.snapButton);
        panel.add(Box.createRigidArea(new Dimension(10, 10)));
        panel.add(this.buildMapControls());
        panel.add(this.buildAnimationControls());
        for (int i = 0; i < this.ncp.length; ++i) {
            this.tabby.addTab("Data", this.ncp[i]);
        }
        panel.add(Box.createRigidArea(new Dimension(10, 30)));
        panel.add(this.tabby);
        panel.add(Box.createVerticalGlue());
        panel.add(Box.createRigidArea(new Dimension(10, 10)));
        this.statLabel.setAlignmentX(0.5f);
        panel.add(this.statLabel);
        return panel;
    }

    private void buildUI() {
        this.buildMenuBar();
        this.vdisplay = (JPanel)this.display.getComponent();
        this.vdisplay.setPreferredSize(new Dimension(700, 700));
        this.vdisplay.setAlignmentX(0.0f);
        this.vdisplay.setAlignmentY(0.0f);
        this.cf = this.getContentPane();
        this.cf.setLayout(new BoxLayout(this.cf, 0));
        if (!this.isClient) {
            this.cf.add(this.buildControlPanel());
        }
        this.cf.add(this.vdisplay);
        this.setSize(1024, 768);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.cmd = e.getActionCommand();
        if (this.cmd.equals("menuFile")) {
            try {
                this.setLooping(false);
            }
            catch (Exception mfs) {
                mfs.printStackTrace();
                System.exit(1);
            }
            FileDialog fileBox = new FileDialog(this);
            fileBox.setDirectory(this.directory);
            fileBox.setMode(0);
            fileBox.setVisible(true);
            this.getNewFile(fileBox.getDirectory(), fileBox.getFile());
        } else if (this.cmd.equals("menuQuit")) {
            System.exit(0);
        } else if (this.cmd.equals("menuNA")) {
            this.MapFile = "../data/mcidas/OUTLUSAM";
            this.doBaseMap();
        } else if (this.cmd.equals("menuWorld")) {
            this.MapFile = "../data/mcidas/OUTLSUPW";
            this.doBaseMap();
        } else if (this.cmd.startsWith("Param:")) {
            System.out.println("not implemented");
        } else if (this.cmd.equals("start_stop")) {
            try {
                this.setLooping(!this.isLooping);
            }
            catch (Exception sse) {
                sse.printStackTrace();
                System.exit(1);
            }
        } else if (this.cmd.equals("backward")) {
            try {
                this.ca.setDirection(false);
                this.ca.takeStep();
            }
            catch (Exception eb) {
                eb.printStackTrace();
            }
        } else if (this.cmd.equals("forward")) {
            try {
                this.ca.setDirection(true);
                this.ca.takeStep();
            }
            catch (Exception eb) {
                eb.printStackTrace();
            }
        } else if (this.cmd.equals("snapButton")) {
            try {
                this.pc.setMatrix(this.pcMatrix);
            }
            catch (Exception sse) {
                sse.printStackTrace();
                System.exit(1);
            }
        } else if (this.cmd.equals("mapColor")) {
            JColorChooser cc = new JColorChooser();
            Color nc = JColorChooser.showDialog(this, "Choose contour color", Color.white);
            if (nc != null) {
                this.mapColor.setBackground(nc);
                try {
                    for (int i = 0; i < 256; ++i) {
                        this.colorTable[0][i] = (float)nc.getRed() / 255.0f;
                        this.colorTable[1][i] = (float)nc.getGreen() / 255.0f;
                        this.colorTable[2][i] = (float)nc.getBlue() / 255.0f;
                    }
                    this.ccmap.setTable(this.colorTable);
                }
                catch (Exception mce) {
                    mce.printStackTrace();
                }
            }
        } else if (this.cmd.equals("showmap")) {
            try {
                if (this.showMap.isSelected()) {
                    this.mapControl.setValue(0.0);
                } else {
                    this.mapControl.setValue(1.0);
                }
            }
            catch (Exception mcon) {
                mcon.printStackTrace();
            }
        }
    }

    @Override
    public void displayChanged(DisplayEvent e) {
        if (e.getId() == 2) {
            this.statLabel.setText("Display Frame done...");
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int val;
        Object source = e.getSource();
        if (source.equals(this.speedSlider) && (val = this.speedSlider.getValue()) != this.speedValue) {
            this.speedValue = val;
            try {
                this.ca.setStep(50 * (21 - this.speedValue));
            }
            catch (Exception slis) {
                slis.printStackTrace();
                System.exit(1);
            }
        }
    }

    void getNewFile(String directory, String filename) {
        if (filename == null || directory == null) {
            return;
        }
        try {
            File file = new File(directory, filename);
            this.ng = new NetcdfGrids(file);
            this.setTitle("Show NCEP Model Data from " + filename);
            this.ng.setRealTypes(this.x, this.y, this.level, this.time_type, this.pres);
            Dimension dim = this.ng.getDimension();
            this.xAxis.setRange(0.0, dim.width - 1);
            this.yAxis.setRange(0.0, dim.height - 1);
            double aspect = this.ng.getAspect();
            aspect *= (double)dim.width / (double)dim.height;
            if (aspect >= 1.0) {
                this.pcMatrix[0] = 0.95;
                this.pcMatrix[5] = 0.95 / aspect;
            } else {
                this.pcMatrix[0] = 0.95 * aspect;
                this.pcMatrix[5] = 0.95;
            }
            this.pc.setMatrix(this.pcMatrix);
            for (int i = 0; i < this.ncp.length; ++i) {
                this.ncp[i].setNetcdfGrid(this.ng);
            }
            this.maxFrames = this.ng.getNumberOfTimes() - 1;
            Vector vSfc = this.ng.get3dVariables();
            this.ncp[0].setParams(vSfc);
            Vector v = this.ng.get4dVariables();
            for (int i = 1; i < this.ncp.length; ++i) {
                this.ncp[i].setParams(v);
            }
            this.statLabel.setText("Rendering base map...");
            this.doBaseMap();
        }
        catch (Exception op) {
            op.printStackTrace();
            System.exit(1);
        }
    }

    private void doBaseMap() {
        if (this.ng == null) {
            return;
        }
        try {
            this.baseMap = new BaseMapAdapter(this.MapFile);
            this.baseMap.setDomainSet(this.ng.getDomainSet());
            UnionSet mapData = this.baseMap.getData();
            FunctionType mapType = new FunctionType(this.enableMap, mapData.getType());
            Integer1DSet mapSet = new Integer1DSet((MathType)this.enableMap, 2);
            this.mapField = new FieldImpl(mapType, mapSet);
            this.mapField.setSample(0, (Data)mapData);
            this.mapControl = (ValueControl)((Object)this.mapMap.getControl());
            if (this.mapRef != null) {
                this.display.removeReference(this.mapRef);
            }
            this.mapRef = new DataReferenceImpl("mapData");
            this.mapRef.setData(this.mapField);
            ConstantMap[] rendMap = new ConstantMap[]{new ConstantMap(-0.99, Display.ZAxis)};
            this.display.addReference(this.mapRef, rendMap);
            this.mapControl.setValue(0.0);
        }
        catch (Exception mapop) {
            mapop.printStackTrace();
            System.exit(1);
        }
    }

    private void setLooping(boolean on) throws RemoteException, VisADException {
        this.ca.setOn(on);
        this.start_stop.setText(on ? "Stop" : "Animate");
        this.isLooping = on;
    }
}

