/*
 * Decompiled with CFR 0.152.
 */
package visad.georef;

import java.rmi.RemoteException;
import visad.CommonUnit;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.VisADException;
import visad.browser.Convert;
import visad.georef.LatLonPoint;

public class LatLonTuple
extends RealTuple
implements LatLonPoint {
    private Real lat;
    private Real lon;
    public static final Unit[] DEFAULT_UNITS = new Unit[]{CommonUnit.degree, CommonUnit.degree};

    public LatLonTuple() throws VisADException, RemoteException {
        this(Double.NaN, Double.NaN);
    }

    public LatLonTuple(double lat, double lon) throws VisADException, RemoteException {
        this(new Real(RealType.Latitude, lat), new Real(RealType.Longitude, lon), DEFAULT_UNITS, false);
    }

    public LatLonTuple(Real lat, Real lon) throws VisADException, RemoteException {
        this(lat, lon, null, true);
    }

    public LatLonTuple(Real lat, Real lon, Unit[] units, boolean checkUnits) throws VisADException, RemoteException {
        super(RealTupleType.LatitudeLongitudeTuple, new Real[]{lat, lon}, null, units, checkUnits);
        this.lat = lat;
        this.lon = lon;
    }

    @Override
    public Real getLatitude() {
        return this.lat;
    }

    @Override
    public Real getLongitude() {
        return this.lon;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Lat: ");
        try {
            buf.append(Convert.shortString(this.lat.getValue(CommonUnit.degree)));
        }
        catch (VisADException ve) {
            buf.append(Convert.shortString(this.lat.getValue()));
        }
        buf.append(" Lon: ");
        try {
            buf.append(Convert.shortString(this.lon.getValue(CommonUnit.degree)));
        }
        catch (VisADException ve) {
            buf.append(Convert.shortString(this.lon.getValue()));
        }
        return buf.toString();
    }
}

