/*
 * Decompiled with CFR 0.152.
 */
package visad.data.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.AreaFile;
import edu.wisc.ssec.mcidas.AreaFileException;
import edu.wisc.ssec.mcidas.McIDASException;
import java.awt.geom.Rectangle2D;
import visad.CoordinateSystemException;
import visad.QuickSort;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.MapProjection;

public class AREACoordinateSystem
extends MapProjection {
    private static final long serialVersionUID = 1L;
    protected AREAnav anav = null;
    private int lines;
    private int elements;
    private int[] dirBlock;
    private int[] navBlock;
    private int[] auxBlock;
    private boolean useSpline = true;
    private static Unit[] coordinate_system_units = new Unit[]{null, null};

    public AREACoordinateSystem(AreaFile af) throws VisADException, AreaFileException {
        this(RealTupleType.LatitudeLongitudeTuple, af.getDir(), af.getNav(), af.getAux());
    }

    public AREACoordinateSystem(RealTupleType ref, AreaFile af) throws VisADException, AreaFileException {
        this(ref, af.getDir(), af.getNav(), af.getAux());
    }

    public AREACoordinateSystem(int[] dir, int[] nav) throws VisADException {
        this(RealTupleType.LatitudeLongitudeTuple, dir, nav, null);
    }

    public AREACoordinateSystem(int[] dir, int[] nav, int[] aux) throws VisADException {
        this(dir, nav, aux, true);
    }

    public AREACoordinateSystem(int[] dir, int[] nav, int[] aux, boolean useSpline) throws VisADException {
        this(RealTupleType.LatitudeLongitudeTuple, dir, nav, aux, useSpline);
    }

    public AREACoordinateSystem(RealTupleType reference, int[] dir, int[] nav) throws VisADException {
        this(reference, dir, nav, null);
    }

    public AREACoordinateSystem(RealTupleType reference, int[] dir, int[] nav, int[] aux) throws VisADException {
        this(reference, dir, nav, aux, true);
    }

    protected AREACoordinateSystem() throws VisADException {
        super(RealTupleType.LatitudeLongitudeTuple, coordinate_system_units);
    }

    public AREACoordinateSystem(RealTupleType reference, int[] dir, int[] nav, int[] aux, boolean useSpline) throws VisADException {
        super(reference, coordinate_system_units);
        this.init(dir, nav, aux, useSpline);
    }

    protected AREAnav getAreaNav() {
        return this.anav;
    }

    protected void init(int[] dir, int[] nav, int[] aux, boolean useSpline) throws VisADException {
        try {
            this.anav = AREAnav.makeAreaNav(nav, aux);
        }
        catch (McIDASException excp) {
            throw new CoordinateSystemException("AREACoordinateSystem: problem creating navigation" + excp);
        }
        this.dirBlock = dir;
        this.navBlock = nav;
        this.auxBlock = aux;
        this.useSpline = !useSpline ? false : this.anav.canApproximateWithSpline();
        this.anav.setImageStart(dir[5], dir[6]);
        this.anav.setRes(dir[11], dir[12]);
        this.anav.setStart(0, 0);
        this.anav.setMag(1, 1);
        this.lines = dir[8];
        this.elements = dir[9];
        this.anav.setFlipLineCoordinates(dir[8] - 1);
    }

    public int[] getDirBlock() {
        this.getAreaNav();
        return this.dirBlock;
    }

    public int[] getNavBlock() {
        this.getAreaNav();
        return this.navBlock;
    }

    public int[] getAuxBlock() {
        this.getAreaNav();
        return this.auxBlock;
    }

    public double[] getSubpoint() {
        return this.getAreaNav().getSubpoint();
    }

    public boolean getUseSpline() {
        return this.useSpline;
    }

    @Override
    public double[][] toReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 2) {
            throw new CoordinateSystemException("AREACoordinateSystem.toReference: tuples wrong dimension");
        }
        AREAnav anav = this.getAreaNav();
        if (anav == null) {
            throw new CoordinateSystemException("AREA O & A data not availble");
        }
        double[] mins = new double[2];
        double[] maxs = new double[2];
        int[] nums = new int[2];
        double[][] newval = this.makeSpline(tuples, mins, maxs, nums);
        if (newval != null) {
            double[][] newtrans = anav.toLatLon(newval);
            int len = tuples[0].length;
            double[][] misstrans = new double[2][len];
            int[][] miss_to_trans = new int[1][len];
            double[][] val = this.applySpline(tuples, mins, maxs, nums, newtrans, misstrans, miss_to_trans);
            if (miss_to_trans[0] != null) {
                double[][] newmiss = anav.toLatLon(misstrans);
                for (int i = 0; i < miss_to_trans[0].length; ++i) {
                    val[0][miss_to_trans[0][i]] = newmiss[0][i];
                    val[1][miss_to_trans[0][i]] = newmiss[1][i];
                }
            }
            return val;
        }
        return anav.toLatLon(tuples);
    }

    @Override
    public double[][] fromReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 2) {
            throw new CoordinateSystemException("AREACoordinateSystem.fromReference: tuples wrong dimension");
        }
        AREAnav anav = this.getAreaNav();
        if (anav == null) {
            throw new CoordinateSystemException("AREA O & A data not availble");
        }
        double[] mins = new double[2];
        double[] maxs = new double[2];
        int[] nums = new int[2];
        double[][] newval = this.makeSpline(tuples, mins, maxs, nums);
        if (newval != null) {
            double[][] newtrans = anav.toLinEle(newval);
            int len = tuples[0].length;
            double[][] misstrans = new double[2][len];
            int[][] miss_to_trans = new int[1][len];
            double[][] val = this.applySpline(tuples, mins, maxs, nums, newtrans, misstrans, miss_to_trans);
            if (miss_to_trans[0] != null) {
                double[][] newmiss = anav.toLinEle(misstrans);
                for (int i = 0; i < miss_to_trans[0].length; ++i) {
                    val[0][miss_to_trans[0][i]] = newmiss[0][i];
                    val[1][miss_to_trans[0][i]] = newmiss[1][i];
                }
            }
            return val;
        }
        return anav.toLinEle(tuples);
    }

    @Override
    public float[][] toReference(float[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 2) {
            throw new CoordinateSystemException("AREACoordinateSystem.toReference: tuples wrong dimension");
        }
        AREAnav anav = this.getAreaNav();
        if (anav == null) {
            throw new CoordinateSystemException("AREA O & A data not availble");
        }
        float[][] val = tuples;
        float[] mins = new float[2];
        float[] maxs = new float[2];
        int[] nums = new int[2];
        float[][] newval = this.makeSpline(val, mins, maxs, nums);
        if (newval != null) {
            float[][] newtrans = anav.toLatLon(newval);
            int len = tuples[0].length;
            float[][] misstrans = new float[2][len];
            int[][] miss_to_trans = new int[1][len];
            val = this.applySpline(val, mins, maxs, nums, newtrans, misstrans, miss_to_trans);
            if (miss_to_trans[0] != null) {
                float[][] newmiss = anav.toLatLon(misstrans);
                for (int i = 0; i < miss_to_trans[0].length; ++i) {
                    val[0][miss_to_trans[0][i]] = newmiss[0][i];
                    val[1][miss_to_trans[0][i]] = newmiss[1][i];
                }
            }
        } else {
            val = anav.toLatLon(val);
        }
        return val;
    }

    @Override
    public float[][] fromReference(float[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 2) {
            throw new CoordinateSystemException("AREACoordinateSystem.fromReference: tuples wrong dimension");
        }
        AREAnav anav = this.getAreaNav();
        if (anav == null) {
            throw new CoordinateSystemException("AREA O & A data not availble");
        }
        float[][] val = tuples;
        float[] mins = new float[2];
        float[] maxs = new float[2];
        int[] nums = new int[2];
        float[][] newval = this.makeSpline(val, mins, maxs, nums);
        if (newval != null) {
            float[][] newtrans = anav.toLinEle(newval);
            int len = tuples[0].length;
            float[][] misstrans = new float[2][len];
            int[][] miss_to_trans = new int[1][len];
            val = this.applySpline(val, mins, maxs, nums, newtrans, misstrans, miss_to_trans);
            if (miss_to_trans[0] != null) {
                float[][] newmiss = anav.toLinEle(misstrans);
                for (int i = 0; i < miss_to_trans[0].length; ++i) {
                    val[0][miss_to_trans[0][i]] = newmiss[0][i];
                    val[1][miss_to_trans[0][i]] = newmiss[1][i];
                }
            }
        } else {
            val = anav.toLinEle(val);
        }
        return val;
    }

    private double[][] makeSpline(double[][] val, double[] mins, double[] maxs, int[] nums) throws VisADException {
        if (!this.useSpline) {
            return null;
        }
        int len = val[0].length;
        if (len < 1000) {
            return null;
        }
        double reduction = 10.0;
        if (len < 10000) {
            reduction = 2.0;
        } else if (len < 100000) {
            reduction = 5.0;
        }
        mins[0] = Double.MAX_VALUE;
        maxs[0] = -1.7976931348623157E308;
        mins[1] = Double.MAX_VALUE;
        maxs[1] = -1.7976931348623157E308;
        for (int i = 0; i < len; ++i) {
            if (val[0][i] == val[0][i]) {
                if (val[0][i] < mins[0]) {
                    mins[0] = val[0][i];
                }
                if (val[0][i] > maxs[0]) {
                    maxs[0] = val[0][i];
                }
            }
            if (val[1][i] != val[1][i]) continue;
            if (val[1][i] < mins[1]) {
                mins[1] = val[1][i];
            }
            if (!(val[1][i] > maxs[1])) continue;
            maxs[1] = val[1][i];
        }
        float[] norm = new float[len - 1];
        int k = 0;
        for (int i = 0; i < len - 1; ++i) {
            float n = (float)Math.sqrt((val[0][i] - val[0][i + 1]) * (val[0][i] - val[0][i + 1]) + (val[1][i] - val[1][i + 1]) * (val[1][i] - val[1][i + 1]));
            if (n != n) continue;
            norm[k++] = n;
        }
        if (k < 3) {
            return null;
        }
        float[] nnorm = new float[k];
        System.arraycopy(norm, 0, nnorm, 0, k);
        QuickSort.sort(nnorm);
        double spacing = reduction * (double)nnorm[k / 4];
        nums[0] = (int)((maxs[0] - mins[0]) / spacing) + 1;
        nums[1] = (int)((maxs[1] - mins[1]) / spacing) + 1;
        if (nums[0] < 20 || nums[1] < 20) {
            return null;
        }
        if (nums[0] * nums[1] > len / 4) {
            return null;
        }
        if (nums[0] * nums[1] < 0) {
            return null;
        }
        double spacing0 = (maxs[0] - mins[0]) / (double)(nums[0] - 1);
        double spacing1 = (maxs[1] - mins[1]) / (double)(nums[1] - 1);
        double[][] newval = new double[2][nums[0] * nums[1]];
        k = 0;
        for (int i = 0; i < nums[0]; ++i) {
            for (int j = 0; j < nums[1]; ++j) {
                newval[0][k] = mins[0] + (double)i * spacing0;
                newval[1][k] = mins[1] + (double)j * spacing1;
                ++k;
            }
        }
        return newval;
    }

    private double[][] applySpline(double[][] val, double[] mins, double[] maxs, int[] nums, double[][] newtrans, double[][] misstrans, int[][] miss_to_trans) throws VisADException {
        int n0 = nums[0];
        int n1 = nums[1];
        double spacing0 = (maxs[0] - mins[0]) / (double)(n0 - 1);
        double spacing1 = (maxs[1] - mins[1]) / (double)(n1 - 1);
        int len = val[0].length;
        double[][] trans = new double[2][len];
        boolean[] lon_flags = new boolean[n0 * n1];
        double[] min_trans = new double[]{Double.MAX_VALUE, Double.MAX_VALUE};
        double[] max_trans = new double[]{-1.7976931348623157E308, -1.7976931348623157E308};
        for (int i = 0; i < n0 * n1; ++i) {
            if (newtrans[0][i] == newtrans[0][i]) {
                if (newtrans[0][i] < min_trans[0]) {
                    min_trans[0] = newtrans[0][i];
                }
                if (newtrans[0][i] > max_trans[0]) {
                    max_trans[0] = newtrans[0][i];
                }
            }
            if (newtrans[1][i] == newtrans[1][i]) {
                if (newtrans[1][i] < min_trans[1]) {
                    min_trans[1] = newtrans[1][i];
                }
                if (newtrans[1][i] > max_trans[1]) {
                    max_trans[1] = newtrans[1][i];
                }
            }
            lon_flags[i] = false;
        }
        double minn0n1 = Math.min(n0, n1);
        double mean0 = (max_trans[0] - min_trans[0]) / minn0n1;
        double mean1 = (max_trans[1] - min_trans[1]) / minn0n1;
        for (int i0 = 0; i0 < n0 - 1; ++i0) {
            for (int i1 = 0; i1 < n1 - 1; ++i1) {
                int ii = i1 + i0 * n1;
                if (!(Math.abs(newtrans[0][ii + n1] - newtrans[0][ii]) > 3.0 * mean0 || Math.abs(newtrans[0][ii + 1] - newtrans[0][ii]) > 3.0 * mean0 || Math.abs(newtrans[0][ii + n1 + 1] - newtrans[0][ii + 1]) > 3.0 * mean0 || Math.abs(newtrans[0][ii + n1 + 1] - newtrans[0][ii + n1]) > 3.0 * mean0 || Math.abs(newtrans[1][ii + n1] - newtrans[1][ii]) > 3.0 * mean1 || Math.abs(newtrans[1][ii + 1] - newtrans[1][ii]) > 3.0 * mean1 || Math.abs(newtrans[1][ii + n1 + 1] - newtrans[1][ii + 1]) > 3.0 * mean1) && !(Math.abs(newtrans[1][ii + n1 + 1] - newtrans[1][ii + n1]) > 3.0 * mean1)) continue;
                lon_flags[ii] = true;
            }
        }
        int nmiss = 0;
        for (int i = 0; i < len; ++i) {
            double a0 = (val[0][i] - mins[0]) / spacing0;
            int i0 = (int)a0;
            if (i0 < 0) {
                i0 = 0;
            }
            if (i0 > n0 - 2) {
                i0 = n0 - 2;
            }
            a0 -= (double)i0;
            double a1 = (val[1][i] - mins[1]) / spacing1;
            int i1 = (int)a1;
            if (i1 < 0) {
                i1 = 0;
            }
            if (i1 > n1 - 2) {
                i1 = n1 - 2;
            }
            a1 -= (double)i1;
            int ii = i1 + i0 * n1;
            if (lon_flags[ii]) {
                misstrans[0][nmiss] = val[0][i];
                misstrans[1][nmiss] = val[1][i];
                miss_to_trans[0][nmiss] = i;
                ++nmiss;
                continue;
            }
            trans[0][i] = (1.0 - a0) * ((1.0 - a1) * newtrans[0][ii] + a1 * newtrans[0][ii + 1]) + a0 * ((1.0 - a1) * newtrans[0][ii + n1] + a1 * newtrans[0][ii + n1 + 1]);
            trans[1][i] = (1.0 - a0) * ((1.0 - a1) * newtrans[1][ii] + a1 * newtrans[1][ii + 1]) + a0 * ((1.0 - a1) * newtrans[1][ii + n1] + a1 * newtrans[1][ii + n1 + 1]);
            if (trans[0][i] == trans[0][i] && trans[1][i] == trans[1][i]) continue;
            misstrans[0][nmiss] = val[0][i];
            misstrans[1][nmiss] = val[1][i];
            miss_to_trans[0][nmiss] = i;
            ++nmiss;
        }
        if (nmiss == 0) {
            miss_to_trans[0] = null;
            misstrans[0] = null;
            misstrans[1] = null;
        } else {
            double[] xmisstrans = new double[nmiss];
            System.arraycopy(misstrans[0], 0, xmisstrans, 0, nmiss);
            misstrans[0] = xmisstrans;
            xmisstrans = new double[nmiss];
            System.arraycopy(misstrans[1], 0, xmisstrans, 0, nmiss);
            misstrans[1] = xmisstrans;
            int[] xmiss_to_trans = new int[nmiss];
            System.arraycopy(miss_to_trans[0], 0, xmiss_to_trans, 0, nmiss);
            miss_to_trans[0] = xmiss_to_trans;
        }
        return trans;
    }

    private float[][] makeSpline(float[][] val, float[] mins, float[] maxs, int[] nums) throws VisADException {
        int len = val[0].length;
        if (len < 1000) {
            return null;
        }
        float reduction = 10.0f;
        if (len < 10000) {
            reduction = 2.0f;
        } else if (len < 100000) {
            reduction = 5.0f;
        }
        mins[0] = Float.MAX_VALUE;
        maxs[0] = -3.4028235E38f;
        mins[1] = Float.MAX_VALUE;
        maxs[1] = -3.4028235E38f;
        for (int i = 0; i < len; ++i) {
            if (val[0][i] == val[0][i]) {
                if (val[0][i] < mins[0]) {
                    mins[0] = val[0][i];
                }
                if (val[0][i] > maxs[0]) {
                    maxs[0] = val[0][i];
                }
            }
            if (val[1][i] != val[1][i]) continue;
            if (val[1][i] < mins[1]) {
                mins[1] = val[1][i];
            }
            if (!(val[1][i] > maxs[1])) continue;
            maxs[1] = val[1][i];
        }
        float[] norm = new float[len - 1];
        int k = 0;
        for (int i = 0; i < len - 1; ++i) {
            float n = (float)Math.sqrt((val[0][i] - val[0][i + 1]) * (val[0][i] - val[0][i + 1]) + (val[1][i] - val[1][i + 1]) * (val[1][i] - val[1][i + 1]));
            if (n != n) continue;
            norm[k++] = n;
        }
        if (k < 3) {
            return null;
        }
        float[] nnorm = new float[k];
        System.arraycopy(norm, 0, nnorm, 0, k);
        QuickSort.sort(nnorm);
        float spacing = reduction * nnorm[k / 4];
        nums[0] = (int)((maxs[0] - mins[0]) / spacing) + 1;
        nums[1] = (int)((maxs[1] - mins[1]) / spacing) + 1;
        if (nums[0] < 20 || nums[1] < 20) {
            return null;
        }
        if (nums[0] * nums[1] > len / 4) {
            return null;
        }
        if (nums[0] * nums[1] < 0) {
            return null;
        }
        float spacing0 = (maxs[0] - mins[0]) / (float)(nums[0] - 1);
        float spacing1 = (maxs[1] - mins[1]) / (float)(nums[1] - 1);
        float[][] newval = new float[2][nums[0] * nums[1]];
        k = 0;
        for (int i = 0; i < nums[0]; ++i) {
            for (int j = 0; j < nums[1]; ++j) {
                newval[0][k] = mins[0] + (float)i * spacing0;
                newval[1][k] = mins[1] + (float)j * spacing1;
                ++k;
            }
        }
        return newval;
    }

    private float[][] applySpline(float[][] val, float[] mins, float[] maxs, int[] nums, float[][] newtrans, float[][] misstrans, int[][] miss_to_trans) throws VisADException {
        int n0 = nums[0];
        int n1 = nums[1];
        float spacing0 = (maxs[0] - mins[0]) / (float)(n0 - 1);
        float spacing1 = (maxs[1] - mins[1]) / (float)(n1 - 1);
        int len = val[0].length;
        float[][] trans = new float[2][len];
        boolean[] lon_flags = new boolean[n0 * n1];
        float[] min_trans = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
        float[] max_trans = new float[]{-3.4028235E38f, -3.4028235E38f};
        for (int i = 0; i < n0 * n1; ++i) {
            if (newtrans[0][i] == newtrans[0][i]) {
                if (newtrans[0][i] < min_trans[0]) {
                    min_trans[0] = newtrans[0][i];
                }
                if (newtrans[0][i] > max_trans[0]) {
                    max_trans[0] = newtrans[0][i];
                }
            }
            if (newtrans[1][i] == newtrans[1][i]) {
                if (newtrans[1][i] < min_trans[1]) {
                    min_trans[1] = newtrans[1][i];
                }
                if (newtrans[1][i] > max_trans[1]) {
                    max_trans[1] = newtrans[1][i];
                }
            }
            lon_flags[i] = false;
        }
        float minn0n1 = Math.min(n0, n1);
        float mean0 = (max_trans[0] - min_trans[0]) / minn0n1;
        float mean1 = (max_trans[1] - min_trans[1]) / minn0n1;
        for (int i0 = 0; i0 < n0 - 1; ++i0) {
            for (int i1 = 0; i1 < n1 - 1; ++i1) {
                int ii = i1 + i0 * n1;
                if (!((double)Math.abs(newtrans[0][ii + n1] - newtrans[0][ii]) > 3.0 * (double)mean0 || (double)Math.abs(newtrans[0][ii + 1] - newtrans[0][ii]) > 3.0 * (double)mean0 || (double)Math.abs(newtrans[0][ii + n1 + 1] - newtrans[0][ii + 1]) > 3.0 * (double)mean0 || (double)Math.abs(newtrans[0][ii + n1 + 1] - newtrans[0][ii + n1]) > 3.0 * (double)mean0 || (double)Math.abs(newtrans[1][ii + n1] - newtrans[1][ii]) > 3.0 * (double)mean1 || (double)Math.abs(newtrans[1][ii + 1] - newtrans[1][ii]) > 3.0 * (double)mean1 || (double)Math.abs(newtrans[1][ii + n1 + 1] - newtrans[1][ii + 1]) > 3.0 * (double)mean1) && !((double)Math.abs(newtrans[1][ii + n1 + 1] - newtrans[1][ii + n1]) > 3.0 * (double)mean1)) continue;
                lon_flags[ii] = true;
            }
        }
        int nmiss = 0;
        for (int i = 0; i < len; ++i) {
            float a0 = (val[0][i] - mins[0]) / spacing0;
            int i0 = (int)a0;
            if (i0 < 0) {
                i0 = 0;
            }
            if (i0 > n0 - 2) {
                i0 = n0 - 2;
            }
            a0 -= (float)i0;
            float a1 = (val[1][i] - mins[1]) / spacing1;
            int i1 = (int)a1;
            if (i1 < 0) {
                i1 = 0;
            }
            if (i1 > n1 - 2) {
                i1 = n1 - 2;
            }
            a1 -= (float)i1;
            int ii = i1 + i0 * n1;
            if (lon_flags[ii]) {
                misstrans[0][nmiss] = val[0][i];
                misstrans[1][nmiss] = val[1][i];
                miss_to_trans[0][nmiss] = i;
                ++nmiss;
                continue;
            }
            trans[0][i] = (1.0f - a0) * ((1.0f - a1) * newtrans[0][ii] + a1 * newtrans[0][ii + 1]) + a0 * ((1.0f - a1) * newtrans[0][ii + n1] + a1 * newtrans[0][ii + n1 + 1]);
            trans[1][i] = (1.0f - a0) * ((1.0f - a1) * newtrans[1][ii] + a1 * newtrans[1][ii + 1]) + a0 * ((1.0f - a1) * newtrans[1][ii + n1] + a1 * newtrans[1][ii + n1 + 1]);
            if (trans[0][i] == trans[0][i] && trans[1][i] == trans[1][i]) continue;
            misstrans[0][nmiss] = val[0][i];
            misstrans[1][nmiss] = val[1][i];
            miss_to_trans[0][nmiss] = i;
            ++nmiss;
        }
        if (nmiss == 0) {
            miss_to_trans[0] = null;
            misstrans[0] = null;
            misstrans[1] = null;
        } else {
            float[] xmisstrans = new float[nmiss];
            System.arraycopy(misstrans[0], 0, xmisstrans, 0, nmiss);
            misstrans[0] = xmisstrans;
            xmisstrans = new float[nmiss];
            System.arraycopy(misstrans[1], 0, xmisstrans, 0, nmiss);
            misstrans[1] = xmisstrans;
            int[] xmiss_to_trans = new int[nmiss];
            System.arraycopy(miss_to_trans[0], 0, xmiss_to_trans, 0, nmiss);
            miss_to_trans[0] = xmiss_to_trans;
        }
        return trans;
    }

    @Override
    public Rectangle2D getDefaultMapArea() {
        return new Rectangle2D.Float(0.0f, 0.0f, this.elements, this.lines);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AREACoordinateSystem)) {
            return false;
        }
        AREACoordinateSystem that = (AREACoordinateSystem)obj;
        AREAnav anav = this.getAreaNav();
        return this == that || anav.equals(that.getAreaNav()) && this.lines == that.lines && this.elements == that.elements;
    }

    @Override
    public String toString() {
        if (this.anav == null) {
            return "Image  Projection";
        }
        return "Image (" + this.anav.toString() + ") Projection";
    }
}

