/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.DAS;
import dods.dap.DArray;
import dods.dap.DArrayDimension;
import dods.dap.PrimitiveVector;
import dods.dap.Server.InvalidParameterException;
import java.rmi.RemoteException;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FunctionType;
import visad.GriddedSet;
import visad.IntegerNDSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.SimpleSet;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.FileFlatField;
import visad.data.dods.VariableAdapter;
import visad.data.dods.VariableAdapterFactory;
import visad.data.dods.VectorAccessor;
import visad.data.dods.VectorAdapter;

public class ArrayVariableAdapter
extends VariableAdapter {
    private final FunctionType funcType;
    private final VectorAdapter vectorAdapter;

    private ArrayVariableAdapter(DArray array, DAS das, VariableAdapterFactory factory) throws VisADException, RemoteException {
        this.vectorAdapter = factory.vectorAdapter(array.getPrimitiveVector(), das);
        int rank = array.numDimensions();
        MathType[] realTypes = new RealType[rank];
        for (int i = 0; i < rank; ++i) {
            try {
                realTypes[rank - 1 - i] = RealType.getRealType(array.getDimension(i).getName() + "_ndx");
                continue;
            }
            catch (InvalidParameterException e) {
                throw new BadFormException(this.getClass().getName() + ".<init>: Couldn't get DArray dimension: " + e);
            }
        }
        this.funcType = new FunctionType(ArrayVariableAdapter.mathType(realTypes), this.vectorAdapter.getMathType());
    }

    public static ArrayVariableAdapter arrayVariableAdapter(DArray array, DAS das, VariableAdapterFactory factory) throws VisADException, RemoteException {
        return new ArrayVariableAdapter(array, das, factory);
    }

    @Override
    public MathType getMathType() {
        return this.funcType;
    }

    public FunctionType getFunctionType() {
        return this.funcType;
    }

    @Override
    public SimpleSet[] getRepresentationalSets(boolean copy) {
        return this.vectorAdapter.getRepresentationalSets(copy);
    }

    @Override
    public DataImpl data(DArray array, boolean copy) throws VisADException, RemoteException {
        FieldImpl field;
        RealTupleType domainType = this.funcType.getDomain();
        int rank = domainType.getDimension();
        int[] firsts = new int[rank];
        int[] lasts = new int[rank];
        int[] lengths = new int[rank];
        boolean allIntegerSets = true;
        for (int i = 0; i < rank; ++i) {
            DArrayDimension dim;
            int j = rank - 1 - i;
            try {
                dim = array.getDimension(i);
            }
            catch (InvalidParameterException e) {
                throw new BadFormException(this.getClass().getName() + ".data(DArray,...): Couldn't get DArray dimension: " + e);
            }
            int first = dim.getStart();
            int last = dim.getStop();
            int stride = dim.getStride();
            firsts[j] = first;
            lasts[j] = last;
            lengths[j] = 1 + (last - first) / stride;
            allIntegerSets &= stride == 1 && first == 0 || stride == -1 && last == 0;
        }
        GriddedSet domain = allIntegerSets ? IntegerNDSet.create(domainType, lengths) : (SampledSet)((Object)LinearNDSet.create(domainType, this.doubleArray(firsts), this.doubleArray(lasts), lengths));
        PrimitiveVector vector = array.getPrimitiveVector();
        if (this.vectorAdapter.isFlat()) {
            field = new FileFlatField(new VectorAccessor(this.funcType, this.vectorAdapter, domain, vector), this.getCacheStrategy());
        } else {
            field = new FieldImpl(this.funcType, domain);
            this.vectorAdapter.setField(vector, field, copy);
        }
        return field;
    }

    public void setField(DArray array, FieldImpl field, boolean copy) throws VisADException, RemoteException {
        this.vectorAdapter.setField(array.getPrimitiveVector(), field, copy);
    }

    private double[] doubleArray(int[] ints) {
        double[] doubles = new double[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            doubles[i] = ints[i];
        }
        return doubles;
    }
}

