/*
 * Decompiled with CFR 0.152.
 */
package visad.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import visad.browser.Widget;

public class Slider
extends Component
implements MouseListener,
MouseMotionListener {
    public static final int SLIDER_PREF_HEIGHT = 14;
    public static final int SLIDER_PREF_WIDTH = 300;
    public static final int GRIP_WIDTH = 29;
    public static final int GRIP_HEIGHT = 14;
    public static final int GRIP_TOP_Y = 0;
    public static final int GRIP_BOTTOM_Y = 14;
    public static final int LINE_LEVEL = 7;
    protected int width = 300;
    protected float value = 0.0f;
    protected float minimum = 0.0f;
    protected float maximum = 100.0f;
    private int grip = 0;
    private boolean slide = false;
    private boolean moved = false;
    protected Dimension minSize = null;
    protected Dimension prefSize = null;
    protected Dimension maxSize = null;
    private int gripX;
    private Vector listeners = new Vector();
    private String command = null;

    public Slider() {
    }

    public Slider(float value, float min, float max) {
        this.setBounds(min, max);
        this.setValue(value);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public float getValue() {
        return this.value;
    }

    public float getMinimum() {
        return this.minimum;
    }

    public float getMaximum() {
        return this.maximum;
    }

    public void setValue(float value) {
        this.value = value;
        this.grip = this.valueToGrip(value);
        this.repaint();
    }

    public void setBounds(float min, float max) {
        this.minimum = min;
        this.maximum = max;
        this.repaint();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.width = w;
    }

    private void updateGrip(int x) {
        this.grip = x - this.gripX;
        if (this.grip < 0) {
            this.grip = 0;
        }
        if (this.grip > this.width - 29) {
            this.grip = this.width - 29;
        }
        this.value = this.gripToValue(this.grip);
        this.notifyListeners();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener l) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionListener(ActionListener l) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(l);
        }
    }

    public void setActionCommand(String cmd) {
        this.command = cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners() {
        ActionEvent e = new ActionEvent(this, 1001, this.command);
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ActionListener l = (ActionListener)this.listeners.elementAt(i);
                l.actionPerformed(e);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int y;
        int x = e.getX();
        if (Widget.containedIn(x, y = e.getY(), this.grip, 0, 29, 14)) {
            this.gripX = x - this.grip;
            this.slide = true;
        } else if (Widget.containedIn(x, y, 0, 0, this.grip - 1, 14) || Widget.containedIn(x, y, this.grip + 29, 0, this.width - this.grip - 29, 14)) {
            this.gripX = 14;
            this.slide = true;
            this.updateGrip(x);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.slide = false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.slide) {
            this.updateGrip(x);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            this.minSize = new Dimension(0, 14);
        }
        return this.minSize;
    }

    @Override
    public void setMinimumSize(Dimension dim) {
        this.minSize = dim;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            this.prefSize = new Dimension(300, 14);
        }
        return this.prefSize;
    }

    @Override
    public void setPreferredSize(Dimension dim) {
        this.prefSize = dim;
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.maxSize == null) {
            this.maxSize = new Dimension(Integer.MAX_VALUE, 14);
        }
        return this.maxSize;
    }

    @Override
    public void setMaximumSize(Dimension dim) {
        this.maxSize = dim;
    }

    private float gripToValue(int grip) {
        return (float)grip / (float)(this.width - 29) * (this.maximum - this.minimum) + this.minimum;
    }

    private int valueToGrip(float value) {
        return (int)((value - this.minimum) / (this.maximum - this.minimum) * (float)(this.width - 29));
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Widget.PALE_GRAY);
        g.fillRect(0, 0, this.grip, 7);
        g.fillRect(this.grip + 29, 0, this.width - this.grip - 29, 7);
        g.fillRect(0, 8, this.grip, 6);
        g.fillRect(this.grip + 29, 8, this.width - this.grip - 29, 6);
        g.drawRect(this.grip, 0, 0, 0);
        g.drawRect(this.grip + 29 - 1, 0, 0, 0);
        g.drawRect(this.grip, 13, 0, 0);
        g.drawRect(this.grip + 29 - 1, 13, 0, 0);
        g.fillRect(this.grip + 2, 2, 26, 11);
        g.setColor(Color.black);
        g.drawLine(this.grip + 1, 0, this.grip + 29 - 2, 0);
        g.drawLine(this.grip + 1, 13, this.grip + 29 - 2, 13);
        g.drawLine(this.grip, 1, this.grip, 12);
        g.drawLine(this.grip + 29 - 1, 1, this.grip + 29 - 1, 12);
        g.setColor(Color.white);
        g.drawLine(this.grip + 1, 1, this.grip + 29 - 2, 1);
        g.drawLine(this.grip + 1, 2, this.grip + 1, 12);
        if (this.grip > 0) {
            g.drawLine(0, 7, this.grip - 1, 7);
        }
        g.drawLine(this.grip + 29, 7, this.width, 7);
    }

    @Override
    public void repaint() {
        Graphics g = this.getGraphics();
        if (g != null) {
            this.paint(g);
            g.dispose();
        }
    }

    public static void main(String[] argv) {
        Slider s = new Slider(26.3f, 0.0f, 100.0f);
        Frame f = new Frame("Slider test");
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.add(s);
        f.pack();
        f.setVisible(true);
    }
}

