/*
 * Decompiled with CFR 0.152.
 */
package visad.bom.annotations;

import java.awt.Font;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Font3D;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import visad.PlotText;
import visad.TextControl;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.VisADCanvasJ3D;
import visad.util.HersheyFont;

public class ScreenAnnotatorUtils {
    public static BranchGroup makeJLabelShape3D(DisplayImplJ3D display, String text, int x, int y, float[] colour, Font font, double zValue, double fontSizeInPixels, int align, int path) {
        DisplayRendererJ3D renderer = (DisplayRendererJ3D)display.getDisplayRenderer();
        VisADCanvasJ3D canvas = renderer.getCanvas();
        int[][] screenXY = new int[][]{{x, x}, {y, y - 1}};
        Point3d[] points = ScreenAnnotatorUtils.screenToVworld(screenXY, canvas);
        ScreenAnnotatorUtils.ditherPoints(canvas, 0.4, points);
        ScreenAnnotatorUtils.adjustZ(display, canvas, zValue, points);
        double scale = fontSizeInPixels * (points[1].y - points[0].y) / (double)font.getSize2D();
        Font3D font3D = new Font3D(font, null);
        Text3D text3D = new Text3D(font3D, text, new Point3f(0.0f, 0.0f, 0.0f), align, path);
        ColoringAttributes textColor = new ColoringAttributes();
        textColor.setColor(colour[0], colour[1], colour[2]);
        Appearance textAppearance = new Appearance();
        textAppearance.setColoringAttributes(textColor);
        Shape3D textShape = new Shape3D(text3D, textAppearance);
        Transform3D tMove = new Transform3D();
        tMove.set(new Vector3d(points[0].x, points[0].y, points[0].z));
        Transform3D tScale = new Transform3D();
        tScale.set(scale);
        tMove.mul(tScale);
        TransformGroup tg = new TransformGroup();
        Transform3D t3D = new Transform3D();
        tg.setTransform(tMove);
        tg.addChild(textShape);
        BranchGroup bg = new BranchGroup();
        bg.addChild(tg);
        return bg;
    }

    public static Shape3D makeLabelShape3D(DisplayImplJ3D display, String text, int x, int y, float[] colour, Font font, HersheyFont hfont, double zValue, double scaleFactor, boolean filled, double thickness, double orientation, TextControl.Justification horizontal, TextControl.Justification vertical, double charRotation) throws VisADException {
        Object shape = null;
        DisplayRendererJ3D renderer = (DisplayRendererJ3D)display.getDisplayRenderer();
        VisADCanvasJ3D canvas = renderer.getCanvas();
        Point3d position1 = new Point3d();
        Point3d position2 = new Point3d();
        Point3d position3 = new Point3d();
        canvas.getPixelLocationInImagePlate(x, y, position1);
        canvas.getPixelLocationInImagePlate(x + 1, y, position2);
        double pixelInImagePlate = position2.x - position1.x;
        position2.x = position1.x + pixelInImagePlate * Math.cos(Math.toRadians(orientation));
        position2.y = position1.y + pixelInImagePlate * Math.sin(Math.toRadians(orientation));
        position2.z = position1.z;
        position3.x = position1.x - pixelInImagePlate * Math.sin(Math.toRadians(orientation));
        position3.y = position1.y + pixelInImagePlate * Math.cos(Math.toRadians(orientation));
        position3.z = position1.z;
        Transform3D t = new Transform3D();
        canvas.getImagePlateToVworld(t);
        t.transform(position1);
        t.transform(position2);
        t.transform(position3);
        Point3d[] textStart = new Point3d[]{position1, position2, position3};
        ScreenAnnotatorUtils.ditherPoints(canvas, 0.4, textStart);
        ScreenAnnotatorUtils.adjustZ(display, canvas, zValue, textStart);
        position1 = textStart[0];
        position2 = textStart[1];
        position3 = textStart[2];
        double[] start = new double[]{position1.x, position1.y, position1.z};
        double[] base = new double[]{position2.x - position1.x, position2.y - position1.y, position2.z - position1.z};
        double[] up = new double[]{position3.x - position1.x, position3.y - position1.y, position3.z - position1.z};
        for (int i = 0; i < 3; ++i) {
            up[i] = scaleFactor * up[i];
            base[i] = scaleFactor * base[i];
        }
        double[] offset = new double[]{0.0, 0.0, 0.0};
        VisADGeometryArray array = null;
        array = font != null ? (charRotation == 0.0 ? PlotText.render_font(text, font, start, base, up, horizontal, vertical) : PlotText.render_font(text, font, start, base, up, horizontal, vertical, charRotation, 1.0, offset)) : (hfont != null ? (charRotation == 0.0 ? PlotText.render_font(text, hfont, start, base, up, horizontal, vertical) : PlotText.render_font(text, hfont, start, base, up, horizontal, vertical, charRotation, 1.0, offset)) : (charRotation == 0.0 ? PlotText.render_label(text, start, base, up, horizontal, vertical) : PlotText.render_label(text, start, base, up, horizontal, vertical, charRotation, 1.0, offset)));
        GeometryArray geom = display.makeGeometry(array);
        Appearance appearance = new Appearance();
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        coloringAttributes.setColor(colour[0], colour[1], colour[2]);
        appearance.setColoringAttributes(coloringAttributes);
        LineAttributes lineAttributes = new LineAttributes();
        lineAttributes.setLineWidth((float)thickness);
        appearance.setLineAttributes(lineAttributes);
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCullFace(0);
        if (filled) {
            polygonAttributes.setPolygonMode(2);
        } else {
            polygonAttributes.setPolygonMode(1);
        }
        appearance.setPolygonAttributes(polygonAttributes);
        return new Shape3D(geom, appearance);
    }

    public static void adjustZ(DisplayImplJ3D display, Canvas3D canvas, double z, Point3d[] points) {
        if (display.getGraphicsModeControl().getProjectionPolicy() == 1) {
            Point3d leftEye = new Point3d();
            Point3d rightEye = new Point3d();
            canvas.getLeftEyeInImagePlate(leftEye);
            canvas.getRightEyeInImagePlate(rightEye);
            double xLoc = (leftEye.x + rightEye.x) / 2.0;
            double yLoc = (leftEye.y + rightEye.y) / 2.0;
            double zLoc = (leftEye.z + rightEye.z) / 2.0;
            Point3d eye = new Point3d(xLoc, yLoc, zLoc);
            Transform3D t = new Transform3D();
            canvas.getImagePlateToVworld(t);
            t.transform(eye);
            for (int i = 0; i < points.length; ++i) {
                double a = (z - points[i].z) / (eye.z - points[i].z);
                points[i].x = a * (eye.x - points[i].x) + points[i].x;
                points[i].y = a * (eye.y - points[i].y) + points[i].y;
                points[i].z = z;
            }
        } else {
            for (int i = 0; i < points.length; ++i) {
                points[i].z = z;
            }
        }
    }

    public static Shape3D makeQuadrilateralShape3D(DisplayImplJ3D display, int style, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, float[] colour, double z, double thickness) {
        DisplayRendererJ3D renderer = (DisplayRendererJ3D)display.getDisplayRenderer();
        VisADCanvasJ3D canvas = renderer.getCanvas();
        int[][] screenXY = new int[][]{{x1, x2, x3, x4}, {y1, y2, y3, y4}};
        Point3d[] points = ScreenAnnotatorUtils.screenToVworld(screenXY, canvas);
        ScreenAnnotatorUtils.ditherPoints(canvas, 0.4, points);
        ScreenAnnotatorUtils.adjustZ(display, canvas, z, points);
        QuadArray quadArray = new QuadArray(points.length, 1);
        quadArray.setCoordinates(0, points);
        PointAttributes pointAttributes = new PointAttributes();
        pointAttributes.setPointSize((float)thickness);
        LineAttributes lineAttributes = new LineAttributes();
        lineAttributes.setLineWidth((float)thickness);
        PolygonAttributes pointPolygon = new PolygonAttributes();
        pointPolygon.setCullFace(0);
        if (style == 1) {
            pointPolygon.setPolygonMode(0);
        } else if (style == 2) {
            pointPolygon.setPolygonMode(1);
        } else {
            pointPolygon.setPolygonMode(2);
        }
        ColoringAttributes pointColor = new ColoringAttributes();
        pointColor.setColor(colour[0], colour[1], colour[2]);
        Appearance pointAppearance = new Appearance();
        pointAppearance.setPointAttributes(pointAttributes);
        pointAppearance.setLineAttributes(lineAttributes);
        pointAppearance.setPolygonAttributes(pointPolygon);
        pointAppearance.setColoringAttributes(pointColor);
        return new Shape3D(quadArray, pointAppearance);
    }

    public static Shape3D makeTriangleShape3D(DisplayImplJ3D display, int style, int x1, int y1, int x2, int y2, int x3, int y3, float[] colour, double z, double thickness) {
        DisplayRendererJ3D renderer = (DisplayRendererJ3D)display.getDisplayRenderer();
        VisADCanvasJ3D canvas = renderer.getCanvas();
        int[][] screenXY = new int[][]{{x1, x2, x3}, {y1, y2, y3}};
        Point3d[] points = ScreenAnnotatorUtils.screenToVworld(screenXY, canvas);
        ScreenAnnotatorUtils.ditherPoints(canvas, 0.4, points);
        ScreenAnnotatorUtils.adjustZ(display, canvas, z, points);
        TriangleArray triangleArray = new TriangleArray(points.length, 1);
        triangleArray.setCoordinates(0, points);
        PointAttributes pointAttributes = new PointAttributes();
        pointAttributes.setPointSize((float)thickness);
        LineAttributes lineAttributes = new LineAttributes();
        lineAttributes.setLineWidth((float)thickness);
        PolygonAttributes pointPolygon = new PolygonAttributes();
        pointPolygon.setCullFace(0);
        if (style == 1) {
            pointPolygon.setPolygonMode(0);
        } else if (style == 2) {
            pointPolygon.setPolygonMode(1);
        } else {
            pointPolygon.setPolygonMode(2);
        }
        ColoringAttributes pointColor = new ColoringAttributes();
        pointColor.setColor(colour[0], colour[1], colour[2]);
        Appearance pointAppearance = new Appearance();
        pointAppearance.setPointAttributes(pointAttributes);
        pointAppearance.setLineAttributes(lineAttributes);
        pointAppearance.setPolygonAttributes(pointPolygon);
        pointAppearance.setColoringAttributes(pointColor);
        return new Shape3D(triangleArray, pointAppearance);
    }

    public static Shape3D makeLineShape3D(DisplayImplJ3D display, int style, int x1, int y1, int x2, int y2, float[] colour, double z, double thickness) {
        DisplayRendererJ3D renderer = (DisplayRendererJ3D)display.getDisplayRenderer();
        VisADCanvasJ3D canvas = renderer.getCanvas();
        int[][] screenXY = new int[][]{{x1, x2}, {y1, y2}};
        Point3d[] points = ScreenAnnotatorUtils.screenToVworld(screenXY, canvas);
        ScreenAnnotatorUtils.ditherPoints(canvas, 0.4, points);
        ScreenAnnotatorUtils.adjustZ(display, canvas, z, points);
        LineArray lineArray = new LineArray(points.length, 1);
        lineArray.setCoordinates(0, points);
        PointAttributes pointAttributes = new PointAttributes();
        pointAttributes.setPointSize((float)thickness);
        LineAttributes lineAttributes = new LineAttributes();
        lineAttributes.setLineWidth((float)thickness);
        if (style == 4) {
            lineAttributes.setLinePattern(0);
        } else if (style == 5) {
            lineAttributes.setLinePattern(1);
        } else if (style == 6) {
            lineAttributes.setLinePattern(2);
        } else if (style == 7) {
            lineAttributes.setLinePattern(3);
        }
        ColoringAttributes pointColor = new ColoringAttributes();
        pointColor.setColor(colour[0], colour[1], colour[2]);
        Appearance pointAppearance = new Appearance();
        pointAppearance.setPointAttributes(pointAttributes);
        pointAppearance.setLineAttributes(lineAttributes);
        pointAppearance.setColoringAttributes(pointColor);
        return new Shape3D(lineArray, pointAppearance);
    }

    public static Shape3D makePointShape3D(DisplayImplJ3D display, int x1, int y1, float[] colour, double z, double thickness) {
        DisplayRendererJ3D renderer = (DisplayRendererJ3D)display.getDisplayRenderer();
        VisADCanvasJ3D canvas = renderer.getCanvas();
        int[][] screenXY = new int[][]{{x1}, {y1}};
        Point3d[] points = ScreenAnnotatorUtils.screenToVworld(screenXY, canvas);
        ScreenAnnotatorUtils.ditherPoints(canvas, 0.4, points);
        ScreenAnnotatorUtils.adjustZ(display, canvas, z, points);
        PointArray pointArray = new PointArray(points.length, 1);
        pointArray.setCoordinates(0, points);
        PointAttributes pointAttributes = new PointAttributes();
        pointAttributes.setPointSize((float)thickness);
        ColoringAttributes pointColor = new ColoringAttributes();
        pointColor.setColor(colour[0], colour[1], colour[2]);
        Appearance pointAppearance = new Appearance();
        pointAppearance.setPointAttributes(pointAttributes);
        pointAppearance.setColoringAttributes(pointColor);
        return new Shape3D(pointArray, pointAppearance);
    }

    public static Point3d[] screenToVworld(int[][] screenXY, Canvas3D canvas) {
        int numPoints = screenXY[0].length;
        Point3d[] points = new Point3d[numPoints];
        Transform3D t = new Transform3D();
        canvas.getImagePlateToVworld(t);
        for (int i = 0; i < numPoints; ++i) {
            points[i] = new Point3d();
            canvas.getPixelLocationInImagePlate(screenXY[0][i], screenXY[1][i], points[i]);
            t.transform(points[i]);
        }
        return points;
    }

    public static int[][] vworldToScreen(Point3d[] points, Canvas3D canvas) {
        int numPoints = points.length;
        Point2d point2d = new Point2d();
        Point3d point3d = new Point3d();
        int[][] screenXY = new int[2][numPoints];
        Transform3D t = new Transform3D();
        canvas.getVworldToImagePlate(t);
        for (int j = 0; j < numPoints; ++j) {
            point3d.x = points[j].x;
            point3d.y = points[j].y;
            point3d.z = points[j].z;
            t.transform(point3d);
            canvas.getPixelLocationFromImagePlate(point3d, point2d);
            screenXY[0][j] = (int)point2d.x;
            screenXY[1][j] = (int)point2d.y;
        }
        return screenXY;
    }

    public static void ditherPoints(Canvas3D canvas, double frac, Point3d[] points) {
        if (frac < 0.1) {
            frac = 0.1;
        }
        if (frac > 0.9) {
            frac = 0.9;
        }
        Point3d p1 = new Point3d();
        Point3d p2 = new Point3d();
        Point3d p3 = new Point3d();
        canvas.getPixelLocationInImagePlate(1, 1, p1);
        canvas.getPixelLocationInImagePlate(2, 1, p2);
        canvas.getPixelLocationInImagePlate(1, 2, p3);
        Transform3D t = new Transform3D();
        canvas.getImagePlateToVworld(t);
        t.transform(p1);
        t.transform(p2);
        t.transform(p3);
        double deltaX = p2.x - p1.x;
        double deltaY = p1.y - p3.y;
        for (int i = 0; i < points.length; ++i) {
            points[i].x += frac * deltaX;
            points[i].y -= frac * deltaY;
        }
    }

    public static Shape3D makeImageShape3D(DisplayImplJ3D display, Image image, int position, int x, int y, int width, int height, double zValue, double scale) throws VisADException {
        int index = 0;
        int ind = 0;
        DisplayRendererJ3D renderer = (DisplayRendererJ3D)display.getDisplayRenderer();
        VisADCanvasJ3D canvas = renderer.getCanvas();
        int scaledWidth = Math.round((float)((double)width * scale));
        int scaledHeight = Math.round((float)((double)height * scale));
        double scaleW = (double)scaledWidth / (double)width;
        double scaleH = (double)scaledHeight / (double)height;
        if (position == 21) {
            x -= scaledWidth - 1;
        } else if (position == 22) {
            x -= scaledWidth - 1;
            y -= scaledHeight - 1;
        } else if (position == 23) {
            y -= scaledHeight - 1;
        } else if (position == 24) {
            x -= (scaledWidth - 1) / 2;
            y -= (scaledHeight - 1) / 2;
        }
        Transform3D t = new Transform3D();
        canvas.getImagePlateToVworld(t);
        index = 0;
        Point3d[] points = new Point3d[scaledWidth * scaledHeight];
        for (int i = 0; i < scaledHeight; ++i) {
            for (int j = 0; j < scaledWidth; ++j) {
                points[index] = new Point3d();
                canvas.getPixelLocationInImagePlate(x + j, y + i, points[index]);
                t.transform(points[index]);
                ++index;
            }
        }
        ScreenAnnotatorUtils.ditherPoints(canvas, 0.4, points);
        ScreenAnnotatorUtils.adjustZ(display, canvas, zValue, points);
        int[] pixels = new int[width * height];
        PixelGrabber pixelGrabber = new PixelGrabber(image.getSource(), 0, 0, width, height, pixels, 0, width);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException ie) {
            throw new VisADException("ScreenAnnotatorUtils.makeImageShape3D(): failed to grabPixels()");
        }
        float[] colours = new float[4 * scaledWidth * scaledHeight];
        ind = 0;
        index = 0;
        ColorModel cm = pixelGrabber.getColorModel();
        for (int i = 0; i < scaledHeight; ++i) {
            for (int j = 0; j < scaledWidth; ++j) {
                ind = (int)((double)j / scaleW) + width * (int)((double)i / scaleH);
                colours[4 * index] = (float)cm.getRed(pixels[ind]) / 255.0f;
                colours[4 * index + 1] = (float)cm.getGreen(pixels[ind]) / 255.0f;
                colours[4 * index + 2] = (float)cm.getBlue(pixels[ind]) / 255.0f;
                colours[4 * index + 3] = (float)cm.getAlpha(pixels[ind]) / 255.0f;
                ++index;
            }
        }
        PointArray picture = new PointArray(scaledWidth * scaledHeight, 13);
        picture.setCoordinates(0, points);
        picture.setColors(0, colours);
        Appearance appearance = new Appearance();
        appearance.setTransparencyAttributes(new TransparencyAttributes(0, 0.0f));
        return new Shape3D(picture, appearance);
    }
}

