/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.Data;
import visad.DataShadow;
import visad.Scalar;
import visad.ShadowType;
import visad.TextType;
import visad.TypeException;
import visad.VisADException;

public class Text
extends Scalar {
    private String Value;

    public Text(TextType type) throws VisADException {
        super(type);
        if (!(type instanceof TextType)) {
            throw new TypeException("Text: bad type");
        }
        this.Value = null;
    }

    public Text(TextType type, String value) throws VisADException {
        super(type);
        if (!(type instanceof TextType)) {
            throw new TypeException("Text: bad type");
        }
        this.Value = value;
    }

    public Text(String value) {
        super(TextType.Generic);
        this.Value = value;
    }

    public String getValue() {
        return this.Value;
    }

    @Override
    public boolean isMissing() {
        return this.Value == null;
    }

    @Override
    public Data binary(Data data, int op, int sampling_mode, int error_mode) throws VisADException {
        if (data instanceof Text && op == 1) {
            return new Text((TextType)this.Type, this.Value + ((Text)data).getValue());
        }
        throw new TypeException("Text.binary: types don't match");
    }

    @Override
    public Data unary(int op, int sampling_mode, int error_mode) throws VisADException {
        throw new TypeException("Text.unary");
    }

    @Override
    public DataShadow computeRanges(ShadowType type, DataShadow shadow) throws VisADException {
        return shadow;
    }

    @Override
    public String toString() {
        return this.Value;
    }

    @Override
    public String longString(String pre) {
        return pre + "Text: Value = " + this.Value + "  (TypeName = " + ((TextType)this.Type).getName() + ")\n";
    }

    public int compareTo(Object object) {
        return this.getValue().compareTo(((Text)object).getValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Text)) {
            return false;
        }
        String objValue = ((Text)obj).getValue();
        if (this.Value == null) {
            return objValue == null;
        }
        if (objValue == null) {
            return false;
        }
        return objValue.equals(this.Value);
    }
}

