/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.ConstantMap;
import visad.ScalarMap;
import visad.VisADEvent;

public class ScalarMapEvent
extends VisADEvent {
    public static final int UNKNOWN = 0;
    public static final int AUTO_SCALE = 1;
    public static final int MANUAL = 2;
    public static final int CONTROL_ADDED = 3;
    public static final int CONTROL_REMOVED = 4;
    public static final int CONTROL_REPLACED = 5;
    private int id = 0;
    private ScalarMap map;

    public ScalarMapEvent(ScalarMap map, int id) {
        this(map, id, 0);
    }

    public ScalarMapEvent(ScalarMap map, int id, int remoteId) {
        super(null, 0, null, remoteId);
        this.map = map;
        this.id = id;
    }

    public ScalarMapEvent(ScalarMap map, boolean auto) {
        super(null, 0, null, 0);
        this.map = map;
        this.id = auto ? 1 : 2;
    }

    public ScalarMap getScalarMap() {
        return this.map;
    }

    public int getId() {
        return this.id;
    }

    public String getIdString() {
        switch (this.id) {
            case 1: {
                return "AUTO_SCALE";
            }
            case 2: {
                return "MANUAL";
            }
            case 3: {
                return "CONTROL_ADDED";
            }
            case 4: {
                return "CONTROL_REMOVED";
            }
            case 5: {
                return "CONTROL_REPLACED";
            }
        }
        return "UNKNOWN_ID=" + this.id;
    }

    String getMapString() {
        StringBuffer buf = new StringBuffer();
        if (this.map instanceof ConstantMap) {
            buf.append(((ConstantMap)this.map).getConstant());
        } else {
            buf.append(this.map.getScalar());
        }
        buf.append("->");
        buf.append(this.map.getDisplayScalar());
        return buf.toString();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer("ScalarMapEvent[");
        buf.append(this.getIdString());
        buf.append(", ");
        buf.append(this.getMapString());
        buf.append(']');
        return buf.toString();
    }
}

