/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.StringTokenizer;
import visad.Control;
import visad.DataRenderer;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.VisADException;
import visad.browser.Convert;
import visad.util.Util;

public abstract class ProjectionControl
extends Control {
    protected double[] matrix = null;
    private double[] savedProjectionMatrix = null;
    private double[] asp = new double[]{1.0, 1.0, 1.0};
    public static final int MATRIX2D_LENGTH = 6;
    public static final int MATRIX2D_MAJOR = 3;
    public static final int MATRIX2D_MINOR = 2;
    public static final int MATRIX3D_LENGTH = 16;
    public static final int MATRIX3D_MAJOR = 4;
    public static final int MATRIX3D_MINOR = 4;
    public static final double SCALE2D = 0.65;
    public static final double INVSCALE2D = 1.5384615384615383;

    public ProjectionControl(DisplayImpl d) throws VisADException {
        super(d);
        if (d.getProjectionControl() != null) {
            throw new DisplayException("display already has a ProjectionControl");
        }
    }

    public double[] getMatrix() {
        double[] c = new double[this.matrix.length];
        System.arraycopy(this.matrix, 0, c, 0, this.matrix.length);
        return c;
    }

    public void setMatrix(double[] m) throws VisADException, RemoteException {
        if (m == null) {
            return;
        }
        if (m.length != this.matrix.length) {
            throw new DisplayException("setMatrix: input length must be " + this.matrix.length);
        }
        System.arraycopy(m, 0, this.matrix, 0, this.matrix.length);
    }

    @Override
    public String getSaveString() {
        int minor;
        int major;
        int len = this.matrix.length;
        if (len == 6) {
            major = 3;
            minor = 2;
        } else if (len == 16) {
            major = 4;
            minor = 4;
        } else {
            major = len;
            minor = 1;
        }
        StringBuffer sb = new StringBuffer(25 * len);
        sb.append(major);
        if (minor > 1) {
            sb.append(" x ");
            sb.append(minor);
        }
        sb.append('\n');
        for (int j = 0; j < minor; ++j) {
            for (int i = 0; i < major; ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(this.matrix[major * j + i]);
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public void setSaveString(String save) throws VisADException, RemoteException {
        if (save == null) {
            throw new VisADException("Invalid save string");
        }
        int eol = save.indexOf(10);
        if (eol < 0) {
            throw new VisADException("Invalid save string");
        }
        StringTokenizer st = new StringTokenizer(save.substring(0, eol));
        int numTokens = st.countTokens();
        int size = -1;
        if (numTokens == 3) {
            int len = Convert.getInt(st.nextToken());
            if (len < 1) {
                throw new VisADException("First matrix dimension is not positive");
            }
            if (!st.nextToken().equalsIgnoreCase("x")) {
                throw new VisADException("Invalid save string");
            }
            int len0 = Convert.getInt(st.nextToken());
            if (len0 < 1) {
                throw new VisADException("Second matrix dimension is not positive");
            }
            size = len * len0;
        } else if (numTokens == 1) {
            size = Convert.getInt(st.nextToken());
            if (size < 1) {
                throw new VisADException("Matrix size is not positive");
            }
        } else {
            throw new VisADException("Cannot determine matrix size");
        }
        st = new StringTokenizer(save.substring(eol + 1));
        numTokens = st.countTokens();
        if (numTokens < size) {
            throw new VisADException("Not enough matrix entries");
        }
        double[] m = new double[size];
        for (int i = 0; i < size; ++i) {
            m[i] = Convert.getDouble(st.nextToken());
        }
        this.setMatrix(m);
    }

    public abstract void setAspect(double[] var1) throws VisADException, RemoteException;

    public void setAspectCartesian(double[] aspect) throws VisADException, RemoteException {
        if (aspect != null) {
            for (int i = 0; i < aspect.length; ++i) {
                if (aspect[i] <= 0.0) {
                    throw new DisplayException("aspect must be positive");
                }
                this.asp[i] = aspect[i];
            }
        }
        this.getDisplay().setAspectCartesian(this.asp);
    }

    public double[] getAspectCartesian() {
        return (double[])this.asp.clone();
    }

    public void saveProjection() {
        this.savedProjectionMatrix = this.getMatrix();
    }

    public double[] getSavedProjectionMatrix() {
        double[] c = new double[this.savedProjectionMatrix.length];
        System.arraycopy(this.savedProjectionMatrix, 0, c, 0, this.savedProjectionMatrix.length);
        return c;
    }

    public void resetProjection() throws VisADException, RemoteException {
        this.setMatrix(this.savedProjectionMatrix);
    }

    public static double[] matrix2DTo3D(double[] matrix) throws VisADException {
        if (matrix.length != 6) {
            throw new DisplayException("matrix2DTo3D: input length must be 6");
        }
        double[] mat = new double[16];
        for (int i = 0; i < 16; ++i) {
            mat[i] = 0.0;
        }
        mat[0] = 0.65 * matrix[0];
        mat[1] = 0.65 * matrix[2];
        mat[3] = matrix[4];
        mat[4] = 0.65 * matrix[1];
        mat[5] = -0.65 * matrix[3];
        mat[7] = -matrix[5];
        mat[10] = 1.0;
        mat[15] = 1.0;
        return mat;
    }

    public static double[] matrix3DTo2D(double[] matrix) throws VisADException {
        if (matrix.length != 16) {
            throw new DisplayException("matrix3DTo2D: input length must be 16");
        }
        double[] mat = new double[]{1.5384615384615383 * matrix[0], 1.5384615384615383 * matrix[4], 1.5384615384615383 * matrix[1], -1.5384615384615383 * matrix[5], matrix[3], -matrix[7]};
        return mat;
    }

    public static double[] matrixDConvert(double[] matrix) throws VisADException {
        if (matrix.length == 16) {
            return ProjectionControl.matrix3DTo2D(matrix);
        }
        if (matrix.length == 6) {
            return ProjectionControl.matrix2DTo3D(matrix);
        }
        throw new DisplayException("matrixDConvert: input length must be 16 or 6");
    }

    public void clearSwitches(DataRenderer re) {
    }

    private boolean matrixEquals(double[] newMatrix) {
        if (this.matrix == null) {
            if (newMatrix != null) {
                return false;
            }
        } else {
            if (newMatrix == null) {
                return false;
            }
            if (this.matrix.length != newMatrix.length) {
                return false;
            }
            for (int i = 0; i < this.matrix.length; ++i) {
                if (Util.isApproximatelyEqual(this.matrix[i], newMatrix[i])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean aspEquals(double[] newAsp) {
        if (this.asp == null) {
            if (newAsp != null) {
                return false;
            }
        } else {
            if (newAsp == null) {
                return false;
            }
            if (this.asp.length != newAsp.length) {
                return false;
            }
            for (int i = 0; i < this.asp.length; ++i) {
                if (Util.isApproximatelyEqual(this.asp[i], newAsp[i])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void syncControl(Control rmt) throws VisADException {
        if (rmt == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(rmt instanceof ProjectionControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + rmt.getClass().getName());
        }
        ProjectionControl pc = (ProjectionControl)rmt;
        if (!this.matrixEquals(pc.matrix)) {
            try {
                this.setMatrix(pc.matrix);
            }
            catch (RemoteException re) {
                throw new VisADException("Could not set matrix: " + re.getMessage());
            }
        }
        if (!this.aspEquals(pc.asp)) {
            try {
                this.setAspectCartesian(pc.asp);
            }
            catch (RemoteException re) {
                throw new VisADException("Could not setAspectCartesian: " + re.getMessage());
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ProjectionControl pc = (ProjectionControl)o;
        if (!this.matrixEquals(pc.matrix)) {
            return false;
        }
        return this.aspEquals(pc.asp);
    }

    @Override
    public Object clone() {
        ProjectionControl pc = (ProjectionControl)super.clone();
        if (this.matrix != null) {
            pc.matrix = (double[])this.matrix.clone();
        }
        if (this.asp != null) {
            pc.asp = (double[])this.asp.clone();
        }
        return pc;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer("ProjectionControl[");
        if (this.matrix == null) {
            buf.append("null");
        } else {
            int minor;
            int major;
            if (this.matrix.length == 6) {
                major = 3;
                minor = 2;
            } else if (this.matrix.length == 16) {
                major = 4;
                minor = 4;
            } else {
                major = 1;
                minor = this.matrix.length;
            }
            int offset = 0;
            for (int i = 0; i < major; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                for (int j = 0; j < minor; ++j) {
                    buf.append(j == 0 ? (char)'(' : ',');
                    buf.append(this.matrix[offset + j]);
                }
                buf.append(')');
                offset += minor;
            }
        }
        buf.append(']');
        return buf.toString();
    }
}

