/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.InputStreamReader;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SetException;
import visad.Unit;
import visad.VisADException;

public class Gridded2DSet
extends GriddedSet {
    int LengthX;
    int LengthY;
    float LowX;
    float HiX;
    float LowY;
    float HiY;

    public Gridded2DSet(MathType type, float[][] samples, int lengthX, int lengthY) throws VisADException {
        this(type, samples, lengthX, lengthY, null, null, null);
    }

    public Gridded2DSet(MathType type, float[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, lengthX, lengthY, coord_sys, units, errors, true, true);
    }

    public Gridded2DSet(MathType type, float[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        this(type, samples, lengthX, lengthY, coord_sys, units, errors, copy, true);
    }

    public Gridded2DSet(MathType type, float[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy, boolean test) throws VisADException {
        super(type, samples, Gridded2DSet.make_lengths(lengthX, lengthY), coord_sys, units, errors, copy);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LengthX = this.Lengths[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.LengthY = this.Lengths[1];
        float[][] mySamples = this.getMySamples();
        if (mySamples != null && this.Lengths[0] > 1 && this.Lengths[1] > 1) {
            float xpos = (mySamples[0][1] - mySamples[0][0]) * (mySamples[1][this.LengthX + 1] - mySamples[1][1]) - (mySamples[1][1] - mySamples[1][0]) * (mySamples[0][this.LengthX + 1] - mySamples[0][1]);
            boolean bl = this.Pos = xpos > 0.0f;
            if (test) {
                if (xpos == 0.0f) {
                    throw new SetException("Gridded2DSet: samples do not form a valid grid");
                }
                for (int i = 0; i < this.Length; ++i) {
                    if (mySamples[0][i] == mySamples[0][i]) continue;
                    throw new SetException("Gridded2DSet: samples value #" + i + " may not be missing");
                }
                float[] v00 = new float[2];
                float[] v10 = new float[2];
                float[] v01 = new float[2];
                float[] v11 = new float[2];
                for (int j = 0; j < this.LengthY - 1; ++j) {
                    for (int i = 0; i < this.LengthX - 1; ++i) {
                        for (int v = 0; v < 2; ++v) {
                            v00[v] = mySamples[v][j * this.LengthX + i];
                            v10[v] = mySamples[v][j * this.LengthX + i + 1];
                            v01[v] = mySamples[v][(j + 1) * this.LengthX + i];
                            v11[v] = mySamples[v][(j + 1) * this.LengthX + i + 1];
                        }
                        float w1 = (v10[0] - v00[0]) * (v11[1] - v10[1]) - (v10[1] - v00[1]) * (v11[0] - v10[0]);
                        float w2 = (v11[0] - v10[0]) * (v01[1] - v11[1]) - (v11[1] - v10[1]) * (v01[0] - v11[0]);
                        float w3 = (v01[0] - v11[0]) * (v00[1] - v01[1]) - (v01[1] - v11[1]) * (v00[0] - v01[0]);
                        float w4 = (v00[0] - v01[0]) * (v10[1] - v00[1]) - (v00[1] - v01[1]) * (v10[0] - v00[0]);
                        if (w1 > 0.0f == this.Pos && w1 != 0.0f && w2 > 0.0f == this.Pos && w2 != 0.0f && w3 > 0.0f == this.Pos && w3 != 0.0f && w4 > 0.0f == this.Pos && w4 != 0.0f) continue;
                        throw new SetException("Gridded2DSet: samples do not form a valid grid (" + i + "," + j + ")");
                    }
                }
            }
        }
    }

    public Gridded2DSet(MathType type, float[][] samples, int lengthX) throws VisADException {
        this(type, samples, lengthX, null, null, null);
    }

    public Gridded2DSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, lengthX, coord_sys, units, errors, true);
    }

    public Gridded2DSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        super(type, samples, Gridded1DSet.make_lengths(lengthX), coord_sys, units, errors, copy);
        if (this.DomainDimension != 2) {
            throw new SetException("Gridded2DSet Domain dimension should be 2, not " + this.DomainDimension);
        }
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LengthX = this.Lengths[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
    }

    static int[] make_lengths(int lengthX, int lengthY) {
        int[] lens = new int[]{lengthX, lengthY};
        return lens;
    }

    @Override
    public float[][] indexToValue(int[] index) throws VisADException {
        int length = index.length;
        float[][] mySamples = this.getMySamples();
        if (mySamples == null) {
            float[][] grid = new float[this.ManifoldDimension][length];
            for (int i = 0; i < length; ++i) {
                int indexY;
                int indexX;
                if (0 <= index[i] && index[i] < this.Length) {
                    indexX = index[i] % this.LengthX;
                    indexY = index[i] / this.LengthX;
                } else {
                    indexX = -1;
                    indexY = -1;
                }
                grid[0][i] = indexX;
                grid[1][i] = indexY;
            }
            return this.gridToValue(grid);
        }
        float[][] values = new float[2][length];
        for (int i = 0; i < length; ++i) {
            if (0 <= index[i] && index[i] < this.Length) {
                values[0][i] = mySamples[0][index[i]];
                values[1][i] = mySamples[1][index[i]];
                continue;
            }
            values[0][i] = Float.NaN;
            values[1][i] = Float.NaN;
        }
        return values;
    }

    @Override
    public int[] valueToIndex(float[][] value) throws VisADException {
        if (value.length != this.DomainDimension) {
            throw new SetException("Gridded2DSet.valueToIndex: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        int[] index = new int[length];
        float[][] grid = this.valueToGrid(value);
        float[] grid0 = grid[0];
        float[] grid1 = grid[1];
        for (int i = 0; i < length; ++i) {
            float g0 = grid0[i];
            float g1 = grid1[i];
            index[i] = g0 != g0 || g1 != g1 ? -1 : (int)((double)g0 + 0.5) + this.LengthX * (int)((double)g1 + 0.5);
        }
        return index;
    }

    @Override
    public float[][] gridToValue(float[][] grid) throws VisADException {
        if (grid.length != this.ManifoldDimension) {
            throw new SetException("Gridded2DSet.gridToValue: grid dimension " + grid.length + " not equal to Manifold dimension " + this.ManifoldDimension);
        }
        if (this.ManifoldDimension < 2) {
            throw new SetException("Gridded2DSet.gridToValue: Manifold dimension must be 2, not " + this.ManifoldDimension);
        }
        if (this.Length > 1 && (this.Lengths[0] < 2 || this.Lengths[1] < 2)) {
            throw new SetException("Gridded2DSet.gridToValue: requires all grid dimensions to be > 1");
        }
        float[][] mySamples = this.getMySamples();
        int length = Math.min(grid[0].length, grid[1].length);
        float[][] value = new float[2][length];
        for (int i = 0; i < length; ++i) {
            int j;
            float gx = grid[0][i];
            float gy = grid[1][i];
            if ((double)gx < -0.5 || (double)gy < -0.5 || (double)gx > (double)this.LengthX - 0.5 || (double)gy > (double)this.LengthY - 0.5) {
                value[1][i] = Float.NaN;
                value[0][i] = Float.NaN;
                continue;
            }
            if (this.Length == 1) {
                value[0][i] = mySamples[0][0];
                value[1][i] = mySamples[1][0];
                continue;
            }
            int igx = (int)gx;
            int igy = (int)gy;
            if (igx < 0) {
                igx = 0;
            }
            if (igx > this.LengthX - 2) {
                igx = this.LengthX - 2;
            }
            if (igy < 0) {
                igy = 0;
            }
            if (igy > this.LengthY - 2) {
                igy = this.LengthY - 2;
            }
            int[][] s = new int[][]{{this.LengthX * igy + igx, this.LengthX * (igy + 1) + igx}, {this.LengthX * igy + igx + 1, this.LengthX * (igy + 1) + igx + 1}};
            if (gx + gy - (float)igx - (float)igy - 1.0f <= 0.0f) {
                for (j = 0; j < 2; ++j) {
                    value[j][i] = mySamples[j][s[0][0]] + (gx - (float)igx) * (mySamples[j][s[1][0]] - mySamples[j][s[0][0]]) + (gy - (float)igy) * (mySamples[j][s[0][1]] - mySamples[j][s[0][0]]);
                }
                continue;
            }
            for (j = 0; j < 2; ++j) {
                value[j][i] = mySamples[j][s[1][1]] + ((float)(1 + igx) - gx) * (mySamples[j][s[0][1]] - mySamples[j][s[1][1]]) + ((float)(1 + igy) - gy) * (mySamples[j][s[1][0]] - mySamples[j][s[1][1]]);
            }
        }
        return value;
    }

    @Override
    public float[][] valueToGrid(float[][] value) throws VisADException {
        return this.valueToGrid(value, null);
    }

    @Override
    public float[][] valueToGrid(float[][] value, int[] guess) throws VisADException {
        float[][] mySamples = this.getMySamples();
        if (value.length < this.DomainDimension) {
            throw new SetException("Gridded2DSet.valueToGrid: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.ManifoldDimension < 2) {
            throw new SetException("Gridded2DSet.valueToGrid: Manifold dimension must be 2, not " + this.ManifoldDimension);
        }
        if (this.Length > 1 && (this.Lengths[0] < 2 || this.Lengths[1] < 2)) {
            throw new SetException("Gridded2DSet.valueToGrid: requires all grid dimensions to be > 1");
        }
        if (guess != null && guess.length != 2) {
            throw new SetException("Gridded2DSet.valueToGrid: guess length " + guess.length + " must equal 2");
        }
        int length = Math.min(value[0].length, value[1].length);
        float[][] grid = new float[this.ManifoldDimension][length];
        int gx = (this.LengthX - 1) / 2;
        int gy = (this.LengthY - 1) / 2;
        if (guess != null && guess[0] >= 0 && guess[1] >= 0) {
            gx = guess[0];
            gy = guess[1];
        }
        boolean lowertri = true;
        for (int i = 0; i < length; ++i) {
            if (this.Length == 1) {
                if (Float.isNaN(value[0][i]) || Float.isNaN(value[1][i])) {
                    grid[1][i] = Float.NaN;
                    grid[0][i] = Float.NaN;
                    continue;
                }
                grid[0][i] = 0.0f;
                grid[1][i] = 0.0f;
                continue;
            }
            if (i != 0 && grid[0][i - 1] != grid[0][i - 1]) {
                gx = (this.LengthX - 1) / 2;
                gy = (this.LengthY - 1) / 2;
            }
            grid[1][i] = Float.NaN;
            grid[0][i] = Float.NaN;
            for (int itnum = 0; itnum < 2 * (this.LengthX + this.LengthY); ++itnum) {
                int ogy;
                int ogx;
                boolean test3;
                boolean test2;
                boolean test1;
                float tval3;
                float tval2;
                float tval1;
                float[] v0 = new float[]{mySamples[0][gy * this.LengthX + gx], mySamples[1][gy * this.LengthX + gx]};
                float[] v1 = new float[]{mySamples[0][gy * this.LengthX + gx + 1], mySamples[1][gy * this.LengthX + gx + 1]};
                float[] v2 = new float[]{mySamples[0][(gy + 1) * this.LengthX + gx], mySamples[1][(gy + 1) * this.LengthX + gx]};
                float[] v3 = new float[]{mySamples[0][(gy + 1) * this.LengthX + gx + 1], mySamples[1][(gy + 1) * this.LengthX + gx + 1]};
                float[] bd = new float[]{v2[0] - v1[0], v2[1] - v1[1]};
                float[] bp = new float[]{value[0][i] - v1[0], value[1][i] - v1[1]};
                float[] dp = new float[]{value[0][i] - v2[0], value[1][i] - v2[1]};
                if (lowertri) {
                    float[] ab = new float[]{v1[0] - v0[0], v1[1] - v0[1]};
                    float[] da = new float[]{v0[0] - v2[0], v0[1] - v2[1]};
                    float[] ap = new float[]{value[0][i] - v0[0], value[1][i] - v0[1]};
                    tval1 = ab[0] * ap[1] - ab[1] * ap[0];
                    tval2 = bd[0] * bp[1] - bd[1] * bp[0];
                    tval3 = da[0] * dp[1] - da[1] * dp[0];
                    boolean bl = tval1 == 0.0f || tval1 > 0.0f == this.Pos ? true : (test1 = false);
                    boolean bl2 = tval2 == 0.0f || tval2 > 0.0f == this.Pos ? true : (test2 = false);
                    test3 = tval3 == 0.0f || tval3 > 0.0f == this.Pos;
                    ogx = gx++;
                    ogy = gy--;
                    if (test1 || test2) {
                        if (!test2 && !test3) {
                            --gx;
                            ++gy;
                        } else if (!test1 && !test3) {
                            --gx;
                            --gy;
                        } else if (!test1) {
                            --gy;
                        } else if (!test3) {
                            --gx;
                        }
                    }
                    if (gx < 0) {
                        gx = 0;
                    }
                    if (gx > this.LengthX - 2) {
                        gx = this.LengthX - 2;
                    }
                    if (gy < 0) {
                        gy = 0;
                    }
                    if (gy > this.LengthY - 2) {
                        gy = this.LengthY - 2;
                    }
                    if (gx == ogx && gy == ogy && test2) {
                        grid[0][i] = ((value[0][i] - v0[0]) * (v2[1] - v0[1]) + (v0[1] - value[1][i]) * (v2[0] - v0[0])) / ((v1[0] - v0[0]) * (v2[1] - v0[1]) + (v0[1] - v1[1]) * (v2[0] - v0[0])) + (float)gx;
                        grid[1][i] = ((value[0][i] - v0[0]) * (v1[1] - v0[1]) + (v0[1] - value[1][i]) * (v1[0] - v0[0])) / ((v2[0] - v0[0]) * (v1[1] - v0[1]) + (v0[1] - v2[1]) * (v1[0] - v0[0])) + (float)gy;
                        break;
                    }
                    lowertri = false;
                    continue;
                }
                float[] bc = new float[]{v3[0] - v1[0], v3[1] - v1[1]};
                float[] cd = new float[]{v2[0] - v3[0], v2[1] - v3[1]};
                float[] cp = new float[]{value[0][i] - v3[0], value[1][i] - v3[1]};
                tval1 = bc[0] * bp[1] - bc[1] * bp[0];
                tval2 = cd[0] * cp[1] - cd[1] * cp[0];
                tval3 = bd[0] * dp[1] - bd[1] * dp[0];
                boolean bl = tval1 == 0.0f || tval1 > 0.0f == this.Pos ? true : (test1 = false);
                boolean bl3 = tval2 == 0.0f || tval2 > 0.0f == this.Pos ? true : (test2 = false);
                test3 = tval3 == 0.0f || tval3 < 0.0f == this.Pos;
                ogx = gx++;
                ogy = gy--;
                if (test1 || test3) {
                    if (!test2 && !test3) {
                        --gx;
                        ++gy;
                    } else if (!test1 && !test2) {
                        ++gx;
                        ++gy;
                    } else if (!test1) {
                        ++gx;
                    } else if (!test2) {
                        ++gy;
                    }
                }
                if (gx < 0) {
                    gx = 0;
                }
                if (gx > this.LengthX - 2) {
                    gx = this.LengthX - 2;
                }
                if (gy < 0) {
                    gy = 0;
                }
                if (gy > this.LengthY - 2) {
                    gy = this.LengthY - 2;
                }
                if (gx == ogx && gy == ogy && test3) {
                    grid[0][i] = ((v3[0] - value[0][i]) * (v1[1] - v3[1]) + (value[1][i] - v3[1]) * (v1[0] - v3[0])) / ((v2[0] - v3[0]) * (v1[1] - v3[1]) - (v2[1] - v3[1]) * (v1[0] - v3[0])) + (float)gx + 1.0f;
                    grid[1][i] = ((v2[1] - v3[1]) * (v3[0] - value[0][i]) + (v2[0] - v3[0]) * (value[1][i] - v3[1])) / ((v1[0] - v3[0]) * (v2[1] - v3[1]) - (v2[0] - v3[0]) * (v1[1] - v3[1])) + (float)gy + 1.0f;
                    break;
                }
                lowertri = true;
            }
            if (!((double)grid[0][i] >= (double)this.LengthX - 0.5 || (double)grid[1][i] >= (double)this.LengthY - 0.5 || (double)grid[0][i] <= -0.5) && !((double)grid[1][i] <= -0.5)) continue;
            grid[1][i] = Float.NaN;
            grid[0][i] = Float.NaN;
        }
        if (guess != null) {
            guess[0] = gx;
            guess[1] = gy;
        }
        return grid;
    }

    @Override
    public Object cloneButType(MathType type) throws VisADException {
        float[][] mySamples = this.getMySamples();
        if (this.ManifoldDimension == 2) {
            return new Gridded2DSet(type, mySamples, this.LengthX, this.LengthY, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        return new Gridded2DSet(type, mySamples, this.LengthX, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public static void main(String[] argv) throws VisADException {
        int i;
        InputStreamReader inStr = new InputStreamReader(System.in);
        int[] ints = new int[80];
        try {
            ints[0] = inStr.read();
        }
        catch (Exception e) {
            System.out.println("Gridded2DSet: " + e);
        }
        int l = 0;
        while (ints[l] != 10) {
            try {
                ints[++l] = inStr.read();
            }
            catch (Exception e) {
                System.out.println("Gridded2DSet: " + e);
            }
        }
        char[] chars = new char[l];
        for (int i2 = 0; i2 < l; ++i2) {
            chars[i2] = (char)ints[i2];
        }
        int num_coords = Integer.parseInt(new String(chars));
        if (num_coords % 4 != 0) {
            System.out.println("Gridded2DSet: input coordinates must be divisible by 4 for main function testing routines.");
        }
        float[][] samp = new float[2][num_coords];
        System.out.println("num_dimensions = 2, num_coords = " + num_coords + "\n");
        try {
            ints[0] = inStr.read();
        }
        catch (Exception e) {
            System.out.println("Gridded2DSet: " + e);
        }
        for (int c = 0; c < num_coords; ++c) {
            for (int d = 0; d < 2; ++d) {
                l = 0;
                try {
                    ints[0] = inStr.read();
                }
                catch (Exception e) {
                    System.out.println("Gridded2DSet: " + e);
                }
                while (ints[l] != 32 && ints[l] != 10) {
                    try {
                        ints[++l] = inStr.read();
                    }
                    catch (Exception e) {
                        System.out.println("Gridded2DSet: " + e);
                    }
                }
                chars = new char[l];
                for (int i3 = 0; i3 < l; ++i3) {
                    chars[i3] = (char)ints[i3];
                }
                samp[d][c] = Float.valueOf(new String(chars)).floatValue();
            }
        }
        try {
            inStr.close();
        }
        catch (Exception e) {
            System.out.println("Gridded2DSet: " + e);
        }
        RealType vis_xcoord = RealType.getRealType("xcoord");
        RealType vis_ycoord = RealType.getRealType("ycoord");
        RealType[] vis_array = new RealType[]{vis_xcoord, vis_ycoord};
        RealTupleType vis_tuple = new RealTupleType(vis_array);
        Gridded2DSet gSet2D = new Gridded2DSet((MathType)vis_tuple, samp, num_coords / 4, 4);
        System.out.println("Lengths = " + num_coords / 4 + " 4  wedge = ");
        int[] wedge = gSet2D.getWedge();
        for (int i4 = 0; i4 < wedge.length; ++i4) {
            System.out.println(" " + wedge[i4]);
        }
        float[][] thatMySamples = gSet2D.getMySamples();
        System.out.println("Samples (" + gSet2D.LengthX + " x " + gSet2D.LengthY + "):");
        for (int i5 = 0; i5 < gSet2D.LengthX * gSet2D.LengthY; ++i5) {
            System.out.println("#" + i5 + ":\t" + thatMySamples[0][i5] + ", " + thatMySamples[1][i5]);
        }
        System.out.println("\ngridToValue test:");
        int myLengthX = gSet2D.LengthX + 1;
        int myLengthY = gSet2D.LengthY + 1;
        float[][] myGrid = new float[2][myLengthX * myLengthY];
        for (int j = 0; j < myLengthY; ++j) {
            for (i = 0; i < myLengthX; ++i) {
                myGrid[0][j * myLengthX + i] = (float)i - 0.5f;
                myGrid[1][j * myLengthX + i] = (float)j - 0.5f;
                if (myGrid[0][j * myLengthX + i] < 0.0f) {
                    float[] fArray = myGrid[0];
                    int n = j * myLengthX + i;
                    fArray[n] = (float)((double)fArray[n] + 0.1);
                }
                if (myGrid[0][j * myLengthX + i] > (float)(gSet2D.LengthX - 1)) {
                    float[] fArray = myGrid[0];
                    int n = j * myLengthX + i;
                    fArray[n] = (float)((double)fArray[n] - 0.1);
                }
                if (myGrid[1][j * myLengthX + i] < 0.0f) {
                    float[] fArray = myGrid[1];
                    int n = j * myLengthX + i;
                    fArray[n] = (float)((double)fArray[n] + 0.1);
                }
                if (!(myGrid[1][j * myLengthX + i] > (float)(gSet2D.LengthY - 1))) continue;
                float[] fArray = myGrid[1];
                int n = j * myLengthX + i;
                fArray[n] = (float)((double)fArray[n] - 0.1);
            }
        }
        float[][] myValue = gSet2D.gridToValue(myGrid);
        for (i = 0; i < myLengthX * myLengthY; ++i) {
            System.out.println("(" + (float)Math.round(1000000.0f * myGrid[0][i]) / 1000000.0f + ", " + (float)Math.round(1000000.0f * myGrid[1][i]) / 1000000.0f + ")\t-->  " + (float)Math.round(1000000.0f * myValue[0][i]) / 1000000.0f + ", " + (float)Math.round(1000000.0f * myValue[1][i]) / 1000000.0f);
        }
        System.out.println("\nvalueToGrid test:");
        float[][] gridTwo = gSet2D.valueToGrid(myValue);
        for (int i6 = 0; i6 < gridTwo[0].length; ++i6) {
            System.out.println((float)Math.round(1000000.0f * myValue[0][i6]) / 1000000.0f + ", " + (float)Math.round(1000000.0f * myValue[1][i6]) / 1000000.0f + "\t-->  (" + (float)Math.round(1000000.0f * gridTwo[0][i6]) / 1000000.0f + ", " + (float)Math.round(1000000.0f * gridTwo[1][i6]) / 1000000.0f + ")");
        }
        System.out.println();
    }
}

