/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.ErrorEstimate;
import visad.GriddedSet;
import visad.Set;
import visad.SetType;
import visad.Unit;
import visad.VisADException;

public class GridCoordinateSystem
extends CoordinateSystem {
    private GriddedSet set;
    private int dimension;

    public GridCoordinateSystem(GriddedSet s) throws VisADException {
        super(((SetType)s.getType()).getDomain(), null);
        this.set = s;
        this.dimension = this.set.getDimension();
    }

    public GriddedSet getGriddedSet() {
        return this.set;
    }

    @Override
    public double[][] toReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != this.dimension) {
            throw new CoordinateSystemException("GridCoordinateSystem.toReference: tuples wrong dimension");
        }
        double[][] values = Set.floatToDouble(this.set.gridToValue(Set.doubleToFloat(tuples)));
        Unit[] units_in = this.set.getSetUnits();
        Unit[] units_out = this.getReference().getDefaultUnits();
        ErrorEstimate[] errors_out = new ErrorEstimate[1];
        for (int i = 0; i < this.dimension; ++i) {
            values[i] = Unit.transformUnits(units_out[i], errors_out, units_in[i], null, values[i], false);
        }
        return values;
    }

    @Override
    public double[][] fromReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != this.dimension) {
            throw new CoordinateSystemException("GridCoordinateSystem.fromReference: tuples wrong dimension");
        }
        Object values = new double[this.dimension][];
        for (int i = 0; i < this.dimension; ++i) {
            values[i] = tuples[i];
        }
        Unit[] units_in = this.getReference().getDefaultUnits();
        Unit[] units_out = this.set.getSetUnits();
        ErrorEstimate[] errors_out = new ErrorEstimate[1];
        for (int i = 0; i < this.dimension; ++i) {
            values[i] = Unit.transformUnits(units_out[i], errors_out, units_in[i], null, values[i]);
        }
        values = Set.floatToDouble(this.set.valueToGrid(Set.doubleToFloat(values)));
        return values;
    }

    @Override
    public float[][] toReference(float[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != this.dimension) {
            throw new CoordinateSystemException("GridCoordinateSystem.toReference: tuples wrong dimension");
        }
        float[][] values = this.set.gridToValue(tuples);
        Unit[] units_in = this.set.getSetUnits();
        Unit[] units_out = this.getReference().getDefaultUnits();
        ErrorEstimate[] errors_out = new ErrorEstimate[1];
        for (int i = 0; i < this.dimension; ++i) {
            values[i] = Unit.transformUnits(units_out[i], errors_out, units_in[i], null, values[i], false);
        }
        return values;
    }

    @Override
    public float[][] fromReference(float[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != this.dimension) {
            throw new CoordinateSystemException("GridCoordinateSystem.fromReference: tuples wrong dimension");
        }
        Object values = new float[this.dimension][];
        for (int i = 0; i < this.dimension; ++i) {
            values[i] = tuples[i];
        }
        Unit[] units_in = this.getReference().getDefaultUnits();
        Unit[] units_out = this.set.getSetUnits();
        ErrorEstimate[] errors_out = new ErrorEstimate[1];
        for (int i = 0; i < this.dimension; ++i) {
            values[i] = Unit.transformUnits(units_out[i], errors_out, units_in[i], null, values[i]);
        }
        values = this.set.valueToGrid((float[][])values);
        return values;
    }

    @Override
    public boolean equals(Object cs) {
        return cs instanceof GridCoordinateSystem && this.set.equals(((GridCoordinateSystem)cs).set);
    }
}

