/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.StringTokenizer;
import visad.Control;
import visad.ControlEvent;
import visad.ControlListener;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.TrajectoryParams;
import visad.VisADException;
import visad.browser.Convert;
import visad.util.Util;

public abstract class FlowControl
extends Control {
    float flowScale = 0.02f;
    public static final int NH_ORIENTATION = 0;
    public static final int SH_ORIENTATION = 1;
    int barbOrientation = 1;
    boolean adjustFlowToEarth = true;
    boolean HorizontalVectorSlice = false;
    boolean VerticalVectorSlice = false;
    boolean HorizontalStreamSlice = false;
    boolean VerticalStreamSlice = false;
    double HorizontalVectorSliceHeight = 0.0;
    double HorizontalStreamSliceHeight = 0.0;
    private boolean autoScale = false;
    private ProjectionControlListener pcl = null;
    boolean streamlinesEnabled = false;
    float streamlineDensity = 1.0f;
    float arrowScale = 1.0f;
    float stepFactor = 2.0f;
    float packingFactor = 1.0f;
    float cntrWeight = 3.0f;
    int n_pass = 0;
    float reduction = 1.0f;
    boolean trajectoryEnabled = false;
    TrajectoryParams trajParams = new TrajectoryParams();

    public FlowControl(DisplayImpl d) {
        super(d);
    }

    public void setFlowScale(float scale) throws VisADException, RemoteException {
        this.flowScale = scale;
        this.changeControl(true);
    }

    public float getFlowScale() {
        return this.flowScale;
    }

    public void setBarbOrientation(int orientation) throws VisADException, RemoteException {
        if (orientation != 1 && orientation != 0) {
            throw new VisADException("Invalid orientation value: " + orientation);
        }
        this.barbOrientation = orientation;
        this.changeControl(true);
    }

    public int getBarbOrientation() {
        return this.barbOrientation;
    }

    public void setAdjustFlowToEarth(boolean adjust) throws VisADException, RemoteException {
        this.adjustFlowToEarth = adjust;
        this.changeControl(true);
    }

    public boolean getAdjustFlowToEarth() {
        return this.adjustFlowToEarth;
    }

    public void enableStreamlines(boolean flag) throws VisADException, RemoteException {
        this.streamlinesEnabled = flag;
        if (this.trajectoryEnabled && this.streamlinesEnabled) {
            this.trajectoryEnabled = false;
        }
        this.changeControl(true);
    }

    public void enableTrajectory(boolean flag) throws VisADException, RemoteException {
        this.trajectoryEnabled = flag;
        if (this.trajectoryEnabled && this.streamlinesEnabled) {
            this.streamlinesEnabled = false;
        }
        this.changeControl(true);
    }

    public void enableTrajectory(boolean flag, TrajectoryParams tparms) throws VisADException, RemoteException {
        if (tparms == null) {
            throw new VisADException("TrajectoryParams cannot be null");
        }
        this.trajectoryEnabled = flag;
        if (this.trajectoryEnabled && this.streamlinesEnabled) {
            this.streamlinesEnabled = false;
        }
        this.trajParams = new TrajectoryParams(tparms);
        this.changeControl(true);
    }

    public void setStreamlineDensity(float density) throws VisADException, RemoteException {
        this.streamlineDensity = density;
        this.changeControl(true);
    }

    public void setArrowScale(float arrowScale) throws VisADException, RemoteException {
        this.arrowScale = arrowScale;
        this.changeControl(true);
    }

    public void setStepFactor(float stepFactor) throws VisADException, RemoteException {
        this.stepFactor = stepFactor;
        this.changeControl(true);
    }

    public void setStreamlinePacking(float packing) throws VisADException, RemoteException {
        this.packingFactor = packing;
        this.changeControl(true);
    }

    public void setStreamlineSmoothing(float cntrWeight, int n_pass) throws VisADException, RemoteException {
        this.cntrWeight = cntrWeight;
        this.n_pass = n_pass;
        this.changeControl(true);
    }

    public void setStreamlineReduction(float reduction) throws VisADException, RemoteException {
        this.reduction = reduction;
        this.changeControl(true);
    }

    public boolean streamlinesEnabled() {
        return this.streamlinesEnabled;
    }

    public boolean trajectoryEnabled() {
        return this.trajectoryEnabled;
    }

    public TrajectoryParams getTrajectoryParams() {
        return this.trajParams;
    }

    public void setTrajectoryParams(TrajectoryParams trajParams) throws VisADException, RemoteException {
        this.trajParams = new TrajectoryParams(trajParams);
        this.changeControl(true);
    }

    public float getStreamlineDensity() {
        return this.streamlineDensity;
    }

    public float getArrowScale() {
        return this.arrowScale;
    }

    public float getStepFactor() {
        return this.stepFactor;
    }

    public float getStreamlinePacking() {
        return this.packingFactor;
    }

    public float[] getStreamlineSmoothing() {
        return new float[]{this.cntrWeight, this.n_pass};
    }

    public float getStreamlineReduction() {
        return this.reduction;
    }

    @Override
    public String getSaveString() {
        return "" + this.getFlowScale() + " " + this.getBarbOrientation() + " " + this.streamlinesEnabled() + " " + this.trajectoryEnabled() + " " + this.getStreamlineDensity() + " " + this.getArrowScale() + " " + this.getStepFactor() + " " + this.getStreamlinePacking() + " " + this.getStreamlineSmoothing()[0] + " " + this.getStreamlineSmoothing()[1] + " " + this.getStreamlineReduction() + " " + this.getAdjustFlowToEarth() + " " + this.getAutoScale();
    }

    @Override
    public void setSaveString(String save) throws VisADException, RemoteException {
        if (save == null) {
            throw new VisADException("Invalid save string");
        }
        StringTokenizer st = new StringTokenizer(save);
        if (st.countTokens() < 2) {
            throw new VisADException("Invalid save string");
        }
        float scale = Convert.getFloat(st.nextToken());
        int orientation = Convert.getInt(st.nextToken());
        boolean es = st.hasMoreTokens() ? Convert.getBoolean(st.nextToken()) : this.streamlinesEnabled();
        boolean tes = st.hasMoreTokens() ? Convert.getBoolean(st.nextToken()) : this.trajectoryEnabled();
        float sd = st.hasMoreTokens() ? Convert.getFloat(st.nextToken()) : this.getStreamlineDensity();
        float as = st.hasMoreTokens() ? Convert.getFloat(st.nextToken()) : this.getArrowScale();
        float sf = st.hasMoreTokens() ? Convert.getFloat(st.nextToken()) : this.getStepFactor();
        float sp = st.hasMoreTokens() ? Convert.getFloat(st.nextToken()) : this.getStreamlinePacking();
        float ssc = st.hasMoreTokens() ? Convert.getFloat(st.nextToken()) : this.getStreamlineSmoothing()[0];
        float ssn = st.hasMoreTokens() ? Convert.getFloat(st.nextToken()) : this.getStreamlineSmoothing()[1];
        float sr = st.hasMoreTokens() ? Convert.getFloat(st.nextToken()) : this.getStreamlineReduction();
        boolean af = st.hasMoreTokens() ? Convert.getBoolean(st.nextToken()) : this.getAdjustFlowToEarth();
        boolean asc = st.hasMoreTokens() ? Convert.getBoolean(st.nextToken()) : this.getAutoScale();
        this.flowScale = scale;
        this.barbOrientation = orientation;
        this.streamlinesEnabled = es;
        this.trajectoryEnabled = tes;
        this.streamlineDensity = sd;
        this.arrowScale = as;
        this.stepFactor = sf;
        this.packingFactor = sp;
        this.cntrWeight = ssc;
        this.n_pass = (int)ssn;
        this.reduction = sr;
        this.adjustFlowToEarth = af;
        this.autoScale = asc;
        this.changeControl(true);
    }

    @Override
    public void syncControl(Control rmt) throws VisADException {
        if (rmt == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(rmt instanceof FlowControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + rmt.getClass().getName());
        }
        FlowControl fc = (FlowControl)rmt;
        boolean changed = false;
        if (!Util.isApproximatelyEqual(this.flowScale, fc.flowScale)) {
            changed = true;
            this.flowScale = fc.flowScale;
        }
        if (this.barbOrientation != fc.barbOrientation) {
            changed = true;
            this.barbOrientation = fc.barbOrientation;
        }
        if (this.HorizontalVectorSlice != fc.HorizontalVectorSlice) {
            changed = true;
            this.HorizontalVectorSlice = fc.HorizontalVectorSlice;
        }
        if (this.VerticalVectorSlice != fc.VerticalVectorSlice) {
            changed = true;
            this.VerticalVectorSlice = fc.VerticalVectorSlice;
        }
        if (this.HorizontalStreamSlice != fc.HorizontalStreamSlice) {
            changed = true;
            this.HorizontalStreamSlice = fc.HorizontalStreamSlice;
        }
        if (this.VerticalStreamSlice != fc.VerticalStreamSlice) {
            changed = true;
            this.VerticalStreamSlice = fc.VerticalStreamSlice;
        }
        if (!Util.isApproximatelyEqual(this.HorizontalVectorSliceHeight, fc.HorizontalVectorSliceHeight)) {
            changed = true;
            this.HorizontalVectorSliceHeight = fc.HorizontalVectorSliceHeight;
        }
        if (!Util.isApproximatelyEqual(this.HorizontalStreamSliceHeight, fc.HorizontalStreamSliceHeight)) {
            changed = true;
            this.HorizontalStreamSliceHeight = fc.HorizontalStreamSliceHeight;
        }
        if (this.streamlinesEnabled != fc.streamlinesEnabled) {
            changed = true;
            this.streamlinesEnabled = fc.streamlinesEnabled;
        }
        if (this.trajectoryEnabled != fc.trajectoryEnabled) {
            changed = true;
            this.trajectoryEnabled = fc.trajectoryEnabled;
        }
        if (!Util.isApproximatelyEqual(this.streamlineDensity, fc.streamlineDensity)) {
            changed = true;
            this.streamlineDensity = fc.streamlineDensity;
        }
        if (!Util.isApproximatelyEqual(this.arrowScale, fc.arrowScale)) {
            changed = true;
            this.arrowScale = fc.arrowScale;
        }
        if (!Util.isApproximatelyEqual(this.stepFactor, fc.stepFactor)) {
            changed = true;
            this.stepFactor = fc.stepFactor;
        }
        if (!Util.isApproximatelyEqual(this.packingFactor, fc.packingFactor)) {
            changed = true;
            this.packingFactor = fc.packingFactor;
        }
        if (!Util.isApproximatelyEqual(this.cntrWeight, fc.cntrWeight)) {
            changed = true;
            this.cntrWeight = fc.cntrWeight;
        }
        if (!Util.isApproximatelyEqual(this.n_pass, fc.n_pass)) {
            changed = true;
            this.n_pass = fc.n_pass;
        }
        if (!Util.isApproximatelyEqual(this.reduction, fc.reduction)) {
            changed = true;
            this.reduction = fc.reduction;
        }
        if (this.autoScale != fc.autoScale) {
            this.setAutoScale(fc.autoScale);
        }
        if (!this.trajParams.equals(fc.trajParams)) {
            changed = true;
            this.trajParams = fc.trajParams;
        }
        if (changed) {
            try {
                this.changeControl(true);
            }
            catch (RemoteException re) {
                throw new VisADException("Could not indicate that control changed: " + re.getMessage());
            }
        }
    }

    public void setAutoScale(boolean auto) throws VisADException {
        if (auto == this.autoScale) {
            return;
        }
        DisplayImpl display = this.getDisplay();
        DisplayRenderer dr = display.getDisplayRenderer();
        MouseBehavior mouse = dr.getMouseBehavior();
        ProjectionControl pc = display.getProjectionControl();
        if (auto) {
            this.pcl = new ProjectionControlListener(mouse, this, pc);
            pc.addControlListener(this.pcl);
        } else {
            pc.removeControlListener(this.pcl);
        }
        this.autoScale = auto;
        try {
            this.changeControl(true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean getAutoScale() {
        return this.autoScale;
    }

    @Override
    public void nullControl() {
        try {
            this.setAutoScale(false);
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        super.nullControl();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        FlowControl fc = (FlowControl)o;
        if (!Util.isApproximatelyEqual(this.flowScale, fc.flowScale)) {
            return false;
        }
        if (this.barbOrientation != fc.barbOrientation) {
            return false;
        }
        if (this.HorizontalVectorSlice != fc.HorizontalVectorSlice) {
            return false;
        }
        if (this.VerticalVectorSlice != fc.VerticalVectorSlice) {
            return false;
        }
        if (this.HorizontalStreamSlice != fc.HorizontalStreamSlice) {
            return false;
        }
        if (this.VerticalStreamSlice != fc.VerticalStreamSlice) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.HorizontalVectorSliceHeight, fc.HorizontalVectorSliceHeight)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.HorizontalStreamSliceHeight, fc.HorizontalStreamSliceHeight)) {
            return false;
        }
        if (this.streamlinesEnabled != fc.streamlinesEnabled) {
            return false;
        }
        if (this.trajectoryEnabled != fc.trajectoryEnabled) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.streamlineDensity, fc.streamlineDensity)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.arrowScale, fc.arrowScale)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.stepFactor, fc.stepFactor)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.packingFactor, fc.packingFactor)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.cntrWeight, fc.cntrWeight)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.n_pass, fc.n_pass)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.reduction, fc.reduction)) {
            return false;
        }
        if (this.autoScale != fc.autoScale) {
            return false;
        }
        return this.trajParams.equals(fc.trajParams);
    }

    @Override
    public Object clone() {
        FlowControl fc = (FlowControl)super.clone();
        return fc;
    }

    class ProjectionControlListener
    implements ControlListener {
        private boolean pfirst = true;
        private MouseBehavior mouse;
        private ProjectionControl pcontrol;
        private FlowControl flowControl;
        private double base_scale = 1.0;
        private float last_cscale = 1.0f;
        private double base_size = 1.0;

        ProjectionControlListener(MouseBehavior m, FlowControl s, ProjectionControl p) {
            this.mouse = m;
            this.flowControl = s;
            this.pcontrol = p;
        }

        @Override
        public void controlChanged(ControlEvent e) throws VisADException, RemoteException {
            double[] matrix = this.pcontrol.getMatrix();
            double[] rot = new double[3];
            double[] scale = new double[3];
            double[] trans = new double[3];
            this.mouse.instance_unmake_matrix(rot, scale, trans, matrix);
            if (this.pfirst) {
                this.pfirst = false;
                this.base_scale = scale[2];
                this.last_cscale = 1.0f;
                this.base_size = this.flowControl.getFlowScale();
            } else {
                float cscale = (float)(this.base_scale / scale[2]);
                float ratio = cscale / this.last_cscale;
                if (ratio < 0.95f || 1.05f < ratio) {
                    this.last_cscale = cscale;
                    this.flowControl.setFlowScale((float)this.base_size * cscale);
                }
            }
        }
    }
}

