/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.VisADException;
import visad.data.ArrayCache;

public class CachingCoordinateSystem
extends CoordinateSystem {
    private CoordinateSystem myCS = null;
    private ArrayCache arrayCache = new ArrayCache();
    public static boolean debugTime = Boolean.parseBoolean(System.getProperty("visad.cachingcoordinatesystem.debugtime", "false"));
    private static int cnt = 0;
    private int mycnt = cnt++;

    public CachingCoordinateSystem(CoordinateSystem cs) throws VisADException {
        super(cs.getReference(), cs.getCoordinateSystemUnits());
        this.myCS = cs;
    }

    @Override
    public double[][] toReference(double[][] inputs) throws VisADException {
        if (inputs == null) {
            return inputs;
        }
        long t1 = System.currentTimeMillis();
        boolean hit = true;
        String key = "toReferenceD";
        ArrayCache.DoubleResult results = this.arrayCache.get(key, inputs);
        if (results.values == null) {
            double[][] tmp = results.cloneForCache(inputs);
            results.values = this.myCS.toReference(inputs);
            this.arrayCache.put(key, tmp, results);
            hit = false;
        }
        if (debugTime && results.getShouldCache()) {
            this.debugTime(inputs[0].length, key + " hit?" + hit, t1, System.currentTimeMillis());
        }
        return results.values;
    }

    private void debugTime(int size, String msg, long t1, long t2) {
        if (size > 100 && debugTime && t1 != t2) {
            System.err.println("CCS #" + cnt + " size:" + size + " " + msg + " time:" + (t2 - t1));
        }
    }

    @Override
    public double[][] fromReference(double[][] inputs) throws VisADException {
        if (inputs == null) {
            return inputs;
        }
        long t1 = System.currentTimeMillis();
        boolean hit = true;
        String key = "fromReferenceD";
        ArrayCache.DoubleResult results = this.arrayCache.get(key, inputs);
        if (results.values == null) {
            double[][] tmp = results.cloneForCache(inputs);
            results.values = this.myCS.fromReference(inputs);
            this.arrayCache.put(key, tmp, results);
            hit = false;
        }
        if (debugTime && results.getShouldCache()) {
            this.debugTime(inputs[0].length, key + " hit?" + hit, t1, System.currentTimeMillis());
        }
        return results.values;
    }

    @Override
    public float[][] toReference(float[][] inputs) throws VisADException {
        if (inputs == null) {
            return inputs;
        }
        long t1 = System.currentTimeMillis();
        boolean hit = true;
        String key = "toReferenceF";
        ArrayCache.FloatResult results = this.arrayCache.get(key, inputs);
        if (results.values == null) {
            float[][] tmp = results.cloneForCache(inputs);
            results.values = this.myCS.toReference(inputs);
            this.arrayCache.put(key, tmp, results);
            hit = false;
        }
        if (debugTime && results.getShouldCache()) {
            this.debugTime(inputs[0].length, key + " hit?" + hit, t1, System.currentTimeMillis());
        }
        return results.values;
    }

    @Override
    public float[][] fromReference(float[][] inputs) throws VisADException {
        if (inputs == null) {
            return inputs;
        }
        long t1 = System.currentTimeMillis();
        boolean hit = true;
        String key = "fromReferenceF";
        ArrayCache.FloatResult results = this.arrayCache.get(key, inputs);
        if (results.values == null) {
            float[][] tmp = results.cloneForCache(inputs);
            results.values = this.myCS.fromReference(inputs);
            this.arrayCache.put(key, tmp, results);
            hit = false;
        }
        if (debugTime && results.getShouldCache()) {
            this.debugTime(inputs[0].length, key + " hit?" + hit, t1, System.currentTimeMillis());
        }
        return results.values;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CachingCoordinateSystem)) {
            return false;
        }
        CachingCoordinateSystem that = (CachingCoordinateSystem)obj;
        return that.myCS.equals(this.myCS);
    }

    public CoordinateSystem getCachedCoordinateSystem() {
        return this.myCS;
    }

    public String toString() {
        return "Cached CS: " + this.myCS.toString();
    }
}

