/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import visad.CommonUnit;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayRenderer;
import visad.PlotText;
import visad.ProjectionControl;
import visad.Real;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.ShadowType;
import visad.TextControl;
import visad.Unit;
import visad.VisADException;
import visad.VisADLineArray;
import visad.VisADTriangleArray;
import visad.util.HersheyFont;

public class AxisScale
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int Z_AXIS = 2;
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    public static final int QUATERNARY = 3;
    private boolean screenBased = false;
    private boolean gridLinesVisible = false;
    private boolean ticksVisible = true;
    private boolean labelBothSides = false;
    private VisADLineArray scaleArray;
    private VisADTriangleArray labelArray;
    private ScalarMap scalarMap;
    private Color myColor = Color.white;
    private double[] dataRange = new double[2];
    private int myAxis = -1;
    private int axisOrdinal = -1;
    private String myTitle;
    private Hashtable labelTable;
    private double[] majorTicks = null;
    private double[] minorTicks = null;
    private double majorTickSpacing = 0.0;
    private double minorTickSpacing = 0.0;
    private double tickBase = 0.0;
    private boolean autoComputeTicks = true;
    private boolean baseLineVisible = true;
    private boolean snapToBox = false;
    private boolean userLabels = false;
    private boolean visibility = true;
    private boolean labelAllTicks = false;
    private Object labelFont = null;
    private int labelSize = 12;
    private int axisSide = 0;
    private int tickOrient = 0;
    private static final double TICKSIZE = 0.5;
    private NumberFormat labelFormat = null;
    private boolean labelRelief = true;

    public AxisScale(ScalarMap map) throws VisADException {
        DisplayRenderer displayRenderer;
        this.scalarMap = map;
        DisplayRealType displayScalar = this.scalarMap.getDisplayScalar();
        if (!(displayScalar.equals(Display.XAxis) || displayScalar.equals(Display.YAxis) || displayScalar.equals(Display.ZAxis))) {
            throw new DisplayException("AxisSale: DisplayScalar must be XAxis, YAxis or ZAxis");
        }
        this.myAxis = displayScalar.equals(Display.XAxis) ? 0 : (displayScalar.equals(Display.YAxis) ? 1 : 2);
        this.myTitle = this.scalarMap.getScalarName();
        this.visibility = this.scalarMap.getScaleEnable();
        this.labelTable = new Hashtable();
        DisplayImpl display = this.scalarMap.getDisplay();
        if (display != null && (displayRenderer = display.getDisplayRenderer()) != null) {
            float[] rgb = displayRenderer.getRendererControl().getForegroundColor();
            this.myColor = new Color(rgb[0], rgb[1], rgb[2]);
            boolean bl = this.makeScale();
        }
    }

    public int getAxisOrdinal() {
        return this.axisOrdinal;
    }

    void setAxisOrdinal(int ordinalValue) {
        this.axisOrdinal = ordinalValue;
    }

    public void setLabel(String label) {
        this.setTitle(label);
    }

    public String getLabel() {
        return this.getTitle();
    }

    public void setTitle(String title) {
        String oldTitle = this.myTitle;
        this.myTitle = title;
        if (!this.myTitle.equals(oldTitle)) {
            try {
                if (!this.myTitle.equals(this.scalarMap.getScalarName())) {
                    this.scalarMap.setScalarName(this.myTitle);
                }
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public String getTitle() {
        return this.myTitle;
    }

    public int getAxis() {
        return this.myAxis;
    }

    public VisADLineArray getScaleArray() {
        return this.scaleArray;
    }

    public VisADTriangleArray getLabelArray() {
        return this.labelArray;
    }

    public void setScreenBased(boolean sb) {
        this.screenBased = sb;
    }

    public boolean getScreenBased() {
        return this.screenBased;
    }

    public boolean makeScreenBasedScale(double xmin, double ymin, double xmax, double ymax, double XTMIN, double YTMIN, double XTMAX, double YTMAX) throws VisADException {
        DisplayImpl display = this.scalarMap.getDisplay();
        if (display == null) {
            return false;
        }
        DisplayRenderer displayRenderer = display.getDisplayRenderer();
        if (displayRenderer == null) {
            return false;
        }
        if (this.axisOrdinal < 0) {
            return false;
        }
        this.dataRange = this.scalarMap.getRange();
        if (!displayRenderer.getMode2D()) {
            return false;
        }
        boolean twoD = true;
        ProjectionControl pcontrol = display.getProjectionControl();
        double[] aspect = pcontrol.getAspectCartesian();
        double oldMax = 1.0;
        double oldMin = -1.0;
        double newMax = 1.0;
        double newMin = -1.0;
        if (this.myAxis == 0) {
            oldMax = aspect[0];
            oldMin = -aspect[0];
            newMax = XTMAX;
            newMin = XTMIN;
        } else if (this.myAxis == 1) {
            oldMax = aspect[1];
            oldMin = -aspect[1];
            newMax = YTMAX;
            newMin = YTMIN;
        }
        double mult = (this.dataRange[1] - this.dataRange[0]) / (oldMax - oldMin);
        double d1 = (newMax - oldMin) * mult + this.dataRange[0];
        double d0 = (newMin - oldMin) * mult + this.dataRange[0];
        double[] dr = new double[]{d0, d1};
        double zmin = 0.0;
        double zmax = -zmin;
        double scale = (double)this.labelSize / 200.0;
        double offset = 1.05;
        scale *= 0.6;
        int position = 0;
        int myPosition = 0;
        if (this.snapToBox) {
            offset = 1.0;
        } else {
            Enumeration e = display.getMapVector().elements();
            while (e.hasMoreElements()) {
                ScalarMap map = (ScalarMap)e.nextElement();
                if (!map.getDisplayScalar().equals(this.scalarMap.getDisplayScalar()) || this.getSide() != map.getAxisScale().getSide()) continue;
                if (!map.equals(this.scalarMap)) {
                    ++position;
                    continue;
                }
                myPosition = position;
            }
        }
        double line = 4.0 * (double)myPosition * scale;
        return this.makeScale(twoD, xmin, ymin, zmin, xmax, ymax, zmax, scale, offset, line, dr);
    }

    public boolean makeScale() throws VisADException {
        DisplayImpl display = this.scalarMap.getDisplay();
        if (display == null) {
            return false;
        }
        DisplayRenderer displayRenderer = display.getDisplayRenderer();
        if (displayRenderer == null) {
            return false;
        }
        if (this.axisOrdinal < 0) {
            this.axisOrdinal = displayRenderer.getAxisOrdinal(this.myAxis);
        }
        this.dataRange = this.scalarMap.getRange();
        boolean twoD = displayRenderer.getMode2D();
        ProjectionControl pcontrol = display.getProjectionControl();
        double[] aspect = pcontrol.getAspectCartesian();
        double xmin = -aspect[0];
        double ymin = -aspect[1];
        double zmin = -aspect[2];
        double xmax = -xmin;
        double ymax = -ymin;
        double zmax = -zmin;
        double scale = (double)this.labelSize / 200.0;
        double offset = 1.05;
        int position = 0;
        int myPosition = 0;
        if (this.snapToBox) {
            offset = 1.0;
        } else {
            Enumeration e = display.getMapVector().elements();
            while (e.hasMoreElements()) {
                ScalarMap map = (ScalarMap)e.nextElement();
                if (!map.getDisplayScalar().equals(this.scalarMap.getDisplayScalar()) || this.getSide() != map.getAxisScale().getSide()) continue;
                if (!map.equals(this.scalarMap)) {
                    ++position;
                    continue;
                }
                myPosition = position;
            }
        }
        double line = 4.0 * (double)myPosition * scale;
        return this.makeScale(twoD, xmin, ymin, zmin, xmax, ymax, zmax, scale, offset, line, this.dataRange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean makeScale(boolean twoD, double xmin, double ymin, double zmin, double xmax, double ymax, double zmax, double scale, double offset, double line, double[] dataRange) throws VisADException {
        double[] base = null;
        double[] up = null;
        double[] startn = null;
        double[] startp = null;
        double[] gridstartn = null;
        double[] gridstartp = null;
        int numSides = this.getLabelBothSides() ? 2 : 1;
        Vector<VisADLineArray> lineArrayVector = new Vector<VisADLineArray>(4 * numSides);
        Vector<VisADTriangleArray> labelArrayVector = new Vector<VisADTriangleArray>();
        double one = 1.0;
        if (dataRange[0] > dataRange[1]) {
            one = -1.0;
        }
        for (int l = 0; l < numSides; ++l) {
            Hashtable localTable;
            double[] dArray;
            int side = this.getSide();
            side = (side + l) % (twoD ? 2 : 4);
            if (this.myAxis == 0) {
                if (side == 0) {
                    base = new double[]{scale, 0.0, 0.0};
                    up = new double[]{0.0, scale, scale};
                    startp = new double[]{one * xmax, ymin - (offset - 1.0 + line), zmin - (offset - 1.0 + line)};
                    startn = new double[]{one * xmin, ymin - (offset - 1.0 + line), zmin - (offset - 1.0 + line)};
                    gridstartp = new double[]{one * xmax, ymin, zmin};
                    gridstartn = new double[]{one * xmin, ymin, zmin};
                } else if (side == 1) {
                    base = new double[]{-scale, 0.0, 0.0};
                    up = new double[]{0.0, -scale, scale};
                    startp = new double[]{one * xmax, ymax + (offset - 1.0 + line), zmin - (offset - 1.0 + line)};
                    startn = new double[]{one * xmin, ymax + (offset - 1.0 + line), zmin - (offset - 1.0 + line)};
                    gridstartp = new double[]{one * xmax, ymax, zmin};
                    gridstartn = new double[]{one * xmin, ymax, zmin};
                } else if (side == 2) {
                    base = new double[]{scale, 0.0, 0.0};
                    up = new double[]{0.0, scale, -scale};
                    startp = new double[]{one * xmax, ymin - (offset - 1.0 + line), zmax + (offset - 1.0 + line)};
                    startn = new double[]{one * xmin, ymin - (offset - 1.0 + line), zmax + (offset - 1.0 + line)};
                    gridstartp = new double[]{one * xmax, ymin, zmax};
                    gridstartn = new double[]{one * xmin, ymin, zmax};
                } else {
                    base = new double[]{-scale, 0.0, 0.0};
                    up = new double[]{0.0, -scale, -scale};
                    startp = new double[]{one * xmax, ymax + (offset - 1.0 + line), zmax + (offset - 1.0 + line)};
                    startn = new double[]{one * xmin, ymax + (offset - 1.0 + line), zmax + (offset - 1.0 + line)};
                    gridstartp = new double[]{one * xmax, ymax, zmax};
                    gridstartn = new double[]{one * xmin, ymax, zmax};
                }
            } else if (this.myAxis == 1) {
                if (side == 0) {
                    base = new double[]{0.0, -scale, 0.0};
                    up = new double[]{scale, 0.0, scale};
                    startp = new double[]{xmin - (offset - 1.0 + line), one * ymax, zmin - (offset - 1.0 + line)};
                    startn = new double[]{xmin - (offset - 1.0 + line), one * ymin, zmin - (offset - 1.0 + line)};
                    gridstartp = new double[]{xmin, one * ymax, zmin};
                    gridstartn = new double[]{xmin, one * ymin, zmin};
                } else if (side == 1) {
                    base = new double[]{0.0, scale, 0.0};
                    up = new double[]{-scale, 0.0, scale};
                    startp = new double[]{xmax + (offset - 1.0 + line), one * ymax, zmin - (offset - 1.0 + line)};
                    startn = new double[]{xmax + (offset - 1.0 + line), one * ymin, zmin - (offset - 1.0 + line)};
                    gridstartp = new double[]{xmax, one * ymax, zmin};
                    gridstartn = new double[]{xmax, one * ymin, zmin};
                } else if (side == 2) {
                    base = new double[]{0.0, -scale, 0.0};
                    up = new double[]{scale, 0.0, -scale};
                    startp = new double[]{xmin - (offset - 1.0 + line), one * ymax, zmax + (offset - 1.0 + line)};
                    startn = new double[]{xmin - (offset - 1.0 + line), one * ymin, zmax + (offset - 1.0 + line)};
                    gridstartp = new double[]{xmin, one * ymax, zmax};
                    gridstartn = new double[]{xmin, one * ymin, zmax};
                } else {
                    base = new double[]{0.0, scale, 0.0};
                    up = new double[]{-scale, 0.0, -scale};
                    startp = new double[]{xmax + (offset - 1.0 + line), one * ymax, zmax + (offset - 1.0 + line)};
                    startn = new double[]{xmax + (offset - 1.0 + line), one * ymin, zmax + (offset - 1.0 + line)};
                    gridstartp = new double[]{xmax, one * ymax, zmax};
                    gridstartn = new double[]{xmax, one * ymin, zmax};
                }
            } else if (this.myAxis == 2) {
                if (side == 0) {
                    base = new double[]{0.0, 0.0, -scale};
                    up = new double[]{scale, scale, 0.0};
                    startp = new double[]{xmin - (offset - 1.0 + line), ymin - (offset - 1.0 + line), one * zmax};
                    startn = new double[]{xmin - (offset - 1.0 + line), ymin - (offset - 1.0 + line), one * zmin};
                    gridstartp = new double[]{xmin, ymin, one * zmax};
                    gridstartn = new double[]{xmin, ymin, one * zmin};
                } else if (side == 1) {
                    base = new double[]{0.0, 0.0, scale};
                    up = new double[]{-scale, scale, 0.0};
                    startp = new double[]{xmax + (offset - 1.0 + line), ymin - (offset - 1.0 + line), one * zmax};
                    startn = new double[]{xmax + (offset - 1.0 + line), ymin - (offset - 1.0 + line), one * zmin};
                    gridstartp = new double[]{xmax, ymin, one * zmax};
                    gridstartn = new double[]{xmax, ymin, one * zmin};
                } else if (side == 2) {
                    base = new double[]{0.0, 0.0, -scale};
                    up = new double[]{scale, -scale, 0.0};
                    startp = new double[]{xmin - (offset - 1.0 + line), ymax + (offset - 1.0 + line), one * zmax};
                    startn = new double[]{xmin - (offset - 1.0 + line), ymax + (offset - 1.0 + line), one * zmin};
                    gridstartp = new double[]{xmin, ymax, one * zmax};
                    gridstartn = new double[]{xmin, ymax, one * zmin};
                } else {
                    base = new double[]{0.0, 0.0, scale};
                    up = new double[]{-scale, -scale, 0.0};
                    startp = new double[]{xmax + (offset - 1.0 + line), ymax + (offset - 1.0 + line), one * zmax};
                    startn = new double[]{xmax + (offset - 1.0 + line), ymax + (offset - 1.0 + line), one * zmin};
                    gridstartp = new double[]{xmax, ymax, one * zmax};
                    gridstartn = new double[]{xmax, ymax, one * zmin};
                }
            }
            if (twoD) {
                if (this.myAxis == 2) {
                    return false;
                }
                base[2] = 0.0;
                up[2] = 0.0;
                startn[2] = 0.0;
                startp[2] = 0.0;
            }
            if (!this.labelRelief) {
                up[2] = 0.0;
            }
            if (this.baseLineVisible) {
                VisADLineArray baseLineArray = new VisADLineArray();
                float[] lineCoordinates = new float[6];
                for (int i = 0; i < 3; ++i) {
                    lineCoordinates[i] = (float)startn[i];
                    lineCoordinates[3 + i] = (float)startp[i];
                }
                baseLineArray.vertexCount = 2;
                baseLineArray.coordinates = lineCoordinates;
                lineArrayVector.add(baseLineArray);
            }
            double range = Math.abs(dataRange[1] - dataRange[0]);
            double min = Math.min(dataRange[0], dataRange[1]);
            double max = Math.max(dataRange[0], dataRange[1]);
            double tens = 1.0;
            if (range < tens) {
                tens /= 10.0;
                while (range < tens) {
                    tens /= 10.0;
                }
            } else {
                while (10.0 * tens <= range) {
                    tens *= 10.0;
                }
            }
            if (this.autoComputeTicks || this.majorTickSpacing <= 0.0) {
                double ratio = range / tens;
                if (ratio < 2.0) {
                    tens /= 5.0;
                } else if (ratio < 4.0) {
                    tens /= 2.0;
                }
                this.majorTickSpacing = tens;
            }
            double[] hilo = this.majorTicks == null ? this.computeTicks(max, min, this.tickBase, this.majorTickSpacing) : this.computeTicks(max, min, this.majorTicks);
            VisADLineArray majorTickArray = new VisADLineArray();
            int nticks = hilo.length;
            float[] majorCoordinates = new float[6 * nticks];
            double[] tickup = up;
            if (this.getTickOrientation() != 0) {
                if (this.myAxis == 0) {
                    tickup = new double[]{up[0], -up[1], -up[2]};
                } else if (this.myAxis == 1) {
                    tickup = new double[]{-up[0], up[1], -up[2]};
                } else if (this.myAxis == 2) {
                    tickup = new double[]{-up[0], -up[1], up[2]};
                }
            }
            int k = 0;
            if (this.ticksVisible) {
                for (int j = 0; j < nticks; ++j) {
                    double value = hilo[j];
                    double a = (value - min) / (max - min);
                    for (int i = 0; i < 3; ++i) {
                        if (k + 3 + i >= majorCoordinates.length) continue;
                        majorCoordinates[k + i] = (float)((1.0 - a) * startn[i] + a * startp[i]);
                        majorCoordinates[k + 3 + i] = (float)((double)majorCoordinates[k + i] - 0.5 * tickup[i]);
                    }
                    k += 6;
                }
                majorTickArray.vertexCount = 2 * nticks;
                majorTickArray.coordinates = majorCoordinates;
                lineArrayVector.add(majorTickArray);
            }
            if (this.gridLinesVisible && l == 0) {
                VisADLineArray gridArray = new VisADLineArray();
                float[] gridCoordinates = new float[6 * nticks];
                k = 0;
                double[] gridup = null;
                double gridLength = 1.0;
                if (this.myAxis == 0) {
                    gridup = new double[]{0.0, up[1], 0.0};
                    gridLength = (ymax - ymin) / scale;
                } else if (this.myAxis == 1) {
                    gridup = new double[]{up[0], 0.0, 0.0};
                    gridLength = (xmax - xmin) / scale;
                } else if (this.myAxis == 2) {
                    gridup = new double[]{up[0], 0.0, 0.0};
                    gridLength = (xmax - xmin) / scale;
                }
                for (int j = 0; j < nticks; ++j) {
                    double value = hilo[j];
                    double a = (value - min) / (max - min);
                    for (int i = 0; i < 3; ++i) {
                        if (k + 3 + i >= gridCoordinates.length) continue;
                        gridCoordinates[k + i] = (float)((1.0 - a) * gridstartn[i] + a * gridstartp[i]);
                        gridCoordinates[k + 3 + i] = (float)((double)gridCoordinates[k + i] + gridLength * gridup[i]);
                    }
                    k += 6;
                }
                gridArray.vertexCount = 2 * nticks;
                gridArray.coordinates = gridCoordinates;
                lineArrayVector.add(gridArray);
            }
            if ((this.getMinorTickSpacing() > 0.0 || this.minorTicks != null) && this.ticksVisible) {
                double[] minorTicksToDraw = this.minorTicks == null ? this.computeTicks(max, min, this.tickBase, this.minorTickSpacing) : this.computeTicks(max, min, this.minorTicks);
                VisADLineArray minorTickArray = new VisADLineArray();
                nticks = minorTicksToDraw.length;
                float[] minorCoordinates = new float[6 * nticks];
                k = 0;
                for (int j = 0; j < nticks; ++j) {
                    double val = minorTicksToDraw[j];
                    double a = (val - min) / (max - min);
                    for (int i = 0; i < 3; ++i) {
                        if (k + 3 + i >= minorCoordinates.length) continue;
                        minorCoordinates[k + i] = (float)((1.0 - a) * startn[i] + a * startp[i]);
                        minorCoordinates[k + 3 + i] = (float)((double)minorCoordinates[k + i] - 0.25 * tickup[i]);
                    }
                    k += 6;
                }
                minorTickArray.vertexCount = 2 * nticks;
                minorTickArray.coordinates = minorCoordinates;
                lineArrayVector.add(minorTickArray);
            }
            TextControl.Justification justification = TextControl.Justification.CENTER;
            if (twoD) {
                if (this.myAxis == 0) {
                    up = new double[]{0.0, scale, 0.0};
                } else if (this.myAxis == 1) {
                    up = new double[]{-scale, 0.0, 0.0};
                }
            }
            if (!this.userLabels) {
                this.createLabels(hilo, false);
            }
            double dist = 1.5;
            if (!twoD) {
                dArray = up;
            } else {
                double[] dArray2 = new double[3];
                dArray2[0] = 0.0;
                dArray2[1] = scale;
                dArray = dArray2;
                dArray2[2] = 0.0;
            }
            double[] updir = dArray;
            if (twoD) {
                base = new double[]{scale, 0.0, 0.0};
                if (this.myAxis == 0) {
                    dist = side == 0 ? 1.65 : -0.65;
                } else if (this.myAxis == 1) {
                    dist = side == 0 ? -0.65 : 0.65;
                    justification = side == 0 ? TextControl.Justification.RIGHT : TextControl.Justification.LEFT;
                }
            }
            int maximumYAxisTickLabelSize = 1;
            int yAxisLabelLength = 0;
            Hashtable hashtable = this.labelTable;
            synchronized (hashtable) {
                localTable = new Hashtable(this.labelTable);
            }
            Enumeration e = localTable.keys();
            while (e.hasMoreElements()) {
                Double value;
                try {
                    value = (Double)e.nextElement();
                }
                catch (ClassCastException cce) {
                    throw new VisADException("Invalid keys in label hashtable");
                }
                double test = value;
                if (test > max || test < min) continue;
                if (this.myAxis == 1 && (yAxisLabelLength = ((String)localTable.get(value)).length()) > maximumYAxisTickLabelSize) {
                    maximumYAxisTickLabelSize = yAxisLabelLength;
                }
                double val = (test - min) / (max - min);
                if (this.myAxis == 1 && twoD) {
                    val -= 0.2 * scale;
                }
                double[] point = new double[3];
                for (int j = 0; j < 3; ++j) {
                    point[j] = (1.0 - val) * startn[j] + val * startp[j] - dist * up[j];
                }
                if (this.labelFont == null) {
                    VisADLineArray label = PlotText.render_label((String)localTable.get(value), point, base, updir, justification);
                    lineArrayVector.add(label);
                    continue;
                }
                if (this.labelFont instanceof Font) {
                    VisADTriangleArray label = PlotText.render_font((String)localTable.get(value), (Font)this.labelFont, point, base, updir, justification);
                    labelArrayVector.add(label);
                    continue;
                }
                if (!(this.labelFont instanceof HersheyFont)) continue;
                VisADLineArray label = PlotText.render_font((String)localTable.get(value), (HersheyFont)this.labelFont, point, base, updir, justification);
                lineArrayVector.add(label);
            }
            double[] startlabel = new double[3];
            dist = 2.5;
            justification = TextControl.Justification.CENTER;
            if (twoD) {
                if (this.myAxis == 0) {
                    base = new double[]{scale, 0.0, 0.0};
                    up = new double[]{0.0, scale, 0.0};
                    dist = side == 0 ? 3.0 : -1.95;
                } else if (this.myAxis == 1) {
                    base = new double[]{0.0, scale, 0.0};
                    up = new double[]{-scale, 0.0, 0.0};
                    dist = side == 0 ? -(1.0 + (double)maximumYAxisTickLabelSize) : 1.0 + (double)maximumYAxisTickLabelSize;
                }
            }
            for (int i = 0; i < 3; ++i) {
                startlabel[i] = 0.5 * (startn[i] + startp[i]) - dist * up[i];
            }
            if (this.labelFont == null) {
                VisADLineArray plotArray = PlotText.render_label(this.myTitle, startlabel, base, up, justification);
                lineArrayVector.add(plotArray);
            } else if (this.labelFont instanceof Font) {
                VisADTriangleArray nameArray = PlotText.render_font(this.myTitle, (Font)this.labelFont, startlabel, base, up, justification);
                labelArrayVector.add(nameArray);
            } else if (this.labelFont instanceof HersheyFont) {
                VisADLineArray plotArray = PlotText.render_font(this.myTitle, (HersheyFont)this.labelFont, startlabel, base, up, justification);
                lineArrayVector.add(plotArray);
            }
            VisADLineArray[] arrays = lineArrayVector.toArray(new VisADLineArray[lineArrayVector.size()]);
            this.scaleArray = VisADLineArray.merge(arrays);
            this.labelArray = new VisADTriangleArray();
            if (labelArrayVector.isEmpty()) continue;
            VisADTriangleArray[] labelArrays = labelArrayVector.toArray(new VisADTriangleArray[labelArrayVector.size()]);
            this.labelArray = VisADTriangleArray.merge(labelArrays);
            float[] rgb = this.myColor.getColorComponents(null);
            byte red = ShadowType.floatToByte(rgb[0]);
            byte green = ShadowType.floatToByte(rgb[1]);
            byte blue = ShadowType.floatToByte(rgb[2]);
            int n = 3 * this.labelArray.vertexCount;
            byte[] colors = new byte[n];
            for (int i = 0; i < n; i += 3) {
                colors[i] = red;
                colors[i + 1] = green;
                colors[i + 2] = blue;
            }
            this.labelArray.colors = colors;
        }
        return true;
    }

    public Color getColor() {
        return this.myColor;
    }

    public void setColor(Color color) {
        Color oldColor = this.myColor;
        this.myColor = color;
        if (this.myColor != null && !this.myColor.equals(oldColor)) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public void setColor(float[] color) {
        this.setColor(new Color(color[0], color[1], color[2]));
    }

    AxisScale clone(ScalarMap map) throws VisADException {
        AxisScale newScale = new AxisScale(map);
        if (!map.getDisplayScalar().equals(this.scalarMap.getDisplayScalar())) {
            throw new VisADException("AxisScale: DisplayScalar for map is not" + this.scalarMap.getDisplayScalar());
        }
        newScale.myColor = this.myColor;
        newScale.axisOrdinal = this.axisOrdinal;
        newScale.myAxis = this.myAxis;
        newScale.myTitle = this.myTitle;
        newScale.labelTable = (Hashtable)this.labelTable.clone();
        newScale.majorTickSpacing = this.majorTickSpacing;
        newScale.minorTickSpacing = this.minorTickSpacing;
        newScale.autoComputeTicks = this.autoComputeTicks;
        newScale.baseLineVisible = this.baseLineVisible;
        newScale.snapToBox = this.snapToBox;
        newScale.labelFont = this.labelFont;
        newScale.labelSize = this.labelSize;
        newScale.axisSide = this.axisSide;
        newScale.tickOrient = this.tickOrient;
        newScale.userLabels = this.userLabels;
        newScale.labelAllTicks = this.labelAllTicks;
        newScale.gridLinesVisible = this.gridLinesVisible;
        newScale.ticksVisible = this.ticksVisible;
        newScale.labelBothSides = this.labelBothSides;
        return newScale;
    }

    public void setMajorTickSpacing(double spacing) {
        double oldValue = this.majorTickSpacing;
        this.majorTickSpacing = Math.abs(spacing);
        this.autoComputeTicks = false;
        if (this.majorTickSpacing != oldValue) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public void setMajorTicks(double[] majorTicks) {
        this.majorTicks = majorTicks;
        this.autoComputeTicks = false;
        try {
            this.scalarMap.makeScale();
        }
        catch (VisADException visADException) {
            // empty catch block
        }
    }

    public void setMinorTicks(double[] minorTicks) {
        this.minorTicks = minorTicks;
        this.autoComputeTicks = false;
        try {
            this.scalarMap.makeScale();
        }
        catch (VisADException visADException) {
            // empty catch block
        }
    }

    public double getMajorTickSpacing() {
        return this.majorTickSpacing;
    }

    public void setMinorTickSpacing(double spacing) {
        double oldValue = this.minorTickSpacing;
        this.minorTickSpacing = Math.abs(spacing);
        if (this.minorTickSpacing != oldValue) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public double getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    public void setAutoComputeTicks(boolean b) {
        boolean oldValue = this.autoComputeTicks;
        this.autoComputeTicks = b;
        if (this.autoComputeTicks != oldValue) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public void createStandardLabels(double max, double min, double base, double increment) {
        if (min > max) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        if (increment > max - min) {
            throw new IllegalArgumentException("increment must be less than or equal to range (max-min)");
        }
        this.createStandardLabels(max, min, base, increment, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStandardLabels(double max, double min, double base, double increment, boolean byuser) {
        Hashtable hashtable = this.labelTable;
        synchronized (hashtable) {
            this.labelTable.clear();
            double[] values = this.computeTicks(max, min, base, increment);
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    this.labelTable.put(new Double(values[i]), this.createLabelString(values[i]));
                }
            }
        }
        if (byuser) {
            try {
                this.userLabels = true;
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLabels(double[] values, boolean byuser) {
        Hashtable hashtable = this.labelTable;
        synchronized (hashtable) {
            this.labelTable.clear();
            if (values != null) {
                if (this.getLabelAllTicks()) {
                    for (int i = 0; i < values.length; ++i) {
                        this.labelTable.put(new Double(values[i]), this.createLabelString(values[i]));
                    }
                } else {
                    this.labelTable.put(new Double(values[0]), this.createLabelString(values[0]));
                    this.labelTable.put(new Double(values[values.length - 1]), this.createLabelString(values[values.length - 1]));
                }
            }
        }
        if (byuser) {
            try {
                this.userLabels = true;
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public void setLabelTable(Hashtable labels) throws VisADException {
        Hashtable oldTable = this.labelTable;
        this.labelTable = labels;
        if (labels != oldTable) {
            this.userLabels = true;
            this.scalarMap.makeScale();
        }
    }

    public Hashtable getLabelTable() {
        return this.labelTable;
    }

    public void setFont(Font font) {
        Object oldFont = this.labelFont;
        this.labelFont = font;
        if (this.labelFont == null && oldFont != null || this.labelFont != null && !this.labelFont.equals(oldFont)) {
            if (this.labelFont != null && this.labelFont instanceof Font) {
                this.labelSize = ((Font)this.labelFont).getSize();
            }
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public void setFont(HersheyFont font) {
        Object oldFont = this.labelFont;
        this.labelFont = font;
        if (this.labelFont == null && oldFont != null || this.labelFont != null && !this.labelFont.equals(oldFont)) {
            this.labelSize = 12;
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public Font getFont() {
        return this.labelFont instanceof Font ? (Font)this.labelFont : null;
    }

    public void setBaseLineVisible(boolean visible) {
        boolean oldValue = this.baseLineVisible;
        this.baseLineVisible = visible;
        if (this.baseLineVisible != oldValue) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public boolean getBaseLineVisible() {
        return this.baseLineVisible;
    }

    public void setSnapToBox(boolean b) {
        boolean oldValue = this.snapToBox;
        this.snapToBox = b;
        if (this.snapToBox != oldValue) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public boolean getSnapToBox() {
        return this.snapToBox;
    }

    public void setLabelSize(int size) {
        int oldSize = this.labelSize;
        this.labelSize = size;
        if (this.labelSize != oldSize) {
            if (this.labelFont != null && this.labelFont instanceof Font) {
                this.labelFont = new Font(((Font)this.labelFont).getName(), ((Font)this.labelFont).getStyle(), this.labelSize);
            }
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public int getLabelSize() {
        return this.labelSize;
    }

    public void setTickBase(double base) {
        double oldBase = this.tickBase;
        this.tickBase = base;
        if (this.tickBase != oldBase) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public void setSide(int side) {
        if (side != 0 && side != 1 && side != 2 && side != 3) {
            return;
        }
        if (this.axisSide == side) {
            return;
        }
        this.axisSide = side;
        try {
            this.scalarMap.makeScale();
        }
        catch (VisADException visADException) {
            // empty catch block
        }
    }

    public int getSide() {
        return this.axisSide;
    }

    public void setTickOrientation(int orient) {
        double oldOrient = this.tickOrient;
        int n = this.tickOrient = orient == 1 ? 1 : 0;
        if ((double)this.tickOrient != oldOrient) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public int getTickOrientation() {
        return this.tickOrient;
    }

    public void setNumberFormat(NumberFormat format) {
        this.labelFormat = format;
    }

    public NumberFormat getNumberFormat() {
        return this.labelFormat;
    }

    public void setVisible(boolean visible) {
        boolean oldVisibility = this.visibility;
        this.visibility = visible;
        if (oldVisibility != this.visibility) {
            try {
                if (visible != this.scalarMap.getScaleEnable()) {
                    this.scalarMap.setScaleEnable(visible);
                }
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public boolean isVisible() {
        return this.scalarMap.getScaleEnable();
    }

    public void setGridLinesVisible(boolean show) {
        boolean oldShow = this.gridLinesVisible;
        this.gridLinesVisible = show;
        if (oldShow != show) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public boolean getGridLinesVisible() {
        return this.gridLinesVisible;
    }

    public void setLabelBothSides(boolean both) {
        boolean oldBoth = this.labelBothSides;
        this.labelBothSides = both;
        if (oldBoth != both) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public boolean getLabelBothSides() {
        return this.labelBothSides;
    }

    public void setTicksVisible(boolean visible) {
        boolean oldValue = this.ticksVisible;
        this.ticksVisible = visible;
        if (oldValue != visible) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public boolean getTicksVisible() {
        return this.ticksVisible;
    }

    public void setLabelAllTicks(boolean labelAll) {
        boolean oldValue = this.labelAllTicks;
        this.labelAllTicks = labelAll;
        if (this.labelAllTicks != oldValue) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public boolean getLabelAllTicks() {
        return this.labelAllTicks;
    }

    private double[] computeTicks(double high, double low, double base, double interval) {
        double[] vals = null;
        long nlo = Math.round(Math.ceil((low - base) / Math.abs(interval)));
        long nhi = Math.round(Math.floor((high - base) / Math.abs(interval)));
        int numc = (int)(nhi - nlo) + 1;
        if (numc < 1) {
            return new double[]{low, high};
        }
        vals = new double[numc];
        for (int i = 0; i < numc; ++i) {
            vals[i] = base + (double)(nlo + (long)i) * interval;
        }
        return vals;
    }

    private double[] computeTicks(double max, double min, double[] ticks) {
        double[] vals = new double[ticks.length];
        Arrays.sort(ticks);
        int numTicks = 0;
        for (int i = 0; i < ticks.length; ++i) {
            double tick = ticks[i];
            if (!(tick <= max) || !(tick >= min)) continue;
            vals[numTicks++] = tick;
        }
        if (numTicks < ticks.length) {
            double[] newVals = new double[numTicks];
            System.arraycopy(vals, 0, newVals, 0, numTicks);
            return newVals;
        }
        return vals;
    }

    private String createLabelString(double value) {
        RealType rType;
        Unit unit;
        String label = null;
        ScalarType sType = this.scalarMap.getScalar();
        label = sType instanceof RealType ? (Unit.canConvert(CommonUnit.secondsSinceTheEpoch, unit = (rType = (RealType)sType).getDefaultUnit()) && !unit.getAbsoluteUnit().equals(unit) ? new Real(rType, value).toValueString() : (this.labelFormat != null ? this.labelFormat.format(value) : PlotText.shortString(value))) : (this.labelFormat != null ? this.labelFormat.format(value) : PlotText.shortString(value));
        return label;
    }

    public boolean isLabelRelief() {
        return this.labelRelief;
    }

    public void setLabelRelief(boolean labelRelief) {
        this.labelRelief = labelRelief;
    }
}

