/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class GMSXnav
extends AREAnav {
    private static final long serialVersionUID = 1L;
    private byte[] bParms = new byte[3200];
    private float subLon;
    private float subLat;
    private float[] resLin = new float[4];
    private float[] resEle = new float[4];
    private float[] rlic = new float[4];
    private float[] relmfc = new float[4];
    private float[] senssu = new float[4];
    private float[] rline = new float[4];
    private float[] relem = new float[4];
    private float[] vmis = new float[3];
    private float[][] elmis = new float[3][3];
    private double dtims = 0.0;
    private double dspin = 0.0;
    private double sitagt = 0.0;
    private double sunalp = 0.0;
    private double sundel = 0.0;
    private double[] sat = new double[3];
    private double[] sp = new double[3];
    private double[] ss = new double[3];
    private double[][] orbt1 = new double[35][8];
    private double[][] atit = new double[10][10];
    private static final double cdr = Math.PI / 180;
    private static final double crd = 57.29577951308232;
    private static final double hpai = 1.5707963267948966;
    private static final double dpai = Math.PI * 2;
    private static final double ea = 6378136.0;
    private static final double ef = 0.0033528131778969143;

    public GMSXnav(int[] navBlock) {
        int j;
        byte[] tmpArr;
        int i;
        int index = 0;
        for (i = 0; i < 126; ++i) {
            tmpArr = GMSXnav.intToBytes(navBlock[i + 1]);
            for (j = 0; j < 4; ++j) {
                this.bParms[index] = tmpArr[j];
                ++index;
            }
        }
        int srcOffset = 128;
        for (int block = 0; block < 4; ++block) {
            for (i = 0; i < 127; ++i) {
                tmpArr = GMSXnav.intToBytes(navBlock[i + srcOffset]);
                for (j = 0; j < 4; ++j) {
                    this.bParms[index] = tmpArr[j];
                    ++index;
                }
            }
            srcOffset += 128;
        }
        this.decOABlock(this.bParms, 0);
    }

    @Override
    public synchronized float[][] toLinEle(float[][] latlon) {
        int mode = 1;
        int count = latlon[0].length;
        float[][] linele = new float[2][count];
        float line = 0.0f;
        float elem = 0.0f;
        float lon = 0.0f;
        for (int point = 0; point < count; ++point) {
            linele[1][point] = Float.NaN;
            linele[0][point] = Float.NaN;
            if ((double)Math.abs(latlon[0][point]) > 90.0) continue;
            lon = latlon[1][point];
            if (lon > 180.0f) {
                lon -= 360.0f;
            }
            if (lon < -180.0f) {
                lon += 360.0f;
            }
            if (Math.abs(latlon[1][point]) > 180.0f || -lon > 90.0f - this.subLon && -lon < 270.0f - this.subLon) continue;
            float[] rtnPoint = this.mgivsr(mode, elem, line, lon, latlon[0][point]);
            linele[1][point] = rtnPoint[0];
            linele[0][point] = rtnPoint[1];
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }

    @Override
    public synchronized double[][] toLinEle(double[][] latlon) {
        int mode = 1;
        int count = latlon[0].length;
        double[][] linele = new double[2][count];
        double line = 0.0;
        double elem = 0.0;
        double lon = 0.0;
        for (int point = 0; point < count; ++point) {
            linele[1][point] = Double.NaN;
            linele[0][point] = Double.NaN;
            if (Math.abs(latlon[0][point]) > 90.0) continue;
            lon = latlon[1][point];
            if (lon > 180.0) {
                lon -= 360.0;
            }
            if (lon < -180.0) {
                lon += 360.0;
            }
            if (Math.abs(latlon[1][point]) > 180.0 || -lon > (double)(90.0f - this.subLon) && -lon < (double)(270.0f - this.subLon)) continue;
            float[] rtnPoint = this.mgivsr(mode, (float)elem, (float)line, (float)lon, (float)latlon[0][point]);
            linele[1][point] = rtnPoint[0];
            linele[0][point] = rtnPoint[1];
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }

    @Override
    public synchronized float[][] toLatLon(float[][] linele) {
        int mode = -1;
        int count = linele[0].length;
        float[][] latlon = new float[2][count];
        float lat = 0.0f;
        float lon = 0.0f;
        float[][] imgLinEle = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < count; ++point) {
            latlon[0][point] = Float.NaN;
            latlon[1][point] = Float.NaN;
            float[] rtnPoint = this.mgivsr(mode, imgLinEle[0][point], imgLinEle[1][point], lon, lat);
            if ((lon = rtnPoint[1]) > 180.0f) {
                lon -= 360.0f;
            }
            if (lon < -180.0f) {
                lon += 360.0f;
            }
            if (Math.abs(lon) > 180.0f || -lon > 90.0f - this.subLon && -lon < 270.0f - this.subLon) {
                rtnPoint[0] = Float.NaN;
                lon = Float.NaN;
            }
            latlon[0][point] = rtnPoint[0];
            latlon[1][point] = lon;
        }
        return latlon;
    }

    @Override
    public synchronized double[][] toLatLon(double[][] linele) {
        int mode = -1;
        int count = linele[0].length;
        double[][] latlon = new double[2][count];
        double lat = 0.0;
        double lon = 0.0;
        double[][] imgLinEle = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < count; ++point) {
            latlon[0][point] = Double.NaN;
            latlon[1][point] = Double.NaN;
            float[] rtnPoint = this.mgivsr(mode, (float)imgLinEle[0][point], (float)imgLinEle[1][point], (float)lon, (float)lat);
            if ((lon = (double)rtnPoint[1]) > 180.0) {
                lon -= 360.0;
            }
            if (lon < -180.0) {
                lon += 360.0;
            }
            if (Math.abs(lon) > 180.0 || -lon > 90.0 - (double)this.subLon && -lon < 270.0 - (double)this.subLon) {
                rtnPoint[0] = Float.NaN;
                lon = Double.NaN;
            }
            latlon[0][point] = rtnPoint[0];
            latlon[1][point] = lon;
        }
        return latlon;
    }

    @Override
    public double[] getSubpoint() {
        return new double[]{this.subLat, this.subLon};
    }

    private double sv0100(int iWord, int iPos, byte[] b, int bOffs) {
        int i;
        boolean negative = false;
        int[] tmpInt = new int[6];
        double r8Dat = 0.0;
        if (b[bOffs] < 0) {
            negative = true;
        }
        if (iWord == 4) {
            for (i = 1; i < 4; ++i) {
                tmpInt[i] = b[i + bOffs] < 0 ? (b[i + bOffs] & 0x7F) + 128 : b[i + bOffs];
            }
            r8Dat = (double)(b[0 + bOffs] & 0x7F) * 1.6777216E7 + (double)tmpInt[1] * 65536.0 + (double)tmpInt[2] * 256.0 + (double)tmpInt[3];
        }
        if (iWord == 6) {
            for (i = 1; i < 6; ++i) {
                tmpInt[i] = b[i + bOffs] < 0 ? (b[i + bOffs] & 0x7F) + 128 : b[i + bOffs];
            }
            r8Dat = (double)(b[0 + bOffs] & 0x7F) * Math.pow(2.0, 40.0) + (double)tmpInt[1] * Math.pow(2.0, 32.0) + (double)tmpInt[2] * 1.6777216E7 + (double)tmpInt[3] * 65536.0 + (double)tmpInt[4] * 256.0 + (double)tmpInt[5];
        }
        r8Dat /= Math.pow(10.0, iPos);
        if (negative) {
            r8Dat = -r8Dat;
        }
        return r8Dat;
    }

    private void decOABlock(byte[] b, int form) {
        int i = 0;
        int j = 0;
        this.dtims = this.sv0100(6, 8, b, 0);
        this.dspin = this.sv0100(6, 8, b, 240);
        this.resLin[0] = (float)this.sv0100(4, 8, b, 6);
        this.resLin[1] = (float)this.sv0100(4, 8, b, 10);
        this.resLin[2] = (float)this.sv0100(4, 8, b, 10);
        this.resLin[3] = (float)this.sv0100(4, 8, b, 10);
        this.resEle[0] = (float)this.sv0100(4, 10, b, 14);
        this.resEle[1] = (float)this.sv0100(4, 10, b, 18);
        this.resEle[2] = (float)this.sv0100(4, 10, b, 18);
        this.resEle[3] = (float)this.sv0100(4, 10, b, 18);
        this.rlic[0] = (float)this.sv0100(4, 4, b, 22);
        this.rlic[1] = (float)this.sv0100(4, 4, b, 26);
        this.rlic[2] = (float)this.sv0100(4, 4, b, 110);
        this.rlic[3] = (float)this.sv0100(4, 4, b, 114);
        this.relmfc[0] = (float)this.sv0100(4, 4, b, 30);
        this.relmfc[1] = (float)this.sv0100(4, 4, b, 34);
        this.relmfc[2] = (float)this.sv0100(4, 4, b, 118);
        this.relmfc[3] = (float)this.sv0100(4, 4, b, 122);
        this.senssu[0] = (float)this.sv0100(4, 0, b, 38);
        this.senssu[1] = (float)this.sv0100(4, 0, b, 42);
        this.senssu[2] = (float)this.sv0100(4, 0, b, 42);
        this.senssu[3] = (float)this.sv0100(4, 0, b, 42);
        this.rline[0] = (float)this.sv0100(4, 0, b, 46);
        this.rline[1] = (float)this.sv0100(4, 0, b, 50);
        this.rline[2] = (float)this.sv0100(4, 0, b, 50);
        this.rline[3] = (float)this.sv0100(4, 0, b, 50);
        this.relem[0] = (float)this.sv0100(4, 0, b, 54);
        this.relem[1] = (float)this.sv0100(4, 0, b, 58);
        this.relem[2] = (float)this.sv0100(4, 0, b, 58);
        this.relem[3] = (float)this.sv0100(4, 0, b, 58);
        this.vmis[0] = (float)this.sv0100(4, 10, b, 62);
        this.vmis[1] = (float)this.sv0100(4, 10, b, 66);
        this.vmis[2] = (float)this.sv0100(4, 10, b, 70);
        this.elmis[0][0] = (float)this.sv0100(4, 7, b, 74);
        this.elmis[1][0] = (float)this.sv0100(4, 10, b, 78);
        this.elmis[2][0] = (float)this.sv0100(4, 10, b, 82);
        this.elmis[0][1] = (float)this.sv0100(4, 10, b, 86);
        this.elmis[1][1] = (float)this.sv0100(4, 7, b, 90);
        this.elmis[2][1] = (float)this.sv0100(4, 10, b, 94);
        this.elmis[0][2] = (float)this.sv0100(4, 10, b, 98);
        this.elmis[1][2] = (float)this.sv0100(4, 10, b, 102);
        this.elmis[2][2] = (float)this.sv0100(4, 7, b, 106);
        this.subLon = (float)this.sv0100(6, 6, b, 198);
        this.subLat = (float)this.sv0100(6, 6, b, 204);
        for (i = 0; i < 10; ++i) {
            if (form == 1) {
                j = (i - 1) * 64 + 256;
            }
            if (form == 0) {
                j = (i - 1) * 48 + 256;
            }
            this.atit[0][i] = this.sv0100(6, 8, b, j);
            this.atit[2][i] = this.sv0100(6, 8, b, j + 12);
            this.atit[3][i] = this.sv0100(6, 11, b, j + 18);
            this.atit[4][i] = this.sv0100(6, 8, b, j + 24);
            this.atit[5][i] = this.sv0100(6, 8, b, j + 30);
        }
        for (i = 0; i < 8; ++i) {
            if (form == 1) {
                j = (i - 1) * 256 + 896;
            }
            if (form == 0) {
                j = (i - 1) * 200 + 736;
            }
            this.orbt1[0][i] = this.sv0100(6, 8, b, j + 0);
            this.orbt1[8][i] = this.sv0100(6, 6, b, j + 48);
            this.orbt1[9][i] = this.sv0100(6, 6, b, j + 54);
            this.orbt1[10][i] = this.sv0100(6, 6, b, j + 60);
            this.orbt1[14][i] = this.sv0100(6, 8, b, j + 84);
            this.orbt1[17][i] = this.sv0100(6, 8, b, j + 102);
            this.orbt1[18][i] = this.sv0100(6, 8, b, j + 108);
            this.orbt1[19][i] = this.sv0100(6, 12, b, j + 128);
            this.orbt1[20][i] = this.sv0100(6, 14, b, j + 134);
            this.orbt1[21][i] = this.sv0100(6, 14, b, j + 140);
            this.orbt1[22][i] = this.sv0100(6, 14, b, j + 146);
            this.orbt1[23][i] = this.sv0100(6, 12, b, j + 152);
            this.orbt1[24][i] = this.sv0100(6, 16, b, j + 158);
            this.orbt1[25][i] = this.sv0100(6, 12, b, j + 164);
            this.orbt1[26][i] = this.sv0100(6, 16, b, j + 170);
            this.orbt1[27][i] = this.sv0100(6, 12, b, j + 176);
        }
    }

    private float[] mgivsr(int iMode, float rPix, float rLin, float rLon, float rLat) {
        double[] sl;
        double[] sy;
        double[] sx;
        double bs;
        double bc;
        double[] sw2;
        double[] sw1;
        float[] point = new float[2];
        double beta = 0.0;
        double dLat = 0.0;
        double dLon = 0.0;
        double rtim = 0.0;
        double tl = 0.0;
        double tp = 0.0;
        double[] stn1 = new double[3];
        double[] slv = new double[3];
        double[] sw3 = new double[3];
        point[0] = Float.NaN;
        point[1] = Float.NaN;
        if (Math.abs(iMode) > 4) {
            return point;
        }
        if (Math.abs(rLat) > 90.0f && iMode > 0) {
            return point;
        }
        int lMode = Math.abs(iMode) - 1;
        float rstep = this.resLin[lMode];
        float rsamp = this.resEle[lMode];
        float rfcl = this.rlic[lMode];
        float rfcp = this.relmfc[lMode];
        float sens = this.senssu[lMode];
        float rftl = (float)((double)this.rline[lMode] + 0.5);
        float rftp = (float)((double)this.relem[lMode] + 0.5);
        if (iMode > 0) {
            float rj;
            float ri;
            dLat = (double)rLat * (Math.PI / 180);
            dLon = (double)rLon * (Math.PI / 180);
            double ee = 0.006694384999587949;
            double en = 6378136.0 / Math.sqrt(1.0 - ee * Math.sin(dLat) * Math.sin(dLat));
            stn1[0] = en * Math.cos(dLat) * Math.cos(dLon);
            stn1[1] = en * Math.cos(dLat) * Math.sin(dLon);
            stn1[2] = en * (1.0 - ee) * Math.sin(dLat);
            float rio = (float)((double)rfcl - Math.atan(Math.sin(dLat) / (6.610689 - Math.cos(dLat))) / (double)rstep);
            rtim = this.dtims + (double)(rio / sens) / 1440.0 / this.dspin;
            while (true) {
                beta = this.mg1100(rtim);
                sw1 = this.mg1220(this.sp, this.ss);
                sw2 = this.mg1220(sw1, this.sp);
                bc = Math.cos(beta);
                bs = Math.sin(beta);
                sw3[0] = sw1[0] * bs + sw2[0] * bc;
                sw3[1] = sw1[1] * bs + sw2[1] * bc;
                sw3[2] = sw1[2] * bs + sw2[2] * bc;
                sx = this.mg1200(sw3);
                sy = this.mg1220(this.sp, sx);
                slv[0] = stn1[0] - this.sat[0];
                slv[1] = stn1[1] - this.sat[1];
                slv[2] = stn1[2] - this.sat[2];
                sl = this.mg1200(slv);
                sw2 = this.mg1210(this.sp, sl);
                sw3 = this.mg1210(sy, sw2);
                tp = this.mg1230(sy, sw2);
                double tf = this.sp[0] * sw3[0] + this.sp[1] * sw3[1] + this.sp[2] * sw3[2];
                if (tf < 0.0) {
                    tp = -tp;
                }
                tl = this.mg1230(this.sp, sl);
                ri = (float)(1.5707963267948966 - tl) / rstep + rfcl - this.vmis[1] / rstep;
                rj = (float)(tp / (double)rsamp + (double)rfcp + (double)(this.vmis[2] / rsamp) - (1.5707963267948966 - tl) * Math.tan(this.vmis[0]) / (double)rsamp);
                if (!((double)Math.abs(ri - rio) >= 1.0)) break;
                rtim = (Math.rint((ri - 1.0f) / sens) + (double)(rj * rsamp) / (Math.PI * 2)) / (this.dspin * 1440.0) + this.dtims;
                rio = ri;
            }
            point[0] = ri;
            point[1] = rj;
            rLin = ri;
            rPix = rj;
            if (rLin < 0.0f || rLin > rftl) {
                point[0] = Float.NaN;
                point[1] = Float.NaN;
            }
            if (rPix < 0.0f || rPix > rftp) {
                point[0] = Float.NaN;
                point[1] = Float.NaN;
            }
        }
        if (iMode < 0) {
            double ddc;
            double dda;
            rtim = (Math.rint((rLin - 1.0f) / sens) + (double)(rPix * rsamp) / (Math.PI * 2)) / (this.dspin * 1440.0) + this.dtims;
            beta = this.mg1100(rtim);
            sw1 = this.mg1220(this.sp, this.ss);
            sw2 = this.mg1220(sw1, this.sp);
            bc = Math.cos(beta);
            bs = Math.sin(beta);
            sw3[0] = sw1[0] * bs + sw2[0] * bc;
            sw3[1] = sw1[1] * bs + sw2[1] * bc;
            sw3[2] = sw1[2] * bs + sw2[2] * bc;
            sx = this.mg1200(sw3);
            sy = this.mg1220(this.sp, sx);
            double pc = Math.cos(rstep * (rLin - rfcl));
            double ps = Math.sin(rstep * (rLin - rfcl));
            double qc = Math.cos(rsamp * (rPix - rfcp));
            double qs = Math.sin(rsamp * (rPix - rfcp));
            sw1[0] = (double)this.elmis[0][0] * pc + (double)this.elmis[0][2] * ps;
            sw1[1] = (double)this.elmis[1][0] * pc + (double)this.elmis[1][2] * ps;
            sw1[2] = (double)this.elmis[2][0] * pc + (double)this.elmis[2][2] * ps;
            sw2[0] = qc * sw1[0] - qs * sw1[1];
            sw2[1] = qs * sw1[0] + qc * sw1[1];
            sw2[2] = sw1[2];
            sw3[0] = sx[0] * sw2[0] + sy[0] * sw2[1] + this.sp[0] * sw2[2];
            sw3[1] = sx[1] * sw2[0] + sy[1] * sw2[1] + this.sp[1] * sw2[2];
            sw3[2] = sx[2] * sw2[0] + sy[2] * sw2[1] + this.sp[2] * sw2[2];
            double def = 0.993305615000412;
            sl = this.mg1200(sw3);
            double ddb = def * (this.sat[0] * sl[0] + this.sat[1] * sl[1]) + this.sat[2] * sl[2];
            double dd = ddb * ddb - (dda = def * (sl[0] * sl[0] + sl[1] * sl[1]) + sl[2] * sl[2]) * (ddc = def * (this.sat[0] * this.sat[0] + this.sat[1] * this.sat[1] - 4.0680618834496E13) + this.sat[2] * this.sat[2]);
            if (!(dd >= 0.0) || dda == 0.0) {
                return point;
            }
            double dk1 = (-ddb + Math.sqrt(dd)) / dda;
            double dk2 = (-ddb - Math.sqrt(dd)) / dda;
            double dk = Math.abs(dk1) < Math.abs(dk2) ? dk1 : dk2;
            stn1[0] = this.sat[0] + dk * sl[0];
            stn1[1] = this.sat[1] + dk * sl[1];
            stn1[2] = this.sat[2] + dk * sl[2];
            dLat = Math.atan(stn1[2] / (def * Math.sqrt(stn1[0] * stn1[0] + stn1[1] * stn1[1])));
            if (stn1[0] != 0.0) {
                dLon = Math.atan(stn1[1] / stn1[0]);
                if (stn1[0] < 0.0 && stn1[1] >= 0.0) {
                    dLon += Math.PI;
                }
                if (stn1[0] < 0.0 && stn1[1] < 0.0) {
                    dLon -= Math.PI;
                }
            } else {
                dLon = stn1[1] > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
            }
            point[0] = (float)(dLat * 57.29577951308232);
            point[1] = (float)(dLon * 57.29577951308232);
        }
        return point;
    }

    private double mg1100(double rtim) {
        int i;
        double beta = 0.0;
        double delt = 0.0;
        double attalp = 0.0;
        double attdel = 0.0;
        double wkcos = 0.0;
        double wksin = 0.0;
        double[] att1 = new double[3];
        double[] att2 = new double[3];
        double[] att3 = new double[3];
        double[][] npa = new double[3][3];
        for (i = 0; i < 7; ++i) {
            if (!(rtim > this.orbt1[0][i]) || !(rtim < this.orbt1[0][i + 1])) continue;
            npa = this.mg1110(i, rtim, this.orbt1);
            break;
        }
        for (i = 0; i < 9; ++i) {
            if (!(rtim >= this.atit[0][i]) || !(rtim < this.atit[0][i + 1])) continue;
            delt = (rtim - this.atit[0][i]) / (this.atit[0][i + 1] - this.atit[0][i]);
            attalp = this.atit[2][i] + (this.atit[2][i + 1] - this.atit[2][i]) * delt;
            attdel = this.atit[3][i] + (this.atit[3][i + 1] - this.atit[3][i]) * delt;
            beta = this.atit[4][i] + (this.atit[4][i + 1] - this.atit[4][i]) * delt;
            if (!(this.atit[4][i + 1] - this.atit[4][i] > 0.0)) break;
            beta = this.atit[4][i] + (this.atit[4][i + 1] - this.atit[4][i] - Math.PI * 2) * delt;
            break;
        }
        wkcos = Math.cos(attdel);
        att1[0] = Math.sin(attdel);
        att1[1] = wkcos * -Math.sin(attalp);
        att1[2] = wkcos * Math.cos(attalp);
        att2[0] = npa[0][0] * att1[0] + npa[0][1] * att1[1] + npa[0][2] * att1[2];
        att2[1] = npa[1][0] * att1[0] + npa[1][1] * att1[1] + npa[1][2] * att1[2];
        att2[2] = npa[2][0] * att1[0] + npa[2][1] * att1[1] + npa[2][2] * att1[2];
        wksin = Math.sin(this.sitagt);
        wkcos = Math.cos(this.sitagt);
        att3[0] = wkcos * att2[0] + wksin * att2[1];
        att3[1] = -wksin * att2[0] + wkcos * att2[1];
        att3[2] = att2[2];
        this.sp = this.mg1200(att3);
        wkcos = Math.cos(this.sundel);
        this.ss[0] = wkcos * Math.cos(this.sunalp);
        this.ss[1] = wkcos * Math.sin(this.sunalp);
        this.ss[2] = Math.sin(this.sundel);
        return beta;
    }

    private double[][] mg1110(int i, double rtim, double[][] orbta) {
        double[][] npa = new double[3][3];
        if (i != 7) {
            double delt = (rtim - orbta[0][i]) / (orbta[0][i + 1] - orbta[0][i]);
            this.sat[0] = orbta[8][i] + (orbta[8][i + 1] - orbta[8][i]) * delt;
            this.sat[1] = orbta[9][i] + (orbta[9][i + 1] - orbta[9][i]) * delt;
            this.sat[2] = orbta[10][i] + (orbta[10][i + 1] - orbta[10][i]) * delt;
            this.sitagt = (orbta[14][i] + (orbta[14][i + 1] - orbta[14][i]) * delt) * (Math.PI / 180);
            if (orbta[14][i + 1] - orbta[14][i] < 0.0) {
                this.sitagt = (orbta[14][i] + (orbta[14][i + 1] - orbta[14][i] + 360.0) * delt) * (Math.PI / 180);
            }
            this.sunalp = (orbta[17][i] + (orbta[17][i + 1] - orbta[17][i]) * delt) * (Math.PI / 180);
            if (orbta[17][i + 1] - orbta[17][i] > 0.0) {
                this.sunalp = (orbta[17][i] + (orbta[17][i + 1] - orbta[17][i] - 360.0) * delt) * (Math.PI / 180);
            }
            this.sundel = (orbta[18][i] + (orbta[18][i + 1] - orbta[18][i]) * delt) * (Math.PI / 180);
            npa[0][0] = orbta[19][i];
            npa[1][0] = orbta[20][i];
            npa[2][0] = orbta[21][i];
            npa[0][1] = orbta[22][i];
            npa[1][1] = orbta[23][i];
            npa[2][1] = orbta[24][i];
            npa[0][2] = orbta[25][i];
            npa[1][2] = orbta[26][i];
            npa[2][2] = orbta[27][i];
        }
        return npa;
    }

    private double[] mg1200(double[] vec) {
        double[] vecu = new double[3];
        double rv1 = vec[0] * vec[0] + vec[1] * vec[1] + vec[2] * vec[2];
        if (rv1 == 0.0) {
            return vecu;
        }
        double rv2 = Math.sqrt(rv1);
        vecu[0] = vec[0] / rv2;
        vecu[1] = vec[1] / rv2;
        vecu[2] = vec[2] / rv2;
        return vecu;
    }

    private double[] mg1210(double[] va, double[] vb) {
        double[] vc = new double[]{va[1] * vb[2] - va[2] * vb[1], va[2] * vb[0] - va[0] * vb[2], va[0] * vb[1] - va[1] * vb[0]};
        return vc;
    }

    private double[] mg1220(double[] va, double[] vb) {
        double[] vc = new double[3];
        double[] vd = new double[3];
        vc[0] = va[1] * vb[2] - va[2] * vb[1];
        vc[1] = va[2] * vb[0] - va[0] * vb[2];
        vc[2] = va[0] * vb[1] - va[1] * vb[0];
        vd = this.mg1200(vc);
        return vd;
    }

    private double mg1230(double[] va, double[] vb) {
        double asita = 0.0;
        double as1 = va[0] * vb[0] + va[1] * vb[1] + va[2] * vb[2];
        double as2 = (va[0] * va[0] + va[1] * va[1] + va[2] * va[2]) * (vb[0] * vb[0] + vb[1] * vb[1] + vb[2] * vb[2]);
        if (as2 == 0.0) {
            return asita;
        }
        double temp = as1 / Math.sqrt(as2);
        if (temp > 1.0 && temp - 1.0 < 1.0E-6) {
            temp = 1.0;
        }
        asita = Math.acos(temp);
        return asita;
    }

    public static byte[] intToBytes(int v) {
        byte[] b = new byte[4];
        int allbits = 255;
        for (int i = 0; i < 4; ++i) {
            b[3 - i] = (byte)((v & allbits << i * 8) >> i * 8);
        }
        return b;
    }

    public static void main(String[] args) {
        int[] navBlock = new int[800];
        int[] dirBlock = new int[64];
        DataInputStream dis = null;
        GMSXnav gmsx = null;
        String fileName = "GMSXAREA";
        System.out.println("unit test of class GMSXnav begin...");
        if (args.length > 0) {
            fileName = args[0];
        }
        try {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName), 2048));
        }
        catch (Exception e) {
            System.out.println("error creating DataInputStream: " + e);
            System.exit(0);
        }
        System.out.println("reading in, discarding directory words...");
        try {
            for (int i = 0; i < 64; ++i) {
                dirBlock[i] = dis.readInt();
            }
        }
        catch (IOException e) {
            System.out.println("error reading area file directory: " + e);
            System.exit(0);
        }
        System.out.println("reading in navigation words...");
        try {
            for (int i = 0; i < navBlock.length; ++i) {
                navBlock[i] = dis.readInt();
            }
        }
        catch (IOException e) {
            System.out.println("error reading area file navigation data: " + e);
            System.exit(0);
        }
        if (navBlock[0] != 1196249944) {
            System.out.println("error: not a GMS navigation block.");
            System.exit(0);
        }
        System.out.println("creating GMSXnav object...");
        gmsx = new GMSXnav(navBlock);
        gmsx.setImageStart(dirBlock[5], dirBlock[6]);
        System.out.println("####  ImageStart set to:" + dirBlock[5] + " " + dirBlock[6]);
        gmsx.setRes(dirBlock[11], dirBlock[12]);
        System.out.println("####  ImageRes set to:" + dirBlock[11] + " " + dirBlock[12]);
        gmsx.setStart(1, 1);
        gmsx.setFlipLineCoordinates(dirBlock[8]);
        System.out.println(" test of toLatLon...");
        System.out.println("  answer should be close to: -2.37, 133.31");
        double[][] linEle = new double[2][1];
        double[][] latLon = new double[2][1];
        gmsx.getClass();
        linEle[1][0] = 471.0;
        gmsx.getClass();
        linEle[0][0] = 323.0;
        latLon = gmsx.toLatLon(linEle);
        StringBuilder stringBuilder = new StringBuilder().append("  answer is: ");
        gmsx.getClass();
        StringBuilder stringBuilder2 = stringBuilder.append(latLon[0][0]).append(", ");
        gmsx.getClass();
        System.out.println(stringBuilder2.append(latLon[1][0]).toString());
        System.out.println(" test of toLinEle...");
        System.out.println("  answer should be close to: 480.0, 1.0");
        gmsx.getClass();
        latLon[0][0] = -2.0;
        gmsx.getClass();
        latLon[1][0] = 118.0;
        linEle = gmsx.toLinEle(latLon);
        StringBuilder stringBuilder3 = new StringBuilder().append("  answer is: ");
        gmsx.getClass();
        StringBuilder stringBuilder4 = stringBuilder3.append(linEle[1][0]).append(", ");
        gmsx.getClass();
        System.out.println(stringBuilder4.append(linEle[0][0]).toString());
        System.out.println("  answer should be close to: 16.0, 628.0");
        gmsx.getClass();
        latLon[0][0] = -24.0;
        gmsx.getClass();
        latLon[1][0] = 148.0;
        linEle = gmsx.toLinEle(latLon);
        StringBuilder stringBuilder5 = new StringBuilder().append("  answer is: ");
        gmsx.getClass();
        StringBuilder stringBuilder6 = stringBuilder5.append(linEle[1][0]).append(", ");
        gmsx.getClass();
        System.out.println(stringBuilder6.append(linEle[0][0]).toString());
        System.out.println("unit test of class GMSXnav end...");
    }
}

