/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.test.eval;

import junit.framework.TestCase;
import org.junit.Assert;
import org.matheclipse.parser.client.eval.BooleanVariable;
import org.matheclipse.parser.client.eval.DoubleEvaluator;
import org.matheclipse.parser.client.eval.DoubleVariable;

public class EvalDoubleTestCase
extends TestCase {
    public EvalDoubleTestCase(String name) {
        super(name);
    }

    public void check(String in, String compareWith) {
        try {
            DoubleEvaluator engine = new DoubleEvaluator();
            double d = engine.evaluate(in);
            EvalDoubleTestCase.assertEquals((String)Double.valueOf(d).toString(), (String)compareWith);
        }
        catch (Exception e) {
            e.printStackTrace();
            EvalDoubleTestCase.assertEquals((String)"", (String)e.getMessage());
        }
    }

    public void testEval001() {
        this.check("42", "42.0");
        this.check("1.0E10", "1.0E10");
        this.check("1.0E-10", "1.0E-10");
        this.check("1.0E+10", "1.0E10");
        this.check("1.5", "1.5");
        this.check("-42", "-42.0");
        this.check("+42", "42.0");
        this.check("-42.1", "-42.1");
        this.check("+42.2", "42.2");
        this.check("-3/4", "-0.75");
        this.check("+3/4", "0.75");
        this.check("3^3", "27.0");
        this.check("2+2*2", "6.0");
        this.check("2^9", "512.0");
        this.check("2^3^2", "512.0");
        this.check("(2^3)^2", "64.0");
        this.check("3+4*7", "31.0");
        this.check("3+4*7*3", "87.0");
        this.check("1+2+3+4*7*3", "90.0");
        this.check("Sin[Cos[3.2]]", "-0.8405484252742996");
        this.check("90.0*Degree", "1.5707963267948966");
        this.check("Pi/2", "1.5707963267948966");
        this.check("Sin[Pi/2*Cos[Pi]]", "-1.0");
        this.check("Max[0,-42,Pi,12]", "12.0");
        this.check("Min[0,-42,Pi,12]", "-42.0");
    }

    public void testEval002() {
        this.check("If[3/4<0.51, 1.1, -1.2]", "-1.2");
        this.check("If[True, 1.1, -1.2]", "1.1");
        this.check("If[3/4>0.51 && 3/8>0.1, 1.1, -1.2]", "1.1");
        this.check("If[3/4>0.51 || 3/8>0.1, 1.1, -1.2]", "1.1");
        this.check("If[!(3/4>0.51 || 3/8>0.1), 1.1, -1.2]", "-1.2");
    }

    public void testEval003() {
        try {
            DoubleEvaluator engine = new DoubleEvaluator();
            double d = engine.evaluate("Sin[Pi/2*Cos[Pi]]");
            EvalDoubleTestCase.assertEquals((String)Double.toString(d), (String)"-1.0");
        }
        catch (Exception e) {
            e.printStackTrace();
            EvalDoubleTestCase.assertEquals((String)"", (String)e.getMessage());
        }
    }

    public void testEval004() {
        try {
            DoubleVariable vd = new DoubleVariable(3.0);
            DoubleEvaluator engine = new DoubleEvaluator();
            engine.defineVariable("x", vd);
            double d = engine.evaluate("x^2+3");
            EvalDoubleTestCase.assertEquals((String)Double.valueOf(d).toString(), (String)"12.0");
            vd.setValue(4.0);
            d = engine.evaluate();
            EvalDoubleTestCase.assertEquals((String)Double.valueOf(d).toString(), (String)"19.0");
        }
        catch (Exception e) {
            e.printStackTrace();
            EvalDoubleTestCase.assertEquals((String)"", (String)e.getMessage());
        }
    }

    public void testEval005() {
        try {
            DoubleVariable vd = new DoubleVariable(3.0);
            DoubleEvaluator engine = new DoubleEvaluator();
            engine.defineVariable("x", vd);
            double d = engine.evaluate("x^2*x^2-1");
            EvalDoubleTestCase.assertEquals((String)Double.valueOf(d).toString(), (String)"80.0");
            vd.setValue(4.0);
            d = engine.evaluate();
            EvalDoubleTestCase.assertEquals((String)Double.valueOf(d).toString(), (String)"255.0");
        }
        catch (Exception e) {
            e.printStackTrace();
            EvalDoubleTestCase.assertEquals((String)"", (String)e.getMessage());
        }
    }

    public void testEval006() {
        try {
            DoubleEvaluator engine = new DoubleEvaluator();
            BooleanVariable vb = new BooleanVariable(true);
            engine.defineVariable("$1", vb);
            BooleanVariable vb2 = new BooleanVariable(true);
            engine.defineVariable("$2", vb2);
            double d = engine.evaluate("If[$1 && $2, 1, 0]");
            Assert.assertEquals((double)d, (double)1.0, (double)DoubleEvaluator.EPSILON);
            vb.setValue(false);
            d = engine.evaluate();
            Assert.assertEquals((double)d, (double)0.0, (double)DoubleEvaluator.EPSILON);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertEquals((Object)"", (Object)e.getMessage());
        }
    }

    public void testEval007() {
        try {
            DoubleEvaluator engine = new DoubleEvaluator();
            DoubleVariable vd = new DoubleVariable(3.0);
            engine.defineVariable("$1", vd);
            DoubleVariable vd2 = new DoubleVariable(-4.0);
            engine.defineVariable("$2", vd2);
            double d = engine.evaluate("$i = $1+$2; If[$i>0, 1, -1]");
            Assert.assertEquals((double)d, (double)-1.0, (double)DoubleEvaluator.EPSILON);
            vd2.setValue(4.0);
            d = engine.evaluate();
            Assert.assertEquals((double)d, (double)1.0, (double)DoubleEvaluator.EPSILON);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertEquals((Object)"", (Object)e.getMessage());
        }
    }

    public void testEval009() {
        try {
            DoubleEvaluator engine = new DoubleEvaluator();
            BooleanVariable vb = new BooleanVariable(true);
            engine.defineVariable("$1", vb);
            double d = engine.evaluate("If[$1, 1, 0]");
            Assert.assertEquals((double)d, (double)1.0, (double)DoubleEvaluator.EPSILON);
            vb.setValue(false);
            d = engine.evaluate();
            Assert.assertEquals((double)d, (double)0.0, (double)DoubleEvaluator.EPSILON);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertEquals((Object)"", (Object)e.getMessage());
        }
    }

    public void testMissingFunction009() {
        try {
            DoubleEvaluator engine = new DoubleEvaluator();
            double d = engine.evaluate("aTest[1.0]");
            EvalDoubleTestCase.assertEquals((String)Double.toString(d), (String)"");
        }
        catch (ArithmeticException e) {
            EvalDoubleTestCase.assertEquals((String)"EvalDouble#evaluateFunction(FunctionNode) not possible for: aTest[1.0]", (String)e.getMessage());
        }
    }
}

