/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.client;

import java.util.HashMap;
import java.util.List;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.ast.IParserFactory;
import org.matheclipse.parser.client.operator.Operator;

public class Scanner {
    protected String fInputString;
    protected char fLastChar;
    protected char fCurrentChar;
    protected int fCurrentPosition;
    protected int fToken;
    protected String fOperatorString;
    protected List<Operator> fOperList;
    protected int rowCount;
    protected int fCurrentColumnStartPosition;
    public static final int TT_EOF = 0;
    public static final int TT_FLOATING_POINT = 10;
    public static final int TT_ARGUMENTS_OPEN = 12;
    public static final int TT_ARGUMENTS_CLOSE = 13;
    public static final int TT_PRECEDENCE_OPEN = 14;
    public static final int TT_PRECEDENCE_CLOSE = 15;
    public static final int TT_LIST_OPEN = 16;
    public static final int TT_LIST_CLOSE = 17;
    public static final int TT_PARTOPEN = 18;
    public static final int TT_PARTCLOSE = 19;
    public static final int TT_OPERATOR = 31;
    public static final int TT_COMMA = 134;
    public static final int TT_PERCENT = 135;
    public static final int TT_STRING = 136;
    public static final int TT_BLANK = 137;
    public static final int TT_IDENTIFIER = 138;
    public static final int TT_DIGIT = 139;
    public static final int TT_SLOT = 141;
    public static final int TT_SLOTSEQUENCE = 142;
    public static final int TT_BLANK_BLANK = 143;
    public static final int TT_BLANK_BLANK_BLANK = 144;
    public static final int TT_BLANK_OPTIONAL = 145;
    public static final int TT_DERIVATIVE = 146;
    static final String string_a = "a";
    static final String string_b = "b";
    static final String string_c = "c";
    static final String string_d = "d";
    static final String string_e = "e";
    static final String string_f = "f";
    static final String string_g = "g";
    static final String string_h = "h";
    static final String string_i = "i";
    static final String string_j = "j";
    static final String string_k = "k";
    static final String string_l = "l";
    static final String string_m = "m";
    static final String string_n = "n";
    static final String string_o = "o";
    static final String string_p = "p";
    static final String string_q = "q";
    static final String string_r = "r";
    static final String string_s = "s";
    static final String string_t = "t";
    static final String string_u = "u";
    static final String string_v = "v";
    static final String string_w = "w";
    static final String string_x = "x";
    static final String string_y = "y";
    static final String string_z = "z";
    static final String var_a = "$a";
    static final String var_b = "$b";
    static final String var_c = "$c";
    static final String var_d = "$d";
    static final String var_e = "$e";
    static final String var_f = "$f";
    static final String var_g = "$g";
    static final String var_h = "$h";
    static final String var_i = "$i";
    static final String var_j = "$j";
    static final String var_k = "$k";
    static final String var_l = "$l";
    static final String var_m = "$m";
    static final String var_n = "$n";
    static final String var_o = "$o";
    static final String var_p = "$p";
    static final String var_q = "$q";
    static final String var_r = "$r";
    static final String var_s = "$s";
    static final String var_t = "$t";
    static final String var_u = "$u";
    static final String var_v = "$v";
    static final String var_w = "$w";
    static final String var_x = "$x";
    static final String var_y = "$y";
    static final String var_z = "$z";
    protected int numFormat = 0;
    protected IParserFactory fFactory;
    private static HashMap<String, String> CHAR_MAP = new HashMap(1024);

    public Scanner() {
        this.initializeNullScanner();
    }

    protected void initialize(String s) throws SyntaxError {
        this.initializeNullScanner();
        this.fInputString = s;
        if (s != null) {
            this.getNextToken();
        }
    }

    private void initializeNullScanner() {
        this.fInputString = null;
        this.fToken = 0;
        this.fCurrentPosition = 0;
        this.rowCount = 0;
        this.fCurrentColumnStartPosition = 0;
    }

    private void getChar() {
        if (this.fInputString.length() > this.fCurrentPosition) {
            this.getNextChar();
            return;
        }
        this.fCurrentPosition = this.fInputString.length() + 1;
        this.fCurrentChar = (char)32;
        this.fToken = 0;
    }

    private void getNextChar() {
        String uStr;
        String uChStr;
        int indx;
        this.fLastChar = this.fCurrentChar;
        this.fCurrentChar = this.fInputString.charAt(this.fCurrentPosition++);
        if (this.fCurrentChar == '\\' && this.fInputString.length() > this.fCurrentPosition && this.fInputString.charAt(this.fCurrentPosition) == '[' && (indx = this.fInputString.indexOf(93, this.fCurrentPosition + 1)) > 0 && (uChStr = CHAR_MAP.get(uStr = this.fInputString.substring(this.fCurrentPosition + 1, indx))) != null) {
            this.fCurrentChar = uChStr.charAt(0);
            this.fCurrentPosition = indx + 1;
        }
    }

    protected List<Operator> getOperator() {
        int startPosition = this.fCurrentPosition - 1;
        this.fOperatorString = this.fInputString.substring(startPosition, this.fCurrentPosition);
        List<Operator> list = this.fFactory.getOperatorList(this.fOperatorString);
        List<Operator> lastList = null;
        int lastOperatorPosition = -1;
        if (list != null) {
            lastList = list;
            lastOperatorPosition = this.fCurrentPosition;
        }
        this.getChar();
        while (this.fFactory.getOperatorCharacters().indexOf(this.fCurrentChar) >= 0) {
            this.fOperatorString = this.fInputString.substring(startPosition, this.fCurrentPosition);
            list = this.fFactory.getOperatorList(this.fOperatorString);
            if (list != null) {
                lastList = list;
                lastOperatorPosition = this.fCurrentPosition;
            }
            this.getChar();
        }
        if (lastOperatorPosition > 0) {
            this.fCurrentPosition = lastOperatorPosition;
            return lastList;
        }
        int endPosition = this.fCurrentPosition--;
        this.fCurrentPosition = startPosition;
        this.throwSyntaxError("Operator token not found: " + this.fInputString.substring(startPosition, endPosition - 1));
        return null;
    }

    protected void getNextToken() throws SyntaxError {
        while (this.fInputString.length() > this.fCurrentPosition) {
            this.getNextChar();
            this.fToken = 0;
            if (this.fFactory.getOperatorCharacters().indexOf(this.fCurrentChar) >= 0) {
                this.fOperList = this.getOperator();
                this.fToken = 31;
                return;
            }
            if (this.fCurrentChar == '\t' || this.fCurrentChar == '\r' || this.fCurrentChar == ' ') continue;
            if (this.fCurrentChar == '\n') {
                ++this.rowCount;
                this.fCurrentColumnStartPosition = this.fCurrentPosition;
                continue;
            }
            if (this.fCurrentChar >= 'a' && this.fCurrentChar <= 'z' || this.fCurrentChar >= 'A' && this.fCurrentChar <= 'Z' || this.fCurrentChar == '$') {
                this.fToken = 138;
                return;
            }
            if (this.fCurrentChar >= '0' && this.fCurrentChar <= '9') {
                this.fToken = 139;
                return;
            }
            if (this.fCurrentChar == '(' && this.fInputString.length() > this.fCurrentPosition && this.fInputString.charAt(this.fCurrentPosition) == '*') {
                this.getComment();
                continue;
            }
            switch (this.fCurrentChar) {
                case '(': {
                    this.fToken = 14;
                    break;
                }
                case ')': {
                    this.fToken = 15;
                    break;
                }
                case '{': {
                    this.fToken = 16;
                    break;
                }
                case '}': {
                    this.fToken = 17;
                    break;
                }
                case '[': {
                    this.fToken = 12;
                    if (this.fInputString.length() <= this.fCurrentPosition || this.fInputString.charAt(this.fCurrentPosition) != '[') break;
                    ++this.fCurrentPosition;
                    this.fToken = 18;
                    break;
                }
                case ']': {
                    this.fToken = 13;
                    break;
                }
                case ',': {
                    this.fToken = 134;
                    break;
                }
                case '_': {
                    this.fToken = 137;
                    if (this.fInputString.length() <= this.fCurrentPosition) break;
                    if (this.fInputString.charAt(this.fCurrentPosition) == '_') {
                        ++this.fCurrentPosition;
                        if (this.fInputString.length() > this.fCurrentPosition && this.fInputString.charAt(this.fCurrentPosition) == '_') {
                            ++this.fCurrentPosition;
                            this.fToken = 144;
                            break;
                        }
                        this.fToken = 143;
                        break;
                    }
                    if (this.fInputString.charAt(this.fCurrentPosition) != '.') break;
                    ++this.fCurrentPosition;
                    this.fToken = 145;
                    break;
                }
                case '.': {
                    if (this.fInputString.length() <= this.fCurrentPosition || this.fInputString.charAt(this.fCurrentPosition) < '0' || this.fInputString.charAt(this.fCurrentPosition) > '9') break;
                    this.fToken = 139;
                    break;
                }
                case '\"': {
                    this.fToken = 136;
                    break;
                }
                case '\'': {
                    this.fToken = 146;
                    break;
                }
                case '%': {
                    this.fToken = 135;
                    break;
                }
                case '#': {
                    this.fToken = 141;
                    if (this.fInputString.length() <= this.fCurrentPosition || this.fInputString.charAt(this.fCurrentPosition) != '#') break;
                    ++this.fCurrentPosition;
                    this.fToken = 142;
                    break;
                }
                default: {
                    this.throwSyntaxError("unexpected character: '" + this.fCurrentChar + "'");
                }
            }
            if (this.fToken == 0) {
                this.throwSyntaxError("token not found");
            }
            return;
        }
        this.fCurrentPosition = this.fInputString.length() + 1;
        this.fCurrentChar = (char)32;
        this.fToken = 0;
    }

    private void getComment() {
        int startPosition = this.fCurrentPosition++;
        int level = 0;
        try {
            while (true) {
                if (this.fInputString.charAt(this.fCurrentPosition) == '*' && this.fInputString.charAt(this.fCurrentPosition + 1) == ')') {
                    ++this.fCurrentPosition;
                    ++this.fCurrentPosition;
                    if (level != 0) {
                        --level;
                        continue;
                    }
                    break;
                }
                if (this.fInputString.charAt(this.fCurrentPosition) == '(' && this.fInputString.charAt(this.fCurrentPosition + 1) == '*') {
                    ++this.fCurrentPosition;
                    ++this.fCurrentPosition;
                    ++level;
                    continue;
                }
                ++this.fCurrentPosition;
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.fCurrentPosition = startPosition;
            this.throwSyntaxError("Comment doesn't end with '*)' (open multiline comment)");
        }
    }

    protected void throwSyntaxError(String error) throws SyntaxError {
        throw new SyntaxError(this.fCurrentPosition - 1, this.rowCount, this.fCurrentPosition - this.fCurrentColumnStartPosition, this.getErrorLine(), error, 1);
    }

    protected void throwSyntaxError(String error, int errorLength) throws SyntaxError {
        throw new SyntaxError(this.fCurrentPosition - errorLength, this.rowCount, this.fCurrentPosition - this.fCurrentColumnStartPosition, this.getErrorLine(), error, errorLength);
    }

    private String getErrorLine() {
        if (this.fInputString.length() < this.fCurrentPosition) {
            --this.fCurrentPosition;
        }
        int eol = this.fCurrentPosition;
        while (this.fInputString.length() > eol) {
            this.fCurrentChar = this.fInputString.charAt(eol++);
            if (this.fCurrentChar != '\n') continue;
            --eol;
            break;
        }
        String line = this.fInputString.substring(this.fCurrentColumnStartPosition, eol);
        return line;
    }

    protected String getIdentifier() {
        int length;
        int startPosition = this.fCurrentPosition - 1;
        this.getChar();
        if (this.fCurrentChar == '$') {
            this.getChar();
        }
        while (this.fCurrentChar >= 'a' && this.fCurrentChar <= 'z' || this.fCurrentChar >= 'A' && this.fCurrentChar <= 'Z' || this.fCurrentChar >= '0' && this.fCurrentChar <= '9') {
            this.getChar();
        }
        int endPosition = this.fCurrentPosition--;
        if ((length = --endPosition - startPosition) == 1) {
            return this.optimizedCurrentTokenSource1(startPosition, endPosition);
        }
        if (length == 2 && this.fInputString.charAt(startPosition) == '$') {
            return this.optimizedCurrentTokenSource2(startPosition, endPosition);
        }
        return this.fInputString.substring(startPosition, endPosition);
    }

    private final String optimizedCurrentTokenSource1(int startPosition, int endPosition) {
        switch (this.fInputString.charAt(startPosition)) {
            case 'a': {
                return string_a;
            }
            case 'b': {
                return string_b;
            }
            case 'c': {
                return string_c;
            }
            case 'd': {
                return string_d;
            }
            case 'e': {
                return string_e;
            }
            case 'f': {
                return string_f;
            }
            case 'g': {
                return string_g;
            }
            case 'h': {
                return string_h;
            }
            case 'i': {
                return string_i;
            }
            case 'j': {
                return string_j;
            }
            case 'k': {
                return string_k;
            }
            case 'l': {
                return string_l;
            }
            case 'm': {
                return string_m;
            }
            case 'n': {
                return string_n;
            }
            case 'o': {
                return string_o;
            }
            case 'p': {
                return string_p;
            }
            case 'q': {
                return string_q;
            }
            case 'r': {
                return string_r;
            }
            case 's': {
                return string_s;
            }
            case 't': {
                return string_t;
            }
            case 'u': {
                return string_u;
            }
            case 'v': {
                return string_v;
            }
            case 'w': {
                return string_w;
            }
            case 'x': {
                return string_x;
            }
            case 'y': {
                return string_y;
            }
            case 'z': {
                return string_z;
            }
        }
        return this.fInputString.substring(startPosition, endPosition);
    }

    private final String optimizedCurrentTokenSource2(int startPosition, int endPosition) {
        switch (this.fInputString.charAt(startPosition + 1)) {
            case 'a': {
                return var_a;
            }
            case 'b': {
                return var_b;
            }
            case 'c': {
                return var_c;
            }
            case 'd': {
                return var_d;
            }
            case 'e': {
                return var_e;
            }
            case 'f': {
                return var_f;
            }
            case 'g': {
                return var_g;
            }
            case 'h': {
                return var_h;
            }
            case 'i': {
                return var_i;
            }
            case 'j': {
                return var_j;
            }
            case 'k': {
                return var_k;
            }
            case 'l': {
                return var_l;
            }
            case 'm': {
                return var_m;
            }
            case 'n': {
                return var_n;
            }
            case 'o': {
                return var_o;
            }
            case 'p': {
                return var_p;
            }
            case 'q': {
                return var_q;
            }
            case 'r': {
                return var_r;
            }
            case 's': {
                return var_s;
            }
            case 't': {
                return var_t;
            }
            case 'u': {
                return var_u;
            }
            case 'v': {
                return var_v;
            }
            case 'w': {
                return var_w;
            }
            case 'x': {
                return var_x;
            }
            case 'y': {
                return var_y;
            }
            case 'z': {
                return var_z;
            }
        }
        return this.fInputString.substring(startPosition, endPosition);
    }

    protected Object[] getNumberString() {
        Object[] result = new Object[2];
        this.numFormat = 10;
        int startPosition = this.fCurrentPosition - 1;
        char firstCh = this.fCurrentChar;
        int dFlag = 32;
        if (this.fCurrentChar == '.') {
            dFlag = this.fCurrentChar;
        }
        this.getChar();
        if (firstCh == '0') {
            switch (this.fCurrentChar) {
                case 'b': {
                    this.numFormat = 2;
                    startPosition = this.fCurrentPosition;
                    this.getChar();
                    break;
                }
                case 'B': {
                    this.numFormat = 2;
                    startPosition = this.fCurrentPosition;
                    this.getChar();
                    break;
                }
                case 'o': {
                    this.numFormat = 8;
                    startPosition = this.fCurrentPosition;
                    this.getChar();
                    break;
                }
                case 'O': {
                    this.numFormat = 8;
                    startPosition = this.fCurrentPosition;
                    this.getChar();
                    break;
                }
                case 'x': {
                    this.numFormat = 16;
                    startPosition = this.fCurrentPosition;
                    this.getChar();
                    break;
                }
                case 'X': {
                    this.numFormat = 16;
                    startPosition = this.fCurrentPosition;
                    this.getChar();
                }
            }
        }
        if (this.numFormat == 2) {
            while (this.fCurrentChar >= '0' && this.fCurrentChar <= '1') {
                this.getChar();
            }
        } else if (this.numFormat == 8) {
            while (this.fCurrentChar >= '0' && this.fCurrentChar <= '7') {
                this.getChar();
            }
        } else if (this.numFormat == 16) {
            while (this.fCurrentChar >= '0' && this.fCurrentChar <= '9' || this.fCurrentChar >= 'a' && this.fCurrentChar <= 'f' || this.fCurrentChar >= 'A' && this.fCurrentChar <= 'F') {
                this.getChar();
            }
        } else {
            while (this.fCurrentChar >= '0' && this.fCurrentChar <= '9' || this.fCurrentChar == '.') {
                if (this.fCurrentChar == '.') {
                    if (this.fCurrentChar == '.' && dFlag != 32) break;
                    dFlag = this.fCurrentChar;
                    this.getChar();
                    continue;
                }
                this.getChar();
            }
            if (dFlag != 32) {
                this.numFormat = -1;
            }
        }
        if (this.numFormat < 0 && (this.fCurrentChar == 'E' || this.fCurrentChar == 'e')) {
            this.getChar();
            if (this.fCurrentChar == '+' || this.fCurrentChar == '-') {
                this.getChar();
            }
            while (this.fCurrentChar >= '0' && this.fCurrentChar <= '9') {
                this.getChar();
            }
        }
        int endPosition = this.fCurrentPosition--;
        result[0] = this.fInputString.substring(startPosition, --endPosition);
        result[1] = this.numFormat;
        return result;
    }

    protected StringBuffer getStringBuffer() throws SyntaxError {
        StringBuffer ident = new StringBuffer();
        this.getChar();
        if (this.fCurrentChar == '\n' || this.fToken == 0) {
            this.throwSyntaxError("string -" + ident.toString() + "- contains no character.");
        }
        while (this.fCurrentChar != '\"') {
            if (this.fCurrentChar == '\\') {
                this.getChar();
                switch (this.fCurrentChar) {
                    case '\\': {
                        ident.append(this.fCurrentChar);
                        break;
                    }
                    case 'n': {
                        ident.append('\n');
                        break;
                    }
                    case 't': {
                        ident.append('\t');
                        break;
                    }
                    default: {
                        this.throwSyntaxError("string - unknown character after back-slash.");
                    }
                }
                this.getChar();
                continue;
            }
            if (this.fCurrentChar != '\"' && this.fToken == 0) {
                this.throwSyntaxError("string -" + ident.toString() + "- not closed.");
            }
            ident.append(this.fCurrentChar);
            this.getChar();
        }
        return ident;
    }

    static {
        CHAR_MAP.put("CenterEllipsis", "\u22ef");
    }
}

