/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.visit;

import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.visit.VisitorExpr;

public class VisitorReplaceSlots
extends VisitorExpr {
    final IAST astSlots;

    public VisitorReplaceSlots(IAST ast) {
        this.astSlots = ast;
    }

    private IExpr getSlot(IInteger ii) {
        try {
            int i = ii.toInt();
            if (i > 0 && i < this.astSlots.size()) {
                return (IExpr)this.astSlots.get(i);
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return null;
    }

    private int getSlotSequence(IAST ast, int pos, IInteger ii) {
        try {
            int i = ii.toInt();
            if (i > 0 && i < this.astSlots.size()) {
                ast.remove(pos);
                for (int j = i; j < this.astSlots.size(); ++j) {
                    ast.add(pos++, this.astSlots.get(j));
                }
                return pos;
            }
        }
        catch (ArithmeticException ae) {
            // empty catch block
        }
        return pos;
    }

    @Override
    public IExpr visit(IAST ast) {
        if (ast.isSlot()) {
            return this.getSlot((IInteger)ast.get(1));
        }
        return this.visitAST(ast);
    }

    @Override
    protected IExpr visitAST(IAST ast) {
        IExpr temp;
        IAST slotSequence;
        int i;
        IAST result = null;
        int j = 0;
        for (i = 0; i < ast.size(); ++i) {
            if (((IExpr)ast.get(i)).isSlotSequence()) {
                slotSequence = (IAST)ast.get(i);
                result = ast.clone();
                j = this.getSlotSequence(result, i, (IInteger)slotSequence.get(1));
                ++i;
                break;
            }
            temp = ((IExpr)ast.get(i)).accept(this);
            if (temp != null) {
                result = ast.clone();
                result.set(i++, temp);
                ++j;
                break;
            }
            ++j;
        }
        while (i < ast.size()) {
            if (((IExpr)ast.get(i)).isSlotSequence()) {
                slotSequence = (IAST)ast.get(i);
                j = this.getSlotSequence(result, j, (IInteger)slotSequence.get(1));
                ++i;
                continue;
            }
            temp = ((IExpr)ast.get(i)).accept(this);
            if (temp != null) {
                result.set(j, temp);
            }
            ++i;
            ++j;
        }
        return result;
    }
}

