/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.stat.descriptive.summary;

import java.io.Serializable;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.stat.descriptive.AbstractSymbolicStorelessUnivariateStatistic;

public class SymbolicSum
extends AbstractSymbolicStorelessUnivariateStatistic
implements Serializable {
    private long n = 0L;
    private IExpr value = F.C0;

    @Override
    public void increment(IExpr d) {
        this.value = F.eval(F.Plus(this.value, d));
        ++this.n;
    }

    @Override
    public IExpr getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = F.C0;
        this.n = 0L;
    }

    @Override
    public IExpr evaluate(IAST values, int begin, int length) {
        if (this.test(values, begin, length, true)) {
            IAST sum = F.Plus();
            for (int i = begin; i < begin + length; ++i) {
                sum.add(values.get(i));
            }
            if (sum.size() > 1) {
                return F.eval(sum);
            }
        }
        return null;
    }

    public IExpr evaluate(IAST values, IAST weights, int begin, int length) {
        if (this.test(values, weights, begin, length, true)) {
            IAST sum = F.Plus();
            for (int i = begin; i < begin + length; ++i) {
                sum.add(F.Times((IExpr)values.get(i), (IExpr)weights.get(i)));
            }
            return sum;
        }
        return null;
    }

    public IExpr evaluate(IAST values, IAST weights) {
        return this.evaluate(values, weights, 1, values.size() - 1);
    }
}

