/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Select
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3, 4);
        if (ast.arg1().isAST()) {
            if (ast.size() == 3) {
                return Select.select((IAST)ast.arg1(), ast.arg2());
            }
            if (ast.size() == 4 && ((IExpr)ast.get(3)).isInteger()) {
                int resultLimit = Validate.checkIntType(ast, 3);
                return Select.select((IAST)ast.arg1(), ast.arg2(), resultLimit);
            }
        }
        return null;
    }

    public static IAST select(IAST ast, IExpr head) {
        return ast.filter(ast.copyHead(), Predicates.isTrue(head));
    }

    public static IAST select(IAST ast, IExpr head, int resultLimit) {
        return ast.args().filter(ast.copyHead(), Predicates.isTrue(head), resultLimit);
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
    }
}

